# System.Xml

``` diff
 namespace System.Xml {
     public class XmlDocument : XmlNode {
-        public virtual XmlProcessingInstruction CreateProcessingInstruction(string target, string data);
+        public virtual XmlProcessingInstruction CreateProcessingInstruction(string target, string? data);
     }
     public class XmlProcessingInstruction : XmlLinkedNode {
-        protected internal XmlProcessingInstruction(string target, string data, XmlDocument doc);
+        protected internal XmlProcessingInstruction(string target, string? data, XmlDocument doc);
-        public string Data { get; set; }
+        [AllowNullAttribute]
+        public string Data { get; set; }
-        public override string InnerText { get; set; }
+        [AllowNullAttribute]
+        public override string InnerText { get; set; }
-        public string? Target { get; }
+        public string Target { get; }
     }
     public abstract class XmlResolver {
+        public static XmlResolver ThrowingResolver { get; }
     }
-    public class XmlSecureResolver : XmlResolver
+    [ObsoleteAttribute("XmlSecureResolver is obsolete. Use XmlResolver.ThrowingResolver instead when attempting to forbid XML external entity resolution.", DiagnosticId="SYSLIB0047", UrlFormat="https://aka.ms/dotnet-warnings/{0}")]
+    public class XmlSecureResolver : XmlResolver
 }
```

