# System.Windows.Forms

``` diff
 namespace System.Windows.Forms {
+    [RequiresPreviewFeaturesAttribute]
+    public abstract class BindableComponent : Component, IBindableComponent, IComponent, IDisposable {
+        protected BindableComponent();
+        [BrowsableAttribute(false)]
+        [DesignerSerializationVisibilityAttribute(0)]
+        [EditorBrowsableAttribute(2)]
+        public BindingContext? BindingContext { get; set; }
+        [DesignerSerializationVisibilityAttribute(2)]
+        [ParenthesizePropertyNameAttribute(true)]
+        [RefreshPropertiesAttribute(1)]
+        public ControlBindingsCollection DataBindings { get; }
+        [EditorBrowsableAttribute(2)]
+        public event EventHandler BindingContextChanged;
+        [EditorBrowsableAttribute(2)]
+        protected virtual void OnBindingContextChanged(EventArgs e);
+    }
     [DesignerAttribute("System.Windows.Forms.Design.ButtonBaseDesigner, System.Design, Version=4.0.0.0, Culture=neutral, PublicKeyToken=b03f5f7f11d50a3a")]
     public abstract class ButtonBase : Control {
+        [BindableAttribute(true)]
+        [BrowsableAttribute(false)]
+        [DesignerSerializationVisibilityAttribute(0)]
+        [RequiresPreviewFeaturesAttribute]
+        public ICommand? Command { get; set; }
+        [BindableAttribute(true)]
+        [BrowsableAttribute(false)]
+        [DesignerSerializationVisibilityAttribute(0)]
+        public object? CommandParameter { [RequiresPreviewFeaturesAttribute] get; [RequiresPreviewFeaturesAttribute] set; }
+        [EditorBrowsableAttribute(2)]
+        [RequiresPreviewFeaturesAttribute]
+        public event EventHandler? CommandCanExecuteChanged;
+        [EditorBrowsableAttribute(2)]
+        [RequiresPreviewFeaturesAttribute]
+        public event EventHandler? CommandChanged;
+        [EditorBrowsableAttribute(2)]
+        [RequiresPreviewFeaturesAttribute]
+        public event EventHandler? CommandParameterChanged;
+        protected override void OnClick(EventArgs e);
+        [EditorBrowsableAttribute(2)]
+        [RequiresPreviewFeaturesAttribute]
+        protected virtual void OnCommandCanExecuteChanged(EventArgs e);
+        [EditorBrowsableAttribute(2)]
+        [RequiresPreviewFeaturesAttribute]
+        protected virtual void OnCommandChanged(EventArgs e);
+        [EditorBrowsableAttribute(2)]
+        [RequiresPreviewFeaturesAttribute]
+        protected virtual void OnCommandParameterChanged(EventArgs e);
+        [RequiresPreviewFeaturesAttribute]
+        protected virtual void OnRequestCommandExecute(EventArgs e);
     }
     public class ContainerControl : ScrollableControl, IContainerControl {
-        [BrowsableAttribute(false)]
-        [DesignerSerializationVisibilityAttribute(0)]
-        public Control ActiveControl { get; set; }
+        [BrowsableAttribute(false)]
+        [DesignerSerializationVisibilityAttribute(0)]
+        public Control? ActiveControl { get; set; }
-        [BrowsableAttribute(false)]
-        public override BindingContext BindingContext { get; set; }
+        [BrowsableAttribute(false)]
+        public override BindingContext? BindingContext { get; set; }
-        [BrowsableAttribute(false)]
-        [DesignerSerializationVisibilityAttribute(0)]
-        public Form ParentForm { get; }
+        [BrowsableAttribute(false)]
+        [DesignerSerializationVisibilityAttribute(0)]
+        public Form? ParentForm { get; }
-        [BrowsableAttribute(false)]
-        [EditorBrowsableAttribute(1)]
-        public event EventHandler AutoValidateChanged;
+        [BrowsableAttribute(false)]
+        [EditorBrowsableAttribute(1)]
+        public event EventHandler? AutoValidateChanged;
+        protected virtual void ScaleMinMaxSize(float xScaleFactor, float yScaleFactor, bool updateContainerSize = true);
     }
     [DefaultEventAttribute("Click")]
     [DefaultPropertyAttribute("Text")]
     [DesignerAttribute("System.Windows.Forms.Design.ControlDesigner, System.Design, Version=4.0.0.0, Culture=neutral, PublicKeyToken=b03f5f7f11d50a3a")]
     [DesignerSerializerAttribute("System.Windows.Forms.Design.ControlCodeDomSerializer, System.Design, Version=4.0.0.0, Culture=neutral, PublicKeyToken=b03f5f7f11d50a3a", "System.ComponentModel.Design.Serialization.CodeDomSerializer, System.Design, Version=4.0.0.0, Culture=neutral, PublicKeyToken=b03f5f7f11d50a3a")]
     [ToolboxItemFilterAttribute("System.Windows.Forms")]
     public class Control : Component, IBindableComponent, IComponent, IDisposable, IDropTarget, Interop.Ole32.IOleControl, Interop.Ole32.IOleInPlaceActiveObject, Interop.Ole32.IOleInPlaceObject, Interop.Ole32.IOleObject, Interop.Ole32.IOleWindow, Interop.Ole32.IPersist, Interop.Ole32.IPersistStorage, Interop.Ole32.IPersistStreamInit, Interop.Ole32.IQuickActivate, Interop.Ole32.IViewObject, Interop.Ole32.IViewObject2, Interop.Oleaut32.IPersistPropertyBag, ISynchronizeInvoke, IWin32Window {
+        [BindableAttribute(true)]
+        [BrowsableAttribute(false)]
+        public virtual object DataContext { get; set; }
+        [BrowsableAttribute(true)]
+        [EditorBrowsableAttribute(2)]
+        public event EventHandler DataContextChanged;
-        [EditorBrowsableAttribute(2)]
-        public IAsyncResult BeginInvoke(Delegate method, params object[] args);
+        [EditorBrowsableAttribute(2)]
+        public IAsyncResult BeginInvoke(Delegate method, params object?[]? args);
-        public DragDropEffects DoDragDrop(object data, DragDropEffects allowedEffects, Bitmap dragImage, Point cursorOffset, bool useDefaultDragImage);
+        public DragDropEffects DoDragDrop(object data, DragDropEffects allowedEffects, Bitmap? dragImage, Point cursorOffset, bool useDefaultDragImage);
-        [EditorBrowsableAttribute(2)]
-        public object EndInvoke(IAsyncResult asyncResult);
+        [EditorBrowsableAttribute(2)]
+        public object? EndInvoke(IAsyncResult asyncResult);
-        public object Invoke(Delegate method, params object[] args);
+        public object Invoke(Delegate method, params object?[]? args);
+        [EditorBrowsableAttribute(2)]
+        protected virtual void OnDataContextChanged(EventArgs e);
+        [EditorBrowsableAttribute(2)]
+        protected virtual void OnParentDataContextChanged(EventArgs e);
     }
     [DefaultBindingPropertyAttribute("SelectedItem")]
     [DefaultEventAttribute("SelectedItemChanged")]
     [DefaultPropertyAttribute("Items")]
     public class DomainUpDown : UpDownBase {
-        [BrowsableAttribute(false)]
-        [DesignerSerializationVisibilityAttribute(0)]
-        public object? SelectedItem { get; set; }
+        [BrowsableAttribute(false)]
+        [DesignerSerializationVisibilityAttribute(0)]
+        public object SelectedItem { get; set; }
-        [BrowsableAttribute(false)]
-        [EditorBrowsableAttribute(1)]
-        public new event EventHandler? PaddingChanged;
+        [BrowsableAttribute(false)]
+        [EditorBrowsableAttribute(1)]
+        public new event EventHandler PaddingChanged;
-        public event EventHandler? SelectedItemChanged;
+        public event EventHandler SelectedItemChanged;
-        public class DomainItemAccessibleObject : AccessibleObject {
+        [EditorBrowsableAttribute(1)]
+        [ObsoleteAttribute("DomainItemAccessibleObject is no longer used to provide accessible support for DomainUpDown items.", false, DiagnosticId="WFDEV003", UrlFormat="https://aka.ms/winforms-warnings/{0}")]
+        public class DomainItemAccessibleObject : AccessibleObject {
-            public override string? Name { get; set; }
+            public override string Name { get; set; }
-            public override string? Value { get; }
+            public override string Value { get; }
         }
-        public class DomainUpDownAccessibleObject : Control.ControlAccessibleObject
+        [EditorBrowsableAttribute(1)]
+        [ObsoleteAttribute("DomainUpDownAccessibleObject is no longer used to provide accessible support for DomainUpDown controls.", false, DiagnosticId="WFDEV002", UrlFormat="https://aka.ms/winforms-warnings/{0}")]
+        public class DomainUpDownAccessibleObject : Control.ControlAccessibleObject
     }
     [DefaultEventAttribute("Load")]
     [DesignTimeVisibleAttribute(false)]
     [DesignerAttribute("System.Windows.Forms.Design.FormDocumentDesigner, System.Design, Version=4.0.0.0, Culture=neutral, PublicKeyToken=b03f5f7f11d50a3a", typeof(IRootDesigner))]
     [DesignerCategoryAttribute("Form")]
     [InitializationEventAttribute("Load")]
     [ToolboxItemAttribute(false)]
     [ToolboxItemFilterAttribute("System.Windows.Forms.Control.TopLevel")]
     public class Form : ContainerControl {
+        protected override void ScaleMinMaxSize(float xScaleFactor, float yScaleFactor, bool updateContainerSize = true);
     }
     [DefaultBindingPropertyAttribute("Value")]
     [DefaultEventAttribute("ValueChanged")]
     [DefaultPropertyAttribute("Value")]
     public class NumericUpDown : UpDownBase, ISupportInitialize {
-        protected override AccessibleObject CreateAccessibilityInstance();
     }
     [DesignerAttribute("System.Windows.Forms.Design.ScrollableControlDesigner, System.Design, Version=4.0.0.0, Culture=neutral, PublicKeyToken=b03f5f7f11d50a3a")]
     public class ScrollableControl : Control, IComponent, IDisposable {
-        public void ScrollControlIntoView(Control activeControl);
+        public void ScrollControlIntoView(Control? activeControl);
     }
     [DesignerAttribute("System.Windows.Forms.Design.ToolStripContainerDesigner, System.Design, Version=4.0.0.0, Culture=neutral, PublicKeyToken=b03f5f7f11d50a3a")]
     public class ToolStripContainer : ContainerControl {
-        [BrowsableAttribute(false)]
-        [DesignerSerializationVisibilityAttribute(0)]
-        [EditorBrowsableAttribute(1)]
-        public override Cursor Cursor { get; set; }
+        [BrowsableAttribute(false)]
+        [DesignerSerializationVisibilityAttribute(0)]
+        [EditorBrowsableAttribute(1)]
+        [AllowNullAttribute]
+        public override Cursor Cursor { get; set; }
     }
-    [DefaultEventAttribute("Click")]
-    [DefaultPropertyAttribute("Text")]
-    [DesignTimeVisibleAttribute(false)]
-    [DesignerAttribute("System.Windows.Forms.Design.ToolStripItemDesigner, System.Design, Version=4.0.0.0, Culture=neutral, PublicKeyToken=b03f5f7f11d50a3a")]
-    [ToolboxItemAttribute(false)]
-    public abstract class ToolStripItem : Component, IComponent, IDisposable, IDropTarget {
+    [DefaultEventAttribute("Click")]
+    [DefaultPropertyAttribute("Text")]
+    [DesignTimeVisibleAttribute(false)]
+    [DesignerAttribute("System.Windows.Forms.Design.ToolStripItemDesigner, System.Design, Version=4.0.0.0, Culture=neutral, PublicKeyToken=b03f5f7f11d50a3a")]
+    [ToolboxItemAttribute(false)]
+    public abstract class ToolStripItem : BindableComponent, IComponent, IDisposable, IDropTarget {
+        [BindableAttribute(true)]
+        [BrowsableAttribute(false)]
+        [DesignerSerializationVisibilityAttribute(0)]
+        [RequiresPreviewFeaturesAttribute]
+        public ICommand Command { get; set; }
+        [BindableAttribute(true)]
+        [BrowsableAttribute(false)]
+        [DesignerSerializationVisibilityAttribute(0)]
+        public object CommandParameter { [RequiresPreviewFeaturesAttribute] get; [RequiresPreviewFeaturesAttribute] set; }
+        [EditorBrowsableAttribute(2)]
+        [RequiresPreviewFeaturesAttribute]
+        public event EventHandler CommandCanExecuteChanged;
+        [EditorBrowsableAttribute(2)]
+        [RequiresPreviewFeaturesAttribute]
+        public event EventHandler CommandChanged;
+        [EditorBrowsableAttribute(2)]
+        [RequiresPreviewFeaturesAttribute]
+        public event EventHandler CommandParameterChanged;
+        [EditorBrowsableAttribute(2)]
+        [RequiresPreviewFeaturesAttribute]
+        protected virtual void OnCommandCanExecuteChanged(EventArgs e);
+        [EditorBrowsableAttribute(2)]
+        [RequiresPreviewFeaturesAttribute]
+        protected virtual void OnCommandChanged(EventArgs e);
+        [EditorBrowsableAttribute(2)]
+        [RequiresPreviewFeaturesAttribute]
+        protected virtual void OnCommandParameterChanged(EventArgs e);
+        [RequiresPreviewFeaturesAttribute]
+        protected virtual void OnRequestCommandExecute(EventArgs e);
     }
     [DesignerAttribute("System.Windows.Forms.Design.ToolStripPanelDesigner, System.Design, Version=4.0.0.0, Culture=neutral, PublicKeyToken=b03f5f7f11d50a3a")]
     [ToolboxBitmapAttribute(typeof(ToolStripPanel), "ToolStripPanel_standalone")]
     public class ToolStripPanel : ContainerControl, IComponent, IDisposable {
-        [BrowsableAttribute(false)]
-        [DesignerSerializationVisibilityAttribute(0)]
-        [EditorBrowsableAttribute(1)]
-        public override string Text { get; set; }
+        [BrowsableAttribute(false)]
+        [DesignerSerializationVisibilityAttribute(0)]
+        [EditorBrowsableAttribute(1)]
+        [AllowNullAttribute]
+        public override string Text { get; set; }
-        [BrowsableAttribute(true)]
-        [EditorBrowsableAttribute(0)]
-        public new event EventHandler AutoSizeChanged;
+        [BrowsableAttribute(true)]
+        [EditorBrowsableAttribute(0)]
+        public new event EventHandler? AutoSizeChanged;
-        public event EventHandler RendererChanged;
+        public event EventHandler? RendererChanged;
-        [BrowsableAttribute(false)]
-        [EditorBrowsableAttribute(1)]
-        public new event EventHandler TabIndexChanged;
+        [BrowsableAttribute(false)]
+        [EditorBrowsableAttribute(1)]
+        public new event EventHandler? TabIndexChanged;
-        [BrowsableAttribute(false)]
-        [EditorBrowsableAttribute(1)]
-        public new event EventHandler TabStopChanged;
+        [BrowsableAttribute(false)]
+        [EditorBrowsableAttribute(1)]
+        public new event EventHandler? TabStopChanged;
-        [BrowsableAttribute(false)]
-        [EditorBrowsableAttribute(1)]
-        public new event EventHandler TextChanged;
+        [BrowsableAttribute(false)]
+        [EditorBrowsableAttribute(1)]
+        public new event EventHandler? TextChanged;
+        protected override AccessibleObject CreateAccessibilityInstance();
-        public ToolStripPanelRow PointToRow(Point clientLocation);
+        public ToolStripPanelRow? PointToRow(Point clientLocation);
     }
     [DesignerAttribute("System.Windows.Forms.Design.UpDownBaseDesigner, System.Design, Version=4.0.0.0, Culture=neutral, PublicKeyToken=b03f5f7f11d50a3a")]
     public abstract class UpDownBase : ContainerControl {
+        protected override AccessibleObject CreateAccessibilityInstance();
     }
 }
```

