# Microsoft.AspNetCore.OutputCaching

``` diff
 namespace Microsoft.AspNetCore.OutputCaching {
     public sealed class CacheVaryByRules {
+        public string CacheKeyPrefix { get; set; }
-        public IDictionary<string, string> VaryByCustom { get; }
+        public bool VaryByHost { get; set; }
-        public StringValues VaryByPrefix { get; set; }
+        public IDictionary<string, string> VaryByValues { get; }
     }
     public class OutputCacheOptions {
+        public void AddBasePolicy(Action<OutputCachePolicyBuilder> build, bool excludeDefaultPolicy);
+        public void AddPolicy(string name, Action<OutputCachePolicyBuilder> build, bool excludeDefaultPolicy);
     }
     public sealed class OutputCachePolicyBuilder {
-        public OutputCachePolicyBuilder();
-        public OutputCachePolicyBuilder AllowLocking(bool lockResponse = true);
-        public OutputCachePolicyBuilder Clear();
+        public OutputCachePolicyBuilder SetCacheKeyPrefix(Func<HttpContext, string> keyPrefix);
+        public OutputCachePolicyBuilder SetCacheKeyPrefix(Func<HttpContext, CancellationToken, ValueTask<string>> keyPrefix);
+        public OutputCachePolicyBuilder SetCacheKeyPrefix(string keyPrefix);
+        public OutputCachePolicyBuilder SetLocking(bool enabled);
+        public OutputCachePolicyBuilder SetVaryByHeader(string headerName, params string[] headerNames);
+        public OutputCachePolicyBuilder SetVaryByHeader(string[] headerNames);
+        public OutputCachePolicyBuilder SetVaryByHost(bool enabled);
+        public OutputCachePolicyBuilder SetVaryByQuery(string queryKey, params string[] queryKeys);
+        public OutputCachePolicyBuilder SetVaryByQuery(string[] queryKeys);
+        public OutputCachePolicyBuilder SetVaryByRouteValue(string routeValueName, params string[] routeValueNames);
+        public OutputCachePolicyBuilder SetVaryByRouteValue(string[] routeValueNames);
-        public OutputCachePolicyBuilder VaryByHeader(params string[] headerNames);
-        public OutputCachePolicyBuilder VaryByQuery(params string[] queryKeys);
-        public OutputCachePolicyBuilder VaryByRouteValue(params string[] routeValueNames);
-        public OutputCachePolicyBuilder VaryByValue(Func<HttpContext, string> varyBy);
-        public OutputCachePolicyBuilder VaryByValue(Func<HttpContext, CancellationToken, ValueTask<string>> varyBy);
+        public OutputCachePolicyBuilder VaryByValue(string key, string value);
     }
 }
```

