# .NET 8.0.0  - November 14, 2023

The .NET 8.0.0 and .NET SDK 8.0.100 releases are available for download. The latest 8.0 release is always listed at [.NET 8.0 Releases](../README.md).

## What's new in .NET 8

.NET 8 is the next major release of .NET following .NET 7.0. You can see [What's new in .NET 8.0](https://learn.microsoft.com/dotnet/core/whats-new/dotnet-8) for more details. You can also find additional details on the following blog posts:

* [Announcing .NET 8][dotnet-blog]
* [EF Core][ef-blog]
* [ASP.NET Core][aspnet-blog]

Here is list of some of the additions and updates we're excited to bring in .NET 8.

* EntityFramework Core: [bugs][ef_bugs] | [features][ef_features]
* .NET SDK [bugs][sdk_bugs]

## Downloads

|           | SDK Installer<sup>1</sup>                        | SDK Binaries<sup>1</sup>                 | Runtime Installer                                        | Runtime Binaries                                 | ASP.NET Core Runtime           |Windows Desktop Runtime          |
| --------- | :------------------------------------------:     | :----------------------:                 | :---------------------------:                            | :-------------------------:                      | :-----------------:            | :-----------------:            |
| Windows   | [x86][dotnet-sdk-win-x86.exe] \| [x64][dotnet-sdk-win-x64.exe] \| [Arm64][dotnet-sdk-win-arm64.exe] | [x86][dotnet-sdk-win-x86.zip] \| [x64][dotnet-sdk-win-x64.zip] \|  [Arm64][dotnet-sdk-win-arm64.zip] | [x86][dotnet-runtime-win-x86.exe] \| [x64][dotnet-runtime-win-x64.exe] \| [Arm64][dotnet-runtime-win-arm64.exe] | [x86][dotnet-runtime-win-x86.zip] \| [x64][dotnet-runtime-win-x64.zip] \| [Arm64][dotnet-runtime-win-arm64.zip] | [x86][aspnetcore-runtime-win-x86.exe] \| [x64][aspnetcore-runtime-win-x64.exe] \|<br/> [Hosting Bundle][dotnet-hosting-win.exe]<sup>2</sup> | [x86][windowsdesktop-runtime-win-x86.exe] \| [x64][windowsdesktop-runtime-win-x64.exe] \| [Arm64][windowsdesktop-runtime-win-arm64.exe] |
| macOS     | [x64][dotnet-sdk-osx-x64.pkg] \| [ARM64][dotnet-sdk-osx-arm64.pkg] | [x64][dotnet-sdk-osx-x64.tar.gz] \| [ARM64][dotnet-sdk-osx-arm64.tar.gz]  | [x64][dotnet-runtime-osx-x64.pkg] \| [ARM64][dotnet-runtime-osx-arm64.pkg] | [x64][dotnet-runtime-osx-x64.tar.gz] \| [ARM64][dotnet-runtime-osx-arm64.tar.gz]| [x64][aspnetcore-runtime-osx-x64.tar.gz] \| [ARM64][aspnetcore-runtime-osx-arm64.tar.gz] | - |<sup>1</sup>
| Linux     |  [Snap and Package Manager](../install-linux.md)  | [x64][dotnet-sdk-linux-x64.tar.gz] \| [Arm][dotnet-sdk-linux-arm.tar.gz]  \| [Arm64][dotnet-sdk-linux-arm64.tar.gz] \| [Arm32 Alpine][dotnet-sdk-linux-musl-arm.tar.gz]  \| [x64 Alpine][dotnet-sdk-linux-musl-x64.tar.gz] | [Packages (x64)][linux-packages] | [x64][dotnet-runtime-linux-x64.tar.gz] \| [Arm][dotnet-runtime-linux-arm.tar.gz] \| [Arm64][dotnet-runtime-linux-arm64.tar.gz] \| [Arm32 Alpine][dotnet-runtime-linux-musl-arm.tar.gz] \| [Arm64 Alpine][dotnet-runtime-linux-musl-arm64.tar.gz] \| [x64 Alpine][dotnet-runtime-linux-musl-x64.tar.gz]  | [x64][aspnetcore-runtime-linux-x64.tar.gz]<sup>1</sup>  \| [Arm][aspnetcore-runtime-linux-arm.tar.gz]<sup>1</sup> \| [Arm64][aspnetcore-runtime-linux-arm64.tar.gz]<sup>1</sup> \| [x64 Alpine][aspnetcore-runtime-linux-musl-x64.tar.gz] | - | <sup>1</sup> |
|  | [Checksums][checksums-sdk]                             | [Checksums][checksums-sdk]                                      | [Checksums][checksums-runtime]                             | [Checksums][checksums-runtime]  | [Checksums][checksums-runtime]  | [Checksums][checksums-runtime]


1. Includes the .NET Runtime and ASP.NET Core Runtime
2. For hosting stand-alone apps on Windows Servers. Includes the ASP.NET Core Module for IIS and can be installed separately on servers without installing .NET Runtime.


The .NET SDK includes a matching updated .NET Runtime. Downloading the Runtime or ASP.NET Core packages is not needed when installing the SDK.

You can check your .NET SDK version by running the following command. The example version shown is for this release.

```console
$ dotnet --version
8.0.100
```

## Docker Images

The [.NET Docker images](https://hub.docker.com/_/microsoft-dotnet) have been updated for this release. The [.NET Docker samples](https://github.com/dotnet/dotnet-docker/blob/main/samples/README.md) show various ways to use .NET and Docker together. You can use the following command to try running the latest .NET 8.0 release in containers:

```console
docker run --rm mcr.microsoft.com/dotnet/samples
```

The following repos have been updated.

* [dotnet/sdk](https://github.com/dotnet/dotnet-docker/blob/main/README.sdk.md): .NET SDK
* [dotnet/aspnet](https://github.com/dotnet/dotnet-docker/blob/main/README.aspnet.md): ASP.NET Core Runtime
* [dotnet/runtime](https://github.com/dotnet/dotnet-docker/blob/main/README.runtime.md): .NET Runtime
* [dotnet/runtime-deps](https://github.com/dotnet/dotnet-docker/blob/main/README.runtime.md): .NET Runtime Dependencies
* [dotnet/monitor](https://github.com/dotnet/dotnet-docker/blob/main/README.monitor.md): .NET Monitor
* [dotnet/monitor/base](https://github.com/dotnet/dotnet-docker/blob/main/README.monitor-base.md): .NET Monitor Base
* [dotnet/samples](https://github.com/dotnet/dotnet-docker/blob/main/README.samples.md): .NET Samples

## Notable Changes

 [.NET 8.0 Blog][dotnet-blog]

.NET 8.0.0 release carries security and non-security fixes.

[CVE-2023-36038 - .NET Denial of Service Vulnerability](https://msrc.microsoft.com/update-guide/vulnerability/CVE-2023-36038)

Microsoft is releasing this security advisory to provide information about a vulnerability in ASP.NET Core 8.0 RC2. This advisory also provides guidance on what developers can do to update their applications to address this vulnerability.

A vulnerability exists in ASP.NET IIS where a remote  unauthenticated user can issue specially crafted requests to a .NET application which may result in denial of service. This vulnerability only impacts Windows OS.

[CVE-2023-36049 - .NET Elevation of Privilege Vulnerability](https://msrc.microsoft.com/update-guide/vulnerability/CVE-2023-36049)

Microsoft is releasing this security advisory to provide information about a vulnerability in .NET 6.0, .NET 7.0 and .NET 8.0 RC2. This advisory also provides guidance on what developers can do to update their applications to address this vulnerability.

An elevation of privilege vulnerability exists in .NET where untrusted URIs provided to System.Net.WebRequest.Create can be used to inject arbitrary commands to backend FTP servers.

[CVE-2023-36558 - .NET Security Feature Bypass Vulnerability](https://msrc.microsoft.com/update-guide/vulnerability/CVE-2023-36558)

Microsoft is releasing this security advisory to provide information about a vulnerability in ASP.NET Core 6.0, ASP.NET Core 7.0 and, ASP.NET Core 8.0 RC2. This advisory also provides guidance on what developers can do to update their applications to address this vulnerability.

A security feature bypass vulnerability exists in ASP.NET where an unauthenticated user is able to bypass validation on Blazor server forms which could trigger unintended actions.

## Visual Studio Compatibility

You need [Visual Studio 17.8](https://visualstudio.microsoft.com) or later to use .NET 8.0 on Windows. While not officially supported, we’ve also enabled rudimentary support for .NET 8 in Visual Studio for Mac. Users have to enable a preview feature in Preferences to enable the IDE to discover and use the .NET 8 SDK for creating, loading, building, and debugging projects. The [C# extension](https://code.visualstudio.com/docs/languages/dotnet) for [Visual Studio Code](https://code.visualstudio.com/) supports .NET 8.0 and C# 11.

## Feedback

Your feedback is important and appreciated. We've created an issue at [dotnet/core #8904](https://github.com/dotnet/core/issues/8904) for your questions and comments.

[blob-runtime]: https://dotnetcli.blob.core.windows.net/dotnet/Runtime/
[blob-sdk]: https://dotnetcli.blob.core.windows.net/dotnet/Sdk/
[release-notes]: 8.0.0.md

[checksums-runtime]: https://dotnetcli.blob.core.windows.net/dotnet/checksums/8.0.0-sha.txt
[checksums-sdk]: https://dotnetcli.blob.core.windows.net/dotnet/checksums/8.0.0-sha.txt

[linux-install]: ../install-linux.md

[dotnet-blog]:  https://devblogs.microsoft.com/dotnet/announcing-dotnet-8/
[aspnet-blog]: https://devblogs.microsoft.com/dotnet/announcing-asp-net-core-in-dotnet-8/
[ef-blog]: https://devblogs.microsoft.com/dotnet/announcing-ef8/
[ef_bugs]: https://github.com/dotnet/efcore/issues?q=is%3Aissue+milestone%3A8.0.0+is%3Aclosed+label%3Atype-bug
[ef_features]: https://github.com/dotnet/efcore/issues?q=is%3Aissue+milestone%3A8.0.0+is%3Aclosed+label%3Atype-enhancement

[aspnet_bugs]: https://github.com/aspnet/AspNetCore/issues?q=is%3Aissue+milestone%3A8.0.0+label%3ADone+label%3Abug
[aspnet_features]: https://github.com/aspnet/AspNetCore/issues?q=is%3Aissue+milestone%3A8.0.0+label%3ADone+label%3Aenhancement
[runtime_bugs]: https://github.com/dotnet/runtime/issues?utf8=%E2%9C%93&q=is%3Aissue+milestone%3A8.0+label%3Abug+
[runtime_features]: https://github.com/dotnet/runtime/issues?q=is%3Aissue+milestone%3A8.0+label%3Aenhancement

[sdk_bugs]: https://github.com/dotnet/sdk/issues?q=is%3Aissue+is%3Aclosed+milestone%3A8.0.1xx

[linux-packages]: ../install-linux.md

## Packages updated in this release:

Package name | Version
:----------- | :------------------
Microsoft.WindowsDesktop.App.Runtime.win-x86 | 8.0.0
Microsoft.WindowsDesktop.App.Runtime.win-arm64 | 8.0.0
Microsoft.WindowsDesktop.App.Ref | 8.0.0
Microsoft.WindowsDesktop.App.Runtime.win-x64 | 8.0.0
Microsoft.Windows.Compatibility | 8.0.0
Microsoft.NET.Runtime.MonoTargets.Sdk.Msi.arm64 | 8.0.0
Microsoft.NET.Runtime.WebAssembly.Sdk | 8.0.0
Microsoft.NETCore.App.Runtime.Mono.android-arm | 8.0.0
Microsoft.NET.ILLink.Tasks | 8.0.0
Microsoft.NET.Runtime.WebAssembly.Templates | 8.0.0
Microsoft.NET.Runtime.WebAssembly.Wasi.Sdk | 8.0.0
Microsoft.NET.Runtime.WebAssembly.Templates.Msi.arm64 | 8.0.0
Microsoft.NET.Runtime.WebAssembly.Templates.Msi.x86 | 8.0.0
Microsoft.NET.Workload.Mono.ToolChain.net7.Manifest-8.0.100.Msi.x64 | 8.0.0
Microsoft.NETCore.App.Crossgen2.linux-arm | 8.0.0
Microsoft.NET.Workload.Mono.ToolChain.net7.Manifest-8.0.100.Msi.arm64 | 8.0.0
Microsoft.NETCore.App.Crossgen2.win-x86 | 8.0.0
Microsoft.NETCore.App.Host.osx-arm64 | 8.0.0
Microsoft.NETCore.App.Runtime.AOT.linux-arm64.Cross.android-x64 | 8.0.0
Microsoft.NETCore.App.Runtime.AOT.linux-arm64.Cross.android-x86 | 8.0.0
Microsoft.NETCore.App.Runtime.AOT.linux-arm64.Cross.browser-wasm | 8.0.0
Microsoft.NETCore.App.Runtime.AOT.win-x64.Cross.android-arm.Msi.arm64 | 8.0.0
Microsoft.NETCore.App.Runtime.linux-bionic-arm64 | 8.0.0
Microsoft.NETCore.App.Runtime.linux-musl-x64 | 8.0.0
Microsoft.NETCore.App.Runtime.linux-x64 | 8.0.0
Microsoft.NETCore.App.Runtime.Mono.android-arm64 | 8.0.0
Microsoft.NETCore.App.Runtime.Mono.ios-arm64 | 8.0.0
Microsoft.NETCore.App.Runtime.Mono.iossimulator-x64.Msi.x86 | 8.0.0
Microsoft.NETCore.App.Runtime.Mono.linux-arm64 | 8.0.0
Microsoft.NETCore.App.Runtime.Mono.multithread.browser-wasm.Msi.x86 | 8.0.0
Microsoft.NETCore.App.Runtime.Mono.tvossimulator-x64.Msi.x64 | 8.0.0
Microsoft.NETCore.App.Runtime.Mono.tvossimulator-x64.Msi.x86 | 8.0.0
Microsoft.NETCore.App.Runtime.Mono.wasi-wasm | 8.0.0
Microsoft.NETCore.App.Runtime.win-x86.Msi.x86 | 8.0.0
Microsoft.NETCore.App.Runtime.win-x64.Msi.x64 | 8.0.0
runtime.linux-musl-arm.Microsoft.NETCore.DotNetHost | 8.0.0
runtime.linux-musl-arm64.Microsoft.NETCore.DotNetHostPolicy | 8.0.0
runtime.linux-musl-arm64.Microsoft.NETCore.ILAsm | 8.0.0
runtime.linux-musl-arm64.Microsoft.NETCore.ILDAsm | 8.0.0
runtime.osx-arm64.Microsoft.NETCore.DotNetHost | 8.0.0
runtime.osx-arm64.Microsoft.NETCore.DotNetHostResolver | 8.0.0
runtime.win-x64.Microsoft.DotNet.ILCompiler | 8.0.0
runtime.win-arm64.Microsoft.NETCore.DotNetHost | 8.0.0
runtime.win-x64.Microsoft.NETCore.ILDAsm | 8.0.0
System.Threading.Channels | 8.0.0
System.Threading.RateLimiting | 8.0.0
Microsoft.Extensions.Configuration.FileExtensions | 8.0.0
Microsoft.NETCore.App.Host.linux-musl-arm | 8.0.0
Microsoft.Extensions.Configuration.EnvironmentVariables | 8.0.0
Microsoft.Bcl.AsyncInterfaces | 8.0.0
Microsoft.Bcl.Cryptography | 8.0.0
Microsoft.Bcl.Numerics | 8.0.0
Microsoft.Extensions.Configuration.Abstractions | 8.0.0
Microsoft.Extensions.Configuration.CommandLine | 8.0.0
Microsoft.Extensions.Configuration.Json | 8.0.0
Microsoft.Extensions.Configuration.UserSecrets | 8.0.0
Microsoft.Extensions.DependencyInjection | 8.0.0
Microsoft.Extensions.Configuration.Ini | 8.0.0
Microsoft.Extensions.Diagnostics.Abstractions | 8.0.0
Microsoft.Extensions.DependencyInjection.Specification.Tests | 8.0.0
Microsoft.Extensions.FileProviders.Physical | 8.0.0
Microsoft.Extensions.Diagnostics | 8.0.0
Microsoft.Extensions.Options.DataAnnotations | 8.0.0
Microsoft.Extensions.Primitives | 8.0.0
Microsoft.NET.Runtime.MonoAOTCompiler.Task.Msi.x86 | 8.0.0
Microsoft.NET.Runtime.MonoAOTCompiler.Task.Msi.x64 | 8.0.0
Microsoft.NET.Runtime.MonoTargets.Sdk.Msi.x86 | 8.0.0
Microsoft.NET.Runtime.wasm.Sample.Mono | 8.0.0
Microsoft.NET.Workload.Mono.ToolChain.Current.Manifest-8.0.100.Msi.x64 | 8.0.0
Microsoft.NET.WebAssembly.Threading | 8.0.0
Microsoft.NET.Workload.Mono.ToolChain.net6.Manifest-8.0.100.Msi.x64 | 8.0.0
Microsoft.NET.Workload.Mono.ToolChain.Current.Manifest-8.0.100.Msi.arm64 | 8.0.0
Microsoft.NET.Workload.Mono.ToolChain.net6.Manifest-8.0.100 | 8.0.0
Microsoft.NETCore.App.Crossgen2.linux-musl-arm | 8.0.0
Microsoft.NETCore.App.Crossgen2.linux-arm64 | 8.0.0
Microsoft.NETCore.App.Crossgen2.osx-x64 | 8.0.0
Microsoft.NETCore.App.Runtime.AOT.linux-x64.Cross.android-arm | 8.0.0
Microsoft.NETCore.App.Runtime.AOT.osx-arm64.Cross.android-x86 | 8.0.0
Microsoft.NETCore.App.Runtime.AOT.osx-arm64.Cross.iossimulator-arm64 | 8.0.0
Microsoft.NETCore.App.Runtime.AOT.osx-arm64.Cross.maccatalyst-arm64 | 8.0.0
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.android-arm | 8.0.0
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.maccatalyst-arm64 | 8.0.0
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.tvossimulator-x64 | 8.0.0
Microsoft.NETCore.App.Runtime.AOT.win-x64.Cross.android-arm | 8.0.0
Microsoft.NETCore.App.Runtime.AOT.win-x64.Cross.android-arm.Msi.x64 | 8.0.0
Microsoft.NETCore.App.Runtime.AOT.win-x64.Cross.android-x64 | 8.0.0
Microsoft.NETCore.App.Runtime.AOT.win-x64.Cross.android-x64.Msi.arm64 | 8.0.0
Microsoft.NETCore.App.Runtime.AOT.win-x64.Cross.android-x64.Msi.x64 | 8.0.0
Microsoft.NETCore.App.Runtime.Mono.android-arm.Msi.x86 | 8.0.0
Microsoft.NETCore.App.Runtime.Mono.android-arm64.Msi.x64 | 8.0.0
Microsoft.NETCore.App.Runtime.Mono.android-arm64.Msi.x86 | 8.0.0
Microsoft.NETCore.App.Runtime.Mono.android-x64 | 8.0.0
Microsoft.NETCore.App.Runtime.Mono.android-x86.Msi.x86 | 8.0.0
Microsoft.NETCore.App.Runtime.Mono.android-x86 | 8.0.0
Microsoft.NETCore.App.Runtime.Mono.android-x86.Msi.x64 | 8.0.0
Microsoft.NETCore.App.Runtime.Mono.ios-arm64.Msi.x86 | 8.0.0
Microsoft.NETCore.App.Runtime.Mono.maccatalyst-arm64.Msi.arm64 | 8.0.0
Microsoft.NETCore.App.Runtime.Mono.tvossimulator-x64.Msi.arm64 | 8.0.0
Microsoft.NETCore.App.Runtime.NativeAOT.linux-bionic-arm64 | 8.0.0
runtime.linux-x64.Microsoft.DotNet.ILCompiler | 8.0.0
runtime.linux-musl-arm64.Microsoft.NETCore.DotNetHostResolver | 8.0.0
runtime.linux-musl-x64.Microsoft.NETCore.DotNetHost | 8.0.0
runtime.linux-musl-x64.Microsoft.NETCore.ILAsm | 8.0.0
runtime.linux-musl-x64.Microsoft.NETCore.ILDAsm | 8.0.0
dotnet-ilverify | 8.0.0
Microsoft.Extensions.DependencyInjection.Abstractions | 8.0.0
Microsoft.Extensions.Logging.TraceSource | 8.0.0
Microsoft.Extensions.Options | 8.0.0
Microsoft.NETCore.App.Crossgen2.win-x64 | 8.0.0
Microsoft.NETCore.App.Host.linux-musl-x64 | 8.0.0
Microsoft.NETCore.App.Host.linux-x64 | 8.0.0
Microsoft.NETCore.App.Host.osx-x64 | 8.0.0
Microsoft.NETCore.App.Host.linux-bionic-x64 | 8.0.0
Microsoft.NETCore.App.Host.linux-musl-arm64 | 8.0.0
Microsoft.NETCore.App.Ref | 8.0.0
Microsoft.NETCore.App.Runtime.AOT.linux-x64.Cross.android-x86 | 8.0.0
Microsoft.NETCore.App.Runtime.AOT.linux-x64.Cross.android-arm64 | 8.0.0
Microsoft.NETCore.App.Runtime.AOT.osx-arm64.Cross.android-arm64 | 8.0.0
Microsoft.NETCore.App.Runtime.AOT.osx-arm64.Cross.android-arm | 8.0.0
Microsoft.NETCore.App.Runtime.AOT.osx-arm64.Cross.ios-arm64 | 8.0.0
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.android-x86 | 8.0.0
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.iossimulator-x64 | 8.0.0
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.iossimulator-arm64 | 8.0.0
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.tvossimulator-arm64 | 8.0.0
Microsoft.NETCore.App.Runtime.Mono.android-arm.Msi.arm64 | 8.0.0
Microsoft.NETCore.App.Runtime.Mono.android-arm.Msi.x64 | 8.0.0
Microsoft.NETCore.App.Runtime.Mono.android-x64.Msi.arm64 | 8.0.0
Microsoft.NETCore.App.Runtime.Mono.android-x86.Msi.arm64 | 8.0.0
Microsoft.NETCore.App.Runtime.Mono.browser-wasm.Msi.arm64 | 8.0.0
Microsoft.NETCore.App.Runtime.Mono.linux-musl-x64 | 8.0.0
Microsoft.NETCore.App.Runtime.Mono.LLVM.AOT.linux-arm64 | 8.0.0
Microsoft.NETCore.App.Runtime.Mono.linux-x64 | 8.0.0
Microsoft.NETCore.App.Runtime.Mono.maccatalyst-x64.Msi.arm64 | 8.0.0
Microsoft.NETCore.App.Runtime.Mono.maccatalyst-x64.Msi.x86 | 8.0.0
Microsoft.NETCore.App.Runtime.Mono.wasi-wasm.Msi.x86 | 8.0.0
Microsoft.NETCore.App.Runtime.NativeAOT.iossimulator-arm64 | 8.0.0
Microsoft.NETCore.App.Runtime.NativeAOT.tvossimulator-x64 | 8.0.0
Microsoft.NETCore.App.Runtime.win-arm64 | 8.0.0
Microsoft.NETCore.App.Runtime.win-x64 | 8.0.0
Microsoft.NETCore.App.Runtime.win-x64.Msi.x86 | 8.0.0
Microsoft.NETCore.App.Runtime.win-x86.Msi.arm64 | 8.0.0
runtime.linux-arm64.Microsoft.DotNet.ILCompiler | 8.0.0
Microsoft.Win32.SystemEvents | 8.0.0
runtime.linux-arm.Microsoft.NETCore.DotNetAppHost | 8.0.0
runtime.linux-arm.Microsoft.NETCore.ILDAsm | 8.0.0
runtime.linux-arm64.Microsoft.NETCore.ILAsm | 8.0.0
runtime.linux-bionic-arm64.Microsoft.NETCore.DotNetAppHost | 8.0.0
runtime.linux-bionic-x64.Microsoft.NETCore.DotNetAppHost | 8.0.0
runtime.linux-bionic-arm64.Microsoft.NETCore.DotNetHostResolver | 8.0.0
runtime.linux-bionic-x64.Microsoft.NETCore.DotNetHostPolicy | 8.0.0
runtime.linux-bionic-x64.Microsoft.NETCore.DotNetHost | 8.0.0
runtime.win-x64.Microsoft.NETCore.DotNetHost | 8.0.0
System.DirectoryServices.AccountManagement | 8.0.0
System.DirectoryServices | 8.0.0
System.IO.Hashing | 8.0.0
System.DirectoryServices.Protocols | 8.0.0
System.IO.Packaging | 8.0.0
System.Reflection.MetadataLoadContext | 8.0.0
System.Management | 8.0.0
System.Memory.Data | 8.0.0
Microsoft.Bcl.TimeProvider | 8.0.0
Microsoft.DotNet.ILCompiler | 8.0.0
Microsoft.Extensions.Caching.Abstractions | 8.0.0
Microsoft.Extensions.Caching.Memory | 8.0.0
Microsoft.Extensions.Configuration.Binder | 8.0.0
Microsoft.Extensions.Configuration | 8.0.0
Microsoft.Extensions.Logging | 8.0.0
Microsoft.Extensions.Hosting.Abstractions | 8.0.0
Microsoft.Extensions.Logging.Configuration | 8.0.0
Microsoft.Extensions.Logging.Abstractions | 8.0.0
Microsoft.Extensions.Logging.Debug | 8.0.0
Microsoft.Extensions.Logging.EventSource | 8.0.0
Microsoft.Extensions.Logging.EventLog | 8.0.0
Microsoft.Extensions.Options.ConfigurationExtensions | 8.0.0
Microsoft.NET.Runtime.MonoAOTCompiler.Task.Msi.arm64 | 8.0.0
Microsoft.NET.Runtime.MonoTargets.Sdk | 8.0.0
Microsoft.NET.Runtime.MonoTargets.Sdk.Msi.x64 | 8.0.0
Microsoft.NET.Sdk.WebAssembly.Pack | 8.0.0
Microsoft.NET.Runtime.WebAssembly.Wasi.Sdk.Msi.arm64 | 8.0.0
Microsoft.NET.Workload.Mono.ToolChain.net7.Manifest-8.0.100 | 8.0.0
Microsoft.NETCore.App.Crossgen2.linux-x64 | 8.0.0
Microsoft.NETCore.App.Host.linux-arm | 8.0.0
Microsoft.NETCore.App.Runtime.AOT.linux-x64.Cross.android-x64 | 8.0.0
Microsoft.NETCore.App.Runtime.AOT.osx-arm64.Cross.browser-wasm | 8.0.0
Microsoft.NETCore.App.Runtime.AOT.osx-arm64.Cross.tvossimulator-arm64 | 8.0.0
Microsoft.NETCore.App.Runtime.AOT.win-x64.Cross.browser-wasm | 8.0.0
Microsoft.NETCore.App.Runtime.AOT.win-x64.Cross.browser-wasm.Msi.arm64 | 8.0.0
Microsoft.NETCore.App.Runtime.AOT.win-x64.Cross.browser-wasm.Msi.x64 | 8.0.0
Microsoft.NETCore.App.Runtime.Mono.android-x64.Msi.x86 | 8.0.0
Microsoft.NETCore.App.Runtime.Mono.LLVM.AOT.linux-x64 | 8.0.0
Microsoft.NETCore.App.Runtime.Mono.LLVM.AOT.osx-x64 | 8.0.0
Microsoft.NETCore.App.Runtime.Mono.osx-arm64 | 8.0.0
Microsoft.NETCore.App.Runtime.Mono.tvossimulator-arm64 | 8.0.0
Microsoft.NETCore.App.Runtime.Mono.tvossimulator-arm64.Msi.arm64 | 8.0.0
Microsoft.NETCore.App.Runtime.Mono.tvossimulator-arm64.Msi.x64 | 8.0.0
Microsoft.NETCore.App.Runtime.Mono.wasi-wasm.Msi.x64 | 8.0.0
Microsoft.NETCore.App.Runtime.NativeAOT.maccatalyst-arm64 | 8.0.0
Microsoft.NETCore.App.Runtime.NativeAOT.tvos-arm64 | 8.0.0
runtime.linux-musl-arm.Microsoft.NETCore.ILAsm | 8.0.0
runtime.linux-musl-x64.Microsoft.DotNet.ILCompiler | 8.0.0
runtime.linux-musl-arm64.Microsoft.NETCore.DotNetHost | 8.0.0
runtime.osx-x64.Microsoft.NETCore.DotNetHostPolicy | 8.0.0
runtime.osx-arm64.Microsoft.DotNet.ILCompiler | 8.0.0
runtime.linux-x64.Microsoft.NETCore.DotNetHost | 8.0.0
runtime.osx-arm64.Microsoft.NETCore.DotNetHostPolicy | 8.0.0
runtime.osx-x64.Microsoft.NETCore.DotNetAppHost | 8.0.0
runtime.osx-arm64.Microsoft.NETCore.ILAsm | 8.0.0
runtime.osx-arm64.runtime.native.System.IO.Ports | 8.0.0
runtime.osx-x64.Microsoft.NETCore.DotNetHostResolver | 8.0.0
runtime.osx-x64.runtime.native.System.IO.Ports | 8.0.0
runtime.win-arm64.Microsoft.NETCore.DotNetAppHost | 8.0.0
runtime.win-x86.Microsoft.NETCore.ILAsm | 8.0.0
runtime.win-x86.Microsoft.NETCore.DotNetHost | 8.0.0
runtime.win-x86.Microsoft.NETCore.DotNetHostPolicy | 8.0.0
System.Configuration.ConfigurationManager | 8.0.0
runtime.win-x86.Microsoft.NETCore.ILDAsm | 8.0.0
System.CodeDom | 8.0.0
System.ComponentModel.Composition | 8.0.0
System.Collections.Immutable | 8.0.0
System.ComponentModel.Composition.Registration | 8.0.0
System.Composition | 8.0.0
System.Diagnostics.EventLog | 8.0.0
System.Composition.AttributedModel | 8.0.0
System.Composition.Convention | 8.0.0
System.Data.OleDb | 8.0.0
System.Data.Odbc | 8.0.0
System.Diagnostics.DiagnosticSource | 8.0.0
System.Diagnostics.PerformanceCounter | 8.0.0
System.IO.Pipelines | 8.0.0
System.Security.Cryptography.Pkcs | 8.0.0
System.Runtime.Serialization.Schema | 8.0.0
System.Security.Cryptography.Cose | 8.0.0
System.Speech | 8.0.0
System.Text.Json | 8.0.0
System.Threading.AccessControl | 8.0.0
System.Windows.Extensions | 8.0.0
Microsoft.Extensions.Hosting | 8.0.0
Microsoft.Extensions.FileSystemGlobbing | 8.0.0
Microsoft.Extensions.FileProviders.Abstractions | 8.0.0
Microsoft.Extensions.FileProviders.Composite | 8.0.0
Microsoft.Extensions.Hosting.Systemd | 8.0.0
Microsoft.Extensions.Logging.Console | 8.0.0
Microsoft.Extensions.Hosting.WindowsServices | 8.0.0
Microsoft.Extensions.Http | 8.0.0
Microsoft.NET.Runtime.MonoAOTCompiler.Task | 8.0.0
Microsoft.NET.Runtime.LibraryBuilder.Sdk | 8.0.0
Microsoft.NET.Runtime.iOS.Sample.Mono | 8.0.0
Microsoft.NET.Runtime.WebAssembly.Templates.Msi.x64 | 8.0.0
Microsoft.NET.Runtime.WebAssembly.Wasi.Sdk.Msi.x64 | 8.0.0
Microsoft.NET.Runtime.WebAssembly.Wasi.Sdk.Msi.x86 | 8.0.0
Microsoft.NET.Workload.Mono.ToolChain.Current.Manifest-8.0.100 | 8.0.0
Microsoft.NET.Sdk.IL | 8.0.0
Microsoft.NETCore.App.Crossgen2.osx-arm64 | 8.0.0
Microsoft.NETCore.App.Host.linux-arm64 | 8.0.0
Microsoft.NETCore.App.Crossgen2.win-arm64 | 8.0.0
Microsoft.NETCore.App.Host.linux-bionic-arm64 | 8.0.0
Microsoft.NETCore.App.Host.win-x64 | 8.0.0
Microsoft.NETCore.App.Runtime.AOT.linux-arm64.Cross.android-arm | 8.0.0
Microsoft.NETCore.App.Runtime.AOT.linux-x64.Cross.browser-wasm | 8.0.0
Microsoft.NETCore.App.Runtime.AOT.osx-arm64.Cross.android-x64 | 8.0.0
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.maccatalyst-x64 | 8.0.0
Microsoft.NETCore.App.Runtime.AOT.win-x64.Cross.android-arm64 | 8.0.0
Microsoft.NETCore.App.Runtime.AOT.win-x64.Cross.android-arm64.Msi.arm64 | 8.0.0
Microsoft.NETCore.App.Runtime.AOT.win-x64.Cross.android-arm64.Msi.x64 | 8.0.0
Microsoft.NETCore.App.Runtime.linux-arm64 | 8.0.0
Microsoft.NETCore.App.Runtime.AOT.win-x64.Cross.android-x86.Msi.arm64 | 8.0.0
Microsoft.NETCore.App.Runtime.linux-musl-arm | 8.0.0
Microsoft.NETCore.App.Runtime.linux-musl-arm64 | 8.0.0
Microsoft.NETCore.App.Runtime.Mono.browser-wasm | 8.0.0
Microsoft.NETCore.App.Runtime.Mono.ios-arm64.Msi.x64 | 8.0.0
Microsoft.NETCore.App.Runtime.Mono.iossimulator-arm64.Msi.x86 | 8.0.0
Microsoft.NETCore.App.Runtime.Mono.iossimulator-x64.Msi.x64 | 8.0.0
Microsoft.NETCore.App.Runtime.Mono.multithread.browser-wasm | 8.0.0
Microsoft.NETCore.App.Runtime.Mono.tvos-arm64 | 8.0.0
Microsoft.NETCore.App.Runtime.Mono.tvos-arm64.Msi.x86 | 8.0.0
Microsoft.NETCore.App.Runtime.Mono.tvossimulator-x64 | 8.0.0
Microsoft.NETCore.App.Runtime.osx-x64 | 8.0.0
Microsoft.NETCore.App.Runtime.osx-arm64 | 8.0.0
Microsoft.NETCore.App.Runtime.win-arm64.Msi.arm64 | 8.0.0
Microsoft.NETCore.App.Runtime.win-arm64.Msi.x86 | 8.0.0
Microsoft.NETCore.App.Runtime.win-x86.Msi.x64 | 8.0.0
runtime.linux-musl-arm.Microsoft.NETCore.DotNetHostPolicy | 8.0.0
Microsoft.NETCore.DotNetAppHost | 8.0.0
Microsoft.NETCore.DotNetHost | 8.0.0
Microsoft.NETCore.DotNetHostPolicy | 8.0.0
Microsoft.NETCore.DotNetHostResolver | 8.0.0
Microsoft.XmlSerializer.Generator | 8.0.0
Microsoft.NETCore.ILAsm | 8.0.0
Microsoft.NETCore.ILDAsm | 8.0.0
Microsoft.Win32.Registry.AccessControl | 8.0.0
runtime.linux-arm.Microsoft.NETCore.DotNetHost | 8.0.0
runtime.linux-arm.Microsoft.NETCore.DotNetHostPolicy | 8.0.0
runtime.linux-arm.Microsoft.NETCore.DotNetHostResolver | 8.0.0
runtime.linux-arm.Microsoft.NETCore.ILAsm | 8.0.0
runtime.linux-arm64.Microsoft.NETCore.DotNetHost | 8.0.0
runtime.linux-arm64.Microsoft.NETCore.DotNetHostPolicy | 8.0.0
runtime.linux-arm64.Microsoft.NETCore.ILDAsm | 8.0.0
runtime.linux-arm64.Microsoft.NETCore.DotNetHostResolver | 8.0.0
runtime.linux-arm64.runtime.native.System.IO.Ports | 8.0.0
runtime.linux-bionic-arm64.Microsoft.NETCore.DotNetHost | 8.0.0
runtime.linux-musl-arm64.Microsoft.DotNet.ILCompiler | 8.0.0
runtime.linux-musl-arm.Microsoft.NETCore.ILDAsm | 8.0.0
runtime.linux-musl-x64.Microsoft.NETCore.DotNetAppHost | 8.0.0
runtime.linux-musl-x64.Microsoft.NETCore.DotNetHostResolver | 8.0.0
runtime.linux-x64.Microsoft.NETCore.DotNetHostPolicy | 8.0.0
runtime.linux-x64.Microsoft.NETCore.DotNetHostResolver | 8.0.0
runtime.linux-x64.Microsoft.NETCore.ILAsm | 8.0.0
runtime.linux-x64.Microsoft.NETCore.ILDAsm | 8.0.0
runtime.native.System.IO.Ports | 8.0.0
runtime.linux-x64.runtime.native.System.IO.Ports | 8.0.0
runtime.osx-arm64.Microsoft.NETCore.DotNetAppHost | 8.0.0
runtime.osx-arm64.Microsoft.NETCore.ILDAsm | 8.0.0
runtime.osx-x64.Microsoft.NETCore.DotNetHost | 8.0.0
runtime.osx-x64.Microsoft.NETCore.ILAsm | 8.0.0
runtime.osx-x64.Microsoft.NETCore.ILDAsm | 8.0.0
runtime.win-arm64.Microsoft.NETCore.DotNetHostResolver | 8.0.0
runtime.win-arm64.Microsoft.NETCore.ILAsm | 8.0.0
runtime.win-x64.Microsoft.NETCore.DotNetAppHost | 8.0.0
runtime.win-x86.Microsoft.NETCore.DotNetHostResolver | 8.0.0
runtime.win-x64.Microsoft.NETCore.DotNetHostPolicy | 8.0.0
runtime.win-x86.Microsoft.NETCore.DotNetAppHost | 8.0.0
System.Composition.Hosting | 8.0.0
System.Composition.Runtime | 8.0.0
System.Composition.TypedParts | 8.0.0
System.Formats.Asn1 | 8.0.0
System.Formats.Cbor | 8.0.0
System.Reflection.Metadata | 8.0.0
System.Net.Http.Json | 8.0.0
System.Net.Http.WinHttpHandler | 8.0.0
System.Security.Cryptography.ProtectedData | 8.0.0
System.Text.Encodings.Web | 8.0.0
System.ServiceModel.Syndication | 8.0.0
System.ServiceProcess.ServiceController | 8.0.0
System.Text.Encoding.CodePages | 8.0.0
System.Threading.Tasks.Dataflow | 8.0.0
Microsoft.NETCore.App.Runtime.AOT.linux-arm64.Cross.android-arm64 | 8.0.0
Microsoft.NETCore.App.Runtime.AOT.osx-arm64.Cross.maccatalyst-x64 | 8.0.0
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.android-x64 | 8.0.0
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.android-arm64 | 8.0.0
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.ios-arm64 | 8.0.0
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.browser-wasm | 8.0.0
Microsoft.NETCore.App.Runtime.AOT.osx-x64.Cross.tvos-arm64 | 8.0.0
Microsoft.NETCore.App.Runtime.AOT.win-x64.Cross.android-x86 | 8.0.0
Microsoft.NETCore.App.Runtime.Mono.browser-wasm.Msi.x86 | 8.0.0
Microsoft.NETCore.App.Runtime.Mono.ios-arm64.Msi.arm64 | 8.0.0
Microsoft.NETCore.App.Runtime.Mono.iossimulator-arm64.Msi.arm64 | 8.0.0
Microsoft.NETCore.App.Runtime.Mono.iossimulator-x64.Msi.arm64 | 8.0.0
Microsoft.NETCore.App.Runtime.Mono.linux-arm | 8.0.0
Microsoft.NETCore.App.Runtime.Mono.LLVM.linux-arm64 | 8.0.0
Microsoft.NETCore.App.Runtime.Mono.LLVM.osx-x64 | 8.0.0
Microsoft.NETCore.App.Runtime.Mono.multithread.browser-wasm.Msi.arm64 | 8.0.0
Microsoft.NETCore.App.Runtime.Mono.osx-x64 | 8.0.0
Microsoft.NETCore.App.Runtime.Mono.tvossimulator-arm64.Msi.x86 | 8.0.0
Microsoft.NETCore.App.Runtime.Mono.win-x86 | 8.0.0
Microsoft.NETCore.App.Runtime.Mono.win-x64 | 8.0.0
Microsoft.NETCore.App.Runtime.NativeAOT.ios-arm64 | 8.0.0
Microsoft.NETCore.App.Runtime.NativeAOT.osx-arm64 | 8.0.0
Microsoft.NETCore.App.Runtime.NativeAOT.osx-x64 | 8.0.0
Microsoft.NETCore.App.Runtime.win-x64.Msi.arm64 | 8.0.0
runtime.linux-arm64.Microsoft.NETCore.DotNetAppHost | 8.0.0
runtime.linux-bionic-arm64.Microsoft.NETCore.DotNetHostPolicy | 8.0.0
runtime.linux-bionic-x64.Microsoft.NETCore.DotNetHostResolver | 8.0.0
runtime.linux-musl-arm.Microsoft.NETCore.DotNetAppHost | 8.0.0
runtime.linux-musl-arm.Microsoft.NETCore.DotNetHostResolver | 8.0.0
runtime.linux-musl-arm64.Microsoft.NETCore.DotNetAppHost | 8.0.0
runtime.linux-musl-x64.Microsoft.NETCore.DotNetHostPolicy | 8.0.0
runtime.linux-x64.Microsoft.NETCore.DotNetAppHost | 8.0.0
runtime.osx-x64.Microsoft.DotNet.ILCompiler | 8.0.0
runtime.win-arm64.Microsoft.DotNet.ILCompiler | 8.0.0
runtime.win-arm64.Microsoft.NETCore.DotNetHostPolicy | 8.0.0
runtime.win-x64.Microsoft.NETCore.DotNetHostResolver | 8.0.0
runtime.win-arm64.Microsoft.NETCore.ILDAsm | 8.0.0
runtime.win-x64.Microsoft.NETCore.ILAsm | 8.0.0
System.IO.Ports | 8.0.0
System.Numerics.Tensors | 8.0.0
System.Runtime.Caching | 8.0.0
System.Reflection.Context | 8.0.0
System.Resources.Extensions | 8.0.0
System.Security.Cryptography.Xml | 8.0.0
Microsoft.NETCore.App.Runtime.AOT.win-x64.Cross.android-x86.Msi.x64 | 8.0.0
Microsoft.NETCore.App.Runtime.Mono.iossimulator-arm64 | 8.0.0
Microsoft.NETCore.App.Runtime.Mono.iossimulator-arm64.Msi.x64 | 8.0.0
System.Security.Permissions | 8.0.0
Microsoft.Extensions.DependencyModel | 8.0.0
Microsoft.Extensions.Configuration.Xml | 8.0.0
Microsoft.ILVerification | 8.0.0
Microsoft.NET.Runtime.Android.Sample.Mono | 8.0.0
Microsoft.NET.Runtime.WebAssembly.Sdk.Msi.arm64 | 8.0.0
Microsoft.NET.Runtime.WebAssembly.Sdk.Msi.x64 | 8.0.0
Microsoft.NET.Runtime.WebAssembly.Sdk.Msi.x86 | 8.0.0
Microsoft.NET.Workload.Mono.ToolChain.Current.Manifest-8.0.100.Msi.x86 | 8.0.0
Microsoft.NET.Workload.Mono.ToolChain.net6.Manifest-8.0.100.Msi.arm64 | 8.0.0
Microsoft.NET.Workload.Mono.ToolChain.net6.Manifest-8.0.100.Msi.x86 | 8.0.0
Microsoft.NET.Workload.Mono.ToolChain.net7.Manifest-8.0.100.Msi.x86 | 8.0.0
Microsoft.NETCore.App.Crossgen2.linux-musl-x64 | 8.0.0
Microsoft.NETCore.App.Crossgen2.linux-musl-arm64 | 8.0.0
Microsoft.NETCore.App.Host.win-arm64 | 8.0.0
Microsoft.NETCore.App.Host.win-x86 | 8.0.0
Microsoft.NETCore.App.Runtime.AOT.osx-arm64.Cross.iossimulator-x64 | 8.0.0
Microsoft.NETCore.App.Runtime.AOT.osx-arm64.Cross.tvos-arm64 | 8.0.0
Microsoft.NETCore.App.Runtime.AOT.osx-arm64.Cross.tvossimulator-x64 | 8.0.0
Microsoft.NETCore.App.Runtime.linux-arm | 8.0.0
Microsoft.NETCore.App.Runtime.linux-bionic-x64 | 8.0.0
Microsoft.NETCore.App.Runtime.Mono.android-arm64.Msi.arm64 | 8.0.0
Microsoft.NETCore.App.Runtime.Mono.android-x64.Msi.x64 | 8.0.0
Microsoft.NETCore.App.Runtime.Mono.browser-wasm.Msi.x64 | 8.0.0
Microsoft.NETCore.App.Runtime.Mono.iossimulator-x64 | 8.0.0
Microsoft.NETCore.App.Runtime.Mono.maccatalyst-arm64 | 8.0.0
Microsoft.NETCore.App.Runtime.Mono.LLVM.linux-x64 | 8.0.0
Microsoft.NETCore.App.Runtime.Mono.maccatalyst-arm64.Msi.x64 | 8.0.0
Microsoft.NETCore.App.Runtime.Mono.maccatalyst-x64 | 8.0.0
Microsoft.NETCore.App.Runtime.Mono.maccatalyst-arm64.Msi.x86 | 8.0.0
Microsoft.NETCore.App.Runtime.Mono.maccatalyst-x64.Msi.x64 | 8.0.0
Microsoft.NETCore.App.Runtime.Mono.multithread.browser-wasm.Msi.x64 | 8.0.0
Microsoft.NETCore.App.Runtime.Mono.tvos-arm64.Msi.arm64 | 8.0.0
Microsoft.NETCore.App.Runtime.Mono.tvos-arm64.Msi.x64 | 8.0.0
Microsoft.NETCore.App.Runtime.Mono.wasi-wasm.Msi.arm64 | 8.0.0
Microsoft.NETCore.App.Runtime.NativeAOT.iossimulator-x64 | 8.0.0
Microsoft.NETCore.App.Runtime.NativeAOT.linux-bionic-x64 | 8.0.0
Microsoft.NETCore.App.Runtime.NativeAOT.maccatalyst-x64 | 8.0.0
Microsoft.NETCore.App.Runtime.NativeAOT.tvossimulator-arm64 | 8.0.0
Microsoft.NETCore.App.Runtime.win-arm64.Msi.x64 | 8.0.0
Microsoft.NETCore.App.Runtime.win-x86 | 8.0.0
runtime.linux-arm.runtime.native.System.IO.Ports | 8.0.0
Microsoft.AspNetCore.App.Runtime.linux-arm | 8.0.0
Microsoft.AspNetCore.App.Runtime.osx-arm64 | 8.0.0
Microsoft.AspNetCore.App.Runtime.linux-musl-arm64 | 8.0.0
AspNetCoreRuntime.8.0.x86 | 8.0.0
Microsoft.AspNetCore.App.Runtime.win-x86 | 8.0.0
Microsoft.AspNetCore.Authentication.Certificate | 8.0.0
Microsoft.AspNetCore.Authentication.Facebook | 8.0.0
Microsoft.AspNetCore.Authentication.Google | 8.0.0
Microsoft.AspNetCore.Authentication.JwtBearer | 8.0.0
Microsoft.AspNetCore.Authentication.MicrosoftAccount | 8.0.0
Microsoft.AspNetCore.Authentication.Negotiate | 8.0.0
Microsoft.AspNetCore.Authentication.OpenIdConnect | 8.0.0
Microsoft.AspNetCore.Authentication.Twitter | 8.0.0
Microsoft.AspNetCore.Authentication.WsFederation | 8.0.0
Microsoft.AspNetCore.Components | 8.0.0
Microsoft.AspNetCore.AzureAppServices.HostingStartup | 8.0.0
Microsoft.AspNetCore.Components.WebAssembly.DevServer | 8.0.0
Microsoft.AspNetCore.AzureAppServices.SiteExtension | 8.0.0
Microsoft.AspNetCore.Components.QuickGrid | 8.0.0
Microsoft.AspNetCore.Components.QuickGrid.EntityFrameworkAdapter | 8.0.0
Microsoft.AspNetCore.Components.WebAssembly.Server | 8.0.0
Microsoft.AspNetCore.Grpc.JsonTranscoding | 8.0.0
Microsoft.AspNetCore.Components.WebView | 8.0.0
Microsoft.AspNetCore.Connections.Abstractions | 8.0.0
Microsoft.AspNetCore.ConcurrencyLimiter | 8.0.0
Microsoft.AspNetCore.DataProtection.Extensions | 8.0.0
Microsoft.AspNetCore.DataProtection.Abstractions | 8.0.0
Microsoft.AspNetCore.Mvc.NewtonsoftJson | 8.0.0
Microsoft.AspNetCore.Mvc.Testing | 8.0.0
Microsoft.AspNetCore.OutputCaching.StackExchangeRedis | 8.0.0
Microsoft.AspNetCore.OpenApi | 8.0.0
Microsoft.AspNetCore.SignalR.Client.Core | 8.0.0
Microsoft.Authentication.WebAssembly.Msal | 8.0.0
Microsoft.AspNetCore.SpaServices.Extensions | 8.0.0
Microsoft.AspNetCore.WebUtilities | 8.0.0
Microsoft.AspNetCore.TestHost | 8.0.0
Microsoft.DotNet.Web.ItemTemplates.8.0 | 8.0.0
Microsoft.Extensions.Caching.SqlServer | 8.0.0
Microsoft.Extensions.Diagnostics.HealthChecks | 8.0.0
Microsoft.Extensions.Identity.Stores | 8.0.0
Microsoft.Extensions.Localization | 8.0.0
Microsoft.AspNetCore.Components.Analyzers | 8.0.0
Microsoft.AspNetCore.Components.WebAssembly.Authentication | 8.0.0
Microsoft.AspNetCore.Cryptography.Internal | 8.0.0
Microsoft.AspNetCore.Cryptography.KeyDerivation | 8.0.0
Microsoft.AspNetCore.DataProtection | 8.0.0
Microsoft.AspNetCore.Hosting.WindowsServices | 8.0.0
Microsoft.AspNetCore.Metadata | 8.0.0
Microsoft.AspNetCore.Mvc.Razor.RuntimeCompilation | 8.0.0
Microsoft.AspNetCore.Http.Connections.Common | 8.0.0
Microsoft.AspNetCore.Http.Connections.Client | 8.0.0
Microsoft.AspNetCore.Identity.EntityFrameworkCore | 8.0.0
Microsoft.AspNetCore.Identity.UI | 8.0.0
Microsoft.AspNetCore.JsonPatch | 8.0.0
Microsoft.AspNetCore.MiddlewareAnalysis | 8.0.0
Microsoft.AspNetCore.Owin | 8.0.0
Microsoft.AspNetCore.SignalR.Client | 8.0.0
Microsoft.DotNet.Web.Client.ItemTemplates | 8.0.0
Microsoft.Extensions.Caching.StackExchangeRedis | 8.0.0
Microsoft.Extensions.Diagnostics.HealthChecks.EntityFrameworkCore | 8.0.0
Microsoft.Extensions.FileProviders.Embedded | 8.0.0
Microsoft.Extensions.Identity.Core | 8.0.0
Microsoft.Extensions.Logging.AzureAppServices | 8.0.0
Microsoft.Extensions.ObjectPool | 8.0.0
Microsoft.AspNetCore.App.Runtime.linux-musl-x64 | 8.0.0
Microsoft.AspNetCore.App.Runtime.win-x64 | 8.0.0
Microsoft.AspNetCore.SignalR.Protocols.MessagePack | 8.0.0
Microsoft.AspNetCore.SignalR.Protocols.NewtonsoftJson | 8.0.0
Microsoft.dotnet-openapi | 8.0.0
Microsoft.DotNet.Web.ProjectTemplates.8.0 | 8.0.0
Microsoft.Extensions.Features | 8.0.0
Microsoft.Extensions.Localization.Abstractions | 8.0.0
Microsoft.Extensions.WebEncoders | 8.0.0
Microsoft.JSInterop | 8.0.0
Microsoft.JSInterop.WebAssembly | 8.0.0
Microsoft.Net.Http.Headers | 8.0.0
Microsoft.AspNetCore.App.Runtime.linux-musl-arm | 8.0.0
Microsoft.AspNetCore.App.Runtime.linux-arm64 | 8.0.0
Microsoft.AspNetCore.App.Runtime.osx-x64 | 8.0.0
dotnet-sql-cache | 8.0.0
Microsoft.AspNetCore.Authorization | 8.0.0
Microsoft.AspNetCore.AzureAppServicesIntegration | 8.0.0
Microsoft.AspNetCore.Components.Forms | 8.0.0
Microsoft.AspNetCore.Components.Authorization | 8.0.0
Microsoft.AspNetCore.Components.Web | 8.0.0
Microsoft.AspNetCore.Components.CustomElements | 8.0.0
Microsoft.AspNetCore.Components.WebAssembly | 8.0.0
Microsoft.AspNetCore.DataProtection.EntityFrameworkCore | 8.0.0
Microsoft.AspNetCore.DataProtection.StackExchangeRedis | 8.0.0
Microsoft.AspNetCore.Diagnostics.EntityFrameworkCore | 8.0.0
Microsoft.AspNetCore.Grpc.Swagger | 0.8.0
Microsoft.AspNetCore.HeaderPropagation | 8.0.0
Microsoft.AspNetCore.SpaProxy | 8.0.0
Microsoft.AspNetCore.SignalR.Common | 8.0.0
Microsoft.AspNetCore.SignalR.Protocols.Json | 8.0.0
Microsoft.AspNetCore.SignalR.Specification.Tests | 8.0.0
Microsoft.AspNetCore.SignalR.StackExchangeRedis | 8.0.0
Microsoft.Extensions.ApiDescription.Client | 8.0.0
Microsoft.Extensions.ApiDescription.Server | 8.0.0
Microsoft.Extensions.Diagnostics.HealthChecks.Abstractions | 8.0.0
Microsoft.Extensions.Http.Polly | 8.0.0
Microsoft.AspNetCore.App.Runtime.linux-x64 | 8.0.0
AspNetCoreRuntime.8.0.x64 | 8.0.0
Microsoft.AspNetCore.App.Ref | 8.0.0
Microsoft.AspNetCore.App.Runtime.win-arm64 | 8.0.0
Microsoft.Extensions.Configuration.KeyPerFile | 8.0.0
Microsoft.NET.Build.Containers | 8.0.100
Microsoft.DotNet.ApiCompat.Task | 8.0.100
FSharp.Core | 8.0.100
Microsoft.DotNet.Common.ItemTemplates | 8.0.100
Microsoft.DotNet.Common.ProjectTemplates.8.0 | 8.0.100
Microsoft.DotNet.ApiCompat.Tool | 8.0.100
FSharp.Compiler.Service | 43.8.100
System.Drawing.Common | 8.0.0
Microsoft.NET.Runtime.Emscripten.3.1.34.Cache.linux-arm64 | 8.0.0
Microsoft.NET.Runtime.Emscripten.3.1.34.Node.osx-arm64 | 8.0.0
Microsoft.NET.Runtime.Emscripten.3.1.34.Node.win-arm64.Msi.arm64 | 8.0.0
Microsoft.NET.Runtime.Emscripten.3.1.34.Cache.osx-x64 | 8.0.0
Microsoft.NET.Runtime.Emscripten.3.1.34.Sdk.osx-x64 | 8.0.0
Microsoft.NET.Runtime.Emscripten.3.1.34.Cache.win-x64 | 8.0.0
Microsoft.NET.Workload.Emscripten.net7.Manifest-8.0.100.Msi.x64 | 8.0.0
Microsoft.NET.Workload.Emscripten.net7.Manifest-8.0.100.Msi.x86 | 8.0.0
Microsoft.NET.Runtime.Emscripten.3.1.34.Node.win-x64 | 8.0.0
Microsoft.NET.Runtime.Emscripten.3.1.34.Cache.linux-x64 | 8.0.0
Microsoft.NET.Runtime.Emscripten.3.1.34.Sdk.osx-arm64 | 8.0.0
Microsoft.NET.Runtime.Emscripten.3.1.34.Python.osx-arm64 | 8.0.0
Microsoft.NET.Runtime.Emscripten.3.1.34.Cache.win-x64.Msi.x64 | 8.0.0
Microsoft.NET.Runtime.Emscripten.3.1.34.Node.win-x64.Msi.x64 | 8.0.0
Microsoft.NET.Runtime.Emscripten.3.1.34.Sdk.win-x64 | 8.0.0
Microsoft.NET.Workload.Emscripten.Current.Manifest-8.0.100.Msi.arm64 | 8.0.0
Microsoft.NET.Workload.Emscripten.Current.Manifest-8.0.100.Msi.x64 | 8.0.0
Microsoft.NET.Runtime.Emscripten.3.1.34.Sdk.linux-arm64 | 8.0.0
Microsoft.NET.Runtime.Emscripten.3.1.34.Node.linux-arm64 | 8.0.0
Microsoft.NET.Runtime.Emscripten.3.1.34.Cache.osx-arm64 | 8.0.0
Microsoft.NET.Runtime.Emscripten.3.1.34.Node.linux-x64 | 8.0.0
Microsoft.NET.Runtime.Emscripten.3.1.34.Node.osx-x64 | 8.0.0
Microsoft.NET.Runtime.Emscripten.3.1.34.Cache.win-arm64 | 8.0.0
Microsoft.NET.Runtime.Emscripten.3.1.34.Python.win-x64.Msi.x64 | 8.0.0
Microsoft.NET.Workload.Emscripten.net6.Manifest-8.0.100.Msi.arm64 | 8.0.0
Microsoft.NET.Runtime.Emscripten.3.1.34.Python.win-x64 | 8.0.0
Microsoft.NET.Workload.Emscripten.Current.Manifest-8.0.100 | 8.0.0
Microsoft.NET.Runtime.Emscripten.3.1.34.Sdk.linux-x64 | 8.0.0
Microsoft.NET.Runtime.Emscripten.3.1.34.Sdk.win-arm64 | 8.0.0
Microsoft.NET.Runtime.Emscripten.3.1.34.Python.osx-x64 | 8.0.0
Microsoft.NET.Workload.Emscripten.Current.Manifest-8.0.100.Msi.x86 | 8.0.0
Microsoft.NET.Workload.Emscripten.net6.Manifest-8.0.100.Msi.x64 | 8.0.0
Microsoft.NET.Workload.Emscripten.net7.Manifest-8.0.100.Msi.arm64 | 8.0.0
Microsoft.NET.Workload.Emscripten.net6.Manifest-8.0.100 | 8.0.0
Microsoft.NET.Runtime.Emscripten.3.1.34.Python.win-arm64.Msi.arm64 | 8.0.0
Microsoft.NET.Runtime.Emscripten.3.1.34.Sdk.win-x64.Msi.x64 | 8.0.0
Microsoft.NET.Workload.Emscripten.net7.Manifest-8.0.100 | 8.0.0
Microsoft.NET.Runtime.Emscripten.3.1.34.Cache.win-arm64.Msi.arm64 | 8.0.0
Microsoft.NET.Runtime.Emscripten.3.1.34.Node.win-arm64 | 8.0.0
Microsoft.NET.Runtime.Emscripten.3.1.34.Python.win-arm64 | 8.0.0
Microsoft.NET.Runtime.Emscripten.3.1.34.Sdk.win-arm64.Msi.arm64 | 8.0.0
Microsoft.NET.Workload.Emscripten.net6.Manifest-8.0.100.Msi.x86 | 8.0.0
Microsoft.Data.Sqlite | 8.0.0
Microsoft.EntityFrameworkCore.AspNet.Specification.Tests | 8.0.0
Microsoft.EntityFrameworkCore.Abstractions | 8.0.0
Microsoft.EntityFrameworkCore.Analyzers | 8.0.0
Microsoft.EntityFrameworkCore.Tools | 8.0.0
Microsoft.Data.Sqlite.Core | 8.0.0
dotnet-ef | 8.0.0
Microsoft.EntityFrameworkCore | 8.0.0
Microsoft.EntityFrameworkCore.SqlServer | 8.0.0
Microsoft.EntityFrameworkCore.Sqlite.NetTopologySuite | 8.0.0
Microsoft.EntityFrameworkCore.SqlServer.Abstractions | 8.0.0
Microsoft.EntityFrameworkCore.SqlServer.NetTopologySuite | 8.0.0
Microsoft.EntityFrameworkCore.SqlServer.HierarchyId | 8.0.0
Microsoft.EntityFrameworkCore.Sqlite.Core | 8.0.0
Microsoft.EntityFrameworkCore.Cosmos | 8.0.0
Microsoft.EntityFrameworkCore.Design | 8.0.0
Microsoft.EntityFrameworkCore.Proxies | 8.0.0
Microsoft.EntityFrameworkCore.InMemory | 8.0.0
Microsoft.EntityFrameworkCore.Sqlite | 8.0.0
Microsoft.EntityFrameworkCore.Relational | 8.0.0
Microsoft.EntityFrameworkCore.Specification.Tests | 8.0.0
Microsoft.EntityFrameworkCore.Relational.Specification.Tests | 8.0.0
Microsoft.EntityFrameworkCore.Templates | 8.0.0
Microsoft.TemplateEngine.Authoring.Templates | 8.0.100
Microsoft.TemplateEngine.Core.Contracts | 8.0.100
Microsoft.TemplateEngine.Utils | 8.0.100
Microsoft.TemplateEngine.Authoring.Tasks | 8.0.100
Microsoft.TemplateEngine.Abstractions | 8.0.100
Microsoft.TemplateEngine.Authoring.TemplateVerifier | 8.0.100
Microsoft.TemplateEngine.Authoring.CLI | 8.0.100
Microsoft.TemplateEngine.Edge | 8.0.100
Microsoft.TemplateEngine.IDE | 8.0.100
Microsoft.TemplateEngine.TemplateLocalizer.Core | 8.0.100
Microsoft.TemplateEngine.Samples | 8.0.100
Microsoft.TemplateEngine.Orchestrator.RunnableProjects | 8.0.100
Microsoft.TemplateSearch.Common | 8.0.100
Microsoft.TemplateEngine.Core | 8.0.100
Microsoft.CodeAnalysis.Analyzers | 3.11.0-beta1.23525.2
Microsoft.CodeAnalysis.NetAnalyzers | 8.0.0-preview.23525.2
Microsoft.CodeAnalysis.BannedApiAnalyzers | 3.11.0-beta1.23525.2
Microsoft.CodeAnalysis.PerformanceSensitiveAnalyzers | 3.11.0-beta1.23525.2
Microsoft.CodeAnalysis.PublicApiAnalyzers | 3.11.0-beta1.23525.2
Microsoft.CodeAnalysis.ResxSourceGenerator | 3.11.0-beta1.23525.2
Microsoft.CodeAnalysis.Metrics | 4.0.0-beta1.23525.2
Microsoft.CodeAnalysis.AnalyzerUtilities | 3.11.0-beta1.23525.2
Roslyn.Diagnostics.Analyzers | 3.11.0-beta1.23525.2
Microsoft.CodeAnalysis.RulesetToEditorconfigConverter | 3.11.0-beta1.23525.2
Text.Analyzers | 3.11.0-beta1.23525.2
Microsoft.AspNetCore.Diagnostics.Middleware | 8.0.0
Microsoft.AspNetCore.AsyncState | 8.0.0
Microsoft.AspNetCore.HeaderParsing | 8.0.0
Microsoft.AspNetCore.Testing | 8.0.0
Microsoft.Extensions.AsyncState | 8.0.0
Microsoft.Extensions.DependencyInjection.AutoActivation | 8.0.0
Microsoft.Extensions.Diagnostics.HealthChecks.Common | 8.0.0
Microsoft.Extensions.Diagnostics.Probes | 8.0.0
Microsoft.Extensions.Diagnostics.ResourceMonitoring | 8.0.0
Microsoft.Extensions.Hosting.Testing | 8.0.0
Microsoft.Extensions.Diagnostics.Testing | 8.0.0
Microsoft.Extensions.Http.Resilience | 8.0.0
Microsoft.Extensions.StaticAnalysis | 8.0.0
Microsoft.Extensions.Compliance.Testing | 8.0.0
Microsoft.Extensions.Diagnostics.HealthChecks.ResourceUtilization | 8.0.0
Microsoft.Extensions.Http.Diagnostics | 8.0.0
Microsoft.Extensions.Options.Contextual | 8.0.0
Microsoft.Extensions.Resilience | 8.0.0
Microsoft.Extensions.Telemetry.Abstractions | 8.0.0
Microsoft.Extensions.Telemetry | 8.0.0
Microsoft.Extensions.TimeProvider.Testing | 8.0.0
Microsoft.Extensions.Compliance.Redaction | 8.0.0
Microsoft.Extensions.AmbientMetadata.Application | 8.0.0
Microsoft.Extensions.AuditReports | 8.0.0
Microsoft.Extensions.Compliance.Abstractions | 8.0.0
Microsoft.Extensions.Diagnostics.ExceptionSummarization | 8.0.0
Microsoft.Extensions.ObjectPool.DependencyInjection | 8.0.0

[//]: # ( Runtime 8.0.0)
[dotnet-runtime-linux-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/ee0a9245-5b87-4217-a9a5-dc589187612e/f3631cfe19cb713296314a6028a9e856/dotnet-runtime-8.0.0-linux-arm.tar.gz
[dotnet-runtime-linux-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/c879318f-48f3-4cc4-8dcc-a6b77cfdfc38/7890f8a96ea335f5265cd1aa80cac8ce/dotnet-runtime-8.0.0-linux-arm64.tar.gz
[dotnet-runtime-linux-musl-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/81cc059e-5697-45b2-bf61-a5f4834ae487/85e37684156ca9501d852a27749ec3cd/dotnet-runtime-8.0.0-linux-musl-arm.tar.gz
[dotnet-runtime-linux-musl-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/73ecf1eb-9823-4b32-bc5f-823e4d9ff871/51b31972bc51ac971430a01119bd6b19/dotnet-runtime-8.0.0-linux-musl-arm64.tar.gz
[dotnet-runtime-linux-musl-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/731765c8-5774-414d-8157-bf184806bca9/7a3c7add7562e1be15954a2739fefe30/dotnet-runtime-8.0.0-linux-musl-x64.tar.gz
[dotnet-runtime-linux-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/fc4b4447-45f2-4fd2-899a-77eb1aed7792/6fd52c0c61f064ddc7fe7684e841f491/dotnet-runtime-8.0.0-linux-x64.tar.gz
[dotnet-runtime-osx-arm64.pkg]: https://download.visualstudio.microsoft.com/download/pr/afde1c3f-4e87-402f-8e38-44ea71a6f5f5/cfd54a005105ca0ea48fbc189155cbe4/dotnet-runtime-8.0.0-osx-arm64.pkg
[dotnet-runtime-osx-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/65665fae-8f24-4214-89b5-980dbad7be30/1b70f4b76e076b4b656879426e861fbd/dotnet-runtime-8.0.0-osx-arm64.tar.gz
[dotnet-runtime-osx-x64.pkg]: https://download.visualstudio.microsoft.com/download/pr/5a409864-2f8c-4801-9fa2-6913c487218d/919476e4f52ee910b7c1bb9cfdefa746/dotnet-runtime-8.0.0-osx-x64.pkg
[dotnet-runtime-osx-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/65e0ad28-b73d-46ab-b3ae-2d2ae4460b78/50ee103e816a255f9a5331bc2975a6ef/dotnet-runtime-8.0.0-osx-x64.tar.gz
[dotnet-runtime-win-arm64.exe]: https://download.visualstudio.microsoft.com/download/pr/42c6a125-439e-4ccf-94a9-f6ace91a0179/b085b6e91c1d1602260d95169c4d9141/dotnet-runtime-8.0.0-win-arm64.exe
[dotnet-runtime-win-arm64.zip]: https://download.visualstudio.microsoft.com/download/pr/394f6191-d02c-4b8f-bcd1-a704676537d8/7cf828ed977dbedcaeb4d5f6a6d5c93c/dotnet-runtime-8.0.0-win-arm64.zip
[dotnet-runtime-win-x64.exe]: https://download.visualstudio.microsoft.com/download/pr/7f4d5cbc-4449-4ea5-9578-c467821f251f/b9b19f89d0642bf78f4b612c6a741637/dotnet-runtime-8.0.0-win-x64.exe
[dotnet-runtime-win-x64.zip]: https://download.visualstudio.microsoft.com/download/pr/924f2e25-ba50-4b90-a35c-6ef73d1149a3/b9a57fa45dad7cca93a0aa937a8ba03d/dotnet-runtime-8.0.0-win-x64.zip
[dotnet-runtime-win-x86.exe]: https://download.visualstudio.microsoft.com/download/pr/593685c9-7e98-455a-8e34-4b8ad1be9489/6ccf85c6fc244428d61f74ca3aee0645/dotnet-runtime-8.0.0-win-x86.exe
[dotnet-runtime-win-x86.zip]: https://download.visualstudio.microsoft.com/download/pr/fc9946c3-b21d-4a32-a084-e3bc56bb9063/e28a035fb3f8f97dc40323d5da4bb42c/dotnet-runtime-8.0.0-win-x86.zip

[//]: # ( WindowsDesktop 8.0.0)
[windowsdesktop-runtime-win-arm64.exe]: https://download.visualstudio.microsoft.com/download/pr/96b09d32-59a7-465c-bfa0-9a49493317f0/a4942158510a267137f161e77906cec0/windowsdesktop-runtime-8.0.0-win-arm64.exe
[windowsdesktop-runtime-win-arm64.zip]: https://download.visualstudio.microsoft.com/download/pr/fca1d1a8-e947-4fab-8e00-0fada425dd0d/f6f3a9e344d9834246d97f178e0d30a0/windowsdesktop-runtime-8.0.0-win-arm64.zip
[windowsdesktop-runtime-win-x64.exe]: https://download.visualstudio.microsoft.com/download/pr/b280d97f-25a9-4ab7-8a12-8291aa3af117/a37ed0e68f51fcd973e9f6cb4f40b1a7/windowsdesktop-runtime-8.0.0-win-x64.exe
[windowsdesktop-runtime-win-x64.zip]: https://download.visualstudio.microsoft.com/download/pr/382f253f-0118-481d-acec-d64921fe75c7/3c4ae5e0305780a2a762505953b9b711/windowsdesktop-runtime-8.0.0-win-x64.zip
[windowsdesktop-runtime-win-x86.exe]: https://download.visualstudio.microsoft.com/download/pr/f9e3b581-059d-429f-9f0d-1d1167ff7e32/bd7661030cd5d66cd3eee0fd20b24540/windowsdesktop-runtime-8.0.0-win-x86.exe
[windowsdesktop-runtime-win-x86.zip]: https://download.visualstudio.microsoft.com/download/pr/cd53bd89-9843-495b-8930-45987bd1cf8e/799ac0f301f219baf3dc5e978b0ad30f/windowsdesktop-runtime-8.0.0-win-x86.zip

[//]: # ( ASP 8.0.0)
[aspnetcore-runtime-linux-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/6d3049cc-4dcf-4dfb-9444-009997fbe620/fa9da42c88a2d74aef7e99f56269e36d/aspnetcore-runtime-8.0.0-linux-arm.tar.gz
[aspnetcore-runtime-linux-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/91223e4e-2300-4e8e-9364-09ea1c317294/47fb26a2df5eeee08f77a4d1b720a34a/aspnetcore-runtime-8.0.0-linux-arm64.tar.gz
[aspnetcore-runtime-linux-musl-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/639a31d4-e000-40da-aebd-2b97f31a49e7/f3f9bc2b800cac9d7f6d4d5c804c1a4f/aspnetcore-runtime-8.0.0-linux-musl-arm.tar.gz
[aspnetcore-runtime-linux-musl-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/c3bf3103-efdb-42e0-af55-bbf861a4215b/dc22eda8877933b8c6569e3823f18d21/aspnetcore-runtime-8.0.0-linux-musl-arm64.tar.gz
[aspnetcore-runtime-linux-musl-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/7aa33fc7-07fe-48c2-8e44-a4bfb4928535/3b96ec50970eee414895ef3a5b188bcd/aspnetcore-runtime-8.0.0-linux-musl-x64.tar.gz
[aspnetcore-runtime-linux-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/257bdcc7-cbfd-4680-964a-cbe8e9160bca/ac0cbf19d897ba51ae004b4146940a0a/aspnetcore-runtime-8.0.0-linux-x64.tar.gz
[aspnetcore-runtime-osx-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/0d05d563-f3ce-4d40-8cd8-f28247510533/48ed8322af7e47c2f68fc0afbd65e37b/aspnetcore-runtime-8.0.0-osx-arm64.tar.gz
[aspnetcore-runtime-osx-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/6ef899a5-571a-4fd3-b294-65665d9cc76f/d21cc874f3832a5e0ad583d948d1f228/aspnetcore-runtime-8.0.0-osx-x64.tar.gz
[aspnetcore-runtime-win-arm64.zip]: https://download.visualstudio.microsoft.com/download/pr/44a28172-e3d3-47f6-8c61-d08b216b1a9d/8efb764492d6356654e156dc6bba45ad/aspnetcore-runtime-8.0.0-win-arm64.zip
[aspnetcore-runtime-win-x64.exe]: https://download.visualstudio.microsoft.com/download/pr/89d3660b-d344-47c5-a1cd-d8343a3f3779/9f55af82923dab7e3dce912f5c5b9d60/aspnetcore-runtime-8.0.0-win-x64.exe
[aspnetcore-runtime-win-x64.zip]: https://download.visualstudio.microsoft.com/download/pr/6df1ec69-9cff-4836-b02a-cf5b09baffaa/9cff973dda0520aa1ed216d67433e37a/aspnetcore-runtime-8.0.0-win-x64.zip
[aspnetcore-runtime-win-x86.exe]: https://download.visualstudio.microsoft.com/download/pr/66ae7d00-596a-4e36-be73-2ebc0c332329/e2f6e37933e204fef5687e338a95b749/aspnetcore-runtime-8.0.0-win-x86.exe
[aspnetcore-runtime-win-x86.zip]: https://download.visualstudio.microsoft.com/download/pr/5cde0bff-74de-43ca-8ec5-e0a170245e5a/b7941851acdab0dca00c69c0212583ac/aspnetcore-runtime-8.0.0-win-x86.zip
[aspnetcore-runtime-composite-linux-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/ed839f31-aa31-4360-ac80-e3b6c30c09bf/5b260246e22a9bd8de442b1690c34429/aspnetcore-runtime-composite-8.0.0-linux-arm.tar.gz
[aspnetcore-runtime-composite-linux-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/30405043-c6ed-4017-8835-ec073190cf23/342685692dc5beedbb49ad72bf413e83/aspnetcore-runtime-composite-8.0.0-linux-arm64.tar.gz
[aspnetcore-runtime-composite-linux-musl-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/102004e7-1106-4888-b3a1-c4c78194f53d/45806e9d6f996a9841473edede1d5f4c/aspnetcore-runtime-composite-8.0.0-linux-musl-arm.tar.gz
[aspnetcore-runtime-composite-linux-musl-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/dc2c8e28-39b3-42b9-be31-ec47e014b945/f394c3d2d91b70486469244323b34282/aspnetcore-runtime-composite-8.0.0-linux-musl-arm64.tar.gz
[aspnetcore-runtime-composite-linux-musl-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/e4c8e070-6794-41ec-a336-27c396edefb5/b7322715c983bafc99970016d88e536f/aspnetcore-runtime-composite-8.0.0-linux-musl-x64.tar.gz
[aspnetcore-runtime-composite-linux-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/6c37b740-be2b-4560-9caa-5f45b0f2cb80/6ba5f7ab4e5f815ddeb0644d5f8360a4/aspnetcore-runtime-composite-8.0.0-linux-x64.tar.gz
[dotnet-hosting-win.exe]: https://download.visualstudio.microsoft.com/download/pr/2a7ae819-fbc4-4611-a1ba-f3b072d4ea25/32f3b931550f7b315d9827d564202eeb/dotnet-hosting-8.0.0-win.exe

[//]: # ( SDK 8.0.100)
[dotnet-sdk-linux-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/7ec1a911-afeb-47fa-a1d0-fa22cd980b32/157c20841cbf1811dd2a7a51bf4aaf88/dotnet-sdk-8.0.100-linux-arm.tar.gz
[dotnet-sdk-linux-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/43e09d57-d0f5-4c92-a75a-b16cfd1983a4/cba02bd4f7c92fb59e22a25573d5a550/dotnet-sdk-8.0.100-linux-arm64.tar.gz
[dotnet-sdk-linux-musl-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/4bc8c698-47bd-4217-8ac8-4c82217d47ab/76b0bbe4aa7050a7e5e54814308ab949/dotnet-sdk-8.0.100-linux-musl-arm.tar.gz
[dotnet-sdk-linux-musl-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/88a7d8f6-e27b-4a43-91a4-233cd40daed5/350c9d253971d0ac527f016e145323dd/dotnet-sdk-8.0.100-linux-musl-arm64.tar.gz
[dotnet-sdk-linux-musl-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/40a3227f-0d20-4c23-b1a5-ecd659e3faef/fa59541ab3a35a50172ea5f81070e075/dotnet-sdk-8.0.100-linux-musl-x64.tar.gz
[dotnet-sdk-linux-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/5226a5fa-8c0b-474f-b79a-8984ad7c5beb/3113ccbf789c9fd29972835f0f334b7a/dotnet-sdk-8.0.100-linux-x64.tar.gz
[dotnet-sdk-osx-arm64.pkg]: https://download.visualstudio.microsoft.com/download/pr/cf196f2f-f1e2-4f9a-a7ac-546242c431e2/8c386932f4a2f96c3e95c433e4899ec2/dotnet-sdk-8.0.100-osx-arm64.pkg
[dotnet-sdk-osx-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/2a79b5ad-82a7-4615-a73b-91bf24028471/0e6a5c6d7f8b792a421e3796a93ef0a1/dotnet-sdk-8.0.100-osx-arm64.tar.gz
[dotnet-sdk-osx-x64.pkg]: https://download.visualstudio.microsoft.com/download/pr/27a7ece8-f6cd-4cab-89cf-987e85ae6805/2c9ab2cb294143b0533f005640c393da/dotnet-sdk-8.0.100-osx-x64.pkg
[dotnet-sdk-osx-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/e59acfc2-5987-43f9-bd03-0cbe446679e1/7db7313c1c99104279a69ccd47d160a1/dotnet-sdk-8.0.100-osx-x64.tar.gz
[dotnet-sdk-win-arm64.exe]: https://download.visualstudio.microsoft.com/download/pr/987b30a7-09b2-4f0f-b425-c4f3b8a55a29/ded7b41eaeea7adf1075a51e31925792/dotnet-sdk-8.0.100-win-arm64.exe
[dotnet-sdk-win-arm64.zip]: https://download.visualstudio.microsoft.com/download/pr/7a580d00-03da-4eb0-96ef-4c7bc57bd6cb/58c0a9814ecafc5e06ad7d014f65a984/dotnet-sdk-8.0.100-win-arm64.zip
[dotnet-sdk-win-x64.exe]: https://download.visualstudio.microsoft.com/download/pr/93961dfb-d1e0-49c8-9230-abcba1ebab5a/811ed1eb63d7652325727720edda26a8/dotnet-sdk-8.0.100-win-x64.exe
[dotnet-sdk-win-x64.zip]: https://download.visualstudio.microsoft.com/download/pr/2b2d6133-c4f9-46dd-9ab6-86443a7f5783/340054e2ac7de2bff9eea73ec9d4995a/dotnet-sdk-8.0.100-win-x64.zip
[dotnet-sdk-win-x86.exe]: https://download.visualstudio.microsoft.com/download/pr/5645f9cc-4f4f-4eac-bd04-96b422ae3406/069e0632b2232401f4b9d123f2173977/dotnet-sdk-8.0.100-win-x86.exe
[dotnet-sdk-win-x86.zip]: https://download.visualstudio.microsoft.com/download/pr/210579cb-610d-4040-9052-e024a42bcd9c/e260700ae965a0f7d3bf38e8d8f0778c/dotnet-sdk-8.0.100-win-x86.zip
