# Microsoft.AspNetCore.Authentication.BearerToken

``` diff
+namespace Microsoft.AspNetCore.Authentication.BearerToken {
+    public sealed class AccessTokenResponse {
+        public AccessTokenResponse();
+        public required string AccessToken { get; set; }
+        public required long ExpiresIn { get; set; }
+        public required string RefreshToken { get; set; }
+        public string TokenType { get; }
+    }
+    public static class BearerTokenDefaults {
+        public const string AuthenticationScheme = "BearerToken";
+    }
+    public class BearerTokenEvents {
+        public BearerTokenEvents();
+        public Func<MessageReceivedContext, Task> OnMessageReceived { get; set; }
+        public virtual Task MessageReceivedAsync(MessageReceivedContext context);
+    }
+    public sealed class BearerTokenOptions : AuthenticationSchemeOptions {
+        public BearerTokenOptions();
+        public TimeSpan BearerTokenExpiration { get; set; }
+        public ISecureDataFormat<AuthenticationTicket> BearerTokenProtector { get; set; }
+        public new BearerTokenEvents Events { get; set; }
+        public TimeSpan RefreshTokenExpiration { get; set; }
+        public ISecureDataFormat<AuthenticationTicket> RefreshTokenProtector { get; set; }
+    }
+    public class MessageReceivedContext : ResultContext<BearerTokenOptions> {
+        public MessageReceivedContext(HttpContext context, AuthenticationScheme scheme, BearerTokenOptions options);
+        public string Token { get; set; }
+    }
+}
```

