# Microsoft.AspNetCore.Authentication

``` diff
 namespace Microsoft.AspNetCore.Authentication {
+    public class AuthenticationFailureException : Exception {
+        public AuthenticationFailureException(string message);
+        public AuthenticationFailureException(string message, Exception innerException);
+    }
     public abstract class AuthenticationHandler<TOptions> : IAuthenticationHandler where TOptions : AuthenticationSchemeOptions, new() {
+        protected AuthenticationHandler(IOptionsMonitor<TOptions> options, ILoggerFactory logger, UrlEncoder encoder);
-        protected AuthenticationHandler(IOptionsMonitor<TOptions> options, ILoggerFactory logger, UrlEncoder encoder, ISystemClock clock);
+        [ObsoleteAttribute("ISystemClock is obsolete, use TimeProvider on AuthenticationSchemeOptions instead.")]
+        protected AuthenticationHandler(IOptionsMonitor<TOptions> options, ILoggerFactory logger, UrlEncoder encoder, ISystemClock clock);
-        protected ISystemClock Clock { get; }
+        [ObsoleteAttribute("ISystemClock is obsolete, use TimeProvider instead.")]
+        protected ISystemClock Clock { get; }
+        protected TimeProvider TimeProvider { get; }
     }
     public class AuthenticationSchemeOptions {
+        public TimeProvider TimeProvider { get; set; }
     }
-    public interface ISystemClock
+    [ObsoleteAttribute("Use TimeProvider instead.")]
+    public interface ISystemClock
     public class PolicySchemeHandler : SignInAuthenticationHandler<PolicySchemeOptions> {
+        public PolicySchemeHandler(IOptionsMonitor<PolicySchemeOptions> options, ILoggerFactory logger, UrlEncoder encoder);
-        public PolicySchemeHandler(IOptionsMonitor<PolicySchemeOptions> options, ILoggerFactory logger, UrlEncoder encoder, ISystemClock clock);
+        [ObsoleteAttribute("ISystemClock is obsolete, use TimeProvider on AuthenticationSchemeOptions instead.")]
+        public PolicySchemeHandler(IOptionsMonitor<PolicySchemeOptions> options, ILoggerFactory logger, UrlEncoder encoder, ISystemClock clock);
     }
     public abstract class RemoteAuthenticationHandler<TOptions> : AuthenticationHandler<TOptions>, IAuthenticationHandler, IAuthenticationRequestHandler where TOptions : RemoteAuthenticationOptions, new() {
+        protected RemoteAuthenticationHandler(IOptionsMonitor<TOptions> options, ILoggerFactory logger, UrlEncoder encoder);
-        protected RemoteAuthenticationHandler(IOptionsMonitor<TOptions> options, ILoggerFactory logger, UrlEncoder encoder, ISystemClock clock);
+        [ObsoleteAttribute("ISystemClock is obsolete, use TimeProvider on AuthenticationSchemeOptions instead.")]
+        protected RemoteAuthenticationHandler(IOptionsMonitor<TOptions> options, ILoggerFactory logger, UrlEncoder encoder, ISystemClock clock);
     }
     public abstract class SignInAuthenticationHandler<TOptions> : SignOutAuthenticationHandler<TOptions>, IAuthenticationHandler, IAuthenticationSignInHandler, IAuthenticationSignOutHandler where TOptions : AuthenticationSchemeOptions, new() {
+        public SignInAuthenticationHandler(IOptionsMonitor<TOptions> options, ILoggerFactory logger, UrlEncoder encoder);
-        public SignInAuthenticationHandler(IOptionsMonitor<TOptions> options, ILoggerFactory logger, UrlEncoder encoder, ISystemClock clock);
+        [ObsoleteAttribute("ISystemClock is obsolete, use TimeProvider on AuthenticationSchemeOptions instead.")]
+        public SignInAuthenticationHandler(IOptionsMonitor<TOptions> options, ILoggerFactory logger, UrlEncoder encoder, ISystemClock clock);
     }
     public abstract class SignOutAuthenticationHandler<TOptions> : AuthenticationHandler<TOptions>, IAuthenticationHandler, IAuthenticationSignOutHandler where TOptions : AuthenticationSchemeOptions, new() {
+        public SignOutAuthenticationHandler(IOptionsMonitor<TOptions> options, ILoggerFactory logger, UrlEncoder encoder);
-        public SignOutAuthenticationHandler(IOptionsMonitor<TOptions> options, ILoggerFactory logger, UrlEncoder encoder, ISystemClock clock);
+        [ObsoleteAttribute("ISystemClock is obsolete, use TimeProvider on AuthenticationSchemeOptions instead.")]
+        public SignOutAuthenticationHandler(IOptionsMonitor<TOptions> options, ILoggerFactory logger, UrlEncoder encoder, ISystemClock clock);
     }
-    public class SystemClock : ISystemClock
+    [ObsoleteAttribute("Use TimeProvider instead.")]
+    public class SystemClock : ISystemClock
 }
```

