# Microsoft.AspNetCore.Authorization

``` diff
 namespace Microsoft.AspNetCore.Authorization {
-    [AttributeUsageAttribute(68, AllowMultiple=false, Inherited=true)]
-    public class AllowAnonymousAttribute : Attribute, IAllowAnonymous {
+    [AttributeUsageAttribute(68, AllowMultiple=false, Inherited=true)]
+    [DebuggerDisplayAttribute("{ToString(),nq}")]
+    public class AllowAnonymousAttribute : Attribute, IAllowAnonymous {
+        public override string ToString();
     }
     public class AuthorizationMiddleware {
+        public AuthorizationMiddleware(RequestDelegate next, IAuthorizationPolicyProvider policyProvider, IServiceProvider services, ILogger<AuthorizationMiddleware> logger);
     }
     public class AuthorizationResult {
-        public bool Succeeded { get; }
+        [MemberNotNullWhenAttribute(false, "Failure")]
+        public bool Succeeded { [MemberNotNullWhenAttribute(false, "Failure")] get; }
     }
-    [AttributeUsageAttribute(68, AllowMultiple=true, Inherited=true)]
-    public class AuthorizeAttribute : Attribute, IAuthorizeData {
+    [AttributeUsageAttribute(68, AllowMultiple=true, Inherited=true)]
+    [DebuggerDisplayAttribute("{ToString(),nq}")]
+    public class AuthorizeAttribute : Attribute, IAuthorizeData {
+        public override string ToString();
     }
+    public interface IAuthorizationRequirementData {
+        IEnumerable<IAuthorizationRequirement> GetRequirements();
+    }
 }
```

