# Microsoft.AspNetCore.Builder

``` diff
 namespace Microsoft.AspNetCore.Builder {
+    public static class AntiforgeryApplicationBuilderExtensions {
+        public static IApplicationBuilder UseAntiforgery(this IApplicationBuilder builder);
+    }
-    public class ApplicationBuilder : IApplicationBuilder
+    [DebuggerDisplayAttribute("Middleware = {MiddlewareCount}")]
+    [DebuggerTypeProxyAttribute(typeof(ApplicationBuilder.ApplicationBuilderDebugView))]
+    public class ApplicationBuilder : IApplicationBuilder
     public static class ConnectionEndpointRouteBuilderExtensions {
-        public static ConnectionEndpointRouteBuilder MapConnectionHandler<TConnectionHandler>(this IEndpointRouteBuilder endpoints, string pattern) where TConnectionHandler : ConnectionHandler;
+        public static ConnectionEndpointRouteBuilder MapConnectionHandler<TConnectionHandler>(this IEndpointRouteBuilder endpoints, [StringSyntaxAttribute("Route")] string pattern) where TConnectionHandler : ConnectionHandler;
-        public static ConnectionEndpointRouteBuilder MapConnectionHandler<TConnectionHandler>(this IEndpointRouteBuilder endpoints, string pattern, Action<HttpConnectionDispatcherOptions>? configureOptions) where TConnectionHandler : ConnectionHandler;
+        public static ConnectionEndpointRouteBuilder MapConnectionHandler<TConnectionHandler>(this IEndpointRouteBuilder endpoints, [StringSyntaxAttribute("Route")] string pattern, Action<HttpConnectionDispatcherOptions>? configureOptions) where TConnectionHandler : ConnectionHandler;
-        public static ConnectionEndpointRouteBuilder MapConnections(this IEndpointRouteBuilder endpoints, string pattern, HttpConnectionDispatcherOptions options, Action<IConnectionBuilder> configure);
+        public static ConnectionEndpointRouteBuilder MapConnections(this IEndpointRouteBuilder endpoints, [StringSyntaxAttribute("Route")] string pattern, HttpConnectionDispatcherOptions options, Action<IConnectionBuilder> configure);
-        public static ConnectionEndpointRouteBuilder MapConnections(this IEndpointRouteBuilder endpoints, string pattern, Action<IConnectionBuilder> configure);
+        public static ConnectionEndpointRouteBuilder MapConnections(this IEndpointRouteBuilder endpoints, [StringSyntaxAttribute("Route")] string pattern, Action<IConnectionBuilder> configure);
     }
     public static class CorsEndpointConventionBuilderExtensions {
+        public static TBuilder RequireCors<TBuilder>(this TBuilder builder) where TBuilder : IEndpointConventionBuilder;
     }
     public static class ExceptionHandlerExtensions {
+        public static IApplicationBuilder UseExceptionHandler(this IApplicationBuilder app, string errorHandlingPath, bool createScopeForErrors);
     }
     public class ExceptionHandlerOptions {
+        public bool CreateScopeForErrors { get; set; }
     }
     public static class FallbackEndpointRouteBuilderExtensions {
-        [RequiresUnreferencedCodeAttribute("This API may perform reflection on the supplied delegate and its parameters. These types may be trimmed if not directly referenced.")]
-        public static IEndpointConventionBuilder MapFallback(this IEndpointRouteBuilder endpoints, RequestDelegate requestDelegate);
+        public static IEndpointConventionBuilder MapFallback(this IEndpointRouteBuilder endpoints, RequestDelegate requestDelegate);
-        [RequiresUnreferencedCodeAttribute("This API may perform reflection on the supplied delegate and its parameters. These types may be trimmed if not directly referenced.")]
-        public static IEndpointConventionBuilder MapFallback(this IEndpointRouteBuilder endpoints, [StringSyntaxAttribute("Route")] string pattern, RequestDelegate requestDelegate);
+        public static IEndpointConventionBuilder MapFallback(this IEndpointRouteBuilder endpoints, [StringSyntaxAttribute("Route")] string pattern, RequestDelegate requestDelegate);
     }
     public class ForwardedHeadersOptions {
+        public string ForwardedPrefixHeaderName { get; set; }
+        public string OriginalPrefixHeaderName { get; set; }
     }
     public static class HealthCheckEndpointRouteBuilderExtensions {
-        public static IEndpointConventionBuilder MapHealthChecks(this IEndpointRouteBuilder endpoints, string pattern);
+        public static IEndpointConventionBuilder MapHealthChecks(this IEndpointRouteBuilder endpoints, [StringSyntaxAttribute("Route")] string pattern);
-        public static IEndpointConventionBuilder MapHealthChecks(this IEndpointRouteBuilder endpoints, string pattern, HealthCheckOptions options);
+        public static IEndpointConventionBuilder MapHealthChecks(this IEndpointRouteBuilder endpoints, [StringSyntaxAttribute("Route")] string pattern, HealthCheckOptions options);
     }
+    public static class HttpLoggingEndpointConventionBuilderExtensions {
+        public static TBuilder WithHttpLogging<TBuilder>(this TBuilder builder, HttpLoggingFields loggingFields, int? requestBodyLogLimit = default(int?), int? responseBodyLogLimit = default(int?)) where TBuilder : IEndpointConventionBuilder;
+    }
     public static class HubEndpointRouteBuilderExtensions {
-        public static HubEndpointConventionBuilder MapHub<THub>(this IEndpointRouteBuilder endpoints, string pattern) where THub : Hub;
+        public static HubEndpointConventionBuilder MapHub<THub>(this IEndpointRouteBuilder endpoints, [StringSyntaxAttribute("Route")] string pattern) where THub : Hub;
-        public static HubEndpointConventionBuilder MapHub<THub>(this IEndpointRouteBuilder endpoints, string pattern, Action<HttpConnectionDispatcherOptions>? configureOptions) where THub : Hub;
+        public static HubEndpointConventionBuilder MapHub<THub>(this IEndpointRouteBuilder endpoints, [StringSyntaxAttribute("Route")] string pattern, Action<HttpConnectionDispatcherOptions>? configureOptions) where THub : Hub;
     }
+    public sealed class RazorComponentsEndpointConventionBuilder : IEndpointConventionBuilder {
+        public void Add(Action<EndpointBuilder> convention);
+        public void Finally(Action<EndpointBuilder> finallyConvention);
+    }
+    public static class RazorComponentsEndpointConventionBuilderExtensions {
+        public static RazorComponentsEndpointConventionBuilder AddAdditionalAssemblies(this RazorComponentsEndpointConventionBuilder builder, params Assembly[] assemblies);
+    }
+    public static class RazorComponentsEndpointRouteBuilderExtensions {
+        public static RazorComponentsEndpointConventionBuilder MapRazorComponents<TRootComponent>(this IEndpointRouteBuilder endpoints);
+    }
     public static class RazorPagesEndpointRouteBuilderExtensions {
-        public static void MapDynamicPageRoute<TTransformer>(this IEndpointRouteBuilder endpoints, string pattern) where TTransformer : DynamicRouteValueTransformer;
+        public static void MapDynamicPageRoute<TTransformer>(this IEndpointRouteBuilder endpoints, [StringSyntaxAttribute("Route")] string pattern) where TTransformer : DynamicRouteValueTransformer;
-        public static void MapDynamicPageRoute<TTransformer>(this IEndpointRouteBuilder endpoints, string pattern, object? state) where TTransformer : DynamicRouteValueTransformer;
+        public static void MapDynamicPageRoute<TTransformer>(this IEndpointRouteBuilder endpoints, [StringSyntaxAttribute("Route")] string pattern, object? state) where TTransformer : DynamicRouteValueTransformer;
-        public static void MapDynamicPageRoute<TTransformer>(this IEndpointRouteBuilder endpoints, string pattern, object state, int order) where TTransformer : DynamicRouteValueTransformer;
+        public static void MapDynamicPageRoute<TTransformer>(this IEndpointRouteBuilder endpoints, [StringSyntaxAttribute("Route")] string pattern, object state, int order) where TTransformer : DynamicRouteValueTransformer;
-        public static IEndpointConventionBuilder MapFallbackToAreaPage(this IEndpointRouteBuilder endpoints, string pattern, string page, string area);
+        public static IEndpointConventionBuilder MapFallbackToAreaPage(this IEndpointRouteBuilder endpoints, [StringSyntaxAttribute("Route")] string pattern, string page, string area);
-        public static IEndpointConventionBuilder MapFallbackToPage(this IEndpointRouteBuilder endpoints, string pattern, string page);
+        public static IEndpointConventionBuilder MapFallbackToPage(this IEndpointRouteBuilder endpoints, [StringSyntaxAttribute("Route")] string pattern, string page);
     }
     public class RequestLocalizationOptions {
+        public bool CultureInfoUseUserOverride { get; set; }
     }
+    public static class RequestTimeoutsIApplicationBuilderExtensions {
+        public static IApplicationBuilder UseRequestTimeouts(this IApplicationBuilder builder);
+    }
+    public static class RequestTimeoutsIEndpointConventionBuilderExtensions {
+        public static IEndpointConventionBuilder DisableRequestTimeout(this IEndpointConventionBuilder builder);
+        public static IEndpointConventionBuilder WithRequestTimeout(this IEndpointConventionBuilder builder, RequestTimeoutPolicy policy);
+        public static IEndpointConventionBuilder WithRequestTimeout(this IEndpointConventionBuilder builder, string policyName);
+        public static IEndpointConventionBuilder WithRequestTimeout(this IEndpointConventionBuilder builder, TimeSpan timeout);
+    }
+    public static class RouteShortCircuitEndpointConventionBuilderExtensions {
+        public static IEndpointConventionBuilder ShortCircuit(this IEndpointConventionBuilder builder, int? statusCode = default(int?));
+    }
     public static class RoutingEndpointConventionBuilderExtensions {
+        public static TBuilder DisableAntiforgery<TBuilder>(this TBuilder builder) where TBuilder : IEndpointConventionBuilder;
+        public static TBuilder WithFormMappingOptions<TBuilder>(this TBuilder builder, int? maxCollectionSize = default(int?), int? maxRecursionDepth = default(int?), int? maxKeySize = default(int?)) where TBuilder : IEndpointConventionBuilder;
+        public static TBuilder WithFormOptions<TBuilder>(this TBuilder builder, bool? bufferBody = default(bool?), int? memoryBufferThreshold = default(int?), long? bufferBodyLengthLimit = default(long?), int? valueCountLimit = default(int?), int? keyLengthLimit = default(int?), int? valueLengthLimit = default(int?), int? multipartBoundaryLengthLimit = default(int?), int? multipartHeadersCountLimit = default(int?), int? multipartHeadersLengthLimit = default(int?), long? multipartBodyLengthLimit = default(long?)) where TBuilder : IEndpointConventionBuilder;
+        public static TBuilder WithOrder<TBuilder>(this TBuilder builder, int order) where TBuilder : IEndpointConventionBuilder;
     }
+    public static class ServerRazorComponentsEndpointConventionBuilderExtensions {
+        public static RazorComponentsEndpointConventionBuilder AddInteractiveServerRenderMode(this RazorComponentsEndpointConventionBuilder builder);
+    }
     public class StaticFileOptions : SharedOptionsBase {
+        public Func<StaticFileResponseContext, Task> OnPrepareResponseAsync { get; set; }
     }
-    public sealed class WebApplication : IApplicationBuilder, IAsyncDisposable, IDisposable, IEndpointRouteBuilder, IHost {
+    [DebuggerDisplayAttribute("{DebuggerToString(),nq}")]
+    [DebuggerTypeProxyAttribute(typeof(WebApplication.WebApplicationDebugView))]
+    public sealed class WebApplication : IApplicationBuilder, IAsyncDisposable, IDisposable, IEndpointRouteBuilder, IHost {
+        public static WebApplicationBuilder CreateEmptyBuilder(WebApplicationOptions options);
+        public static WebApplicationBuilder CreateSlimBuilder();
+        public static WebApplicationBuilder CreateSlimBuilder(WebApplicationOptions options);
+        public static WebApplicationBuilder CreateSlimBuilder(string[] args);
-        public void Run(string? url = null);
+        public void Run([StringSyntaxAttribute("Uri")] string? url = null);
-        public Task RunAsync(string? url = null);
+        public Task RunAsync([StringSyntaxAttribute("Uri")] string? url = null);
     }
-    public sealed class WebApplicationBuilder {
+    public sealed class WebApplicationBuilder : IHostApplicationBuilder {
+        public IMetricsBuilder Metrics { get; }
+        IConfigurationManager IHostApplicationBuilder.Configuration { get; }
+        IHostEnvironment IHostApplicationBuilder.Environment { get; }
+        IDictionary<object, object> IHostApplicationBuilder.Properties { get; }
+        void IHostApplicationBuilder.ConfigureContainer<TContainerBuilder>(IServiceProviderFactory<TContainerBuilder> factory, Action<TContainerBuilder> configure);
     }
 }
```

