# Microsoft.AspNetCore.Components.Endpoints

``` diff
+namespace Microsoft.AspNetCore.Components.Endpoints {
+    public sealed class ComponentTypeMetadata {
+        public ComponentTypeMetadata(Type componentType);
+        public Type Type { get; }
+    }
+    public interface IComponentPrerenderer {
+        Dispatcher Dispatcher { get; }
+        ValueTask<IHtmlAsyncContent> PrerenderComponentAsync(HttpContext httpContext, Type componentType, IComponentRenderMode renderMode, ParameterView parameters);
+        ValueTask<IHtmlContent> PrerenderPersistedStateAsync(HttpContext httpContext, PersistedStateSerializationMode serializationMode);
+    }
+    public interface IRazorComponentEndpointInvoker {
+        Task Render(HttpContext context);
+    }
+    public sealed class RazorComponentsServiceOptions {
+        public RazorComponentsServiceOptions();
+        public bool DetailedErrors { get; set; }
+        public int MaxFormMappingCollectionSize { get; set; }
+        public int MaxFormMappingErrorCount { get; set; }
+        public int MaxFormMappingKeySize { get; set; }
+        public int MaxFormMappingRecursionDepth { get; set; }
+        public TimeSpan TemporaryRedirectionUrlValidityDuration { get; set; }
+    }
+    public sealed class RootComponentMetadata {
+        public RootComponentMetadata(Type rootComponentType);
+        public Type Type { get; }
+    }
+}
```

