# Microsoft.AspNetCore.Components.Forms

``` diff
 namespace Microsoft.AspNetCore.Components.Forms {
+    public class AntiforgeryRequestToken {
+        public AntiforgeryRequestToken(string value, string formFieldName);
+        public string FormFieldName { get; }
+        public string Value { get; }
+    }
+    public abstract class AntiforgeryStateProvider {
+        protected AntiforgeryStateProvider();
+        public abstract AntiforgeryRequestToken? GetAntiforgeryToken();
+    }
+    public class AntiforgeryToken : IComponent {
+        public AntiforgeryToken();
+        void IComponent.Attach(RenderHandle renderHandle);
+        Task IComponent.SetParametersAsync(ParameterView parameters);
+    }
     public sealed class EditContext {
+        public bool ShouldUseFieldIdentifiers { get; set; }
-        [IteratorStateMachineAttribute(typeof(EditContext.<GetValidationMessages>d__23))]
-        public IEnumerable<string> GetValidationMessages();
+        [IteratorStateMachineAttribute(typeof(EditContext.<GetValidationMessages>d__27))]
+        public IEnumerable<string> GetValidationMessages();
-        [IteratorStateMachineAttribute(typeof(EditContext.<GetValidationMessages>d__24))]
-        public IEnumerable<string> GetValidationMessages(FieldIdentifier fieldIdentifier);
+        [IteratorStateMachineAttribute(typeof(EditContext.<GetValidationMessages>d__28))]
+        public IEnumerable<string> GetValidationMessages(FieldIdentifier fieldIdentifier);
+        public bool IsValid(in FieldIdentifier fieldIdentifier);
+        public bool IsValid(Expression<Func<object>> accessor);
     }
     public class EditForm : ComponentBase {
+        [ParameterAttribute]
+        public bool Enhance { get; set; }
+        [ParameterAttribute]
+        public string FormName { get; set; }
     }
+    public abstract class Editor<T> : ComponentBase, ICascadingValueSupplier {
+        protected Editor();
+        [ParameterAttribute]
+        public T Value { get; set; }
+        [ParameterAttribute]
+        public EventCallback<T> ValueChanged { get; set; }
+        [ParameterAttribute]
+        public Expression<Func<T>> ValueExpression { get; set; }
+        protected string NameFor(LambdaExpression expression);
+        protected override void OnParametersSet();
+    }
+    public sealed class FormMappingContext {
+        public string MappingScopeName { get; }
+        public IEnumerable<FormMappingError> GetAllErrors();
+        public IEnumerable<FormMappingError> GetAllErrors(string formName);
+        public string? GetAttemptedValue(string key);
+        public string? GetAttemptedValue(string formName, string key);
+        public FormMappingError? GetErrors(string key);
+        public FormMappingError? GetErrors(string formName, string key);
+    }
+    public sealed class FormMappingScope : ICascadingValueSupplier, IComponent {
+        public FormMappingScope();
+        [ParameterAttribute]
+        public RenderFragment<FormMappingContext> ChildContent { get; set; }
+        [EditorRequiredAttribute]
+        [ParameterAttribute]
+        public string Name { get; set; }
+        void IComponent.Attach(RenderHandle renderHandle);
+        Task IComponent.SetParametersAsync(ParameterView parameters);
+    }
     public abstract class InputBase<TValue> : ComponentBase, IDisposable {
+        protected string NameAttributeValue { get; }
     }
     public class InputFile : ComponentBase, IDisposable, IInputFileJsCallbacks {
-        protected override void OnInitialized();
     }
 }
```

