# Microsoft.AspNetCore.Components.RenderTree

``` diff
 namespace Microsoft.AspNetCore.Components.RenderTree {
+    [FlagsAttribute]
+    public enum ComponentFrameFlags : byte {
+        HasCallerSpecifiedRenderMode = (byte)1,
+    }
+    public readonly struct NamedEventChange {
+        public NamedEventChange(NamedEventChangeType changeType, int componentId, int frameIndex, string eventType, string assignedName);
+        public string AssignedName { get; }
+        public NamedEventChangeType ChangeType { get; }
+        public int ComponentId { get; }
+        public string EventType { get; }
+        public int FrameIndex { get; }
+    }
+    public enum NamedEventChangeType {
+        Added = 0,
+        Removed = 1,
+    }
     public readonly struct RenderBatch {
+        public ArrayRange<NamedEventChange>? NamedEventChanges { get; }
     }
     public abstract class Renderer : IAsyncDisposable, IDisposable {
+        protected virtual void AddPendingTask(ComponentState? componentState, Task task);
+        protected virtual ComponentState CreateComponentState(int componentId, IComponent component, ComponentState? parentComponentState);
+        public virtual Task DispatchEventAsync(ulong eventHandlerId, EventFieldInfo? fieldInfo, EventArgs eventArgs, bool waitForQuiescence);
+        protected internal virtual IComponentRenderMode? GetComponentRenderMode(IComponent component);
+        protected internal ComponentState GetComponentState(IComponent component);
+        protected ComponentState GetComponentState(int componentId);
+        protected internal virtual IComponent ResolveComponentForRenderMode(Type componentType, int? parentComponentId, IComponentActivator componentActivator, IComponentRenderMode renderMode);
     }
     public struct RenderTreeFrame {
+        public ComponentFrameFlags ComponentFrameFlags { get; }
+        public IComponentRenderMode ComponentRenderMode { get; }
+        public string NamedEventAssignedName { get; }
+        public string NamedEventType { get; }
     }
     public enum RenderTreeFrameType : short {
+        ComponentRenderMode = (short)9,
+        NamedEvent = (short)10,
     }
     public abstract class WebRenderer : Renderer {
-        protected int RendererId { get; set; }
+        protected int RendererId { get; [ObsoleteAttribute("The renderer ID can be assigned by overriding 'GetWebRendererId'.")] set; }
+        protected virtual int GetWebRendererId();
     }
 }
```

