# Microsoft.AspNetCore.Components.Rendering

``` diff
 namespace Microsoft.AspNetCore.Components.Rendering {
+    [DebuggerDisplayAttribute("{GetDebuggerDisplay(),nq}")]
+    public class ComponentState : IAsyncDisposable {
+        public ComponentState(Renderer renderer, int componentId, IComponent component, ComponentState? parentComponentState);
+        public IComponent Component { get; }
+        public int ComponentId { get; }
+        public ComponentState? LogicalParentComponentState { get; }
+        public ComponentState? ParentComponentState { get; }
+        public virtual ValueTask DisposeAsync();
+    }
     public sealed class RenderTreeBuilder : IDisposable {
+        public void AddComponentParameter(int sequence, string name, object? value);
+        public void AddComponentRenderMode(IComponentRenderMode? renderMode);
+        public void AddNamedEvent(string eventType, string assignedName);
     }
 }
```

