# Microsoft.AspNetCore.Components

``` diff
 namespace Microsoft.AspNetCore.Components {
     public static class BindConverter {
-        public static string FormatValue(DateOnly value, string format, CultureInfo? culture = null);
+        public static string FormatValue(DateOnly value, [StringSyntaxAttribute("DateOnlyFormat")] string format, CultureInfo? culture = null);
-        public static string FormatValue(DateTime value, string format, CultureInfo? culture = null);
+        public static string FormatValue(DateTime value, [StringSyntaxAttribute("DateTimeFormat")] string format, CultureInfo? culture = null);
-        public static string FormatValue(DateOnly? value, string format, CultureInfo culture = null);
+        public static string FormatValue(DateOnly? value, [StringSyntaxAttribute("DateOnlyFormat")] string format, CultureInfo culture = null);
-        public static string FormatValue(DateTime? value, string format, CultureInfo culture = null);
+        public static string FormatValue(DateTime? value, [StringSyntaxAttribute("DateTimeFormat")] string format, CultureInfo culture = null);
-        public static string FormatValue(TimeOnly? value, string format, CultureInfo culture = null);
+        public static string FormatValue(TimeOnly? value, [StringSyntaxAttribute("TimeOnlyFormat")] string format, CultureInfo culture = null);
-        public static string FormatValue(TimeOnly value, string format, CultureInfo? culture = null);
+        public static string FormatValue(TimeOnly value, [StringSyntaxAttribute("TimeOnlyFormat")] string format, CultureInfo? culture = null);
-        public static bool TryConvertToDateOnly(object obj, CultureInfo culture, string format, out DateOnly value);
+        public static bool TryConvertToDateOnly(object obj, CultureInfo culture, [StringSyntaxAttribute("DateOnlyFormat")] string format, out DateOnly value);
-        public static bool TryConvertToDateTime(object obj, CultureInfo culture, string format, out DateTime value);
+        public static bool TryConvertToDateTime(object obj, CultureInfo culture, [StringSyntaxAttribute("DateTimeFormat")] string format, out DateTime value);
-        public static bool TryConvertToNullableDateOnly(object obj, CultureInfo culture, string format, out DateOnly? value);
+        public static bool TryConvertToNullableDateOnly(object obj, CultureInfo culture, [StringSyntaxAttribute("DateOnlyFormat")] string format, out DateOnly? value);
-        public static bool TryConvertToNullableDateTime(object obj, CultureInfo culture, string format, out DateTime? value);
+        public static bool TryConvertToNullableDateTime(object obj, CultureInfo culture, [StringSyntaxAttribute("DateTimeFormat")] string format, out DateTime? value);
-        public static bool TryConvertToNullableTimeOnly(object obj, CultureInfo culture, string format, out TimeOnly? value);
+        public static bool TryConvertToNullableTimeOnly(object obj, CultureInfo culture, [StringSyntaxAttribute("TimeOnlyFormat")] string format, out TimeOnly? value);
-        public static bool TryConvertToTimeOnly(object obj, CultureInfo culture, string format, out TimeOnly value);
+        public static bool TryConvertToTimeOnly(object obj, CultureInfo culture, [StringSyntaxAttribute("TimeOnlyFormat")] string format, out TimeOnly value);
     }
-    [AttributeUsageAttribute(128, AllowMultiple=false, Inherited=true)]
-    public sealed class CascadingParameterAttribute : Attribute
+    [AttributeUsageAttribute(128, AllowMultiple=false, Inherited=true)]
+    public sealed class CascadingParameterAttribute : CascadingParameterAttributeBase
+    public abstract class CascadingParameterAttributeBase : Attribute {
+        protected CascadingParameterAttributeBase();
+    }
+    public readonly struct CascadingParameterInfo {
+        public CascadingParameterAttributeBase Attribute { get; }
+        public string PropertyName { get; }
+        public Type PropertyType { get; }
+    }
+    public class CascadingValueSource<TValue> : ICascadingValueSupplier {
+        public CascadingValueSource(Func<TValue> initialValueFactory, bool isFixed);
+        public CascadingValueSource(string name, Func<TValue> initialValueFactory, bool isFixed);
+        public CascadingValueSource(string name, TValue value, bool isFixed);
+        public CascadingValueSource(TValue value, bool isFixed);
+        public Task NotifyChangedAsync();
+        public Task NotifyChangedAsync(TValue newValue);
+    }
     public abstract class ComponentBase : IComponent, IHandleAfterRender, IHandleEvent {
+        protected Task DispatchExceptionAsync(Exception exception);
     }
     public readonly struct EventCallback : IEventCallback {
-        public EventCallback(IHandleEvent? receiver, MulticastDelegate? @delegate);
+        public EventCallback(IHandleEvent receiver, MulticastDelegate @delegate);
+        public override bool Equals(object obj);
+        public override int GetHashCode();
     }
     public readonly struct EventCallback<TValue> : IEventCallback {
+        public override bool Equals(object obj);
+        public override int GetHashCode();
     }
+    public interface IComponentRenderMode
     [AttributeUsageAttribute(128, AllowMultiple=false, Inherited=true)]
     public sealed class InjectAttribute : Attribute {
+        public object Key { get; set; }
     }
     public interface IPersistentComponentStateStore {
+        bool SupportsRenderMode(IComponentRenderMode renderMode);
     }
     public abstract class NavigationManager {
-        public void NavigateTo(string uri, NavigationOptions options);
+        public void NavigateTo([StringSyntaxAttribute("Uri")] string uri, NavigationOptions options);
-        public void NavigateTo(string uri, bool forceLoad);
+        public void NavigateTo([StringSyntaxAttribute("Uri")] string uri, bool forceLoad);
-        public void NavigateTo(string uri, bool forceLoad = false, bool replace = false);
+        public void NavigateTo([StringSyntaxAttribute("Uri")] string uri, bool forceLoad = false, bool replace = false);
-        protected virtual void NavigateToCore(string uri, NavigationOptions options);
+        protected virtual void NavigateToCore([StringSyntaxAttribute("Uri")] string uri, NavigationOptions options);
-        protected virtual void NavigateToCore(string uri, bool forceLoad);
+        protected virtual void NavigateToCore([StringSyntaxAttribute("Uri")] string uri, bool forceLoad);
+        public virtual void Refresh(bool forceReload = false);
-        public Uri ToAbsoluteUri(string relativeUri);
+        public Uri ToAbsoluteUri(string? relativeUri);
     }
     public readonly struct ParameterView {
-        public IReadOnlyDictionary<string, object> ToDictionary();
+        public IReadOnlyDictionary<string, object?> ToDictionary();
     }
+    public enum PersistedStateSerializationMode {
+        Infer = 1,
+        Server = 2,
+        WebAssembly = 3,
+    }
     public class PersistentComponentState {
+        public PersistingComponentStateSubscription RegisterOnPersisting(Func<Task> callback, IComponentRenderMode? renderMode);
     }
     public readonly struct RenderHandle {
+        public Task DispatchExceptionAsync(Exception exception);
     }
+    [AttributeUsageAttribute(4, AllowMultiple=false, Inherited=true)]
+    public abstract class RenderModeAttribute : Attribute {
+        protected RenderModeAttribute();
+        public abstract IComponentRenderMode Mode { get; }
+    }
     public sealed class RouteData {
-        public RouteData(Type pageType, IReadOnlyDictionary<string, object> routeValues);
+        public RouteData(Type pageType, IReadOnlyDictionary<string, object?> routeValues);
-        public IReadOnlyDictionary<string, object> RouteValues { get; }
+        public IReadOnlyDictionary<string, object?> RouteValues { get; }
+        public string? Template { get; set; }
     }
+    [AttributeUsageAttribute(4, AllowMultiple=false)]
+    public class StreamRenderingAttribute : Attribute {
+        public StreamRenderingAttribute(bool enabled = true);
+        public bool Enabled { get; }
+    }
+    [AttributeUsageAttribute(128, AllowMultiple=false, Inherited=true)]
+    public sealed class SupplyParameterFromFormAttribute : CascadingParameterAttributeBase {
+        public SupplyParameterFromFormAttribute();
+        public string FormName { get; set; }
+        public string Name { get; set; }
+    }
-    [AttributeUsageAttribute(128, AllowMultiple=false, Inherited=true)]
-    public sealed class SupplyParameterFromQueryAttribute : Attribute
+    [AttributeUsageAttribute(128, AllowMultiple=false, Inherited=true)]
+    public sealed class SupplyParameterFromQueryAttribute : CascadingParameterAttributeBase
+    public static class SupplyParameterFromQueryProviderServiceCollectionExtensions {
+        public static IServiceCollection AddSupplyValueFromQueryProvider(this IServiceCollection services);
+    }
 }
```

