# Microsoft.AspNetCore.DataProtection.XmlEncryption

``` diff
 namespace Microsoft.AspNetCore.DataProtection.XmlEncryption {
     public sealed class EncryptedXmlDecryptor : IInternalEncryptedXmlDecryptor, IXmlDecryptor {
-        public XElement Decrypt(XElement encryptedElement);
+        [DynamicDependencyAttribute(1, typeof(RijndaelManaged))]
+        [UnconditionalSuppressMessageAttribute("AOT", "IL2026:RequiresUnreferencedCode", Justification="The common algorithms are being preserved by the above DynamicDependency attributes.")]
+        [UnconditionalSuppressMessageAttribute("AOT", "IL3050:RequiresDynamicCode", Justification="Only XSLTs require dynamic code. The usage of EncryptedXml doesn't use XSLTs.")]
+        public XElement Decrypt(XElement encryptedElement);
     }
 }
```

