# Microsoft.AspNetCore.Hosting

``` diff
 namespace Microsoft.AspNetCore.Hosting {
     public static class HostingAbstractionsWebHostBuilderExtensions {
-        public static IWebHost Start(this IWebHostBuilder hostBuilder, params string[] urls);
+        public static IWebHost Start(this IWebHostBuilder hostBuilder, [StringSyntaxAttribute("Uri")] params string[] urls);
-        public static IWebHostBuilder UseUrls(this IWebHostBuilder hostBuilder, params string[] urls);
+        public static IWebHostBuilder UseUrls(this IWebHostBuilder hostBuilder, [StringSyntaxAttribute("Uri")] params string[] urls);
     }
     public static class WebHostBuilderKestrelExtensions {
+        public static IWebHostBuilder UseKestrelCore(this IWebHostBuilder hostBuilder);
+        public static IWebHostBuilder UseKestrelHttpsConfiguration(this IWebHostBuilder hostBuilder);
     }
+    public static class WebHostBuilderNamedPipeExtensions {
+        [SupportedOSPlatformAttribute("windows")]
+        public static IWebHostBuilder UseNamedPipes(this IWebHostBuilder hostBuilder);
+        [SupportedOSPlatformAttribute("windows")]
+        public static IWebHostBuilder UseNamedPipes(this IWebHostBuilder hostBuilder, Action<NamedPipeTransportOptions> configureOptions);
+    }
     public static class WebHostDefaults {
+        public static readonly string HttpPortsKey;
+        public static readonly string HttpsPortsKey;
     }
 }
```

