# Microsoft.AspNetCore.Http.Metadata

``` diff
 namespace Microsoft.AspNetCore.Http.Metadata {
+    [DebuggerDisplayAttribute("{ToString(),nq}")]
+    public sealed class AcceptsMetadata : IAcceptsMetadata {
+        public AcceptsMetadata(string[] contentTypes, Type? type = null, bool isOptional = false);
+        public IReadOnlyList<string> ContentTypes { get; }
+        public bool IsOptional { get; }
+        public Type? RequestType { get; }
+        public override string ToString();
+    }
+    public class FormMappingOptionsMetadata {
+        public FormMappingOptionsMetadata(int? maxCollectionSize = default(int?), int? maxRecursionDepth = default(int?), int? maxKeySize = default(int?));
+        public int? MaxCollectionSize { get; }
+        public int? MaxKeySize { get; }
+        public int? MaxRecursionDepth { get; }
+    }
+    public interface IFormOptionsMetadata {
+        bool? BufferBody { get; }
+        long? BufferBodyLengthLimit { get; }
+        int? KeyLengthLimit { get; }
+        int? MemoryBufferThreshold { get; }
+        long? MultipartBodyLengthLimit { get; }
+        int? MultipartBoundaryLengthLimit { get; }
+        int? MultipartHeadersCountLimit { get; }
+        int? MultipartHeadersLengthLimit { get; }
+        int? ValueCountLimit { get; }
+        int? ValueLengthLimit { get; }
+    }
+    public interface IRouteDiagnosticsMetadata {
+        string Route { get; }
+    }
 }
```

