# Microsoft.AspNetCore.Http.Timeouts

``` diff
+namespace Microsoft.AspNetCore.Http.Timeouts {
+    [AttributeUsageAttribute(68)]
+    public sealed class DisableRequestTimeoutAttribute : Attribute {
+        public DisableRequestTimeoutAttribute();
+    }
+    public interface IHttpRequestTimeoutFeature {
+        CancellationToken RequestTimeoutToken { get; }
+        void DisableTimeout();
+    }
+    [AttributeUsageAttribute(68)]
+    public sealed class RequestTimeoutAttribute : Attribute {
+        public RequestTimeoutAttribute(int milliseconds);
+        public RequestTimeoutAttribute(string policyName);
+        public string PolicyName { get; }
+        public TimeSpan? Timeout { get; }
+    }
+    public sealed class RequestTimeoutOptions {
+        public RequestTimeoutOptions();
+        public RequestTimeoutPolicy? DefaultPolicy { get; set; }
+        public IDictionary<string, RequestTimeoutPolicy> Policies { get; }
+        public RequestTimeoutOptions AddPolicy(string policyName, RequestTimeoutPolicy policy);
+        public RequestTimeoutOptions AddPolicy(string policyName, TimeSpan timeout);
+    }
+    public sealed class RequestTimeoutPolicy {
+        public RequestTimeoutPolicy();
+        public TimeSpan? Timeout { get; set; }
+        public int? TimeoutStatusCode { get; set; }
+        public RequestDelegate WriteTimeoutResponse { get; set; }
+    }
+}
```

