# Microsoft.AspNetCore.Http

``` diff
 namespace Microsoft.AspNetCore.Http {
     public class BindingAddress {
+        public bool IsNamedPipe { get; }
+        public string NamedPipeName { get; }
     }
-    public abstract class ConnectionInfo
+    [DebuggerDisplayAttribute("{DebuggerToString(),nq}")]
+    [DebuggerTypeProxyAttribute(typeof(ConnectionInfo.ConnectionInfoDebugView))]
+    public abstract class ConnectionInfo
     public sealed class DefaultEndpointFilterInvocationContext : EndpointFilterInvocationContext {
-        public DefaultEndpointFilterInvocationContext(HttpContext httpContext, params object[] arguments);
+        public DefaultEndpointFilterInvocationContext(HttpContext httpContext, params object?[] arguments);
     }
-    public sealed class DefaultHttpContext : HttpContext
+    [DebuggerDisplayAttribute("{DebuggerToString(),nq}")]
+    public sealed class DefaultHttpContext : HttpContext
-    public class Endpoint
+    [DebuggerDisplayAttribute("{ToString(),nq}")]
+    public class Endpoint
-    [AttributeUsageAttribute(64, Inherited=false, AllowMultiple=false)]
-    public sealed class EndpointDescriptionAttribute : Attribute, IEndpointDescriptionMetadata {
+    [AttributeUsageAttribute(64, Inherited=false, AllowMultiple=false)]
+    [DebuggerDisplayAttribute("{ToString(),nq}")]
+    public sealed class EndpointDescriptionAttribute : Attribute, IEndpointDescriptionMetadata {
+        public override string ToString();
     }
     public static class EndpointFilterExtensions {
-        [RequiresUnreferencedCodeAttribute("This API may perform reflection on the supplied delegate and its parameters. These types may be trimmed if not directly referenced.")]
-        public static TBuilder AddEndpointFilter<TBuilder, TFilterType>(this TBuilder builder) where TBuilder : IEndpointConventionBuilder where TFilterType : IEndpointFilter;
+        public static TBuilder AddEndpointFilter<TBuilder, TFilterType>(this TBuilder builder) where TBuilder : IEndpointConventionBuilder where TFilterType : IEndpointFilter;
-        [RequiresUnreferencedCodeAttribute("This API may perform reflection on the supplied delegate and its parameters. These types may be trimmed if not directly referenced.")]
-        public static TBuilder AddEndpointFilter<TBuilder>(this TBuilder builder, IEndpointFilter filter) where TBuilder : IEndpointConventionBuilder;
+        public static TBuilder AddEndpointFilter<TBuilder>(this TBuilder builder, IEndpointFilter filter) where TBuilder : IEndpointConventionBuilder;
-        [RequiresUnreferencedCodeAttribute("This API may perform reflection on the supplied delegate and its parameters. These types may be trimmed if not directly referenced.")]
-        public static TBuilder AddEndpointFilter<TBuilder>(this TBuilder builder, Func<EndpointFilterInvocationContext, EndpointFilterDelegate, ValueTask<object?>> routeHandlerFilter) where TBuilder : IEndpointConventionBuilder;
+        public static TBuilder AddEndpointFilter<TBuilder>(this TBuilder builder, Func<EndpointFilterInvocationContext, EndpointFilterDelegate, ValueTask<object?>> routeHandlerFilter) where TBuilder : IEndpointConventionBuilder;
-        [RequiresUnreferencedCodeAttribute("This API may perform reflection on the supplied delegate and its parameters. These types may be trimmed if not directly referenced.")]
-        public static RouteHandlerBuilder AddEndpointFilter<TFilterType>(this RouteHandlerBuilder builder) where TFilterType : IEndpointFilter;
+        public static RouteHandlerBuilder AddEndpointFilter<TFilterType>(this RouteHandlerBuilder builder) where TFilterType : IEndpointFilter;
-        [RequiresUnreferencedCodeAttribute("This API may perform reflection on the supplied delegate and its parameters. These types may be trimmed if not directly referenced.")]
-        public static RouteGroupBuilder AddEndpointFilter<TFilterType>(this RouteGroupBuilder builder) where TFilterType : IEndpointFilter;
+        public static RouteGroupBuilder AddEndpointFilter<TFilterType>(this RouteGroupBuilder builder) where TFilterType : IEndpointFilter;
-        [RequiresUnreferencedCodeAttribute("This API may perform reflection on the supplied delegate and its parameters. These types may be trimmed if not directly referenced.")]
-        public static TBuilder AddEndpointFilterFactory<TBuilder>(this TBuilder builder, Func<EndpointFilterFactoryContext, EndpointFilterDelegate, EndpointFilterDelegate> filterFactory) where TBuilder : IEndpointConventionBuilder;
+        public static TBuilder AddEndpointFilterFactory<TBuilder>(this TBuilder builder, Func<EndpointFilterFactoryContext, EndpointFilterDelegate, EndpointFilterDelegate> filterFactory) where TBuilder : IEndpointConventionBuilder;
     }
     public abstract class EndpointFilterInvocationContext {
+        public static EndpointFilterInvocationContext Create(HttpContext httpContext);
+        public static EndpointFilterInvocationContext Create<T1, T2, T3, T4, T5, T6, T7, T8>(HttpContext httpContext, T1 arg1, T2 arg2, T3 arg3, T4 arg4, T5 arg5, T6 arg6, T7 arg7, T8 arg8);
+        public static EndpointFilterInvocationContext Create<T1, T2, T3, T4, T5, T6, T7>(HttpContext httpContext, T1 arg1, T2 arg2, T3 arg3, T4 arg4, T5 arg5, T6 arg6, T7 arg7);
+        public static EndpointFilterInvocationContext Create<T1, T2, T3, T4, T5, T6>(HttpContext httpContext, T1 arg1, T2 arg2, T3 arg3, T4 arg4, T5 arg5, T6 arg6);
+        public static EndpointFilterInvocationContext Create<T1, T2, T3, T4, T5>(HttpContext httpContext, T1 arg1, T2 arg2, T3 arg3, T4 arg4, T5 arg5);
+        public static EndpointFilterInvocationContext Create<T1, T2, T3, T4>(HttpContext httpContext, T1 arg1, T2 arg2, T3 arg3, T4 arg4);
+        public static EndpointFilterInvocationContext Create<T1, T2, T3>(HttpContext httpContext, T1 arg1, T2 arg2, T3 arg3);
+        public static EndpointFilterInvocationContext Create<T1, T2>(HttpContext httpContext, T1 arg1, T2 arg2);
+        public static EndpointFilterInvocationContext Create<T>(HttpContext httpContext, T arg);
     }
-    public sealed class EndpointMetadataCollection : IEnumerable, IEnumerable<object>, IReadOnlyCollection<object>, IReadOnlyList<object>
+    [DebuggerDisplayAttribute("Count = {Count}")]
+    [DebuggerTypeProxyAttribute(typeof(EndpointMetadataCollection.EndpointMetadataCollectionDebugView))]
+    public sealed class EndpointMetadataCollection : IEnumerable, IEnumerable<object>, IReadOnlyCollection<object>, IReadOnlyList<object>
-    [AttributeUsageAttribute(64, Inherited=false, AllowMultiple=false)]
-    public sealed class EndpointSummaryAttribute : Attribute, IEndpointSummaryMetadata {
+    [AttributeUsageAttribute(64, Inherited=false, AllowMultiple=false)]
+    [DebuggerDisplayAttribute("{ToString(),nq}")]
+    public sealed class EndpointSummaryAttribute : Attribute, IEndpointSummaryMetadata {
+        public override string ToString();
     }
-    public readonly struct FragmentString : IEquatable<FragmentString>
+    [DebuggerDisplayAttribute("{Value}")]
+    public readonly struct FragmentString : IEquatable<FragmentString>
-    public class HeaderDictionary : ICollection<KeyValuePair<string, StringValues>>, IDictionary<string, StringValues>, IEnumerable, IEnumerable<KeyValuePair<string, StringValues>>, IHeaderDictionary
+    [DebuggerDisplayAttribute("{DebuggerToString(),nq}")]
+    [DebuggerTypeProxyAttribute(typeof(HeaderDictionary.HeaderDictionaryDebugView))]
+    public class HeaderDictionary : ICollection<KeyValuePair<string, StringValues>>, IDictionary<string, StringValues>, IEnumerable, IEnumerable<KeyValuePair<string, StringValues>>, IHeaderDictionary
-    public readonly struct HostString : IEquatable<HostString>
+    [DebuggerDisplayAttribute("{Value}")]
+    public readonly struct HostString : IEquatable<HostString>
-    public abstract class HttpContext
+    [DebuggerDisplayAttribute("{DebuggerToString(),nq}")]
+    [DebuggerTypeProxyAttribute(typeof(HttpContext.HttpContextDebugView))]
+    public abstract class HttpContext
-    public class HttpContextAccessor : IHttpContextAccessor
+    [DebuggerDisplayAttribute("HttpContext = {HttpContext}")]
+    public class HttpContextAccessor : IHttpContextAccessor
-    public abstract class HttpRequest
+    [DebuggerDisplayAttribute("{DebuggerToString(),nq}")]
+    [DebuggerTypeProxyAttribute(typeof(HttpRequest.HttpRequestDebugView))]
+    public abstract class HttpRequest
     public static class HttpRequestJsonExtensions {
+        public static ValueTask<object?> ReadFromJsonAsync(this HttpRequest request, JsonTypeInfo jsonTypeInfo, CancellationToken cancellationToken = default(CancellationToken));
-        [RequiresUnreferencedCodeAttribute("JSON serialization and deserialization might require types that cannot be statically analyzed. Use the overload that takes a JsonTypeInfo or JsonSerializerContext, or make sure all of the required types are preserved.")]
-        public static ValueTask<object?> ReadFromJsonAsync(this HttpRequest request, Type type, CancellationToken cancellationToken = default(CancellationToken));
+        public static ValueTask<object?> ReadFromJsonAsync(this HttpRequest request, Type type, CancellationToken cancellationToken = default(CancellationToken));
-        [RequiresUnreferencedCodeAttribute("JSON serialization and deserialization might require types that cannot be statically analyzed. Use the overload that takes a JsonTypeInfo or JsonSerializerContext, or make sure all of the required types are preserved.")]
-        public static ValueTask<TValue?> ReadFromJsonAsync<TValue>(this HttpRequest request, CancellationToken cancellationToken = default(CancellationToken));
+        public static ValueTask<TValue?> ReadFromJsonAsync<TValue>(this HttpRequest request, CancellationToken cancellationToken = default(CancellationToken));
     }
-    public abstract class HttpResponse {
+    [DebuggerDisplayAttribute("{DebuggerToString(),nq}")]
+    [DebuggerTypeProxyAttribute(typeof(HttpResponse.HttpResponseDebugView))]
+    public abstract class HttpResponse {
-        public virtual void Redirect(string location);
+        public virtual void Redirect([StringSyntaxAttribute("Uri")] string location);
-        public abstract void Redirect(string location, bool permanent);
+        public abstract void Redirect([StringSyntaxAttribute("Uri")] string location, bool permanent);
     }
     public static class HttpResponseJsonExtensions {
+        public static Task WriteAsJsonAsync(this HttpResponse response, object? value, JsonTypeInfo jsonTypeInfo, string? contentType = null, CancellationToken cancellationToken = default(CancellationToken));
     }
-    [JsonConverterAttribute(typeof(HttpValidationProblemDetailsJsonConverter))]
-    public class HttpValidationProblemDetails : ProblemDetails {
+    public class HttpValidationProblemDetails : ProblemDetails {
-        public IDictionary<string, string[]> Errors { get; }
+        public IDictionary<string, string[]> Errors { get; set; }
     }
     public interface IProblemDetailsService {
+        ValueTask<bool> TryWriteAsync(ProblemDetailsContext context);
     }
-    [TypeConverterAttribute(typeof(PathStringConverter))]
-    public readonly struct PathString : IEquatable<PathString>
+    [DebuggerDisplayAttribute("{Value}")]
+    [TypeConverterAttribute(typeof(PathStringConverter))]
+    public readonly struct PathString : IEquatable<PathString>
     public sealed class ProblemDetailsContext {
+        public Exception? Exception { get; set; }
     }
+    [DebuggerDisplayAttribute("{ToString(),nq}")]
+    public sealed class ProducesResponseTypeMetadata : IProducesResponseTypeMetadata {
+        public ProducesResponseTypeMetadata(int statusCode, Type? type = null, string[]? contentTypes = null);
+        public IEnumerable<string> ContentTypes { get; }
+        public int StatusCode { get; }
+        public Type? Type { get; }
+        public override string ToString();
+    }
-    public class QueryCollection : IEnumerable, IEnumerable<KeyValuePair<string, StringValues>>, IQueryCollection
+    [DebuggerDisplayAttribute("Count = {Count}")]
+    [DebuggerTypeProxyAttribute(typeof(QueryCollection.QueryCollectionDebugView))]
+    public class QueryCollection : IEnumerable, IEnumerable<KeyValuePair<string, StringValues>>, IQueryCollection
-    public readonly struct QueryString : IEquatable<QueryString> {
+    [DebuggerDisplayAttribute("{Value}")]
+    public readonly struct QueryString : IEquatable<QueryString> {
-        public bool HasValue { get; }
+        [MemberNotNullWhenAttribute(true, "Value")]
+        public bool HasValue { [MemberNotNullWhenAttribute(true, "Value")] get; }
     }
-    [UnconditionalSuppressMessageAttribute("Trimmer", "IL2026", Justification="RequestDelegateFactory.Create requires unreferenced code.")]
-    [UnconditionalSuppressMessageAttribute("Trimmer", "IL2060", Justification="RequestDelegateFactory.Create requires unreferenced code.")]
-    [UnconditionalSuppressMessageAttribute("Trimmer", "IL2072", Justification="RequestDelegateFactory.Create requires unreferenced code.")]
-    [UnconditionalSuppressMessageAttribute("Trimmer", "IL2075", Justification="RequestDelegateFactory.Create requires unreferenced code.")]
-    [UnconditionalSuppressMessageAttribute("Trimmer", "IL2077", Justification="RequestDelegateFactory.Create requires unreferenced code.")]
-    public static class RequestDelegateFactory {
+    [RequiresUnreferencedCodeAttribute("RequestDelegateFactory performs object creation, serialization and deserialization on the delegates and its parameters. This cannot be statically analyzed.")]
+    public static class RequestDelegateFactory {
-        [RequiresUnreferencedCodeAttribute("RequestDelegateFactory performs object creation, serialization and deserialization on the delegates and its parameters. This cannot be statically analyzed.")]
-        public static RequestDelegateResult Create(Delegate handler, RequestDelegateFactoryOptions? options);
+        public static RequestDelegateResult Create(Delegate handler, RequestDelegateFactoryOptions? options);
-        [RequiresUnreferencedCodeAttribute("RequestDelegateFactory performs object creation, serialization and deserialization on the delegates and its parameters. This cannot be statically analyzed.")]
-        public static RequestDelegateResult Create(Delegate handler, RequestDelegateFactoryOptions? options = null, RequestDelegateMetadataResult? metadataResult = null);
+        public static RequestDelegateResult Create(Delegate handler, RequestDelegateFactoryOptions? options = null, RequestDelegateMetadataResult? metadataResult = null);
-        [RequiresUnreferencedCodeAttribute("RequestDelegateFactory performs object creation, serialization and deserialization on the delegates and its parameters. This cannot be statically analyzed.")]
-        public static RequestDelegateResult Create(MethodInfo methodInfo, Func<HttpContext, object>? targetFactory, RequestDelegateFactoryOptions? options);
+        public static RequestDelegateResult Create(MethodInfo methodInfo, Func<HttpContext, object>? targetFactory, RequestDelegateFactoryOptions? options);
-        [RequiresUnreferencedCodeAttribute("RequestDelegateFactory performs object creation, serialization and deserialization on the delegates and its parameters. This cannot be statically analyzed.")]
-        public static RequestDelegateResult Create(MethodInfo methodInfo, Func<HttpContext, object>? targetFactory = null, RequestDelegateFactoryOptions? options = null, RequestDelegateMetadataResult? metadataResult = null);
+        public static RequestDelegateResult Create(MethodInfo methodInfo, Func<HttpContext, object>? targetFactory = null, RequestDelegateFactoryOptions? options = null, RequestDelegateMetadataResult? metadataResult = null);
-        [RequiresUnreferencedCodeAttribute("RequestDelegateFactory performs object creation, serialization and deserialization on the delegates and its parameters. This cannot be statically analyzed.")]
-        public static RequestDelegateMetadataResult InferMetadata(MethodInfo methodInfo, RequestDelegateFactoryOptions? options = null);
+        public static RequestDelegateMetadataResult InferMetadata(MethodInfo methodInfo, RequestDelegateFactoryOptions? options = null);
     }
     public static class Results {
+        public static IResult AcceptedAtRoute(string routeName, RouteValueDictionary routeValues, object value = null);
-        public static IResult AcceptedAtRoute(string routeName = null, object routeValues = null, object value = null);
+        [RequiresUnreferencedCodeAttribute("This API may perform reflection on supplied parameters which may be trimmed if not referenced directly. Initialize a RouteValueDictionary with route values to avoid this issue.")]
+        public static IResult AcceptedAtRoute(string routeName = null, object routeValues = null, object value = null);
+        public static IResult AcceptedAtRoute<TValue>(string routeName, RouteValueDictionary routeValues, TValue value = null);
-        public static IResult AcceptedAtRoute<TValue>(string routeName = null, object routeValues = null, TValue value = null);
+        [RequiresUnreferencedCodeAttribute("This API may perform reflection on supplied parameters which may be trimmed if not referenced directly. Initialize a RouteValueDictionary with route values to avoid this issue.")]
+        public static IResult AcceptedAtRoute<TValue>(string routeName = null, object routeValues = null, TValue value = null);
+        public static IResult Created();
-        public static IResult Created(string uri, object? value);
+        public static IResult Created(string uri, object value);
-        public static IResult Created(Uri uri, object? value);
+        public static IResult Created(Uri uri, object value);
-        public static IResult Created<TValue>(string uri, TValue? value);
+        public static IResult Created<TValue>(string uri, TValue value);
-        public static IResult Created<TValue>(Uri uri, TValue? value);
+        public static IResult Created<TValue>(Uri uri, TValue value);
+        public static IResult CreatedAtRoute(string routeName, RouteValueDictionary routeValues, object value = null);
-        public static IResult CreatedAtRoute(string routeName = null, object routeValues = null, object value = null);
+        [RequiresUnreferencedCodeAttribute("This API may perform reflection on supplied parameters which may be trimmed if not referenced directly. Initialize a RouteValueDictionary with route values to avoid this issue.")]
+        public static IResult CreatedAtRoute(string routeName = null, object routeValues = null, object value = null);
+        public static IResult CreatedAtRoute<TValue>(string routeName, RouteValueDictionary routeValues, TValue value = null);
-        public static IResult CreatedAtRoute<TValue>(string routeName = null, object routeValues = null, TValue value = null);
+        [RequiresUnreferencedCodeAttribute("This API may perform reflection on supplied parameters which may be trimmed if not referenced directly. Initialize a RouteValueDictionary with route values to avoid this issue.")]
+        public static IResult CreatedAtRoute<TValue>(string routeName = null, object routeValues = null, TValue value = null);
-        public static IResult Json(object data, JsonSerializerOptions options = null, string contentType = null, int? statusCode = default(int?));
+        [RequiresUnreferencedCodeAttribute("JSON serialization and deserialization might require types that cannot be statically analyzed. Use the overload that takes a JsonTypeInfo or JsonSerializerContext.")]
+        public static IResult Json(object data, JsonSerializerOptions options = null, string contentType = null, int? statusCode = default(int?));
+        public static IResult Json(object? data, JsonTypeInfo jsonTypeInfo, string? contentType = null, int? statusCode = default(int?));
+        public static IResult Json(object? data, Type type, JsonSerializerContext context, string? contentType = null, int? statusCode = default(int?));
-        public static IResult Json<TValue>(TValue data, JsonSerializerOptions options = null, string contentType = null, int? statusCode = default(int?));
+        [RequiresUnreferencedCodeAttribute("JSON serialization and deserialization might require types that cannot be statically analyzed. Use the overload that takes a JsonTypeInfo or JsonSerializerContext.")]
+        public static IResult Json<TValue>(TValue data, JsonSerializerOptions options = null, string contentType = null, int? statusCode = default(int?));
+        public static IResult Json<TValue>(TValue data, JsonSerializerContext context, string contentType = null, int? statusCode = default(int?));
+        public static IResult Json<TValue>(TValue data, JsonTypeInfo<TValue> jsonTypeInfo, string contentType = null, int? statusCode = default(int?));
-        public static IResult LocalRedirect(string localUrl, bool permanent = false, bool preserveMethod = false);
+        public static IResult LocalRedirect([StringSyntaxAttribute("Uri", new object[]{ 2})] string localUrl, bool permanent = false, bool preserveMethod = false);
-        public static IResult Redirect(string url, bool permanent = false, bool preserveMethod = false);
+        public static IResult Redirect([StringSyntaxAttribute("Uri")] string url, bool permanent = false, bool preserveMethod = false);
+        public static IResult RedirectToRoute(string routeName, RouteValueDictionary routeValues, bool permanent = false, bool preserveMethod = false, string fragment = null);
-        public static IResult RedirectToRoute(string routeName = null, object routeValues = null, bool permanent = false, bool preserveMethod = false, string fragment = null);
+        [RequiresUnreferencedCodeAttribute("This API may perform reflection on supplied parameters which may be trimmed if not referenced directly. Initialize a RouteValueDictionary with route values to avoid this issue.")]
+        public static IResult RedirectToRoute(string routeName = null, object routeValues = null, bool permanent = false, bool preserveMethod = false, string fragment = null);
     }
     public static class StatusCodes {
+        public const int Status499ClientClosedRequest = 499;
     }
-    [AttributeUsageAttribute(4164, Inherited=false, AllowMultiple=false)]
-    public sealed class TagsAttribute : Attribute, ITagsMetadata {
+    [AttributeUsageAttribute(4164, Inherited=false, AllowMultiple=false)]
+    [DebuggerDisplayAttribute("{ToString(),nq}")]
+    public sealed class TagsAttribute : Attribute, ITagsMetadata {
+        public override string ToString();
     }
     public static class TypedResults {
+        public static IResultExtensions Extensions { get; }
+        public static AcceptedAtRoute AcceptedAtRoute(string routeName, RouteValueDictionary routeValues);
-        public static AcceptedAtRoute AcceptedAtRoute(string routeName = null, object routeValues = null);
+        [RequiresUnreferencedCodeAttribute("This API may perform reflection on supplied parameters which may be trimmed if not referenced directly. Initialize a RouteValueDictionary with route values to avoid this issue.")]
+        public static AcceptedAtRoute AcceptedAtRoute(string routeName = null, object routeValues = null);
+        public static AcceptedAtRoute<TValue> AcceptedAtRoute<TValue>(TValue value, string routeName, RouteValueDictionary routeValues);
-        public static AcceptedAtRoute<TValue> AcceptedAtRoute<TValue>(TValue value, string routeName = null, object routeValues = null);
+        [RequiresUnreferencedCodeAttribute("This API may perform reflection on supplied parameters which may be trimmed if not referenced directly. Initialize a RouteValueDictionary with route values to avoid this issue.")]
+        public static AcceptedAtRoute<TValue> AcceptedAtRoute<TValue>(TValue value, string routeName = null, object routeValues = null);
+        public static Created Created();
-        public static Created Created(string uri);
+        public static Created Created(string? uri);
-        public static Created Created(Uri uri);
+        public static Created Created(Uri? uri);
-        public static Created<TValue> Created<TValue>(string uri, TValue? value);
+        public static Created<TValue> Created<TValue>(string uri, TValue value);
-        public static Created<TValue> Created<TValue>(Uri uri, TValue? value);
+        public static Created<TValue> Created<TValue>(Uri uri, TValue value);
+        public static CreatedAtRoute CreatedAtRoute(string routeName, RouteValueDictionary routeValues);
-        public static CreatedAtRoute CreatedAtRoute(string routeName = null, object routeValues = null);
+        [RequiresUnreferencedCodeAttribute("This API may perform reflection on supplied parameters which may be trimmed if not referenced directly. Initialize a RouteValueDictionary with route values to avoid this issue.")]
+        public static CreatedAtRoute CreatedAtRoute(string routeName = null, object routeValues = null);
+        public static CreatedAtRoute<TValue> CreatedAtRoute<TValue>(TValue value, string routeName, RouteValueDictionary routeValues);
-        public static CreatedAtRoute<TValue> CreatedAtRoute<TValue>(TValue value, string routeName = null, object routeValues = null);
+        [RequiresUnreferencedCodeAttribute("This API may perform reflection on supplied parameters which may be trimmed if not referenced directly. Initialize a RouteValueDictionary with route values to avoid this issue.")]
+        public static CreatedAtRoute<TValue> CreatedAtRoute<TValue>(TValue value, string routeName = null, object routeValues = null);
-        public static JsonHttpResult<TValue> Json<TValue>(TValue data, JsonSerializerOptions options = null, string contentType = null, int? statusCode = default(int?));
+        [RequiresUnreferencedCodeAttribute("JSON serialization and deserialization might require types that cannot be statically analyzed. Use the overload that takes a JsonTypeInfo or JsonSerializerContext.")]
+        public static JsonHttpResult<TValue> Json<TValue>(TValue data, JsonSerializerOptions options = null, string contentType = null, int? statusCode = default(int?));
+        public static JsonHttpResult<TValue> Json<TValue>(TValue data, JsonSerializerContext context, string contentType = null, int? statusCode = default(int?));
+        public static JsonHttpResult<TValue> Json<TValue>(TValue data, JsonTypeInfo<TValue> jsonTypeInfo, string contentType = null, int? statusCode = default(int?));
-        public static RedirectHttpResult LocalRedirect(string localUrl, bool permanent = false, bool preserveMethod = false);
+        public static RedirectHttpResult LocalRedirect([StringSyntaxAttribute("Uri", new object[]{ 2})] string localUrl, bool permanent = false, bool preserveMethod = false);
-        public static RedirectHttpResult Redirect(string url, bool permanent = false, bool preserveMethod = false);
+        public static RedirectHttpResult Redirect([StringSyntaxAttribute("Uri")] string url, bool permanent = false, bool preserveMethod = false);
+        public static RedirectToRouteHttpResult RedirectToRoute(string routeName, RouteValueDictionary routeValues, bool permanent = false, bool preserveMethod = false, string fragment = null);
-        public static RedirectToRouteHttpResult RedirectToRoute(string routeName = null, object routeValues = null, bool permanent = false, bool preserveMethod = false, string fragment = null);
+        [RequiresUnreferencedCodeAttribute("This API may perform reflection on supplied parameters which may be trimmed if not referenced directly. Initialize a RouteValueDictionary with route values to avoid this issue.")]
+        public static RedirectToRouteHttpResult RedirectToRoute(string routeName = null, object routeValues = null, bool permanent = false, bool preserveMethod = false, string fragment = null);
     }
-    public abstract class WebSocketManager
+    [DebuggerDisplayAttribute("{DebuggerToString(),nq}")]
+    [DebuggerTypeProxyAttribute(typeof(WebSocketManager.WebSocketManagerDebugView))]
+    public abstract class WebSocketManager
 }
```

