# Microsoft.AspNetCore.HttpLogging

``` diff
 namespace Microsoft.AspNetCore.HttpLogging {
+    [AttributeUsageAttribute(68, AllowMultiple=false, Inherited=true)]
+    public sealed class HttpLoggingAttribute : Attribute {
+        public HttpLoggingAttribute(HttpLoggingFields loggingFields);
+        public bool IsRequestBodyLogLimitSet { get; }
+        public bool IsResponseBodyLogLimitSet { get; }
+        public HttpLoggingFields LoggingFields { get; }
+        public int RequestBodyLogLimit { get; set; }
+        public int ResponseBodyLogLimit { get; set; }
+    }
     [FlagsAttribute]
     public enum HttpLoggingFields : long {
-        All = (long)3325,
+        All = (long)7421,
+        Duration = (long)4096,
     }
+    public sealed class HttpLoggingInterceptorContext {
+        public HttpLoggingInterceptorContext();
+        public HttpContext HttpContext { get; set; }
+        public HttpLoggingFields LoggingFields { get; set; }
+        public IList<KeyValuePair<string, object?>> Parameters { get; }
+        public int RequestBodyLogLimit { get; set; }
+        public int ResponseBodyLogLimit { get; set; }
+        public void AddParameter(string key, object? value);
+        public void Disable(HttpLoggingFields fields);
+        public void Enable(HttpLoggingFields fields);
+        public bool IsAnyEnabled(HttpLoggingFields fields);
+        public bool TryDisable(HttpLoggingFields fields);
+    }
     public sealed class HttpLoggingOptions {
+        public bool CombineLogs { get; set; }
     }
+    public interface IHttpLoggingInterceptor {
+        ValueTask OnRequestAsync(HttpLoggingInterceptorContext logContext);
+        ValueTask OnResponseAsync(HttpLoggingInterceptorContext logContext);
+    }
 }
```

