# Microsoft.AspNetCore.Identity.Data

``` diff
+namespace Microsoft.AspNetCore.Identity.Data {
+    public sealed class ForgotPasswordRequest {
+        public ForgotPasswordRequest();
+        public required string Email { get; set; }
+    }
+    public sealed class InfoRequest {
+        public InfoRequest();
+        public string NewEmail { get; set; }
+        public string NewPassword { get; set; }
+        public string OldPassword { get; set; }
+    }
+    public sealed class InfoResponse {
+        public InfoResponse();
+        public required string Email { get; set; }
+        public required bool IsEmailConfirmed { get; set; }
+    }
+    public sealed class LoginRequest {
+        public LoginRequest();
+        public required string Email { get; set; }
+        public required string Password { get; set; }
+        public string? TwoFactorCode { get; set; }
+        public string? TwoFactorRecoveryCode { get; set; }
+    }
+    public sealed class RefreshRequest {
+        public RefreshRequest();
+        public required string RefreshToken { get; set; }
+    }
+    public sealed class RegisterRequest {
+        public RegisterRequest();
+        public required string Email { get; set; }
+        public required string Password { get; set; }
+    }
+    public sealed class ResendConfirmationEmailRequest {
+        public ResendConfirmationEmailRequest();
+        public required string Email { get; set; }
+    }
+    public sealed class ResetPasswordRequest {
+        public ResetPasswordRequest();
+        public required string Email { get; set; }
+        public required string NewPassword { get; set; }
+        public required string ResetCode { get; set; }
+    }
+    public sealed class TwoFactorRequest {
+        public TwoFactorRequest();
+        public bool? Enable { get; set; }
+        public bool ForgetMachine { get; set; }
+        public bool ResetRecoveryCodes { get; set; }
+        public bool ResetSharedKey { get; set; }
+        public string TwoFactorCode { get; set; }
+    }
+    public sealed class TwoFactorResponse {
+        public TwoFactorResponse();
+        public required bool IsMachineRemembered { get; set; }
+        public required bool IsTwoFactorEnabled { get; set; }
+        public string[]? RecoveryCodes { get; set; }
+        public required int RecoveryCodesLeft { get; set; }
+        public required string SharedKey { get; set; }
+    }
+}
```

