# Microsoft.AspNetCore.Identity

``` diff
 namespace Microsoft.AspNetCore.Identity {
     public class IdentityBuilder {
-        public virtual IdentityBuilder AddClaimsPrincipalFactory<TFactory>() where TFactory : class;
+        [UnconditionalSuppressMessageAttribute("AOT", "IL3050", Justification="MakeGenericType is safe because UserType is a reference type.")]
+        public virtual IdentityBuilder AddClaimsPrincipalFactory<TFactory>() where TFactory : class;
-        public virtual IdentityBuilder AddPasswordValidator<TValidator>() where TValidator : class;
+        [UnconditionalSuppressMessageAttribute("AOT", "IL3050", Justification="MakeGenericType is safe because UserType is a reference type.")]
+        public virtual IdentityBuilder AddPasswordValidator<TValidator>() where TValidator : class;
-        public virtual IdentityBuilder AddRoleManager<TRoleManager>() where TRoleManager : class;
+        [UnconditionalSuppressMessageAttribute("AOT", "IL3050", Justification="MakeGenericType is safe because RoleType is a reference type.")]
+        public virtual IdentityBuilder AddRoleManager<TRoleManager>() where TRoleManager : class;
-        public virtual IdentityBuilder AddRoles<TRole>() where TRole : class;
+        [UnconditionalSuppressMessageAttribute("AOT", "IL3050", Justification="MakeGenericType is safe because UserType is a reference type.")]
+        public virtual IdentityBuilder AddRoles<TRole>() where TRole : class;
-        public virtual IdentityBuilder AddRoleStore<TStore>() where TStore : class;
+        [UnconditionalSuppressMessageAttribute("AOT", "IL3050", Justification="MakeGenericType is safe because RoleType is a reference type.")]
+        public virtual IdentityBuilder AddRoleStore<TStore>() where TStore : class;
-        public virtual IdentityBuilder AddRoleValidator<TRole>() where TRole : class;
+        [UnconditionalSuppressMessageAttribute("AOT", "IL3050", Justification="MakeGenericType is safe because RoleType is a reference type.")]
+        public virtual IdentityBuilder AddRoleValidator<TRole>() where TRole : class;
-        public virtual IdentityBuilder AddTokenProvider(string providerName, Type provider);
+        [UnconditionalSuppressMessageAttribute("AOT", "IL3050", Justification="MakeGenericType is safe because UserType is a reference type.")]
+        public virtual IdentityBuilder AddTokenProvider(string providerName, Type provider);
-        public virtual IdentityBuilder AddUserConfirmation<TUserConfirmation>() where TUserConfirmation : class;
+        [UnconditionalSuppressMessageAttribute("AOT", "IL3050", Justification="MakeGenericType is safe because UserType is a reference type.")]
+        public virtual IdentityBuilder AddUserConfirmation<TUserConfirmation>() where TUserConfirmation : class;
-        public virtual IdentityBuilder AddUserManager<TUserManager>() where TUserManager : class;
+        [UnconditionalSuppressMessageAttribute("AOT", "IL3050", Justification="MakeGenericType is safe because UserType is a reference type.")]
+        public virtual IdentityBuilder AddUserManager<TUserManager>() where TUserManager : class;
-        public virtual IdentityBuilder AddUserStore<TStore>() where TStore : class;
+        [UnconditionalSuppressMessageAttribute("AOT", "IL3050", Justification="MakeGenericType is safe because UserType is a reference type.")]
+        public virtual IdentityBuilder AddUserStore<TStore>() where TStore : class;
-        public virtual IdentityBuilder AddUserValidator<TValidator>() where TValidator : class;
+        [UnconditionalSuppressMessageAttribute("AOT", "IL3050", Justification="MakeGenericType is safe because UserType is a reference type.")]
+        public virtual IdentityBuilder AddUserValidator<TValidator>() where TValidator : class;
     }
     public static class IdentityBuilderExtensions {
+        public static IdentityBuilder AddApiEndpoints(this IdentityBuilder builder);
-        public static IdentityBuilder AddDefaultTokenProviders(this IdentityBuilder builder);
+        [UnconditionalSuppressMessageAttribute("AOT", "IL3050", Justification="MakeGenericType is safe because user type is a reference type.")]
+        public static IdentityBuilder AddDefaultTokenProviders(this IdentityBuilder builder);
-        public static IdentityBuilder AddSignInManager(this IdentityBuilder builder);
+        [UnconditionalSuppressMessageAttribute("AOT", "IL3050", Justification="MakeGenericType is safe because user type is a reference type.")]
+        public static IdentityBuilder AddSignInManager(this IdentityBuilder builder);
-        public static IdentityBuilder AddSignInManager<TSignInManager>(this IdentityBuilder builder) where TSignInManager : class;
+        [UnconditionalSuppressMessageAttribute("AOT", "IL3050", Justification="MakeGenericType is safe because user type is a reference type.")]
+        public static IdentityBuilder AddSignInManager<TSignInManager>(this IdentityBuilder builder) where TSignInManager : class;
     }
     public class IdentityConstants {
+        public static readonly string BearerScheme;
     }
+    public static class IdentitySchemaVersions {
+        public static readonly Version Default;
+        public static readonly Version Version1;
+        public static readonly Version Version2;
+    }
+    public interface IEmailSender<TUser> where TUser : class {
+        Task SendConfirmationLinkAsync(TUser user, string email, string confirmationLink);
+        Task SendPasswordResetCodeAsync(TUser user, string email, string resetCode);
+        Task SendPasswordResetLinkAsync(TUser user, string email, string resetLink);
+    }
     public class SecurityStampValidator<TUser> : ISecurityStampValidator where TUser : class {
-        public SecurityStampValidator(IOptions<SecurityStampValidatorOptions> options, SignInManager<TUser> signInManager, ISystemClock clock, ILoggerFactory logger);
+        [ObsoleteAttribute("ISystemClock is obsolete, use TimeProvider on SecurityStampValidatorOptions instead.")]
+        public SecurityStampValidator(IOptions<SecurityStampValidatorOptions> options, SignInManager<TUser> signInManager, ISystemClock clock, ILoggerFactory logger);
+        public SecurityStampValidator(IOptions<SecurityStampValidatorOptions> options, SignInManager<TUser> signInManager, ILoggerFactory logger);
-        public ISystemClock Clock { get; }
+        [ObsoleteAttribute("ISystemClock is obsolete, use TimeProvider instead.")]
+        public ISystemClock Clock { get; }
+        public TimeProvider TimeProvider { get; }
     }
     public class SecurityStampValidatorOptions {
+        public TimeProvider TimeProvider { get; set; }
     }
     public class SignInManager<TUser> where TUser : class {
+        public string AuthenticationScheme { get; set; }
-        public virtual AuthenticationProperties ConfigureExternalAuthenticationProperties(string? provider, string? redirectUrl, string? userId = null);
+        public virtual AuthenticationProperties ConfigureExternalAuthenticationProperties(string? provider, [StringSyntaxAttribute("Uri")] string? redirectUrl, string? userId = null);
+        public virtual Task<bool> IsTwoFactorEnabledAsync(TUser user);
     }
     public class StoreOptions {
+        public Version SchemaVersion { get; set; }
     }
     public class TwoFactorSecurityStampValidator<TUser> : SecurityStampValidator<TUser>, ISecurityStampValidator, ITwoFactorSecurityStampValidator where TUser : class {
-        public TwoFactorSecurityStampValidator(IOptions<SecurityStampValidatorOptions> options, SignInManager<TUser> signInManager, ISystemClock clock, ILoggerFactory logger);
+        [ObsoleteAttribute("ISystemClock is obsolete, use TimeProvider on SecurityStampValidatorOptions instead.")]
+        public TwoFactorSecurityStampValidator(IOptions<SecurityStampValidatorOptions> options, SignInManager<TUser> signInManager, ISystemClock clock, ILoggerFactory logger);
+        public TwoFactorSecurityStampValidator(IOptions<SecurityStampValidatorOptions> options, SignInManager<TUser> signInManager, ILoggerFactory logger);
     }
 }
```

