# Microsoft.AspNetCore.Mvc

``` diff
 namespace Microsoft.AspNetCore.Mvc {
     [ControllerAttribute]
     public abstract class ControllerBase {
-        public IModelMetadataProvider MetadataProvider { get; set; }
+        [DebuggerBrowsableAttribute(0)]
+        public IModelMetadataProvider MetadataProvider { get; set; }
-        public IModelBinderFactory ModelBinderFactory { get; set; }
+        [DebuggerBrowsableAttribute(0)]
+        public IModelBinderFactory ModelBinderFactory { get; set; }
-        public IObjectModelValidator ObjectValidator { get; set; }
+        [DebuggerBrowsableAttribute(0)]
+        public IObjectModelValidator ObjectValidator { get; set; }
-        public ProblemDetailsFactory ProblemDetailsFactory { get; set; }
+        [DebuggerBrowsableAttribute(0)]
+        public ProblemDetailsFactory ProblemDetailsFactory { get; set; }
-        public IUrlHelper Url { get; set; }
+        [DebuggerBrowsableAttribute(0)]
+        public IUrlHelper Url { get; set; }
+        [NonActionAttribute]
+        public virtual CreatedResult Created();
-        [NonActionAttribute]
-        public virtual CreatedResult Created(string uri, [ActionResultObjectValueAttribute] object? value);
+        [NonActionAttribute]
+        public virtual CreatedResult Created(string? uri, [ActionResultObjectValueAttribute] object? value);
-        [NonActionAttribute]
-        public virtual CreatedResult Created(Uri uri, [ActionResultObjectValueAttribute] object? value);
+        [NonActionAttribute]
+        public virtual CreatedResult Created(Uri? uri, [ActionResultObjectValueAttribute] object? value);
-        [NonActionAttribute]
-        public virtual LocalRedirectResult LocalRedirect(string localUrl);
+        [NonActionAttribute]
+        public virtual LocalRedirectResult LocalRedirect([StringSyntaxAttribute("Uri", new object[]{ 2})] string localUrl);
-        [NonActionAttribute]
-        public virtual LocalRedirectResult LocalRedirectPermanent(string localUrl);
+        [NonActionAttribute]
+        public virtual LocalRedirectResult LocalRedirectPermanent([StringSyntaxAttribute("Uri", new object[]{ 2})] string localUrl);
-        [NonActionAttribute]
-        public virtual LocalRedirectResult LocalRedirectPermanentPreserveMethod(string localUrl);
+        [NonActionAttribute]
+        public virtual LocalRedirectResult LocalRedirectPermanentPreserveMethod([StringSyntaxAttribute("Uri", new object[]{ 2})] string localUrl);
-        [NonActionAttribute]
-        public virtual LocalRedirectResult LocalRedirectPreserveMethod(string localUrl);
+        [NonActionAttribute]
+        public virtual LocalRedirectResult LocalRedirectPreserveMethod([StringSyntaxAttribute("Uri", new object[]{ 2})] string localUrl);
-        [NonActionAttribute]
-        public virtual RedirectResult Redirect(string url);
+        [NonActionAttribute]
+        public virtual RedirectResult Redirect([StringSyntaxAttribute("Uri")] string url);
-        [NonActionAttribute]
-        public virtual RedirectResult RedirectPermanent(string url);
+        [NonActionAttribute]
+        public virtual RedirectResult RedirectPermanent([StringSyntaxAttribute("Uri")] string url);
-        [NonActionAttribute]
-        public virtual RedirectResult RedirectPermanentPreserveMethod(string url);
+        [NonActionAttribute]
+        public virtual RedirectResult RedirectPermanentPreserveMethod([StringSyntaxAttribute("Uri")] string url);
-        [NonActionAttribute]
-        public virtual RedirectResult RedirectPreserveMethod(string url);
+        [NonActionAttribute]
+        public virtual RedirectResult RedirectPreserveMethod([StringSyntaxAttribute("Uri")] string url);
     }
-    public class ControllerContext : ActionContext
+    [DebuggerDisplayAttribute("{DebuggerToString(),nq}")]
+    public class ControllerContext : ActionContext
     [DefaultStatusCodeAttribute(201)]
     public class CreatedResult : ObjectResult {
+        public CreatedResult();
-        public CreatedResult(string location, object? value);
+        public CreatedResult(string location, object value);
-        public CreatedResult(Uri location, object? value);
+        public CreatedResult(Uri location, object value);
-        public string Location { get; [MemberNotNullAttribute("_location")] set; }
+        public string Location { get; set; }
     }
     public interface IUrlHelper {
-        bool IsLocalUrl([NotNullWhenAttribute(true)] string? url);
+        bool IsLocalUrl([NotNullWhenAttribute(true), StringSyntaxAttribute("Uri")] string? url);
     }
     public class LocalRedirectResult : ActionResult {
-        public LocalRedirectResult(string localUrl);
+        public LocalRedirectResult([StringSyntaxAttribute("Uri", new object[]{ 2})] string localUrl);
-        public LocalRedirectResult(string localUrl, bool permanent);
+        public LocalRedirectResult([StringSyntaxAttribute("Uri", new object[]{ 2})] string localUrl, bool permanent);
-        public LocalRedirectResult(string localUrl, bool permanent, bool preserveMethod);
+        public LocalRedirectResult([StringSyntaxAttribute("Uri", new object[]{ 2})] string localUrl, bool permanent, bool preserveMethod);
     }
+    public class MiddlewareFilterAttribute<T> : MiddlewareFilterAttribute {
+        public MiddlewareFilterAttribute();
+    }
+    public class ModelBinderAttribute<TBinder> : ModelBinderAttribute where TBinder : IModelBinder {
+        public ModelBinderAttribute();
+    }
+    public class ModelMetadataTypeAttribute<T> : ModelMetadataTypeAttribute {
+        public ModelMetadataTypeAttribute();
+    }
-    [JsonConverterAttribute(typeof(ProblemDetailsJsonConverter))]
-    public class ProblemDetails {
+    public class ProblemDetails {
-        [JsonPropertyNameAttribute("detail")]
-        public string Detail { get; set; }
+        [JsonIgnoreAttribute(Condition=3)]
+        [JsonPropertyOrderAttribute(-2)]
+        public string Detail { get; set; }
-        [JsonExtensionDataAttribute]
-        public IDictionary<string, object?> Extensions { get; }
+        [JsonExtensionDataAttribute]
+        public IDictionary<string, object?> Extensions { get; set; }
-        [JsonPropertyNameAttribute("instance")]
-        public string Instance { get; set; }
+        [JsonIgnoreAttribute(Condition=3)]
+        [JsonPropertyOrderAttribute(-1)]
+        public string Instance { get; set; }
-        [JsonPropertyNameAttribute("status")]
-        public int? Status { get; set; }
+        [JsonIgnoreAttribute(Condition=3)]
+        [JsonPropertyOrderAttribute(-3)]
+        public int? Status { get; set; }
-        [JsonPropertyNameAttribute("title")]
-        public string Title { get; set; }
+        [JsonIgnoreAttribute(Condition=3)]
+        [JsonPropertyOrderAttribute(-4)]
+        public string Title { get; set; }
-        [JsonPropertyNameAttribute("type")]
-        public string Type { get; set; }
+        [JsonIgnoreAttribute(Condition=3)]
+        [JsonPropertyOrderAttribute(-5)]
+        public string Type { get; set; }
     }
+    public class ProducesAttribute<T> : ProducesAttribute {
+        public ProducesAttribute();
+    }
+    public class ProducesResponseTypeAttribute<T> : ProducesResponseTypeAttribute {
+        public ProducesResponseTypeAttribute(int statusCode);
+        public ProducesResponseTypeAttribute(int statusCode, string contentType, params string[] additionalContentTypes);
+    }
     public class RedirectResult : ActionResult, IActionResult, IKeepTempDataResult {
-        public RedirectResult(string url);
+        public RedirectResult([StringSyntaxAttribute("Uri")] string url);
-        public RedirectResult(string url, bool permanent);
+        public RedirectResult([StringSyntaxAttribute("Uri")] string url, bool permanent);
-        public RedirectResult(string url, bool permanent, bool preserveMethod);
+        public RedirectResult([StringSyntaxAttribute("Uri")] string url, bool permanent, bool preserveMethod);
     }
-    [AttributeUsageAttribute(68, AllowMultiple=false, Inherited=true)]
-    public class RequestFormLimitsAttribute : Attribute, IFilterFactory, IFilterMetadata, IOrderedFilter {
+    [AttributeUsageAttribute(68, AllowMultiple=false, Inherited=true)]
+    public class RequestFormLimitsAttribute : Attribute, IFilterFactory, IFilterMetadata, IFormOptionsMetadata, IOrderedFilter {
+        bool? Microsoft.AspNetCore.Http.Metadata.IFormOptionsMetadata.BufferBody { get; }
+        long? Microsoft.AspNetCore.Http.Metadata.IFormOptionsMetadata.BufferBodyLengthLimit { get; }
+        int? Microsoft.AspNetCore.Http.Metadata.IFormOptionsMetadata.KeyLengthLimit { get; }
+        int? Microsoft.AspNetCore.Http.Metadata.IFormOptionsMetadata.MemoryBufferThreshold { get; }
+        long? Microsoft.AspNetCore.Http.Metadata.IFormOptionsMetadata.MultipartBodyLengthLimit { get; }
+        int? Microsoft.AspNetCore.Http.Metadata.IFormOptionsMetadata.MultipartBoundaryLengthLimit { get; }
+        int? Microsoft.AspNetCore.Http.Metadata.IFormOptionsMetadata.MultipartHeadersCountLimit { get; }
+        int? Microsoft.AspNetCore.Http.Metadata.IFormOptionsMetadata.MultipartHeadersLengthLimit { get; }
+        int? Microsoft.AspNetCore.Http.Metadata.IFormOptionsMetadata.ValueCountLimit { get; }
+        int? Microsoft.AspNetCore.Http.Metadata.IFormOptionsMetadata.ValueLengthLimit { get; }
     }
-    [AttributeUsageAttribute(68, AllowMultiple=true, Inherited=true)]
-    [DebuggerDisplayAttribute("ServiceFilter: Type={ServiceType} Order={Order}")]
-    public class ServiceFilterAttribute : Attribute, IFilterFactory, IFilterMetadata, IOrderedFilter
+    [AttributeUsageAttribute(68, AllowMultiple=true, Inherited=true)]
+    [DebuggerDisplayAttribute("Type = {ServiceType}, Order = {Order}")]
+    public class ServiceFilterAttribute : Attribute, IFilterFactory, IFilterMetadata, IOrderedFilter
+    [DebuggerDisplayAttribute("Type = {ServiceType}, Order = {Order}")]
+    public class ServiceFilterAttribute<TFilter> : ServiceFilterAttribute where TFilter : IFilterMetadata {
+        public ServiceFilterAttribute();
+    }
-    [AttributeUsageAttribute(68, AllowMultiple=true, Inherited=true)]
-    [DebuggerDisplayAttribute("TypeFilter: Type={ImplementationType} Order={Order}")]
-    public class TypeFilterAttribute : Attribute, IFilterFactory, IFilterMetadata, IOrderedFilter
+    [AttributeUsageAttribute(68, AllowMultiple=true, Inherited=true)]
+    [DebuggerDisplayAttribute("Type = {ImplementationType}, Order = {Order}")]
+    public class TypeFilterAttribute : Attribute, IFilterFactory, IFilterMetadata, IOrderedFilter
+    public class TypeFilterAttribute<TFilter> : TypeFilterAttribute where TFilter : IFilterMetadata {
+        public TypeFilterAttribute();
+    }
-    [JsonConverterAttribute(typeof(ValidationProblemDetailsJsonConverter))]
-    public class ValidationProblemDetails : HttpValidationProblemDetails {
+    public class ValidationProblemDetails : HttpValidationProblemDetails {
-        public new IDictionary<string, string[]> Errors { get; }
+        public new IDictionary<string, string[]> Errors { get; set; }
     }
 }
```

