# Microsoft.AspNetCore.Routing

``` diff
 namespace Microsoft.AspNetCore.Routing {
     public static class ControllerLinkGeneratorExtensions {
-        public static string GetPathByAction(this LinkGenerator generator, HttpContext httpContext, string action = null, string controller = null, object values = null, PathString? pathBase = default(PathString?), FragmentString fragment = default(FragmentString), LinkOptions options = null);
+        public static string? GetPathByAction(this LinkGenerator generator, HttpContext httpContext, string? action = null, string? controller = null, object? values = null, PathString? pathBase = default(PathString?), FragmentString fragment = default(FragmentString), LinkOptions? options = null);
-        public static string GetUriByAction(this LinkGenerator generator, HttpContext httpContext, string action = null, string controller = null, object values = null, string scheme = null, HostString? host = default(HostString?), PathString? pathBase = default(PathString?), FragmentString fragment = default(FragmentString), LinkOptions options = null);
+        public static string? GetUriByAction(this LinkGenerator generator, HttpContext httpContext, string? action = null, string? controller = null, object? values = null, string? scheme = null, HostString? host = default(HostString?), PathString? pathBase = default(PathString?), FragmentString fragment = default(FragmentString), LinkOptions? options = null);
-        public static string GetUriByAction(this LinkGenerator generator, string action, string controller, object values, string scheme, HostString host, PathString pathBase = default(PathString), FragmentString fragment = default(FragmentString), LinkOptions options = null);
+        public static string? GetUriByAction(this LinkGenerator generator, string action, string controller, object? values, string scheme, HostString host, PathString pathBase = default(PathString), FragmentString fragment = default(FragmentString), LinkOptions? options = null);
     }
-    public sealed class DataTokensMetadata : IDataTokensMetadata {
+    [DebuggerDisplayAttribute("{ToString(),nq}")]
+    public sealed class DataTokensMetadata : IDataTokensMetadata {
+        public override string ToString();
     }
-    public class EndpointNameMetadata : IEndpointNameMetadata {
+    [DebuggerDisplayAttribute("{ToString(),nq}")]
+    public class EndpointNameMetadata : IEndpointNameMetadata {
+        public override string ToString();
     }
-    [AttributeUsageAttribute(4164, AllowMultiple=false, Inherited=true)]
-    public sealed class ExcludeFromDescriptionAttribute : Attribute, IExcludeFromDescriptionMetadata {
+    [AttributeUsageAttribute(4164, AllowMultiple=false, Inherited=true)]
+    [DebuggerDisplayAttribute("{ToString(),nq}")]
+    public sealed class ExcludeFromDescriptionAttribute : Attribute, IExcludeFromDescriptionMetadata {
+        public override string ToString();
     }
-    [AttributeUsageAttribute(68, AllowMultiple=false, Inherited=false)]
-    [DebuggerDisplayAttribute("{DebuggerToString(),nq}")]
-    public sealed class HostAttribute : Attribute, IHostMetadata {
+    [AttributeUsageAttribute(68, AllowMultiple=false, Inherited=false)]
+    [DebuggerDisplayAttribute("{ToString(),nq}")]
+    public sealed class HostAttribute : Attribute, IHostMetadata {
+        public override string ToString();
     }
-    [DebuggerDisplayAttribute("{DebuggerToString(),nq}")]
-    public sealed class HttpMethodMetadata : IHttpMethodMetadata {
+    [DebuggerDisplayAttribute("{ToString(),nq}")]
+    public sealed class HttpMethodMetadata : IHttpMethodMetadata {
+        public override string ToString();
     }
+    public static class IdentityApiEndpointRouteBuilderExtensions {
+        public static IEndpointConventionBuilder MapIdentityApi<TUser>(this IEndpointRouteBuilder endpoints) where TUser : class, new();
+    }
     public abstract class LinkGenerator {
-        public abstract string GetUriByAddress<TAddress>(TAddress address, RouteValueDictionary values, string scheme, HostString host, PathString pathBase = default(PathString), FragmentString fragment = default(FragmentString), LinkOptions options = null);
+        public abstract string? GetUriByAddress<TAddress>(TAddress address, RouteValueDictionary values, string scheme, HostString host, PathString pathBase = default(PathString), FragmentString fragment = default(FragmentString), LinkOptions? options = null);
     }
     public static class LinkGeneratorEndpointNameAddressExtensions {
-        [RequiresUnreferencedCodeAttribute("This API may perform reflection on supplied parameters which may be trimmed if not referenced directly. Consider using a different overload to avoid this issue.")]
-        public static string? GetPathByName(this LinkGenerator generator, HttpContext httpContext, string endpointName, object? values, PathString? pathBase = default(PathString?), FragmentString fragment = default(FragmentString), LinkOptions? options = null);
+        [RequiresUnreferencedCodeAttribute("This API may perform reflection on supplied parameters which may be trimmed if not referenced directly. Initialize a RouteValueDictionary with route values to avoid this issue.")]
+        public static string? GetPathByName(this LinkGenerator generator, HttpContext httpContext, string endpointName, object? values, PathString? pathBase = default(PathString?), FragmentString fragment = default(FragmentString), LinkOptions? options = null);
-        [RequiresUnreferencedCodeAttribute("This API may perform reflection on supplied parameters which may be trimmed if not referenced directly. Consider using a different overload to avoid this issue.")]
-        public static string? GetPathByName(this LinkGenerator generator, string endpointName, object? values, PathString pathBase = default(PathString), FragmentString fragment = default(FragmentString), LinkOptions? options = null);
+        [RequiresUnreferencedCodeAttribute("This API may perform reflection on supplied parameters which may be trimmed if not referenced directly. Initialize a RouteValueDictionary with route values to avoid this issue.")]
+        public static string? GetPathByName(this LinkGenerator generator, string endpointName, object? values, PathString pathBase = default(PathString), FragmentString fragment = default(FragmentString), LinkOptions? options = null);
-        [RequiresUnreferencedCodeAttribute("This API may perform reflection on supplied parameters which may be trimmed if not referenced directly. Consider using a different overload to avoid this issue.")]
-        public static string? GetUriByName(this LinkGenerator generator, HttpContext httpContext, string endpointName, object? values, string? scheme = null, HostString? host = default(HostString?), PathString? pathBase = default(PathString?), FragmentString fragment = default(FragmentString), LinkOptions? options = null);
+        [RequiresUnreferencedCodeAttribute("This API may perform reflection on supplied parameters which may be trimmed if not referenced directly. Initialize a RouteValueDictionary with route values to avoid this issue.")]
+        public static string? GetUriByName(this LinkGenerator generator, HttpContext httpContext, string endpointName, object? values, string? scheme = null, HostString? host = default(HostString?), PathString? pathBase = default(PathString?), FragmentString fragment = default(FragmentString), LinkOptions? options = null);
-        [RequiresUnreferencedCodeAttribute("This API may perform reflection on supplied parameters which may be trimmed if not referenced directly. Consider using a different overload to avoid this issue.")]
-        public static string? GetUriByName(this LinkGenerator generator, string endpointName, object? values, string scheme, HostString host, PathString pathBase = default(PathString), FragmentString fragment = default(FragmentString), LinkOptions? options = null);
+        [RequiresUnreferencedCodeAttribute("This API may perform reflection on supplied parameters which may be trimmed if not referenced directly. Initialize a RouteValueDictionary with route values to avoid this issue.")]
+        public static string? GetUriByName(this LinkGenerator generator, string endpointName, object? values, string scheme, HostString host, PathString pathBase = default(PathString), FragmentString fragment = default(FragmentString), LinkOptions? options = null);
     }
     public static class LinkGeneratorRouteValuesAddressExtensions {
-        [RequiresUnreferencedCodeAttribute("This API may perform reflection on supplied parameters which may be trimmed if not referenced directly. Consider using a different overload to avoid this issue.")]
-        public static string GetPathByRouteValues(this LinkGenerator generator, HttpContext httpContext, string routeName, object values, PathString? pathBase = default(PathString?), FragmentString fragment = default(FragmentString), LinkOptions options = null);
+        [RequiresUnreferencedCodeAttribute("This API may perform reflection on supplied parameters which may be trimmed if not referenced directly. Initialize a RouteValueDictionary with route values to avoid this issue.")]
+        public static string GetPathByRouteValues(this LinkGenerator generator, HttpContext httpContext, string routeName, object values, PathString? pathBase = default(PathString?), FragmentString fragment = default(FragmentString), LinkOptions options = null);
-        [RequiresUnreferencedCodeAttribute("This API may perform reflection on supplied parameters which may be trimmed if not referenced directly. Consider using a different overload to avoid this issue.")]
-        public static string GetPathByRouteValues(this LinkGenerator generator, string routeName, object values, PathString pathBase = default(PathString), FragmentString fragment = default(FragmentString), LinkOptions options = null);
+        [RequiresUnreferencedCodeAttribute("This API may perform reflection on supplied parameters which may be trimmed if not referenced directly. Initialize a RouteValueDictionary with route values to avoid this issue.")]
+        public static string GetPathByRouteValues(this LinkGenerator generator, string routeName, object values, PathString pathBase = default(PathString), FragmentString fragment = default(FragmentString), LinkOptions options = null);
-        [RequiresUnreferencedCodeAttribute("This API may perform reflection on supplied parameters which may be trimmed if not referenced directly. Consider using a different overload to avoid this issue.")]
-        public static string GetUriByRouteValues(this LinkGenerator generator, HttpContext httpContext, string routeName, object values, string scheme = null, HostString? host = default(HostString?), PathString? pathBase = default(PathString?), FragmentString fragment = default(FragmentString), LinkOptions options = null);
+        [RequiresUnreferencedCodeAttribute("This API may perform reflection on supplied parameters which may be trimmed if not referenced directly. Initialize a RouteValueDictionary with route values to avoid this issue.")]
+        public static string GetUriByRouteValues(this LinkGenerator generator, HttpContext httpContext, string routeName, object values, string scheme = null, HostString? host = default(HostString?), PathString? pathBase = default(PathString?), FragmentString fragment = default(FragmentString), LinkOptions options = null);
-        [RequiresUnreferencedCodeAttribute("This API may perform reflection on supplied parameters which may be trimmed if not referenced directly. Consider using a different overload to avoid this issue.")]
-        public static string GetUriByRouteValues(this LinkGenerator generator, string routeName, object values, string scheme, HostString host, PathString pathBase = default(PathString), FragmentString fragment = default(FragmentString), LinkOptions options = null);
+        [RequiresUnreferencedCodeAttribute("This API may perform reflection on supplied parameters which may be trimmed if not referenced directly. Initialize a RouteValueDictionary with route values to avoid this issue.")]
+        public static string GetUriByRouteValues(this LinkGenerator generator, string routeName, object values, string scheme, HostString host, PathString pathBase = default(PathString), FragmentString fragment = default(FragmentString), LinkOptions options = null);
     }
-    public class RouteData
+    [DebuggerDisplayAttribute("Count = {Values.Count}")]
+    [DebuggerTypeProxyAttribute(typeof(RouteData.RouteDataDebugView))]
+    public class RouteData
+    [EditorBrowsableAttribute(1)]
+    public static class RouteHandlerServices {
+        public static RouteHandlerBuilder Map(IEndpointRouteBuilder endpoints, string pattern, Delegate handler, IEnumerable<string>? httpMethods, Func<MethodInfo, RequestDelegateFactoryOptions?, RequestDelegateMetadataResult> populateMetadata, Func<Delegate, RequestDelegateFactoryOptions, RequestDelegateMetadataResult?, RequestDelegateResult> createRequestDelegate);
+    }
-    [DebuggerDisplayAttribute("{DebuggerToString(),nq}")]
-    public sealed class RouteNameMetadata : IRouteNameMetadata {
+    [DebuggerDisplayAttribute("{ToString(),nq}")]
+    public sealed class RouteNameMetadata : IRouteNameMetadata {
+        public override string ToString();
     }
+    public static class RouteShortCircuitEndpointRouteBuilderExtensions {
+        public static IEndpointConventionBuilder MapShortCircuit(this IEndpointRouteBuilder builder, int statusCode, params string[] routePrefixes);
+    }
-    public class RouteValueDictionary : ICollection<KeyValuePair<string, object?>>, IDictionary<string, object?>, IEnumerable, IEnumerable<KeyValuePair<string, object?>>, IReadOnlyCollection<KeyValuePair<string, object?>>, IReadOnlyDictionary<string, object?>
+    [DebuggerDisplayAttribute("Count = {Count}")]
+    [DebuggerTypeProxyAttribute(typeof(RouteValueDictionary.RouteValueDictionaryDebugView))]
+    public class RouteValueDictionary : ICollection<KeyValuePair<string, object?>>, IDictionary<string, object?>, IEnumerable, IEnumerable<KeyValuePair<string, object?>>, IReadOnlyCollection<KeyValuePair<string, object?>>, IReadOnlyDictionary<string, object?>
-    public sealed class SuppressLinkGenerationMetadata : ISuppressLinkGenerationMetadata {
+    [DebuggerDisplayAttribute("{ToString(),nq}")]
+    public sealed class SuppressLinkGenerationMetadata : ISuppressLinkGenerationMetadata {
+        public override string ToString();
     }
-    public sealed class SuppressMatchingMetadata : ISuppressMatchingMetadata {
+    [DebuggerDisplayAttribute("{ToString(),nq}")]
+    public sealed class SuppressMatchingMetadata : ISuppressMatchingMetadata {
+        public override string ToString();
     }
 }
```

