# Microsoft.AspNetCore.Server.HttpSys

``` diff
 namespace Microsoft.AspNetCore.Server.HttpSys {
     public class HttpSysOptions {
+        public bool EnableKernelResponseBuffering { get; set; }
     }
+    public enum HttpSysRequestTimingType {
+        ConnectionStart = 0,
+        DataStart = 1,
+        Http2HeaderDecodeEnd = 14,
+        Http2HeaderDecodeStart = 13,
+        Http2StreamStart = 12,
+        Http3HeaderDecodeEnd = 29,
+        Http3HeaderDecodeStart = 28,
+        Http3StreamStart = 27,
+        RequestDeliveredForDelegation = 23,
+        RequestDeliveredForInspection = 20,
+        RequestDeliveredForIO = 26,
+        RequestHeaderParseEnd = 16,
+        RequestHeaderParseStart = 15,
+        RequestQueuedForDelegation = 22,
+        RequestQueuedForInspection = 19,
+        RequestQueuedForIO = 25,
+        RequestReturnedAfterDelegation = 24,
+        RequestReturnedAfterInspection = 21,
+        RequestRoutingEnd = 18,
+        RequestRoutingStart = 17,
+        TlsAttributesQueryEnd = 9,
+        TlsAttributesQueryStart = 8,
+        TlsCertificateLoadEnd = 3,
+        TlsCertificateLoadStart = 2,
+        TlsClientCertQueryEnd = 11,
+        TlsClientCertQueryStart = 10,
+        TlsHandshakeLeg1End = 5,
+        TlsHandshakeLeg1Start = 4,
+        TlsHandshakeLeg2End = 7,
+        TlsHandshakeLeg2Start = 6,
+    }
+    public interface IHttpSysRequestTimingFeature {
+        ReadOnlySpan<long> Timestamps { get; }
+        bool TryGetElapsedTime(HttpSysRequestTimingType startingTimestampType, HttpSysRequestTimingType endingTimestampType, out TimeSpan elapsed);
+        bool TryGetTimestamp(HttpSysRequestTimingType timestampType, out long timestamp);
+    }
 }
```

