# Microsoft.Extensions.DependencyInjection

``` diff
 namespace Microsoft.Extensions.DependencyInjection {
     public static class ActivatorUtilities {
+        public static ObjectFactory<T> CreateFactory<T>(Type[] argumentTypes);
     }
+    public static class BearerTokenExtensions {
+        public static AuthenticationBuilder AddBearerToken(this AuthenticationBuilder builder);
+        public static AuthenticationBuilder AddBearerToken(this AuthenticationBuilder builder, Action<BearerTokenOptions> configure);
+        public static AuthenticationBuilder AddBearerToken(this AuthenticationBuilder builder, string authenticationScheme);
+        public static AuthenticationBuilder AddBearerToken(this AuthenticationBuilder builder, string authenticationScheme, Action<BearerTokenOptions> configure);
+    }
+    public static class CascadingAuthenticationStateServiceCollectionExtensions {
+        public static IServiceCollection AddCascadingAuthenticationState(this IServiceCollection serviceCollection);
+    }
+    public static class CascadingValueServiceCollectionExtensions {
+        public static IServiceCollection AddCascadingValue<TValue>(this IServiceCollection serviceCollection, Func<IServiceProvider, CascadingValueSource<TValue>> sourceFactory);
+        public static IServiceCollection AddCascadingValue<TValue>(this IServiceCollection serviceCollection, Func<IServiceProvider, TValue> initialValueFactory);
+        public static IServiceCollection AddCascadingValue<TValue>(this IServiceCollection serviceCollection, string name, Func<IServiceProvider, TValue> initialValueFactory);
+        public static void TryAddCascadingValue<TValue>(this IServiceCollection serviceCollection, Func<IServiceProvider, CascadingValueSource<TValue>> sourceFactory);
+        public static void TryAddCascadingValue<TValue>(this IServiceCollection serviceCollection, Func<IServiceProvider, TValue> valueFactory);
+        public static void TryAddCascadingValue<TValue>(this IServiceCollection serviceCollection, string name, Func<IServiceProvider, TValue> valueFactory);
+    }
     public static class ComponentServiceCollectionExtensions {
-        public static IServerSideBlazorBuilder AddServerSideBlazor(this IServiceCollection services, Action<CircuitOptions>? configure = null);
+        [RequiresUnreferencedCodeAttribute("Server-side Blazor does not currently support trimming or native AOT.", Url="https://aka.ms/aspnet/trimming")]
+        public static IServerSideBlazorBuilder AddServerSideBlazor(this IServiceCollection services, Action<CircuitOptions>? configure = null);
     }
     public static class ExceptionHandlerServiceCollectionExtensions {
+        public static IServiceCollection AddExceptionHandler<T>(this IServiceCollection services) where T : class, IExceptionHandler;
     }
+    [AttributeUsageAttribute(2048)]
+    public class FromKeyedServicesAttribute : Attribute {
+        public FromKeyedServicesAttribute(object key);
+        public object Key { get; }
+    }
     public static class HttpClientBuilderExtensions {
+        public static IHttpClientBuilder AddDefaultLogger(this IHttpClientBuilder builder);
+        public static IHttpClientBuilder AddLogger(this IHttpClientBuilder builder, Func<IServiceProvider, IHttpClientLogger> httpClientLoggerFactory, bool wrapHandlersPipeline = false);
+        public static IHttpClientBuilder AddLogger<TLogger>(this IHttpClientBuilder builder, bool wrapHandlersPipeline = false) where TLogger : IHttpClientLogger;
+        public static IHttpClientBuilder ConfigureAdditionalHttpMessageHandlers(this IHttpClientBuilder builder, Action<IList<DelegatingHandler>, IServiceProvider> configureAdditionalHandlers);
-        public static IHttpClientBuilder ConfigureHttpMessageHandlerBuilder(this IHttpClientBuilder builder, Action<HttpMessageHandlerBuilder> configureBuilder);
+        [ObsoleteAttribute("This method has been deprecated. Use ConfigurePrimaryHttpMessageHandler or ConfigureAdditionalHttpMessageHandlers instead.")]
+        public static IHttpClientBuilder ConfigureHttpMessageHandlerBuilder(this IHttpClientBuilder builder, Action<HttpMessageHandlerBuilder> configureBuilder);
+        public static IHttpClientBuilder ConfigurePrimaryHttpMessageHandler(this IHttpClientBuilder builder, Action<HttpMessageHandler, IServiceProvider> configureHandler);
+        public static IHttpClientBuilder RemoveAllLoggers(this IHttpClientBuilder builder);
+        [UnsupportedOSPlatformAttribute("browser")]
+        public static IHttpClientBuilder UseSocketsHttpHandler(this IHttpClientBuilder builder, Action<ISocketsHttpHandlerBuilder> configureBuilder);
+        [UnsupportedOSPlatformAttribute("browser")]
+        public static IHttpClientBuilder UseSocketsHttpHandler(this IHttpClientBuilder builder, Action<SocketsHttpHandler, IServiceProvider>? configureHandler = null);
     }
     public static class HttpClientFactoryServiceCollectionExtensions {
+        public static IServiceCollection ConfigureHttpClientDefaults(this IServiceCollection services, Action<IHttpClientBuilder> configure);
     }
     public static class HttpLoggingServicesExtensions {
+        public static IServiceCollection AddHttpLoggingInterceptor<T>(this IServiceCollection services) where T : class, IHttpLoggingInterceptor;
     }
     public static class IdentityServiceCollectionExtensions {
-        public static IdentityBuilder AddIdentity<TUser, TRole>(this IServiceCollection services) where TUser : class where TRole : class;
+        [RequiresUnreferencedCodeAttribute("Identity middleware does not currently support trimming or native AOT.", Url="https://aka.ms/aspnet/trimming")]
+        public static IdentityBuilder AddIdentity<TUser, TRole>(this IServiceCollection services) where TUser : class where TRole : class;
-        public static IdentityBuilder AddIdentity<TUser, TRole>(this IServiceCollection services, Action<IdentityOptions> setupAction) where TUser : class where TRole : class;
+        [RequiresUnreferencedCodeAttribute("Identity middleware does not currently support trimming or native AOT.", Url="https://aka.ms/aspnet/trimming")]
+        public static IdentityBuilder AddIdentity<TUser, TRole>(this IServiceCollection services, Action<IdentityOptions> setupAction) where TUser : class where TRole : class;
+        public static IdentityBuilder AddIdentityApiEndpoints<TUser>(this IServiceCollection services) where TUser : class, new();
+        public static IdentityBuilder AddIdentityApiEndpoints<TUser>(this IServiceCollection services, Action<IdentityOptions> configure) where TUser : class, new();
     }
+    public interface IKeyedServiceProvider : IServiceProvider {
+        object? GetKeyedService(Type serviceType, object? serviceKey);
+        object GetRequiredKeyedService(Type serviceType, object? serviceKey);
+    }
+    public interface IRazorComponentsBuilder {
+        IServiceCollection Services { get; }
+    }
-    public interface IServerSideBlazorBuilder {
+    public interface IServerSideBlazorBuilder : IRazorComponentsBuilder {
+        IServiceCollection IRazorComponentsBuilder.Services { get; }
-        IServiceCollection Services { get; }
+        new IServiceCollection Services { get; }
     }
+    public interface IServiceProviderIsKeyedService : IServiceProviderIsService {
+        bool IsKeyedService(Type serviceType, object? serviceKey);
+    }
+    public interface ISocketsHttpHandlerBuilder {
+        string Name { get; }
+        IServiceCollection Services { get; }
+    }
+    public static class KeyedService {
+        public static object AnyKey { get; }
+    }
+    public static class MetricsServiceExtensions {
+        public static IServiceCollection AddMetrics(this IServiceCollection services);
+        public static IServiceCollection AddMetrics(this IServiceCollection services, Action<IMetricsBuilder> configure);
+    }
     public static class MvcRazorPagesMvcCoreBuilderExtensions {
-        public static IMvcCoreBuilder AddRazorPages(this IMvcCoreBuilder builder);
+        [RequiresUnreferencedCodeAttribute("Razor Pages does not currently support trimming or native AOT.", Url="https://aka.ms/aspnet/trimming")]
+        public static IMvcCoreBuilder AddRazorPages(this IMvcCoreBuilder builder);
     }
     public static class MvcServiceCollectionExtensions {
-        public static IMvcBuilder AddControllers(this IServiceCollection services);
+        [RequiresUnreferencedCodeAttribute("MVC does not currently support trimming or native AOT.", Url="https://aka.ms/aspnet/trimming")]
+        public static IMvcBuilder AddControllers(this IServiceCollection services);
-        public static IMvcBuilder AddControllers(this IServiceCollection services, Action<MvcOptions>? configure);
+        [RequiresUnreferencedCodeAttribute("MVC does not currently support trimming or native AOT.", Url="https://aka.ms/aspnet/trimming")]
+        public static IMvcBuilder AddControllers(this IServiceCollection services, Action<MvcOptions>? configure);
-        public static IMvcBuilder AddControllersWithViews(this IServiceCollection services);
+        [RequiresUnreferencedCodeAttribute("MVC does not currently support trimming or native AOT.", Url="https://aka.ms/aspnet/trimming")]
+        public static IMvcBuilder AddControllersWithViews(this IServiceCollection services);
-        public static IMvcBuilder AddControllersWithViews(this IServiceCollection services, Action<MvcOptions>? configure);
+        [RequiresUnreferencedCodeAttribute("MVC does not currently support trimming or native AOT.", Url="https://aka.ms/aspnet/trimming")]
+        public static IMvcBuilder AddControllersWithViews(this IServiceCollection services, Action<MvcOptions>? configure);
-        public static IMvcBuilder AddMvc(this IServiceCollection services);
+        [RequiresUnreferencedCodeAttribute("MVC does not currently support trimming or native AOT.", Url="https://aka.ms/aspnet/trimming")]
+        public static IMvcBuilder AddMvc(this IServiceCollection services);
-        public static IMvcBuilder AddMvc(this IServiceCollection services, Action<MvcOptions> setupAction);
+        [RequiresUnreferencedCodeAttribute("MVC does not currently support trimming or native AOT.", Url="https://aka.ms/aspnet/trimming")]
+        public static IMvcBuilder AddMvc(this IServiceCollection services, Action<MvcOptions> setupAction);
-        public static IMvcBuilder AddRazorPages(this IServiceCollection services);
+        [RequiresUnreferencedCodeAttribute("Razor Pages does not currently support trimming or native AOT.", Url="https://aka.ms/aspnet/trimming")]
+        public static IMvcBuilder AddRazorPages(this IServiceCollection services);
-        public static IMvcBuilder AddRazorPages(this IServiceCollection services, Action<RazorPagesOptions>? configure);
+        [RequiresUnreferencedCodeAttribute("Razor Pages does not currently support trimming or native AOT.", Url="https://aka.ms/aspnet/trimming")]
+        public static IMvcBuilder AddRazorPages(this IServiceCollection services, Action<RazorPagesOptions>? configure);
     }
+    public delegate T ObjectFactory<T>(IServiceProvider serviceProvider, object?[]? arguments);
     public static class OptionsServiceCollectionExtensions {
+        public static OptionsBuilder<TOptions> AddOptionsWithValidateOnStart<TOptions, TValidateOptions>(this IServiceCollection services, string? name = null) where TOptions : class where TValidateOptions : class, IValidateOptions<TOptions>;
+        public static OptionsBuilder<TOptions> AddOptionsWithValidateOnStart<TOptions>(this IServiceCollection services, string? name = null) where TOptions : class;
     }
+    public static class RazorComponentsServiceCollectionExtensions {
+        [RequiresUnreferencedCodeAttribute("Razor Components does not currently support trimming or native AOT.", Url="https://aka.ms/aspnet/nativeaot")]
+        public static IRazorComponentsBuilder AddRazorComponents(this IServiceCollection services, Action<RazorComponentsServiceOptions>? configure = null);
+    }
+    public static class RequestTimeoutsIServiceCollectionExtensions {
+        public static IServiceCollection AddRequestTimeouts(this IServiceCollection services);
+        public static IServiceCollection AddRequestTimeouts(this IServiceCollection services, Action<RequestTimeoutOptions> configure);
+    }
     public static class RoutingServiceCollectionExtensions {
+        public static IServiceCollection AddRoutingCore(this IServiceCollection services);
     }
+    public static class ServerRazorComponentsBuilderExtensions {
+        [RequiresUnreferencedCodeAttribute("Server-side Blazor does not currently support native AOT.", Url="https://aka.ms/aspnet/nativeaot")]
+        public static IServerSideBlazorBuilder AddInteractiveServerComponents(this IRazorComponentsBuilder builder, Action<CircuitOptions>? configure = null);
+    }
     public static class ServiceCollectionServiceExtensions {
+        public static IServiceCollection AddKeyedScoped(this IServiceCollection services, Type serviceType, object? serviceKey);
+        public static IServiceCollection AddKeyedScoped(this IServiceCollection services, Type serviceType, object? serviceKey, Func<IServiceProvider, object, object> implementationFactory);
+        public static IServiceCollection AddKeyedScoped(this IServiceCollection services, Type serviceType, object? serviceKey, Type implementationType);
+        public static IServiceCollection AddKeyedScoped<TService, TImplementation>(this IServiceCollection services, object? serviceKey) where TService : class where TImplementation : class, TService;
+        public static IServiceCollection AddKeyedScoped<TService, TImplementation>(this IServiceCollection services, object? serviceKey, Func<IServiceProvider, object, TImplementation> implementationFactory) where TService : class where TImplementation : class, TService;
+        public static IServiceCollection AddKeyedScoped<TService>(this IServiceCollection services, object? serviceKey) where TService : class;
+        public static IServiceCollection AddKeyedScoped<TService>(this IServiceCollection services, object? serviceKey, Func<IServiceProvider, object, TService> implementationFactory) where TService : class;
+        public static IServiceCollection AddKeyedSingleton(this IServiceCollection services, Type serviceType, object? serviceKey);
+        public static IServiceCollection AddKeyedSingleton(this IServiceCollection services, Type serviceType, object? serviceKey, Func<IServiceProvider, object, object> implementationFactory);
+        public static IServiceCollection AddKeyedSingleton(this IServiceCollection services, Type serviceType, object? serviceKey, object implementationInstance);
+        public static IServiceCollection AddKeyedSingleton(this IServiceCollection services, Type serviceType, object? serviceKey, Type implementationType);
+        public static IServiceCollection AddKeyedSingleton<TService, TImplementation>(this IServiceCollection services, object? serviceKey) where TService : class where TImplementation : class, TService;
+        public static IServiceCollection AddKeyedSingleton<TService, TImplementation>(this IServiceCollection services, object? serviceKey, Func<IServiceProvider, object, TImplementation> implementationFactory) where TService : class where TImplementation : class, TService;
+        public static IServiceCollection AddKeyedSingleton<TService>(this IServiceCollection services, object? serviceKey) where TService : class;
+        public static IServiceCollection AddKeyedSingleton<TService>(this IServiceCollection services, object? serviceKey, Func<IServiceProvider, object, TService> implementationFactory) where TService : class;
+        public static IServiceCollection AddKeyedSingleton<TService>(this IServiceCollection services, object? serviceKey, TService implementationInstance) where TService : class;
+        public static IServiceCollection AddKeyedTransient(this IServiceCollection services, Type serviceType, object? serviceKey);
+        public static IServiceCollection AddKeyedTransient(this IServiceCollection services, Type serviceType, object? serviceKey, Func<IServiceProvider, object, object> implementationFactory);
+        public static IServiceCollection AddKeyedTransient(this IServiceCollection services, Type serviceType, object? serviceKey, Type implementationType);
+        public static IServiceCollection AddKeyedTransient<TService, TImplementation>(this IServiceCollection services, object? serviceKey) where TService : class where TImplementation : class, TService;
+        public static IServiceCollection AddKeyedTransient<TService, TImplementation>(this IServiceCollection services, object? serviceKey, Func<IServiceProvider, object, TImplementation> implementationFactory) where TService : class where TImplementation : class, TService;
+        public static IServiceCollection AddKeyedTransient<TService>(this IServiceCollection services, object? serviceKey) where TService : class;
+        public static IServiceCollection AddKeyedTransient<TService>(this IServiceCollection services, object? serviceKey, Func<IServiceProvider, object, TService> implementationFactory) where TService : class;
     }
     public class ServiceDescriptor {
+        public ServiceDescriptor(Type serviceType, object? serviceKey, Func<IServiceProvider, object?, object> factory, ServiceLifetime lifetime);
+        public ServiceDescriptor(Type serviceType, object? serviceKey, object instance);
+        public ServiceDescriptor(Type serviceType, object? serviceKey, Type implementationType, ServiceLifetime lifetime);
+        public bool IsKeyedService { get; }
+        public Func<IServiceProvider, object?, object>? KeyedImplementationFactory { get; }
+        public object? KeyedImplementationInstance { get; }
+        public Type? KeyedImplementationType { get; }
+        public object? ServiceKey { get; }
+        public static ServiceDescriptor DescribeKeyed(Type serviceType, object? serviceKey, Func<IServiceProvider, object, object> implementationFactory, ServiceLifetime lifetime);
+        public static ServiceDescriptor DescribeKeyed(Type serviceType, object? serviceKey, Type implementationType, ServiceLifetime lifetime);
+        public static ServiceDescriptor KeyedScoped(Type service, object? serviceKey, Func<IServiceProvider, object, object> implementationFactory);
+        public static ServiceDescriptor KeyedScoped(Type service, object? serviceKey, Type implementationType);
+        public static ServiceDescriptor KeyedScoped<TService, TImplementation>(object? serviceKey) where TService : class where TImplementation : class, TService;
+        public static ServiceDescriptor KeyedScoped<TService, TImplementation>(object? serviceKey, Func<IServiceProvider, object, TImplementation> implementationFactory) where TService : class where TImplementation : class, TService;
+        public static ServiceDescriptor KeyedScoped<TService>(object? serviceKey, Func<IServiceProvider, object, TService> implementationFactory) where TService : class;
+        public static ServiceDescriptor KeyedSingleton(Type serviceType, object? serviceKey, Func<IServiceProvider, object, object> implementationFactory);
+        public static ServiceDescriptor KeyedSingleton(Type serviceType, object? serviceKey, object implementationInstance);
+        public static ServiceDescriptor KeyedSingleton(Type service, object? serviceKey, Type implementationType);
+        public static ServiceDescriptor KeyedSingleton<TService, TImplementation>(object? serviceKey) where TService : class where TImplementation : class, TService;
+        public static ServiceDescriptor KeyedSingleton<TService, TImplementation>(object? serviceKey, Func<IServiceProvider, object, TImplementation> implementationFactory) where TService : class where TImplementation : class, TService;
+        public static ServiceDescriptor KeyedSingleton<TService>(object? serviceKey, Func<IServiceProvider, object, TService> implementationFactory) where TService : class;
+        public static ServiceDescriptor KeyedSingleton<TService>(object? serviceKey, TService implementationInstance) where TService : class;
+        public static ServiceDescriptor KeyedTransient(Type service, object? serviceKey, Func<IServiceProvider, object, object> implementationFactory);
+        public static ServiceDescriptor KeyedTransient(Type service, object? serviceKey, Type implementationType);
+        public static ServiceDescriptor KeyedTransient<TService, TImplementation>(object? serviceKey) where TService : class where TImplementation : class, TService;
+        public static ServiceDescriptor KeyedTransient<TService, TImplementation>(object? serviceKey, Func<IServiceProvider, object, TImplementation> implementationFactory) where TService : class where TImplementation : class, TService;
+        public static ServiceDescriptor KeyedTransient<TService>(object? serviceKey, Func<IServiceProvider, object, TService> implementationFactory) where TService : class;
     }
+    [AttributeUsageAttribute(2048)]
+    public class ServiceKeyAttribute : Attribute {
+        public ServiceKeyAttribute();
+    }
-    public sealed class ServiceProvider : IAsyncDisposable, IDisposable, IServiceProvider {
+    public sealed class ServiceProvider : IAsyncDisposable, IDisposable, IKeyedServiceProvider, IServiceProvider {
+        public object? GetKeyedService(Type serviceType, object? serviceKey);
+        public object GetRequiredKeyedService(Type serviceType, object? serviceKey);
     }
+    public static class ServiceProviderKeyedServiceExtensions {
+        public static T? GetKeyedService<T>(this IServiceProvider provider, object? serviceKey);
+        public static IEnumerable<object?> GetKeyedServices(this IServiceProvider provider, Type serviceType, object? serviceKey);
+        public static IEnumerable<T> GetKeyedServices<T>(this IServiceProvider provider, object? serviceKey);
+        public static object GetRequiredKeyedService(this IServiceProvider provider, Type serviceType, object? serviceKey);
+        public static T GetRequiredKeyedService<T>(this IServiceProvider provider, object? serviceKey);
+    }
     public static class SessionServiceCollectionExtensions {
-        public static IServiceCollection AddSession(this IServiceCollection services);
+        [RequiresUnreferencedCodeAttribute("Session State middleware does not currently support trimming or native AOT.", Url="https://aka.ms/aspnet/trimming")]
+        public static IServiceCollection AddSession(this IServiceCollection services);
-        public static IServiceCollection AddSession(this IServiceCollection services, Action<SessionOptions> configure);
+        [RequiresUnreferencedCodeAttribute("Session State middleware does not currently support trimming or native AOT.", Url="https://aka.ms/aspnet/trimming")]
+        public static IServiceCollection AddSession(this IServiceCollection services, Action<SessionOptions> configure);
     }
     public static class SignalRDependencyInjectionExtensions {
-        public static ISignalRServerBuilder AddSignalR(this IServiceCollection services);
+        [RequiresUnreferencedCodeAttribute("SignalR does not currently support trimming or native AOT.", Url="https://aka.ms/aspnet/trimming")]
+        public static ISignalRServerBuilder AddSignalR(this IServiceCollection services);
-        public static ISignalRServerBuilder AddSignalR(this IServiceCollection services, Action<HubOptions> configure);
+        [RequiresUnreferencedCodeAttribute("SignalR does not currently support trimming or native AOT.", Url="https://aka.ms/aspnet/trimming")]
+        public static ISignalRServerBuilder AddSignalR(this IServiceCollection services, Action<HubOptions> configure);
     }
+    public static class SocketsHttpHandlerBuilderExtensions {
+        [UnsupportedOSPlatformAttribute("browser")]
+        public static ISocketsHttpHandlerBuilder Configure(this ISocketsHttpHandlerBuilder builder, IConfiguration configuration);
+        [UnsupportedOSPlatformAttribute("browser")]
+        public static ISocketsHttpHandlerBuilder Configure(this ISocketsHttpHandlerBuilder builder, Action<SocketsHttpHandler, IServiceProvider> configure);
+    }
 }
```

