# Microsoft.Extensions.Hosting

``` diff
 namespace Microsoft.Extensions.Hosting {
     public static class GenericHostWebHostBuilderExtensions {
+        public static IHostBuilder ConfigureSlimWebHost(this IHostBuilder builder, Action<IWebHostBuilder> configure, Action<WebHostBuilderOptions> configureWebHostBuilder);
     }
     public static class Host {
+        public static HostApplicationBuilder CreateApplicationBuilder(HostApplicationBuilderSettings? settings);
+        public static HostApplicationBuilder CreateEmptyApplicationBuilder(HostApplicationBuilderSettings? settings);
     }
-    public sealed class HostApplicationBuilder {
+    public sealed class HostApplicationBuilder : IHostApplicationBuilder {
+        public IMetricsBuilder Metrics { get; }
+        IConfigurationManager IHostApplicationBuilder.Configuration { get; }
+        IDictionary<object, object> IHostApplicationBuilder.Properties { get; }
     }
     public static class HostingHostBuilderExtensions {
+        public static IHostBuilder ConfigureMetrics(this IHostBuilder hostBuilder, Action<IMetricsBuilder> configureMetrics);
+        public static IHostBuilder ConfigureMetrics(this IHostBuilder hostBuilder, Action<HostBuilderContext, IMetricsBuilder> configureMetrics);
     }
     public class HostOptions {
+        public bool ServicesStartConcurrently { get; set; }
+        public bool ServicesStopConcurrently { get; set; }
+        public TimeSpan StartupTimeout { get; set; }
     }
+    public interface IHostApplicationBuilder {
+        IConfigurationManager Configuration { get; }
+        IHostEnvironment Environment { get; }
+        ILoggingBuilder Logging { get; }
+        IMetricsBuilder Metrics { get; }
+        IDictionary<object, object> Properties { get; }
+        IServiceCollection Services { get; }
+        void ConfigureContainer<TContainerBuilder>(IServiceProviderFactory<TContainerBuilder> factory, Action<TContainerBuilder>? configure = null);
+    }
+    public interface IHostedLifecycleService : IHostedService {
+        Task StartedAsync(CancellationToken cancellationToken);
+        Task StartingAsync(CancellationToken cancellationToken);
+        Task StoppedAsync(CancellationToken cancellationToken);
+        Task StoppingAsync(CancellationToken cancellationToken);
+    }
 }
```

