# Microsoft.Extensions.Options

``` diff
 namespace Microsoft.Extensions.Options {
+    public interface IStartupValidator {
+        void Validate();
+    }
+    [AttributeUsageAttribute(12)]
+    public sealed class OptionsValidatorAttribute : Attribute {
+        public OptionsValidatorAttribute();
+    }
+    [AttributeUsageAttribute(384)]
+    public sealed class ValidateEnumeratedItemsAttribute : Attribute {
+        public ValidateEnumeratedItemsAttribute();
+        public ValidateEnumeratedItemsAttribute(Type validator);
+        public Type Validator { get; }
+    }
+    [AttributeUsageAttribute(384)]
+    public sealed class ValidateObjectMembersAttribute : Attribute {
+        public ValidateObjectMembersAttribute();
+        public ValidateObjectMembersAttribute(Type validator);
+        public Type Validator { get; }
+    }
+    public class ValidateOptionsResultBuilder {
+        public ValidateOptionsResultBuilder();
+        public void AddError(string error, string? propertyName = null);
+        public void AddResult(ValidateOptionsResult result);
+        public void AddResult(ValidationResult? result);
+        public void AddResults(IEnumerable<ValidationResult?>? results);
+        public ValidateOptionsResult Build();
+        public void Clear();
+    }
 }
```

