# System.Buffers

``` diff
 namespace System.Buffers {
     public sealed class ArrayBufferWriter<T> : IBufferWriter<T> {
+        public void ResetWrittenCount();
     }
+    public static class SearchValues {
+        public static SearchValues<byte> Create(ReadOnlySpan<byte> values);
+        public static SearchValues<char> Create(ReadOnlySpan<char> values);
+    }
+    public class SearchValues<T> where T : IEquatable<T>? {
+        public bool Contains(T value);
+    }
     public ref struct SequenceReader<T> where T : struct {
         public long AdvancePastAny([ScopedRefAttribute] ReadOnlySpan<T> values);
         public bool IsNext([ScopedRefAttribute] ReadOnlySpan<T> next, bool advancePast = false);
         public bool TryAdvanceToAny([ScopedRefAttribute] ReadOnlySpan<T> delimiters, bool advancePastDelimiter = true);
         public bool TryReadTo(out ReadOnlySequence<T> sequence, [ScopedRefAttribute] ReadOnlySpan<T> delimiter, bool advancePastDelimiter = true);
         public bool TryReadTo(out ReadOnlySpan<T> span, [ScopedRefAttribute] ReadOnlySpan<T> delimiter, bool advancePastDelimiter = true);
         public bool TryReadToAny(out ReadOnlySequence<T> sequence, [ScopedRefAttribute] ReadOnlySpan<T> delimiters, bool advancePastDelimiter = true);
         public bool TryReadToAny(out ReadOnlySpan<T> span, [ScopedRefAttribute] ReadOnlySpan<T> delimiters, bool advancePastDelimiter = true);
     }
 }
```

