# System.Collections.Immutable

``` diff
 namespace System.Collections.Immutable {
-    public interface IImmutableList<T> : IEnumerable, IEnumerable<T>, IReadOnlyCollection<T>, IReadOnlyList<T>
+    [CollectionBuilderAttribute(typeof(ImmutableList), "Create")]
+    public interface IImmutableList<T> : IEnumerable, IEnumerable<T>, IReadOnlyCollection<T>, IReadOnlyList<T>
-    public interface IImmutableQueue<T> : IEnumerable, IEnumerable<T>
+    [CollectionBuilderAttribute(typeof(ImmutableQueue), "Create")]
+    public interface IImmutableQueue<T> : IEnumerable, IEnumerable<T>
-    public interface IImmutableSet<T> : IEnumerable, IEnumerable<T>, IReadOnlyCollection<T>
+    [CollectionBuilderAttribute(typeof(ImmutableHashSet), "Create")]
+    public interface IImmutableSet<T> : IEnumerable, IEnumerable<T>, IReadOnlyCollection<T>
-    public interface IImmutableStack<T> : IEnumerable, IEnumerable<T>
+    [CollectionBuilderAttribute(typeof(ImmutableStack), "Create")]
+    public interface IImmutableStack<T> : IEnumerable, IEnumerable<T>
-    public readonly struct ImmutableArray<T> : ICollection, ICollection<T>, IEnumerable, IEnumerable<T>, IEquatable<ImmutableArray<T>>, IImmutableList<T>, IList, IList<T>, IReadOnlyCollection<T>, IReadOnlyList<T>, IStructuralComparable, IStructuralEquatable {
+    [CollectionBuilderAttribute(typeof(ImmutableArray), "Create")]
+    public readonly struct ImmutableArray<T> : ICollection, ICollection<T>, IEnumerable, IEnumerable<T>, IEquatable<ImmutableArray<T>>, IImmutableList<T>, IList, IList<T>, IReadOnlyCollection<T>, IReadOnlyList<T>, IStructuralComparable, IStructuralEquatable {
+        public bool Contains(T item, IEqualityComparer<T>? equalityComparer);
         public sealed class Builder : ICollection<T>, IEnumerable, IEnumerable<T>, IList<T>, IReadOnlyCollection<T>, IReadOnlyList<T> {
+            public ImmutableArray<T> DrainToImmutable();
         }
     }
     public static class ImmutableHashSet {
+        public static ImmutableHashSet<T> Create<T>(IEqualityComparer<T>? equalityComparer, ReadOnlySpan<T> items);
+        public static ImmutableHashSet<T> Create<T>(ReadOnlySpan<T> items);
     }
-    public sealed class ImmutableHashSet<T> : ICollection, ICollection<T>, IEnumerable, IEnumerable<T>, IImmutableSet<T>, IReadOnlyCollection<T>, IReadOnlySet<T>, ISet<T>
+    [CollectionBuilderAttribute(typeof(ImmutableHashSet), "Create")]
+    public sealed class ImmutableHashSet<T> : ICollection, ICollection<T>, IEnumerable, IEnumerable<T>, IImmutableSet<T>, IReadOnlyCollection<T>, IReadOnlySet<T>, ISet<T>
     public static class ImmutableList {
+        public static ImmutableList<T> Create<T>(ReadOnlySpan<T> items);
     }
-    public sealed class ImmutableList<T> : ICollection, ICollection<T>, IEnumerable, IEnumerable<T>, IImmutableList<T>, IList, IList<T>, IReadOnlyCollection<T>, IReadOnlyList<T>
+    [CollectionBuilderAttribute(typeof(ImmutableList), "Create")]
+    public sealed class ImmutableList<T> : ICollection, ICollection<T>, IEnumerable, IEnumerable<T>, IImmutableList<T>, IList, IList<T>, IReadOnlyCollection<T>, IReadOnlyList<T>
     public static class ImmutableQueue {
+        public static ImmutableQueue<T> Create<T>(ReadOnlySpan<T> items);
     }
-    public sealed class ImmutableQueue<T> : IEnumerable, IEnumerable<T>, IImmutableQueue<T>
+    [CollectionBuilderAttribute(typeof(ImmutableQueue), "Create")]
+    public sealed class ImmutableQueue<T> : IEnumerable, IEnumerable<T>, IImmutableQueue<T>
     public static class ImmutableSortedSet {
+        public static ImmutableSortedSet<T> Create<T>(IComparer<T>? comparer, ReadOnlySpan<T> items);
+        public static ImmutableSortedSet<T> Create<T>(ReadOnlySpan<T> items);
     }
-    public sealed class ImmutableSortedSet<T> : ICollection, ICollection<T>, IEnumerable, IEnumerable<T>, IImmutableSet<T>, IList, IList<T>, IReadOnlyCollection<T>, IReadOnlyList<T>, IReadOnlySet<T>, ISet<T>
+    [CollectionBuilderAttribute(typeof(ImmutableSortedSet), "Create")]
+    public sealed class ImmutableSortedSet<T> : ICollection, ICollection<T>, IEnumerable, IEnumerable<T>, IImmutableSet<T>, IList, IList<T>, IReadOnlyCollection<T>, IReadOnlyList<T>, IReadOnlySet<T>, ISet<T>
     public static class ImmutableStack {
+        public static ImmutableStack<T> Create<T>(ReadOnlySpan<T> items);
     }
-    public sealed class ImmutableStack<T> : IEnumerable, IEnumerable<T>, IImmutableStack<T>
+    [CollectionBuilderAttribute(typeof(ImmutableStack), "Create")]
+    public sealed class ImmutableStack<T> : IEnumerable, IEnumerable<T>, IImmutableStack<T>
 }
```

