# System.ComponentModel.DataAnnotations

``` diff
 namespace System.ComponentModel.DataAnnotations {
+    [AttributeUsageAttribute(AttributeTargets.Field | AttributeTargets.Parameter | AttributeTargets.Property, AllowMultiple=false)]
+    [CLSCompliantAttribute(false)]
+    public class AllowedValuesAttribute : ValidationAttribute {
+        public AllowedValuesAttribute(params object?[] values);
+        public object?[] Values { get; }
+        public override bool IsValid(object? value);
+    }
+    [AttributeUsageAttribute(AttributeTargets.Field | AttributeTargets.Parameter | AttributeTargets.Property, AllowMultiple=false)]
+    public class Base64StringAttribute : ValidationAttribute {
+        public Base64StringAttribute();
+        public override bool IsValid(object? value);
+    }
+    [AttributeUsageAttribute(AttributeTargets.Field | AttributeTargets.Parameter | AttributeTargets.Property, AllowMultiple=false)]
+    [CLSCompliantAttribute(false)]
+    public class DeniedValuesAttribute : ValidationAttribute {
+        public DeniedValuesAttribute(params object?[] values);
+        public object?[] Values { get; }
+        public override bool IsValid(object? value);
+    }
+    [AttributeUsageAttribute(AttributeTargets.Field | AttributeTargets.Parameter | AttributeTargets.Property, AllowMultiple=false)]
+    public class LengthAttribute : ValidationAttribute {
+        [RequiresUnreferencedCodeAttribute("Uses reflection to get the 'Count' property on types that don't implement ICollection. This 'Count' property may be trimmed. Ensure it is preserved.")]
+        public LengthAttribute(int minimumLength, int maximumLength);
+        public int MaximumLength { get; }
+        public int MinimumLength { get; }
+        public override string FormatErrorMessage(string name);
+        public override bool IsValid(object? value);
+    }
     [AttributeUsageAttribute(AttributeTargets.Field | AttributeTargets.Parameter | AttributeTargets.Property, AllowMultiple=false)]
     public class RangeAttribute : ValidationAttribute {
+        public bool MaximumIsExclusive { get; set; }
+        public bool MinimumIsExclusive { get; set; }
     }
     public sealed class ValidationContext : IServiceProvider {
-        [RequiresUnreferencedCodeAttribute("The Type of instance cannot be statically discovered.")]
-        public ValidationContext(object instance);
+        [RequiresUnreferencedCodeAttribute("The Type of instance cannot be statically discovered and the Type's properties can be trimmed.")]
+        public ValidationContext(object instance);
-        [RequiresUnreferencedCodeAttribute("The Type of instance cannot be statically discovered.")]
-        public ValidationContext(object instance, IDictionary<object, object?>? items);
+        [RequiresUnreferencedCodeAttribute("The Type of instance cannot be statically discovered and the Type's properties can be trimmed.")]
+        public ValidationContext(object instance, IDictionary<object, object?>? items);
-        [RequiresUnreferencedCodeAttribute("The Type of instance cannot be statically discovered.")]
-        public ValidationContext(object instance, IServiceProvider? serviceProvider, IDictionary<object, object?>? items);
+        [RequiresUnreferencedCodeAttribute("The Type of instance cannot be statically discovered and the Type's properties can be trimmed.")]
+        public ValidationContext(object instance, IServiceProvider? serviceProvider, IDictionary<object, object?>? items);
     }
     public class ValidationException : Exception {
-        protected ValidationException(SerializationInfo info, StreamingContext context);
+        [EditorBrowsableAttribute(EditorBrowsableState.Never)]
+        [ObsoleteAttribute("This API supports obsolete formatter-based serialization. It should not be called or extended by application code.", DiagnosticId="SYSLIB0051", UrlFormat="https://aka.ms/dotnet-warnings/{0}")]
+        protected ValidationException(SerializationInfo info, StreamingContext context);
     }
     public static class Validator {
-        [RequiresUnreferencedCodeAttribute("The Type of instance cannot be statically discovered.")]
-        public static bool TryValidateObject(object instance, ValidationContext validationContext, ICollection<ValidationResult>? validationResults);
+        [RequiresUnreferencedCodeAttribute("The Type of instance cannot be statically discovered and the Type's properties can be trimmed.")]
+        public static bool TryValidateObject(object instance, ValidationContext validationContext, ICollection<ValidationResult>? validationResults);
-        [RequiresUnreferencedCodeAttribute("The Type of instance cannot be statically discovered.")]
-        public static bool TryValidateObject(object instance, ValidationContext validationContext, ICollection<ValidationResult>? validationResults, bool validateAllProperties);
+        [RequiresUnreferencedCodeAttribute("The Type of instance cannot be statically discovered and the Type's properties can be trimmed.")]
+        public static bool TryValidateObject(object instance, ValidationContext validationContext, ICollection<ValidationResult>? validationResults, bool validateAllProperties);
-        public static bool TryValidateValue(object value, ValidationContext validationContext, ICollection<ValidationResult>? validationResults, IEnumerable<ValidationAttribute> validationAttributes);
+        public static bool TryValidateValue(object? value, ValidationContext validationContext, ICollection<ValidationResult>? validationResults, IEnumerable<ValidationAttribute> validationAttributes);
-        [RequiresUnreferencedCodeAttribute("The Type of instance cannot be statically discovered.")]
-        public static void ValidateObject(object instance, ValidationContext validationContext);
+        [RequiresUnreferencedCodeAttribute("The Type of instance cannot be statically discovered and the Type's properties can be trimmed.")]
+        public static void ValidateObject(object instance, ValidationContext validationContext);
-        [RequiresUnreferencedCodeAttribute("The Type of instance cannot be statically discovered.")]
-        public static void ValidateObject(object instance, ValidationContext validationContext, bool validateAllProperties);
+        [RequiresUnreferencedCodeAttribute("The Type of instance cannot be statically discovered and the Type's properties can be trimmed.")]
+        public static void ValidateObject(object instance, ValidationContext validationContext, bool validateAllProperties);
-        public static void ValidateValue(object value, ValidationContext validationContext, IEnumerable<ValidationAttribute> validationAttributes);
+        public static void ValidateValue(object? value, ValidationContext validationContext, IEnumerable<ValidationAttribute> validationAttributes);
     }
 }
```

