# System.ComponentModel

``` diff
 namespace System.ComponentModel {
     public class InvalidAsynchronousStateException : ArgumentException {
-        protected InvalidAsynchronousStateException(SerializationInfo info, StreamingContext context);
+        [EditorBrowsableAttribute(EditorBrowsableState.Never)]
+        [ObsoleteAttribute("This API supports obsolete formatter-based serialization. It should not be called or extended by application code.", DiagnosticId="SYSLIB0051", UrlFormat="https://aka.ms/dotnet-warnings/{0}")]
+        protected InvalidAsynchronousStateException(SerializationInfo info, StreamingContext context);
     }
     public class InvalidEnumArgumentException : ArgumentException {
-        protected InvalidEnumArgumentException(SerializationInfo info, StreamingContext context);
+        [EditorBrowsableAttribute(EditorBrowsableState.Never)]
+        [ObsoleteAttribute("This API supports obsolete formatter-based serialization. It should not be called or extended by application code.", DiagnosticId="SYSLIB0051", UrlFormat="https://aka.ms/dotnet-warnings/{0}")]
+        protected InvalidEnumArgumentException(SerializationInfo info, StreamingContext context);
     }
     public interface ITypedList {
-        PropertyDescriptorCollection GetItemProperties(PropertyDescriptor[] listAccessors);
+        PropertyDescriptorCollection GetItemProperties(PropertyDescriptor[]? listAccessors);
-        string GetListName(PropertyDescriptor[] listAccessors);
+        string GetListName(PropertyDescriptor[]? listAccessors);
     }
     public class LicenseException : SystemException {
-        protected LicenseException(SerializationInfo info, StreamingContext context);
+        [EditorBrowsableAttribute(EditorBrowsableState.Never)]
+        [ObsoleteAttribute("This API supports obsolete formatter-based serialization. It should not be called or extended by application code.", DiagnosticId="SYSLIB0051", UrlFormat="https://aka.ms/dotnet-warnings/{0}")]
+        protected LicenseException(SerializationInfo info, StreamingContext context);
-        public override void GetObjectData(SerializationInfo info, StreamingContext context);
+        [EditorBrowsableAttribute(EditorBrowsableState.Never)]
+        [ObsoleteAttribute("This API supports obsolete formatter-based serialization. It should not be called or extended by application code.", DiagnosticId="SYSLIB0051", UrlFormat="https://aka.ms/dotnet-warnings/{0}")]
+        public override void GetObjectData(SerializationInfo info, StreamingContext context);
     }
     [AttributeUsageAttribute(AttributeTargets.All)]
     public class PropertyTabAttribute : Attribute {
-        public bool Equals(PropertyTabAttribute other);
+        public bool Equals([NotNullWhenAttribute(true)] PropertyTabAttribute? other);
     }
     public abstract class TypeDescriptionProvider {
-        public virtual object? CreateInstance(IServiceProvider? provider, Type objectType, Type[]? argTypes, object[]? args);
+        public virtual object? CreateInstance(IServiceProvider? provider, Type objectType, Type[]? argTypes, object?[]? args);
     }
     public sealed class TypeDescriptor {
-        public static object? CreateInstance(IServiceProvider? provider, Type objectType, Type[]? argTypes, object[]? args);
+        public static object? CreateInstance(IServiceProvider? provider, Type objectType, Type[]? argTypes, object?[]? args);
     }
     public class WarningException : SystemException {
-        protected WarningException(SerializationInfo info, StreamingContext context);
+        [EditorBrowsableAttribute(EditorBrowsableState.Never)]
+        [ObsoleteAttribute("This API supports obsolete formatter-based serialization. It should not be called or extended by application code.", DiagnosticId="SYSLIB0051", UrlFormat="https://aka.ms/dotnet-warnings/{0}")]
+        protected WarningException(SerializationInfo info, StreamingContext context);
-        public override void GetObjectData(SerializationInfo info, StreamingContext context);
+        [EditorBrowsableAttribute(EditorBrowsableState.Never)]
+        [ObsoleteAttribute("This API supports obsolete formatter-based serialization. It should not be called or extended by application code.", DiagnosticId="SYSLIB0051", UrlFormat="https://aka.ms/dotnet-warnings/{0}")]
+        public override void GetObjectData(SerializationInfo info, StreamingContext context);
     }
-    public class Win32Exception : ExternalException, ISerializable {
+    public class Win32Exception : ExternalException {
-        protected Win32Exception(SerializationInfo info, StreamingContext context);
+        [EditorBrowsableAttribute(EditorBrowsableState.Never)]
+        [ObsoleteAttribute("This API supports obsolete formatter-based serialization. It should not be called or extended by application code.", DiagnosticId="SYSLIB0051", UrlFormat="https://aka.ms/dotnet-warnings/{0}")]
+        protected Win32Exception(SerializationInfo info, StreamingContext context);
-        public override void GetObjectData(SerializationInfo info, StreamingContext context);
+        [EditorBrowsableAttribute(EditorBrowsableState.Never)]
+        [ObsoleteAttribute("This API supports obsolete formatter-based serialization. It should not be called or extended by application code.", DiagnosticId="SYSLIB0051", UrlFormat="https://aka.ms/dotnet-warnings/{0}")]
+        public override void GetObjectData(SerializationInfo info, StreamingContext context);
     }
 }
```

