# System.Diagnostics.Metrics

``` diff
 namespace System.Diagnostics.Metrics {
+    public interface IMeterFactory : IDisposable {
+        Meter Create(MeterOptions options);
+    }
     public abstract class Instrument {
+        protected Instrument(Meter meter, string name, string? unit, string? description, IEnumerable<KeyValuePair<string, object?>>? tags);
+        public IEnumerable<KeyValuePair<string, object?>>? Tags { get; }
     }
     public abstract class Instrument<T> : Instrument where T : struct {
+        protected Instrument(Meter meter, string name, string? unit, string? description, IEnumerable<KeyValuePair<string, object?>>? tags);
     }
     public class Meter : IDisposable {
+        public Meter(MeterOptions options);
+        public Meter(string name, string version, IEnumerable<KeyValuePair<string, object?>>? tags, object scope = null);
+        public object Scope { get; }
+        public IEnumerable<KeyValuePair<string, object?>>? Tags { get; }
+        public Counter<T> CreateCounter<T>(string name, string unit, string description, IEnumerable<KeyValuePair<string, object?>> tags) where T : struct;
+        public Histogram<T> CreateHistogram<T>(string name, string unit, string description, IEnumerable<KeyValuePair<string, object?>> tags) where T : struct;
+        public ObservableCounter<T> CreateObservableCounter<T>(string name, Func<IEnumerable<Measurement<T>>> observeValues, string unit, string description, IEnumerable<KeyValuePair<string, object?>> tags) where T : struct;
+        public ObservableCounter<T> CreateObservableCounter<T>(string name, Func<Measurement<T>> observeValue, string unit, string description, IEnumerable<KeyValuePair<string, object?>> tags) where T : struct;
+        public ObservableCounter<T> CreateObservableCounter<T>(string name, Func<T> observeValue, string unit, string description, IEnumerable<KeyValuePair<string, object?>> tags) where T : struct;
+        public ObservableGauge<T> CreateObservableGauge<T>(string name, Func<IEnumerable<Measurement<T>>> observeValues, string unit, string description, IEnumerable<KeyValuePair<string, object?>> tags) where T : struct;
+        public ObservableGauge<T> CreateObservableGauge<T>(string name, Func<Measurement<T>> observeValue, string unit, string description, IEnumerable<KeyValuePair<string, object?>> tags) where T : struct;
+        public ObservableGauge<T> CreateObservableGauge<T>(string name, Func<T> observeValue, string unit, string description, IEnumerable<KeyValuePair<string, object?>> tags) where T : struct;
+        public ObservableUpDownCounter<T> CreateObservableUpDownCounter<T>(string name, Func<IEnumerable<Measurement<T>>> observeValues, string unit, string description, IEnumerable<KeyValuePair<string, object?>> tags) where T : struct;
+        public ObservableUpDownCounter<T> CreateObservableUpDownCounter<T>(string name, Func<Measurement<T>> observeValue, string unit, string description, IEnumerable<KeyValuePair<string, object?>> tags) where T : struct;
+        public ObservableUpDownCounter<T> CreateObservableUpDownCounter<T>(string name, Func<T> observeValue, string unit, string description, IEnumerable<KeyValuePair<string, object?>> tags) where T : struct;
+        public UpDownCounter<T> CreateUpDownCounter<T>(string name, string unit, string description, IEnumerable<KeyValuePair<string, object?>> tags) where T : struct;
+        protected virtual void Dispose(bool disposing);
     }
+    public static class MeterFactoryExtensions {
+        public static Meter Create(this IMeterFactory meterFactory, string name, string? version = null, IEnumerable<KeyValuePair<string, object?>>? tags = null);
+    }
+    public class MeterOptions {
+        public MeterOptions(string name);
+        public string Name { get; set; }
+        public object Scope { get; set; }
+        public IEnumerable<KeyValuePair<string, object?>>? Tags { get; set; }
+        public string Version { get; set; }
+    }
     public abstract class ObservableInstrument<T> : Instrument where T : struct {
+        protected ObservableInstrument(Meter meter, string name, string? unit, string? description, IEnumerable<KeyValuePair<string, object?>> tags);
     }
 }
```

