# System.Diagnostics

``` diff
 namespace System.Diagnostics {
     public abstract class DiagnosticSource {
+        [RequiresUnreferencedCodeAttribute("Only the properties of the T type will be preserved. Properties of referenced types and properties of derived types may be trimmed.")]
+        public Activity StartActivity<T>(Activity activity, T args);
+        [RequiresUnreferencedCodeAttribute("Only the properties of the T type will be preserved. Properties of referenced types and properties of derived types may be trimmed.")]
+        public void StopActivity<T>(Activity activity, T args);
+        [RequiresUnreferencedCodeAttribute("Only the properties of the T type will be preserved. Properties of referenced types and properties of derived types may be trimmed.")]
+        public void Write<T>(string name, T value);
     }
     public sealed class ProcessStartInfo {
+        public ProcessStartInfo(string fileName, IEnumerable<string> arguments);
+        [SupportedOSPlatformAttribute("windows")]
+        public bool UseCredentialsForNetworkingOnly { get; set; }
     }
     public class StackTrace {
+        public StackTrace(IEnumerable<StackFrame> frames);
     }
     public class Stopwatch {
+        public override string ToString();
     }
     public sealed class Trace {
-        [ConditionalAttribute("TRACE")]
-        public static void Assert(bool condition);
+        [ConditionalAttribute("TRACE")]
+        public static void Assert([DoesNotReturnIfAttribute(false)] bool condition);
-        [ConditionalAttribute("TRACE")]
-        public static void Assert(bool condition, string message);
+        [ConditionalAttribute("TRACE")]
+        public static void Assert([DoesNotReturnIfAttribute(false)] bool condition, string message);
-        [ConditionalAttribute("TRACE")]
-        public static void Assert(bool condition, string message, string detailMessage);
+        [ConditionalAttribute("TRACE")]
+        public static void Assert([DoesNotReturnIfAttribute(false)] bool condition, string message, string detailMessage);
-        [ConditionalAttribute("TRACE")]
-        public static void Fail(string message);
+        [ConditionalAttribute("TRACE")]
+        [DoesNotReturnAttribute]
+        public static void Fail(string message);
-        [ConditionalAttribute("TRACE")]
-        public static void Fail(string message, string detailMessage);
+        [ConditionalAttribute("TRACE")]
+        [DoesNotReturnAttribute]
+        public static void Fail(string message, string detailMessage);
     }
 }
```

