# System.Net.Http

``` diff
 namespace System.Net.Http {
     public class HttpClientHandler : HttpMessageHandler {
+        [CLSCompliantAttribute(false)]
+        public IMeterFactory MeterFactory { get; set; }
     }
+    public class HttpIOException : IOException {
+        public HttpIOException(HttpRequestError httpRequestError, string? message = null, Exception? innerException = null);
+        public HttpRequestError HttpRequestError { get; }
+    }
     public class HttpMethod : IEquatable<HttpMethod> {
+        public static HttpMethod Parse(ReadOnlySpan<char> method);
     }
-    public sealed class HttpProtocolException : IOException
+    public sealed class HttpProtocolException : HttpIOException
+    public enum HttpRequestError {
+        ConfigurationLimitExceeded = 11,
+        ConnectionError = 2,
+        ExtendedConnectNotSupported = 5,
+        HttpProtocolError = 4,
+        InvalidResponse = 9,
+        NameResolutionError = 1,
+        ProxyTunnelError = 8,
+        ResponseEnded = 10,
+        SecureConnectionError = 3,
+        Unknown = 0,
+        UserAuthenticationError = 7,
+        VersionNegotiationError = 6,
+    }
     public class HttpRequestException : Exception {
+        public HttpRequestException(HttpRequestError httpRequestError, string message = null, Exception inner = null, HttpStatusCode? statusCode = default(HttpStatusCode?));
+        public HttpRequestError HttpRequestError { get; }
     }
-    public sealed class HttpRequestOptions : ICollection<KeyValuePair<string, object?>>, IDictionary<string, object?>, IEnumerable, IEnumerable<KeyValuePair<string, object?>> {
+    public sealed class HttpRequestOptions : ICollection<KeyValuePair<string, object?>>, IDictionary<string, object?>, IEnumerable, IEnumerable<KeyValuePair<string, object?>>, IReadOnlyCollection<KeyValuePair<string, object?>>, IReadOnlyDictionary<string, object?> {
+        int IReadOnlyCollection<KeyValuePair<string, object?>>.Count { get; }
+        object? IReadOnlyDictionary<string, object?>.this[string key] { get; }
+        IEnumerable<string> IReadOnlyDictionary<string, object?>.Keys { get; }
+        IEnumerable<object?> IReadOnlyDictionary<string, object?>.Values { get; }
+        bool IReadOnlyDictionary<string, object?>.ContainsKey(string key);
+        bool IReadOnlyDictionary<string, object?>.TryGetValue(string key, out object value);
     }
     [UnsupportedOSPlatformAttribute("browser")]
     public sealed class SocketsHttpHandler : HttpMessageHandler {
+        [CLSCompliantAttribute(false)]
+        public IMeterFactory MeterFactory { get; set; }
     }
 }
```

