# System.Net.NetworkInformation

``` diff
 namespace System.Net.NetworkInformation {
     public class NetworkInformationException : Win32Exception {
-        protected NetworkInformationException(SerializationInfo serializationInfo, StreamingContext streamingContext);
+        [EditorBrowsableAttribute(EditorBrowsableState.Never)]
+        [ObsoleteAttribute("This API supports obsolete formatter-based serialization. It should not be called or extended by application code.", DiagnosticId="SYSLIB0051", UrlFormat="https://aka.ms/dotnet-warnings/{0}")]
+        protected NetworkInformationException(SerializationInfo serializationInfo, StreamingContext streamingContext);
     }
     public class Ping : Component {
+        public Task<PingReply> SendPingAsync(IPAddress address, TimeSpan timeout, byte[]? buffer = null, PingOptions? options = null, CancellationToken cancellationToken = default(CancellationToken));
+        public Task<PingReply> SendPingAsync(string hostNameOrAddress, TimeSpan timeout, byte[]? buffer = null, PingOptions? options = null, CancellationToken cancellationToken = default(CancellationToken));
     }
     public class PingException : InvalidOperationException {
-        protected PingException(SerializationInfo serializationInfo, StreamingContext streamingContext);
+        [EditorBrowsableAttribute(EditorBrowsableState.Never)]
+        [ObsoleteAttribute("This API supports obsolete formatter-based serialization. It should not be called or extended by application code.", DiagnosticId="SYSLIB0051", UrlFormat="https://aka.ms/dotnet-warnings/{0}")]
+        protected PingException(SerializationInfo serializationInfo, StreamingContext streamingContext);
     }
 }
```

