# System.Net.Security

``` diff
 namespace System.Net.Security {
-    public sealed class CipherSuitesPolicy
+    [UnsupportedOSPlatformAttribute("android")]
+    [UnsupportedOSPlatformAttribute("windows")]
+    public sealed class CipherSuitesPolicy
-    [UnsupportedOSPlatformAttribute("tvos")]
-    public class NegotiateStream : AuthenticatedStream
+    public class NegotiateStream : AuthenticatedStream
     public class SslClientAuthenticationOptions {
+        public bool AllowTlsResume { get; set; }
+        public SslStreamCertificateContext ClientCertificateContext { get; set; }
     }
     public readonly struct SslClientHelloInfo {
+        public SslClientHelloInfo(string serverName, SslProtocols sslProtocols);
     }
     public class SslServerAuthenticationOptions {
+        public bool AllowTlsResume { get; set; }
     }
     public class SslStream : AuthenticatedStream {
-        public virtual Task NegotiateClientCertificateAsync(CancellationToken cancellationToken = default(CancellationToken));
+        [SupportedOSPlatformAttribute("freebsd")]
+        [SupportedOSPlatformAttribute("linux")]
+        [SupportedOSPlatformAttribute("windows")]
+        public virtual Task NegotiateClientCertificateAsync(CancellationToken cancellationToken = default(CancellationToken));
     }
     public class SslStreamCertificateContext {
+        public ReadOnlyCollection<X509Certificate2> IntermediateCertificates { get; }
+        public X509Certificate2 TargetCertificate { get; }
     }
 }
```

