# System.Net.Sockets

``` diff
 namespace System.Net.Sockets {
     public class LingerOption {
+        public override bool Equals(object? comparand);
+        public override int GetHashCode();
     }
     public class Socket : IDisposable {
+        public int ReceiveFrom(Span<byte> buffer, SocketFlags socketFlags, SocketAddress receivedAddress);
+        public ValueTask<int> ReceiveFromAsync(Memory<byte> buffer, SocketFlags socketFlags, SocketAddress receivedAddress, CancellationToken cancellationToken = default(CancellationToken));
+        public int SendTo(ReadOnlySpan<byte> buffer, SocketFlags socketFlags, SocketAddress socketAddress);
+        public ValueTask<int> SendToAsync(ReadOnlyMemory<byte> buffer, SocketFlags socketFlags, SocketAddress socketAddress, CancellationToken cancellationToken = default(CancellationToken));
     }
     public class SocketException : Win32Exception {
+        public SocketException(int errorCode, string? message);
-        protected SocketException(SerializationInfo serializationInfo, StreamingContext streamingContext);
+        [EditorBrowsableAttribute(EditorBrowsableState.Never)]
+        [ObsoleteAttribute("This API supports obsolete formatter-based serialization. It should not be called or extended by application code.", DiagnosticId="SYSLIB0051", UrlFormat="https://aka.ms/dotnet-warnings/{0}")]
+        protected SocketException(SerializationInfo serializationInfo, StreamingContext streamingContext);
     }
-    public class TcpListener {
+    public class TcpListener : IDisposable {
+        public void Dispose();
     }
     public sealed class UnixDomainSocketEndPoint : EndPoint {
+        public override bool Equals([NotNullWhenAttribute(true)] object? obj);
+        public override int GetHashCode();
     }
 }
```

