# System.Numerics

``` diff
 namespace System.Numerics {
-    public readonly struct BigInteger : IAdditionOperators<BigInteger, BigInteger, BigInteger>, IAdditiveIdentity<BigInteger, BigInteger>, IBinaryInteger<BigInteger>, IBinaryNumber<BigInteger>, IBitwiseOperators<BigInteger, BigInteger, BigInteger>, IComparable, IComparable<BigInteger>, IComparisonOperators<BigInteger, BigInteger, bool>, IDecrementOperators<BigInteger>, IDivisionOperators<BigInteger, BigInteger, BigInteger>, IEqualityOperators<BigInteger, BigInteger, bool>, IEquatable<BigInteger>, IFormattable, IIncrementOperators<BigInteger>, IModulusOperators<BigInteger, BigInteger, BigInteger>, IMultiplicativeIdentity<BigInteger, BigInteger>, IMultiplyOperators<BigInteger, BigInteger, BigInteger>, INumber<BigInteger>, INumberBase<BigInteger>, IParsable<BigInteger>, IShiftOperators<BigInteger, int, BigInteger>, ISignedNumber<BigInteger>, ISpanFormattable, ISpanParsable<BigInteger>, ISubtractionOperators<BigInteger, BigInteger, BigInteger>, IUnaryNegationOperators<BigInteger, BigInteger>, IUnaryPlusOperators<BigInteger, BigInteger>
+    public readonly struct BigInteger : IAdditionOperators<BigInteger, BigInteger, BigInteger>, IAdditiveIdentity<BigInteger, BigInteger>, IBinaryInteger<BigInteger>, IBinaryNumber<BigInteger>, IBitwiseOperators<BigInteger, BigInteger, BigInteger>, IComparable, IComparable<BigInteger>, IComparisonOperators<BigInteger, BigInteger, bool>, IDecrementOperators<BigInteger>, IDivisionOperators<BigInteger, BigInteger, BigInteger>, IEqualityOperators<BigInteger, BigInteger, bool>, IEquatable<BigInteger>, IFormattable, IIncrementOperators<BigInteger>, IModulusOperators<BigInteger, BigInteger, BigInteger>, IMultiplicativeIdentity<BigInteger, BigInteger>, IMultiplyOperators<BigInteger, BigInteger, BigInteger>, INumber<BigInteger>, INumberBase<BigInteger>, IParsable<BigInteger>, IShiftOperators<BigInteger, int, BigInteger>, ISignedNumber<BigInteger>, ISpanFormattable, ISpanParsable<BigInteger>, ISubtractionOperators<BigInteger, BigInteger, BigInteger>, IUnaryNegationOperators<BigInteger, BigInteger>, IUnaryPlusOperators<BigInteger, BigInteger>, IUtf8SpanFormattable, IUtf8SpanParsable<BigInteger>
     public static class BitOperations {
+        [CLSCompliantAttribute(false)]
+        public static uint Crc32C(uint crc, byte data);
+        [CLSCompliantAttribute(false)]
+        public static uint Crc32C(uint crc, ushort data);
+        [CLSCompliantAttribute(false)]
+        public static uint Crc32C(uint crc, uint data);
+        [CLSCompliantAttribute(false)]
+        public static uint Crc32C(uint crc, ulong data);
     }
-    public readonly struct Complex : IAdditionOperators<Complex, Complex, Complex>, IAdditiveIdentity<Complex, Complex>, IDecrementOperators<Complex>, IDivisionOperators<Complex, Complex, Complex>, IEqualityOperators<Complex, Complex, bool>, IEquatable<Complex>, IFormattable, IIncrementOperators<Complex>, IMultiplicativeIdentity<Complex, Complex>, IMultiplyOperators<Complex, Complex, Complex>, INumberBase<Complex>, IParsable<Complex>, ISignedNumber<Complex>, ISpanFormattable, ISpanParsable<Complex>, ISubtractionOperators<Complex, Complex, Complex>, IUnaryNegationOperators<Complex, Complex>, IUnaryPlusOperators<Complex, Complex> {
+    public readonly struct Complex : IAdditionOperators<Complex, Complex, Complex>, IAdditiveIdentity<Complex, Complex>, IDecrementOperators<Complex>, IDivisionOperators<Complex, Complex, Complex>, IEqualityOperators<Complex, Complex, bool>, IEquatable<Complex>, IFormattable, IIncrementOperators<Complex>, IMultiplicativeIdentity<Complex, Complex>, IMultiplyOperators<Complex, Complex, Complex>, INumberBase<Complex>, IParsable<Complex>, ISignedNumber<Complex>, ISpanFormattable, ISpanParsable<Complex>, ISubtractionOperators<Complex, Complex, Complex>, IUnaryNegationOperators<Complex, Complex>, IUnaryPlusOperators<Complex, Complex>, IUtf8SpanFormattable, IUtf8SpanParsable<Complex> {
+        public bool TryFormat(Span<byte> utf8Destination, out int bytesWritten, [StringSyntaxAttribute("NumericFormat")] ReadOnlySpan<char> format = default(ReadOnlySpan<char>), IFormatProvider? provider = null);
-        public bool TryFormat(Span<char> destination, out int charsWritten, ReadOnlySpan<char> format, IFormatProvider? provider);
+        public bool TryFormat(Span<char> destination, out int charsWritten, [StringSyntaxAttribute("NumericFormat")] ReadOnlySpan<char> format = default(ReadOnlySpan<char>), IFormatProvider? provider = null);
     }
-    public interface IBinaryFloatingPointIeee754<TSelf> : IAdditionOperators<TSelf, TSelf, TSelf>, IAdditiveIdentity<TSelf, TSelf>, IBinaryNumber<TSelf>, IBitwiseOperators<TSelf, TSelf, TSelf>, IComparable, IComparable<TSelf>, IComparisonOperators<TSelf, TSelf, bool>, IDecrementOperators<TSelf>, IDivisionOperators<TSelf, TSelf, TSelf>, IEqualityOperators<TSelf, TSelf, bool>, IEquatable<TSelf>, IExponentialFunctions<TSelf>, IFloatingPoint<TSelf>, IFloatingPointConstants<TSelf>, IFloatingPointIeee754<TSelf>, IFormattable, IHyperbolicFunctions<TSelf>, IIncrementOperators<TSelf>, ILogarithmicFunctions<TSelf>, IModulusOperators<TSelf, TSelf, TSelf>, IMultiplicativeIdentity<TSelf, TSelf>, IMultiplyOperators<TSelf, TSelf, TSelf>, INumber<TSelf>, INumberBase<TSelf>, IParsable<TSelf>, IPowerFunctions<TSelf>, IRootFunctions<TSelf>, ISignedNumber<TSelf>, ISpanFormattable, ISpanParsable<TSelf>, ISubtractionOperators<TSelf, TSelf, TSelf>, ITrigonometricFunctions<TSelf>, IUnaryNegationOperators<TSelf, TSelf>, IUnaryPlusOperators<TSelf, TSelf> where TSelf : IBinaryFloatingPointIeee754<TSelf>?
+    public interface IBinaryFloatingPointIeee754<TSelf> : IAdditionOperators<TSelf, TSelf, TSelf>, IAdditiveIdentity<TSelf, TSelf>, IBinaryNumber<TSelf>, IBitwiseOperators<TSelf, TSelf, TSelf>, IComparable, IComparable<TSelf>, IComparisonOperators<TSelf, TSelf, bool>, IDecrementOperators<TSelf>, IDivisionOperators<TSelf, TSelf, TSelf>, IEqualityOperators<TSelf, TSelf, bool>, IEquatable<TSelf>, IExponentialFunctions<TSelf>, IFloatingPoint<TSelf>, IFloatingPointConstants<TSelf>, IFloatingPointIeee754<TSelf>, IFormattable, IHyperbolicFunctions<TSelf>, IIncrementOperators<TSelf>, ILogarithmicFunctions<TSelf>, IModulusOperators<TSelf, TSelf, TSelf>, IMultiplicativeIdentity<TSelf, TSelf>, IMultiplyOperators<TSelf, TSelf, TSelf>, INumber<TSelf>, INumberBase<TSelf>, IParsable<TSelf>, IPowerFunctions<TSelf>, IRootFunctions<TSelf>, ISignedNumber<TSelf>, ISpanFormattable, ISpanParsable<TSelf>, ISubtractionOperators<TSelf, TSelf, TSelf>, ITrigonometricFunctions<TSelf>, IUnaryNegationOperators<TSelf, TSelf>, IUnaryPlusOperators<TSelf, TSelf>, IUtf8SpanFormattable, IUtf8SpanParsable<TSelf> where TSelf : IBinaryFloatingPointIeee754<TSelf>?
-    public interface IBinaryInteger<TSelf> : IAdditionOperators<TSelf, TSelf, TSelf>, IAdditiveIdentity<TSelf, TSelf>, IBinaryNumber<TSelf>, IBitwiseOperators<TSelf, TSelf, TSelf>, IComparable, IComparable<TSelf>, IComparisonOperators<TSelf, TSelf, bool>, IDecrementOperators<TSelf>, IDivisionOperators<TSelf, TSelf, TSelf>, IEqualityOperators<TSelf, TSelf, bool>, IEquatable<TSelf>, IFormattable, IIncrementOperators<TSelf>, IModulusOperators<TSelf, TSelf, TSelf>, IMultiplicativeIdentity<TSelf, TSelf>, IMultiplyOperators<TSelf, TSelf, TSelf>, INumber<TSelf>, INumberBase<TSelf>, IParsable<TSelf>, IShiftOperators<TSelf, int, TSelf>, ISpanFormattable, ISpanParsable<TSelf>, ISubtractionOperators<TSelf, TSelf, TSelf>, IUnaryNegationOperators<TSelf, TSelf>, IUnaryPlusOperators<TSelf, TSelf> where TSelf : IBinaryInteger<TSelf>?
+    public interface IBinaryInteger<TSelf> : IAdditionOperators<TSelf, TSelf, TSelf>, IAdditiveIdentity<TSelf, TSelf>, IBinaryNumber<TSelf>, IBitwiseOperators<TSelf, TSelf, TSelf>, IComparable, IComparable<TSelf>, IComparisonOperators<TSelf, TSelf, bool>, IDecrementOperators<TSelf>, IDivisionOperators<TSelf, TSelf, TSelf>, IEqualityOperators<TSelf, TSelf, bool>, IEquatable<TSelf>, IFormattable, IIncrementOperators<TSelf>, IModulusOperators<TSelf, TSelf, TSelf>, IMultiplicativeIdentity<TSelf, TSelf>, IMultiplyOperators<TSelf, TSelf, TSelf>, INumber<TSelf>, INumberBase<TSelf>, IParsable<TSelf>, IShiftOperators<TSelf, int, TSelf>, ISpanFormattable, ISpanParsable<TSelf>, ISubtractionOperators<TSelf, TSelf, TSelf>, IUnaryNegationOperators<TSelf, TSelf>, IUnaryPlusOperators<TSelf, TSelf>, IUtf8SpanFormattable, IUtf8SpanParsable<TSelf> where TSelf : IBinaryInteger<TSelf>?
-    public interface IBinaryNumber<TSelf> : IAdditionOperators<TSelf, TSelf, TSelf>, IAdditiveIdentity<TSelf, TSelf>, IBitwiseOperators<TSelf, TSelf, TSelf>, IComparable, IComparable<TSelf>, IComparisonOperators<TSelf, TSelf, bool>, IDecrementOperators<TSelf>, IDivisionOperators<TSelf, TSelf, TSelf>, IEqualityOperators<TSelf, TSelf, bool>, IEquatable<TSelf>, IFormattable, IIncrementOperators<TSelf>, IModulusOperators<TSelf, TSelf, TSelf>, IMultiplicativeIdentity<TSelf, TSelf>, IMultiplyOperators<TSelf, TSelf, TSelf>, INumber<TSelf>, INumberBase<TSelf>, IParsable<TSelf>, ISpanFormattable, ISpanParsable<TSelf>, ISubtractionOperators<TSelf, TSelf, TSelf>, IUnaryNegationOperators<TSelf, TSelf>, IUnaryPlusOperators<TSelf, TSelf> where TSelf : IBinaryNumber<TSelf>?
+    public interface IBinaryNumber<TSelf> : IAdditionOperators<TSelf, TSelf, TSelf>, IAdditiveIdentity<TSelf, TSelf>, IBitwiseOperators<TSelf, TSelf, TSelf>, IComparable, IComparable<TSelf>, IComparisonOperators<TSelf, TSelf, bool>, IDecrementOperators<TSelf>, IDivisionOperators<TSelf, TSelf, TSelf>, IEqualityOperators<TSelf, TSelf, bool>, IEquatable<TSelf>, IFormattable, IIncrementOperators<TSelf>, IModulusOperators<TSelf, TSelf, TSelf>, IMultiplicativeIdentity<TSelf, TSelf>, IMultiplyOperators<TSelf, TSelf, TSelf>, INumber<TSelf>, INumberBase<TSelf>, IParsable<TSelf>, ISpanFormattable, ISpanParsable<TSelf>, ISubtractionOperators<TSelf, TSelf, TSelf>, IUnaryNegationOperators<TSelf, TSelf>, IUnaryPlusOperators<TSelf, TSelf>, IUtf8SpanFormattable, IUtf8SpanParsable<TSelf> where TSelf : IBinaryNumber<TSelf>?
-    public interface IExponentialFunctions<TSelf> : IAdditionOperators<TSelf, TSelf, TSelf>, IAdditiveIdentity<TSelf, TSelf>, IDecrementOperators<TSelf>, IDivisionOperators<TSelf, TSelf, TSelf>, IEqualityOperators<TSelf, TSelf, bool>, IEquatable<TSelf>, IFloatingPointConstants<TSelf>, IFormattable, IIncrementOperators<TSelf>, IMultiplicativeIdentity<TSelf, TSelf>, IMultiplyOperators<TSelf, TSelf, TSelf>, INumberBase<TSelf>, IParsable<TSelf>, ISpanFormattable, ISpanParsable<TSelf>, ISubtractionOperators<TSelf, TSelf, TSelf>, IUnaryNegationOperators<TSelf, TSelf>, IUnaryPlusOperators<TSelf, TSelf> where TSelf : IExponentialFunctions<TSelf>?
+    public interface IExponentialFunctions<TSelf> : IAdditionOperators<TSelf, TSelf, TSelf>, IAdditiveIdentity<TSelf, TSelf>, IDecrementOperators<TSelf>, IDivisionOperators<TSelf, TSelf, TSelf>, IEqualityOperators<TSelf, TSelf, bool>, IEquatable<TSelf>, IFloatingPointConstants<TSelf>, IFormattable, IIncrementOperators<TSelf>, IMultiplicativeIdentity<TSelf, TSelf>, IMultiplyOperators<TSelf, TSelf, TSelf>, INumberBase<TSelf>, IParsable<TSelf>, ISpanFormattable, ISpanParsable<TSelf>, ISubtractionOperators<TSelf, TSelf, TSelf>, IUnaryNegationOperators<TSelf, TSelf>, IUnaryPlusOperators<TSelf, TSelf>, IUtf8SpanFormattable, IUtf8SpanParsable<TSelf> where TSelf : IExponentialFunctions<TSelf>?
-    public interface IFloatingPoint<TSelf> : IAdditionOperators<TSelf, TSelf, TSelf>, IAdditiveIdentity<TSelf, TSelf>, IComparable, IComparable<TSelf>, IComparisonOperators<TSelf, TSelf, bool>, IDecrementOperators<TSelf>, IDivisionOperators<TSelf, TSelf, TSelf>, IEqualityOperators<TSelf, TSelf, bool>, IEquatable<TSelf>, IFloatingPointConstants<TSelf>, IFormattable, IIncrementOperators<TSelf>, IModulusOperators<TSelf, TSelf, TSelf>, IMultiplicativeIdentity<TSelf, TSelf>, IMultiplyOperators<TSelf, TSelf, TSelf>, INumber<TSelf>, INumberBase<TSelf>, IParsable<TSelf>, ISignedNumber<TSelf>, ISpanFormattable, ISpanParsable<TSelf>, ISubtractionOperators<TSelf, TSelf, TSelf>, IUnaryNegationOperators<TSelf, TSelf>, IUnaryPlusOperators<TSelf, TSelf> where TSelf : IFloatingPoint<TSelf>?
+    public interface IFloatingPoint<TSelf> : IAdditionOperators<TSelf, TSelf, TSelf>, IAdditiveIdentity<TSelf, TSelf>, IComparable, IComparable<TSelf>, IComparisonOperators<TSelf, TSelf, bool>, IDecrementOperators<TSelf>, IDivisionOperators<TSelf, TSelf, TSelf>, IEqualityOperators<TSelf, TSelf, bool>, IEquatable<TSelf>, IFloatingPointConstants<TSelf>, IFormattable, IIncrementOperators<TSelf>, IModulusOperators<TSelf, TSelf, TSelf>, IMultiplicativeIdentity<TSelf, TSelf>, IMultiplyOperators<TSelf, TSelf, TSelf>, INumber<TSelf>, INumberBase<TSelf>, IParsable<TSelf>, ISignedNumber<TSelf>, ISpanFormattable, ISpanParsable<TSelf>, ISubtractionOperators<TSelf, TSelf, TSelf>, IUnaryNegationOperators<TSelf, TSelf>, IUnaryPlusOperators<TSelf, TSelf>, IUtf8SpanFormattable, IUtf8SpanParsable<TSelf> where TSelf : IFloatingPoint<TSelf>?
-    public interface IFloatingPointConstants<TSelf> : IAdditionOperators<TSelf, TSelf, TSelf>, IAdditiveIdentity<TSelf, TSelf>, IDecrementOperators<TSelf>, IDivisionOperators<TSelf, TSelf, TSelf>, IEqualityOperators<TSelf, TSelf, bool>, IEquatable<TSelf>, IFormattable, IIncrementOperators<TSelf>, IMultiplicativeIdentity<TSelf, TSelf>, IMultiplyOperators<TSelf, TSelf, TSelf>, INumberBase<TSelf>, IParsable<TSelf>, ISpanFormattable, ISpanParsable<TSelf>, ISubtractionOperators<TSelf, TSelf, TSelf>, IUnaryNegationOperators<TSelf, TSelf>, IUnaryPlusOperators<TSelf, TSelf> where TSelf : IFloatingPointConstants<TSelf>?
+    public interface IFloatingPointConstants<TSelf> : IAdditionOperators<TSelf, TSelf, TSelf>, IAdditiveIdentity<TSelf, TSelf>, IDecrementOperators<TSelf>, IDivisionOperators<TSelf, TSelf, TSelf>, IEqualityOperators<TSelf, TSelf, bool>, IEquatable<TSelf>, IFormattable, IIncrementOperators<TSelf>, IMultiplicativeIdentity<TSelf, TSelf>, IMultiplyOperators<TSelf, TSelf, TSelf>, INumberBase<TSelf>, IParsable<TSelf>, ISpanFormattable, ISpanParsable<TSelf>, ISubtractionOperators<TSelf, TSelf, TSelf>, IUnaryNegationOperators<TSelf, TSelf>, IUnaryPlusOperators<TSelf, TSelf>, IUtf8SpanFormattable, IUtf8SpanParsable<TSelf> where TSelf : IFloatingPointConstants<TSelf>?
-    public interface IFloatingPointIeee754<TSelf> : IAdditionOperators<TSelf, TSelf, TSelf>, IAdditiveIdentity<TSelf, TSelf>, IComparable, IComparable<TSelf>, IComparisonOperators<TSelf, TSelf, bool>, IDecrementOperators<TSelf>, IDivisionOperators<TSelf, TSelf, TSelf>, IEqualityOperators<TSelf, TSelf, bool>, IEquatable<TSelf>, IExponentialFunctions<TSelf>, IFloatingPoint<TSelf>, IFloatingPointConstants<TSelf>, IFormattable, IHyperbolicFunctions<TSelf>, IIncrementOperators<TSelf>, ILogarithmicFunctions<TSelf>, IModulusOperators<TSelf, TSelf, TSelf>, IMultiplicativeIdentity<TSelf, TSelf>, IMultiplyOperators<TSelf, TSelf, TSelf>, INumber<TSelf>, INumberBase<TSelf>, IParsable<TSelf>, IPowerFunctions<TSelf>, IRootFunctions<TSelf>, ISignedNumber<TSelf>, ISpanFormattable, ISpanParsable<TSelf>, ISubtractionOperators<TSelf, TSelf, TSelf>, ITrigonometricFunctions<TSelf>, IUnaryNegationOperators<TSelf, TSelf>, IUnaryPlusOperators<TSelf, TSelf> where TSelf : IFloatingPointIeee754<TSelf>? {
+    public interface IFloatingPointIeee754<TSelf> : IAdditionOperators<TSelf, TSelf, TSelf>, IAdditiveIdentity<TSelf, TSelf>, IComparable, IComparable<TSelf>, IComparisonOperators<TSelf, TSelf, bool>, IDecrementOperators<TSelf>, IDivisionOperators<TSelf, TSelf, TSelf>, IEqualityOperators<TSelf, TSelf, bool>, IEquatable<TSelf>, IExponentialFunctions<TSelf>, IFloatingPoint<TSelf>, IFloatingPointConstants<TSelf>, IFormattable, IHyperbolicFunctions<TSelf>, IIncrementOperators<TSelf>, ILogarithmicFunctions<TSelf>, IModulusOperators<TSelf, TSelf, TSelf>, IMultiplicativeIdentity<TSelf, TSelf>, IMultiplyOperators<TSelf, TSelf, TSelf>, INumber<TSelf>, INumberBase<TSelf>, IParsable<TSelf>, IPowerFunctions<TSelf>, IRootFunctions<TSelf>, ISignedNumber<TSelf>, ISpanFormattable, ISpanParsable<TSelf>, ISubtractionOperators<TSelf, TSelf, TSelf>, ITrigonometricFunctions<TSelf>, IUnaryNegationOperators<TSelf, TSelf>, IUnaryPlusOperators<TSelf, TSelf>, IUtf8SpanFormattable, IUtf8SpanParsable<TSelf> where TSelf : IFloatingPointIeee754<TSelf>? {
+        static TSelf Lerp(TSelf value1, TSelf value2, TSelf amount);
     }
-    public interface IHyperbolicFunctions<TSelf> : IAdditionOperators<TSelf, TSelf, TSelf>, IAdditiveIdentity<TSelf, TSelf>, IDecrementOperators<TSelf>, IDivisionOperators<TSelf, TSelf, TSelf>, IEqualityOperators<TSelf, TSelf, bool>, IEquatable<TSelf>, IFloatingPointConstants<TSelf>, IFormattable, IIncrementOperators<TSelf>, IMultiplicativeIdentity<TSelf, TSelf>, IMultiplyOperators<TSelf, TSelf, TSelf>, INumberBase<TSelf>, IParsable<TSelf>, ISpanFormattable, ISpanParsable<TSelf>, ISubtractionOperators<TSelf, TSelf, TSelf>, IUnaryNegationOperators<TSelf, TSelf>, IUnaryPlusOperators<TSelf, TSelf> where TSelf : IHyperbolicFunctions<TSelf>?
+    public interface IHyperbolicFunctions<TSelf> : IAdditionOperators<TSelf, TSelf, TSelf>, IAdditiveIdentity<TSelf, TSelf>, IDecrementOperators<TSelf>, IDivisionOperators<TSelf, TSelf, TSelf>, IEqualityOperators<TSelf, TSelf, bool>, IEquatable<TSelf>, IFloatingPointConstants<TSelf>, IFormattable, IIncrementOperators<TSelf>, IMultiplicativeIdentity<TSelf, TSelf>, IMultiplyOperators<TSelf, TSelf, TSelf>, INumberBase<TSelf>, IParsable<TSelf>, ISpanFormattable, ISpanParsable<TSelf>, ISubtractionOperators<TSelf, TSelf, TSelf>, IUnaryNegationOperators<TSelf, TSelf>, IUnaryPlusOperators<TSelf, TSelf>, IUtf8SpanFormattable, IUtf8SpanParsable<TSelf> where TSelf : IHyperbolicFunctions<TSelf>?
-    public interface ILogarithmicFunctions<TSelf> : IAdditionOperators<TSelf, TSelf, TSelf>, IAdditiveIdentity<TSelf, TSelf>, IDecrementOperators<TSelf>, IDivisionOperators<TSelf, TSelf, TSelf>, IEqualityOperators<TSelf, TSelf, bool>, IEquatable<TSelf>, IFloatingPointConstants<TSelf>, IFormattable, IIncrementOperators<TSelf>, IMultiplicativeIdentity<TSelf, TSelf>, IMultiplyOperators<TSelf, TSelf, TSelf>, INumberBase<TSelf>, IParsable<TSelf>, ISpanFormattable, ISpanParsable<TSelf>, ISubtractionOperators<TSelf, TSelf, TSelf>, IUnaryNegationOperators<TSelf, TSelf>, IUnaryPlusOperators<TSelf, TSelf> where TSelf : ILogarithmicFunctions<TSelf>?
+    public interface ILogarithmicFunctions<TSelf> : IAdditionOperators<TSelf, TSelf, TSelf>, IAdditiveIdentity<TSelf, TSelf>, IDecrementOperators<TSelf>, IDivisionOperators<TSelf, TSelf, TSelf>, IEqualityOperators<TSelf, TSelf, bool>, IEquatable<TSelf>, IFloatingPointConstants<TSelf>, IFormattable, IIncrementOperators<TSelf>, IMultiplicativeIdentity<TSelf, TSelf>, IMultiplyOperators<TSelf, TSelf, TSelf>, INumberBase<TSelf>, IParsable<TSelf>, ISpanFormattable, ISpanParsable<TSelf>, ISubtractionOperators<TSelf, TSelf, TSelf>, IUnaryNegationOperators<TSelf, TSelf>, IUnaryPlusOperators<TSelf, TSelf>, IUtf8SpanFormattable, IUtf8SpanParsable<TSelf> where TSelf : ILogarithmicFunctions<TSelf>?
-    public interface INumber<TSelf> : IAdditionOperators<TSelf, TSelf, TSelf>, IAdditiveIdentity<TSelf, TSelf>, IComparable, IComparable<TSelf>, IComparisonOperators<TSelf, TSelf, bool>, IDecrementOperators<TSelf>, IDivisionOperators<TSelf, TSelf, TSelf>, IEqualityOperators<TSelf, TSelf, bool>, IEquatable<TSelf>, IFormattable, IIncrementOperators<TSelf>, IModulusOperators<TSelf, TSelf, TSelf>, IMultiplicativeIdentity<TSelf, TSelf>, IMultiplyOperators<TSelf, TSelf, TSelf>, INumberBase<TSelf>, IParsable<TSelf>, ISpanFormattable, ISpanParsable<TSelf>, ISubtractionOperators<TSelf, TSelf, TSelf>, IUnaryNegationOperators<TSelf, TSelf>, IUnaryPlusOperators<TSelf, TSelf> where TSelf : INumber<TSelf>?
+    public interface INumber<TSelf> : IAdditionOperators<TSelf, TSelf, TSelf>, IAdditiveIdentity<TSelf, TSelf>, IComparable, IComparable<TSelf>, IComparisonOperators<TSelf, TSelf, bool>, IDecrementOperators<TSelf>, IDivisionOperators<TSelf, TSelf, TSelf>, IEqualityOperators<TSelf, TSelf, bool>, IEquatable<TSelf>, IFormattable, IIncrementOperators<TSelf>, IModulusOperators<TSelf, TSelf, TSelf>, IMultiplicativeIdentity<TSelf, TSelf>, IMultiplyOperators<TSelf, TSelf, TSelf>, INumberBase<TSelf>, IParsable<TSelf>, ISpanFormattable, ISpanParsable<TSelf>, ISubtractionOperators<TSelf, TSelf, TSelf>, IUnaryNegationOperators<TSelf, TSelf>, IUnaryPlusOperators<TSelf, TSelf>, IUtf8SpanFormattable, IUtf8SpanParsable<TSelf> where TSelf : INumber<TSelf>?
-    public interface INumberBase<TSelf> : IAdditionOperators<TSelf, TSelf, TSelf>, IAdditiveIdentity<TSelf, TSelf>, IDecrementOperators<TSelf>, IDivisionOperators<TSelf, TSelf, TSelf>, IEqualityOperators<TSelf, TSelf, bool>, IEquatable<TSelf>, IFormattable, IIncrementOperators<TSelf>, IMultiplicativeIdentity<TSelf, TSelf>, IMultiplyOperators<TSelf, TSelf, TSelf>, IParsable<TSelf>, ISpanFormattable, ISpanParsable<TSelf>, ISubtractionOperators<TSelf, TSelf, TSelf>, IUnaryNegationOperators<TSelf, TSelf>, IUnaryPlusOperators<TSelf, TSelf> where TSelf : INumberBase<TSelf>? {
+    public interface INumberBase<TSelf> : IAdditionOperators<TSelf, TSelf, TSelf>, IAdditiveIdentity<TSelf, TSelf>, IDecrementOperators<TSelf>, IDivisionOperators<TSelf, TSelf, TSelf>, IEqualityOperators<TSelf, TSelf, bool>, IEquatable<TSelf>, IFormattable, IIncrementOperators<TSelf>, IMultiplicativeIdentity<TSelf, TSelf>, IMultiplyOperators<TSelf, TSelf, TSelf>, IParsable<TSelf>, ISpanFormattable, ISpanParsable<TSelf>, ISubtractionOperators<TSelf, TSelf, TSelf>, IUnaryNegationOperators<TSelf, TSelf>, IUnaryPlusOperators<TSelf, TSelf>, IUtf8SpanFormattable, IUtf8SpanParsable<TSelf> where TSelf : INumberBase<TSelf>? {
+        static TSelf Parse(ReadOnlySpan<byte> utf8Text, NumberStyles style, IFormatProvider? provider);
+        bool IUtf8SpanFormattable.TryFormat(Span<byte> utf8Destination, out int bytesWritten, ReadOnlySpan<char> format, IFormatProvider provider);
+        static TSelf IUtf8SpanParsable<TSelf>.Parse(ReadOnlySpan<byte> utf8Text, IFormatProvider provider);
+        static bool IUtf8SpanParsable<TSelf>.TryParse(ReadOnlySpan<byte> utf8Text, IFormatProvider provider, [MaybeNullWhenAttribute(false)] out TSelf result);
+        static bool TryParse(ReadOnlySpan<byte> utf8Text, NumberStyles style, IFormatProvider? provider, [MaybeNullWhenAttribute(false)] out TSelf result);
     }
-    public interface IPowerFunctions<TSelf> : IAdditionOperators<TSelf, TSelf, TSelf>, IAdditiveIdentity<TSelf, TSelf>, IDecrementOperators<TSelf>, IDivisionOperators<TSelf, TSelf, TSelf>, IEqualityOperators<TSelf, TSelf, bool>, IEquatable<TSelf>, IFormattable, IIncrementOperators<TSelf>, IMultiplicativeIdentity<TSelf, TSelf>, IMultiplyOperators<TSelf, TSelf, TSelf>, INumberBase<TSelf>, IParsable<TSelf>, ISpanFormattable, ISpanParsable<TSelf>, ISubtractionOperators<TSelf, TSelf, TSelf>, IUnaryNegationOperators<TSelf, TSelf>, IUnaryPlusOperators<TSelf, TSelf> where TSelf : IPowerFunctions<TSelf>?
+    public interface IPowerFunctions<TSelf> : IAdditionOperators<TSelf, TSelf, TSelf>, IAdditiveIdentity<TSelf, TSelf>, IDecrementOperators<TSelf>, IDivisionOperators<TSelf, TSelf, TSelf>, IEqualityOperators<TSelf, TSelf, bool>, IEquatable<TSelf>, IFormattable, IIncrementOperators<TSelf>, IMultiplicativeIdentity<TSelf, TSelf>, IMultiplyOperators<TSelf, TSelf, TSelf>, INumberBase<TSelf>, IParsable<TSelf>, ISpanFormattable, ISpanParsable<TSelf>, ISubtractionOperators<TSelf, TSelf, TSelf>, IUnaryNegationOperators<TSelf, TSelf>, IUnaryPlusOperators<TSelf, TSelf>, IUtf8SpanFormattable, IUtf8SpanParsable<TSelf> where TSelf : IPowerFunctions<TSelf>?
-    public interface IRootFunctions<TSelf> : IAdditionOperators<TSelf, TSelf, TSelf>, IAdditiveIdentity<TSelf, TSelf>, IDecrementOperators<TSelf>, IDivisionOperators<TSelf, TSelf, TSelf>, IEqualityOperators<TSelf, TSelf, bool>, IEquatable<TSelf>, IFloatingPointConstants<TSelf>, IFormattable, IIncrementOperators<TSelf>, IMultiplicativeIdentity<TSelf, TSelf>, IMultiplyOperators<TSelf, TSelf, TSelf>, INumberBase<TSelf>, IParsable<TSelf>, ISpanFormattable, ISpanParsable<TSelf>, ISubtractionOperators<TSelf, TSelf, TSelf>, IUnaryNegationOperators<TSelf, TSelf>, IUnaryPlusOperators<TSelf, TSelf> where TSelf : IRootFunctions<TSelf>?
+    public interface IRootFunctions<TSelf> : IAdditionOperators<TSelf, TSelf, TSelf>, IAdditiveIdentity<TSelf, TSelf>, IDecrementOperators<TSelf>, IDivisionOperators<TSelf, TSelf, TSelf>, IEqualityOperators<TSelf, TSelf, bool>, IEquatable<TSelf>, IFloatingPointConstants<TSelf>, IFormattable, IIncrementOperators<TSelf>, IMultiplicativeIdentity<TSelf, TSelf>, IMultiplyOperators<TSelf, TSelf, TSelf>, INumberBase<TSelf>, IParsable<TSelf>, ISpanFormattable, ISpanParsable<TSelf>, ISubtractionOperators<TSelf, TSelf, TSelf>, IUnaryNegationOperators<TSelf, TSelf>, IUnaryPlusOperators<TSelf, TSelf>, IUtf8SpanFormattable, IUtf8SpanParsable<TSelf> where TSelf : IRootFunctions<TSelf>?
-    public interface ISignedNumber<TSelf> : IAdditionOperators<TSelf, TSelf, TSelf>, IAdditiveIdentity<TSelf, TSelf>, IDecrementOperators<TSelf>, IDivisionOperators<TSelf, TSelf, TSelf>, IEqualityOperators<TSelf, TSelf, bool>, IEquatable<TSelf>, IFormattable, IIncrementOperators<TSelf>, IMultiplicativeIdentity<TSelf, TSelf>, IMultiplyOperators<TSelf, TSelf, TSelf>, INumberBase<TSelf>, IParsable<TSelf>, ISpanFormattable, ISpanParsable<TSelf>, ISubtractionOperators<TSelf, TSelf, TSelf>, IUnaryNegationOperators<TSelf, TSelf>, IUnaryPlusOperators<TSelf, TSelf> where TSelf : ISignedNumber<TSelf>?
+    public interface ISignedNumber<TSelf> : IAdditionOperators<TSelf, TSelf, TSelf>, IAdditiveIdentity<TSelf, TSelf>, IDecrementOperators<TSelf>, IDivisionOperators<TSelf, TSelf, TSelf>, IEqualityOperators<TSelf, TSelf, bool>, IEquatable<TSelf>, IFormattable, IIncrementOperators<TSelf>, IMultiplicativeIdentity<TSelf, TSelf>, IMultiplyOperators<TSelf, TSelf, TSelf>, INumberBase<TSelf>, IParsable<TSelf>, ISpanFormattable, ISpanParsable<TSelf>, ISubtractionOperators<TSelf, TSelf, TSelf>, IUnaryNegationOperators<TSelf, TSelf>, IUnaryPlusOperators<TSelf, TSelf>, IUtf8SpanFormattable, IUtf8SpanParsable<TSelf> where TSelf : ISignedNumber<TSelf>?
-    public interface ITrigonometricFunctions<TSelf> : IAdditionOperators<TSelf, TSelf, TSelf>, IAdditiveIdentity<TSelf, TSelf>, IDecrementOperators<TSelf>, IDivisionOperators<TSelf, TSelf, TSelf>, IEqualityOperators<TSelf, TSelf, bool>, IEquatable<TSelf>, IFloatingPointConstants<TSelf>, IFormattable, IIncrementOperators<TSelf>, IMultiplicativeIdentity<TSelf, TSelf>, IMultiplyOperators<TSelf, TSelf, TSelf>, INumberBase<TSelf>, IParsable<TSelf>, ISpanFormattable, ISpanParsable<TSelf>, ISubtractionOperators<TSelf, TSelf, TSelf>, IUnaryNegationOperators<TSelf, TSelf>, IUnaryPlusOperators<TSelf, TSelf> where TSelf : ITrigonometricFunctions<TSelf>? {
+    public interface ITrigonometricFunctions<TSelf> : IAdditionOperators<TSelf, TSelf, TSelf>, IAdditiveIdentity<TSelf, TSelf>, IDecrementOperators<TSelf>, IDivisionOperators<TSelf, TSelf, TSelf>, IEqualityOperators<TSelf, TSelf, bool>, IEquatable<TSelf>, IFloatingPointConstants<TSelf>, IFormattable, IIncrementOperators<TSelf>, IMultiplicativeIdentity<TSelf, TSelf>, IMultiplyOperators<TSelf, TSelf, TSelf>, INumberBase<TSelf>, IParsable<TSelf>, ISpanFormattable, ISpanParsable<TSelf>, ISubtractionOperators<TSelf, TSelf, TSelf>, IUnaryNegationOperators<TSelf, TSelf>, IUnaryPlusOperators<TSelf, TSelf>, IUtf8SpanFormattable, IUtf8SpanParsable<TSelf> where TSelf : ITrigonometricFunctions<TSelf>? {
+        static TSelf DegreesToRadians(TSelf degrees);
+        static TSelf RadiansToDegrees(TSelf radians);
     }
-    public interface IUnsignedNumber<TSelf> : IAdditionOperators<TSelf, TSelf, TSelf>, IAdditiveIdentity<TSelf, TSelf>, IDecrementOperators<TSelf>, IDivisionOperators<TSelf, TSelf, TSelf>, IEqualityOperators<TSelf, TSelf, bool>, IEquatable<TSelf>, IFormattable, IIncrementOperators<TSelf>, IMultiplicativeIdentity<TSelf, TSelf>, IMultiplyOperators<TSelf, TSelf, TSelf>, INumberBase<TSelf>, IParsable<TSelf>, ISpanFormattable, ISpanParsable<TSelf>, ISubtractionOperators<TSelf, TSelf, TSelf>, IUnaryNegationOperators<TSelf, TSelf>, IUnaryPlusOperators<TSelf, TSelf> where TSelf : IUnsignedNumber<TSelf>?
+    public interface IUnsignedNumber<TSelf> : IAdditionOperators<TSelf, TSelf, TSelf>, IAdditiveIdentity<TSelf, TSelf>, IDecrementOperators<TSelf>, IDivisionOperators<TSelf, TSelf, TSelf>, IEqualityOperators<TSelf, TSelf, bool>, IEquatable<TSelf>, IFormattable, IIncrementOperators<TSelf>, IMultiplicativeIdentity<TSelf, TSelf>, IMultiplyOperators<TSelf, TSelf, TSelf>, INumberBase<TSelf>, IParsable<TSelf>, ISpanFormattable, ISpanParsable<TSelf>, ISubtractionOperators<TSelf, TSelf, TSelf>, IUnaryNegationOperators<TSelf, TSelf>, IUnaryPlusOperators<TSelf, TSelf>, IUtf8SpanFormattable, IUtf8SpanParsable<TSelf> where TSelf : IUnsignedNumber<TSelf>?
     public struct Matrix4x4 : IEquatable<Matrix4x4> {
+        public static Matrix4x4 CreateLookAtLeftHanded(Vector3 cameraPosition, Vector3 cameraTarget, Vector3 cameraUpVector);
+        public static Matrix4x4 CreateLookTo(Vector3 cameraPosition, Vector3 cameraDirection, Vector3 cameraUpVector);
+        public static Matrix4x4 CreateLookToLeftHanded(Vector3 cameraPosition, Vector3 cameraDirection, Vector3 cameraUpVector);
+        public static Matrix4x4 CreateOrthographicLeftHanded(float width, float height, float zNearPlane, float zFarPlane);
+        public static Matrix4x4 CreateOrthographicOffCenterLeftHanded(float left, float right, float bottom, float top, float zNearPlane, float zFarPlane);
+        public static Matrix4x4 CreatePerspectiveFieldOfViewLeftHanded(float fieldOfView, float aspectRatio, float nearPlaneDistance, float farPlaneDistance);
+        public static Matrix4x4 CreatePerspectiveLeftHanded(float width, float height, float nearPlaneDistance, float farPlaneDistance);
+        public static Matrix4x4 CreatePerspectiveOffCenterLeftHanded(float left, float right, float bottom, float top, float nearPlaneDistance, float farPlaneDistance);
+        public static Matrix4x4 CreateViewport(float x, float y, float width, float height, float minDepth, float maxDepth);
+        public static Matrix4x4 CreateViewportLeftHanded(float x, float y, float width, float height, float minDepth, float maxDepth);
     }
+    public readonly struct TotalOrderIeee754Comparer<T> : IComparer<T>, IEqualityComparer<T>, IEquatable<TotalOrderIeee754Comparer<T>> where T : IFloatingPointIeee754<T>? {
+        public int Compare(T x, T y);
+        public bool Equals(TotalOrderIeee754Comparer<T> other);
+        public override bool Equals([NotNullWhenAttribute(true)] object obj);
+        public bool Equals(T x, T y);
+        public override int GetHashCode();
+        public int GetHashCode([DisallowNullAttribute] T obj);
+    }
     public static class Vector {
-        public static Vector<T> Abs<T>(Vector<T> value) where T : struct;
+        public static Vector<T> Abs<T>(Vector<T> value);
-        public static Vector<T> Add<T>(Vector<T> left, Vector<T> right) where T : struct;
+        public static Vector<T> Add<T>(Vector<T> left, Vector<T> right);
-        public static Vector<T> AndNot<T>(Vector<T> left, Vector<T> right) where T : struct;
+        public static Vector<T> AndNot<T>(Vector<T> left, Vector<T> right);
-        public static Vector<TTo> As<TFrom, TTo>(this Vector<TFrom> vector) where TFrom : struct where TTo : struct;
+        public static Vector<TTo> As<TFrom, TTo>(this Vector<TFrom> vector);
-        public static Vector<byte> AsVectorByte<T>(Vector<T> value) where T : struct;
+        public static Vector<byte> AsVectorByte<T>(Vector<T> value);
-        public static Vector<double> AsVectorDouble<T>(Vector<T> value) where T : struct;
+        public static Vector<double> AsVectorDouble<T>(Vector<T> value);
-        public static Vector<short> AsVectorInt16<T>(Vector<T> value) where T : struct;
+        public static Vector<short> AsVectorInt16<T>(Vector<T> value);
-        public static Vector<int> AsVectorInt32<T>(Vector<T> value) where T : struct;
+        public static Vector<int> AsVectorInt32<T>(Vector<T> value);
-        public static Vector<long> AsVectorInt64<T>(Vector<T> value) where T : struct;
+        public static Vector<long> AsVectorInt64<T>(Vector<T> value);
-        public static Vector<IntPtr> AsVectorNInt<T>(Vector<T> value) where T : struct;
+        public static Vector<IntPtr> AsVectorNInt<T>(Vector<T> value);
-        [CLSCompliantAttribute(false)]
-        public static Vector<UIntPtr> AsVectorNUInt<T>(Vector<T> value) where T : struct;
+        [CLSCompliantAttribute(false)]
+        public static Vector<UIntPtr> AsVectorNUInt<T>(Vector<T> value);
-        [CLSCompliantAttribute(false)]
-        public static Vector<sbyte> AsVectorSByte<T>(Vector<T> value) where T : struct;
+        [CLSCompliantAttribute(false)]
+        public static Vector<sbyte> AsVectorSByte<T>(Vector<T> value);
-        public static Vector<float> AsVectorSingle<T>(Vector<T> value) where T : struct;
+        public static Vector<float> AsVectorSingle<T>(Vector<T> value);
-        [CLSCompliantAttribute(false)]
-        public static Vector<ushort> AsVectorUInt16<T>(Vector<T> value) where T : struct;
+        [CLSCompliantAttribute(false)]
+        public static Vector<ushort> AsVectorUInt16<T>(Vector<T> value);
-        [CLSCompliantAttribute(false)]
-        public static Vector<uint> AsVectorUInt32<T>(Vector<T> value) where T : struct;
+        [CLSCompliantAttribute(false)]
+        public static Vector<uint> AsVectorUInt32<T>(Vector<T> value);
-        [CLSCompliantAttribute(false)]
-        public static Vector<ulong> AsVectorUInt64<T>(Vector<T> value) where T : struct;
+        [CLSCompliantAttribute(false)]
+        public static Vector<ulong> AsVectorUInt64<T>(Vector<T> value);
-        public static Vector<T> BitwiseAnd<T>(Vector<T> left, Vector<T> right) where T : struct;
+        public static Vector<T> BitwiseAnd<T>(Vector<T> left, Vector<T> right);
-        public static Vector<T> BitwiseOr<T>(Vector<T> left, Vector<T> right) where T : struct;
+        public static Vector<T> BitwiseOr<T>(Vector<T> left, Vector<T> right);
-        public static Vector<T> ConditionalSelect<T>(Vector<T> condition, Vector<T> left, Vector<T> right) where T : struct;
+        public static Vector<T> ConditionalSelect<T>(Vector<T> condition, Vector<T> left, Vector<T> right);
-        public static Vector<T> Divide<T>(Vector<T> left, Vector<T> right) where T : struct;
+        public static Vector<T> Divide<T>(Vector<T> left, Vector<T> right);
+        public static Vector<T> Divide<T>(Vector<T> left, T right);
-        public static T Dot<T>(Vector<T> left, Vector<T> right) where T : struct;
+        public static T Dot<T>(Vector<T> left, Vector<T> right);
-        public static Vector<T> Equals<T>(Vector<T> left, Vector<T> right) where T : struct;
+        public static Vector<T> Equals<T>(Vector<T> left, Vector<T> right);
-        public static bool EqualsAll<T>(Vector<T> left, Vector<T> right) where T : struct;
+        public static bool EqualsAll<T>(Vector<T> left, Vector<T> right);
-        public static bool EqualsAny<T>(Vector<T> left, Vector<T> right) where T : struct;
+        public static bool EqualsAny<T>(Vector<T> left, Vector<T> right);
+        public static T GetElement<T>(this Vector<T> vector, int index);
-        public static Vector<T> GreaterThan<T>(Vector<T> left, Vector<T> right) where T : struct;
+        public static Vector<T> GreaterThan<T>(Vector<T> left, Vector<T> right);
-        public static bool GreaterThanAll<T>(Vector<T> left, Vector<T> right) where T : struct;
+        public static bool GreaterThanAll<T>(Vector<T> left, Vector<T> right);
-        public static bool GreaterThanAny<T>(Vector<T> left, Vector<T> right) where T : struct;
+        public static bool GreaterThanAny<T>(Vector<T> left, Vector<T> right);
-        public static Vector<T> GreaterThanOrEqual<T>(Vector<T> left, Vector<T> right) where T : struct;
+        public static Vector<T> GreaterThanOrEqual<T>(Vector<T> left, Vector<T> right);
-        public static bool GreaterThanOrEqualAll<T>(Vector<T> left, Vector<T> right) where T : struct;
+        public static bool GreaterThanOrEqualAll<T>(Vector<T> left, Vector<T> right);
-        public static bool GreaterThanOrEqualAny<T>(Vector<T> left, Vector<T> right) where T : struct;
+        public static bool GreaterThanOrEqualAny<T>(Vector<T> left, Vector<T> right);
-        public static Vector<T> LessThan<T>(Vector<T> left, Vector<T> right) where T : struct;
+        public static Vector<T> LessThan<T>(Vector<T> left, Vector<T> right);
-        public static bool LessThanAll<T>(Vector<T> left, Vector<T> right) where T : struct;
+        public static bool LessThanAll<T>(Vector<T> left, Vector<T> right);
-        public static bool LessThanAny<T>(Vector<T> left, Vector<T> right) where T : struct;
+        public static bool LessThanAny<T>(Vector<T> left, Vector<T> right);
-        public static Vector<T> LessThanOrEqual<T>(Vector<T> left, Vector<T> right) where T : struct;
+        public static Vector<T> LessThanOrEqual<T>(Vector<T> left, Vector<T> right);
-        public static bool LessThanOrEqualAll<T>(Vector<T> left, Vector<T> right) where T : struct;
+        public static bool LessThanOrEqualAll<T>(Vector<T> left, Vector<T> right);
-        public static bool LessThanOrEqualAny<T>(Vector<T> left, Vector<T> right) where T : struct;
+        public static bool LessThanOrEqualAny<T>(Vector<T> left, Vector<T> right);
+        [CLSCompliantAttribute(false)]
+        public unsafe static Vector<T> Load<T>(T* source);
+        [CLSCompliantAttribute(false)]
+        public unsafe static Vector<T> LoadAligned<T>(T* source);
+        [CLSCompliantAttribute(false)]
+        public unsafe static Vector<T> LoadAlignedNonTemporal<T>(T* source);
+        public static Vector<T> LoadUnsafe<T>([RequiresLocationAttribute] ref T source);
+        [CLSCompliantAttribute(false)]
+        public static Vector<T> LoadUnsafe<T>([RequiresLocationAttribute] ref T source, UIntPtr elementOffset);
-        public static Vector<T> Max<T>(Vector<T> left, Vector<T> right) where T : struct;
+        public static Vector<T> Max<T>(Vector<T> left, Vector<T> right);
-        public static Vector<T> Min<T>(Vector<T> left, Vector<T> right) where T : struct;
+        public static Vector<T> Min<T>(Vector<T> left, Vector<T> right);
-        public static Vector<T> Multiply<T>(Vector<T> left, Vector<T> right) where T : struct;
+        public static Vector<T> Multiply<T>(Vector<T> left, Vector<T> right);
-        public static Vector<T> Multiply<T>(Vector<T> left, T right) where T : struct;
+        public static Vector<T> Multiply<T>(Vector<T> left, T right);
-        public static Vector<T> Multiply<T>(T left, Vector<T> right) where T : struct;
+        public static Vector<T> Multiply<T>(T left, Vector<T> right);
-        public static Vector<T> Negate<T>(Vector<T> value) where T : struct;
+        public static Vector<T> Negate<T>(Vector<T> value);
-        public static Vector<T> OnesComplement<T>(Vector<T> value) where T : struct;
+        public static Vector<T> OnesComplement<T>(Vector<T> value);
-        public static Vector<T> SquareRoot<T>(Vector<T> value) where T : struct;
+        public static Vector<T> SquareRoot<T>(Vector<T> value);
+        [CLSCompliantAttribute(false)]
+        public unsafe static void Store<T>(this Vector<T> source, T* destination);
+        [CLSCompliantAttribute(false)]
+        public unsafe static void StoreAligned<T>(this Vector<T> source, T* destination);
+        [CLSCompliantAttribute(false)]
+        public unsafe static void StoreAlignedNonTemporal<T>(this Vector<T> source, T* destination);
+        public static void StoreUnsafe<T>(this Vector<T> source, ref T destination);
+        [CLSCompliantAttribute(false)]
+        public static void StoreUnsafe<T>(this Vector<T> source, ref T destination, UIntPtr elementOffset);
-        public static Vector<T> Subtract<T>(Vector<T> left, Vector<T> right) where T : struct;
+        public static Vector<T> Subtract<T>(Vector<T> left, Vector<T> right);
-        public static T Sum<T>(Vector<T> value) where T : struct;
+        public static T Sum<T>(Vector<T> value);
+        public static T ToScalar<T>(this Vector<T> vector);
+        [CLSCompliantAttribute(false)]
+        public static Vector<ushort> WidenLower(Vector<byte> source);
+        public static Vector<int> WidenLower(Vector<short> source);
+        public static Vector<long> WidenLower(Vector<int> source);
+        [CLSCompliantAttribute(false)]
+        public static Vector<short> WidenLower(Vector<sbyte> source);
+        public static Vector<double> WidenLower(Vector<float> source);
+        [CLSCompliantAttribute(false)]
+        public static Vector<uint> WidenLower(Vector<ushort> source);
+        [CLSCompliantAttribute(false)]
+        public static Vector<ulong> WidenLower(Vector<uint> source);
+        [CLSCompliantAttribute(false)]
+        public static Vector<ushort> WidenUpper(Vector<byte> source);
+        public static Vector<int> WidenUpper(Vector<short> source);
+        public static Vector<long> WidenUpper(Vector<int> source);
+        [CLSCompliantAttribute(false)]
+        public static Vector<short> WidenUpper(Vector<sbyte> source);
+        public static Vector<double> WidenUpper(Vector<float> source);
+        [CLSCompliantAttribute(false)]
+        public static Vector<uint> WidenUpper(Vector<ushort> source);
+        [CLSCompliantAttribute(false)]
+        public static Vector<ulong> WidenUpper(Vector<uint> source);
+        public static Vector<T> WithElement<T>(this Vector<T> vector, int index, T value);
-        public static Vector<T> Xor<T>(Vector<T> left, Vector<T> right) where T : struct;
+        public static Vector<T> Xor<T>(Vector<T> left, Vector<T> right);
     }
-    public readonly struct Vector<T> : IEquatable<Vector<T>>, IFormattable where T : struct {
+    public readonly struct Vector<T> : IEquatable<Vector<T>>, IFormattable {
+        public static Vector<T> AllBitsSet { get; }
+        public static Vector<T> operator /(Vector<T> left, T right);
+        public static Vector<T> operator <<(Vector<T> value, int shiftCount);
+        public static Vector<T> operator >>(Vector<T> value, int shiftCount);
+        public static Vector<T> operator +(Vector<T> value);
+        public static Vector<T> operator >>>(Vector<T> value, int shiftCount);
     }
 }
```

