# System.Reflection.Emit

``` diff
 namespace System.Reflection.Emit {
-    public sealed class AssemblyBuilder : Assembly {
+    public abstract class AssemblyBuilder : Assembly {
+        protected AssemblyBuilder();
+        protected abstract ModuleBuilder DefineDynamicModuleCore(string name);
+        protected abstract ModuleBuilder? GetDynamicModuleCore(string name);
+        protected abstract void SetCustomAttributeCore(ConstructorInfo con, ReadOnlySpan<byte> binaryAttribute);
     }
-    public sealed class ConstructorBuilder : ConstructorInfo {
+    public abstract class ConstructorBuilder : ConstructorInfo {
+        protected ConstructorBuilder();
+        protected abstract bool InitLocalsCore { get; set; }
+        protected abstract ParameterBuilder DefineParameterCore(int iSequence, ParameterAttributes attributes, string strParamName);
+        protected abstract ILGenerator GetILGeneratorCore(int streamSize);
+        protected abstract void SetCustomAttributeCore(ConstructorInfo con, ReadOnlySpan<byte> binaryAttribute);
+        protected abstract void SetImplementationFlagsCore(MethodImplAttributes attributes);
     }
-    public sealed class EnumBuilder : TypeInfo {
+    public abstract class EnumBuilder : TypeInfo {
+        protected EnumBuilder();
+        protected abstract FieldBuilder UnderlyingFieldCore { get; }
+        protected abstract TypeInfo CreateTypeInfoCore();
+        protected abstract FieldBuilder DefineLiteralCore(string literalName, object? literalValue);
+        protected abstract void SetCustomAttributeCore(ConstructorInfo con, ReadOnlySpan<byte> binaryAttribute);
     }
-    public sealed class EventBuilder {
+    public abstract class EventBuilder {
+        protected EventBuilder();
+        protected abstract void AddOtherMethodCore(MethodBuilder mdBuilder);
+        protected abstract void SetAddOnMethodCore(MethodBuilder mdBuilder);
+        protected abstract void SetCustomAttributeCore(ConstructorInfo con, ReadOnlySpan<byte> binaryAttribute);
+        protected abstract void SetRaiseMethodCore(MethodBuilder mdBuilder);
+        protected abstract void SetRemoveOnMethodCore(MethodBuilder mdBuilder);
     }
-    public sealed class FieldBuilder : FieldInfo {
+    public abstract class FieldBuilder : FieldInfo {
+        protected FieldBuilder();
+        protected abstract void SetConstantCore(object? defaultValue);
+        protected abstract void SetCustomAttributeCore(ConstructorInfo con, ReadOnlySpan<byte> binaryAttribute);
+        protected abstract void SetOffsetCore(int iOffset);
     }
-    public sealed class GenericTypeParameterBuilder : TypeInfo {
+    public abstract class GenericTypeParameterBuilder : TypeInfo {
+        protected GenericTypeParameterBuilder();
+        protected abstract void SetBaseTypeConstraintCore(Type? baseTypeConstraint);
+        protected abstract void SetCustomAttributeCore(ConstructorInfo con, ReadOnlySpan<byte> binaryAttribute);
+        protected abstract void SetGenericParameterAttributesCore(GenericParameterAttributes genericParameterAttributes);
+        protected abstract void SetInterfaceConstraintsCore(params Type[]? interfaceConstraints);
     }
-    public class ILGenerator {
+    public abstract class ILGenerator {
+        protected ILGenerator();
-        public virtual int ILOffset { get; }
+        public abstract int ILOffset { get; }
-        public virtual void BeginCatchBlock(Type? exceptionType);
+        public abstract void BeginCatchBlock(Type? exceptionType);
-        public virtual void BeginExceptFilterBlock();
+        public abstract void BeginExceptFilterBlock();
-        public virtual Label BeginExceptionBlock();
+        public abstract Label BeginExceptionBlock();
-        public virtual void BeginFaultBlock();
+        public abstract void BeginFaultBlock();
-        public virtual void BeginFinallyBlock();
+        public abstract void BeginFinallyBlock();
-        public virtual void BeginScope();
+        public abstract void BeginScope();
-        public virtual LocalBuilder DeclareLocal(Type localType, bool pinned);
+        public abstract LocalBuilder DeclareLocal(Type localType, bool pinned);
-        public virtual Label DefineLabel();
+        public abstract Label DefineLabel();
-        public virtual void Emit(OpCode opcode);
+        public abstract void Emit(OpCode opcode);
-        public virtual void Emit(OpCode opcode, byte arg);
+        public abstract void Emit(OpCode opcode, byte arg);
-        public virtual void Emit(OpCode opcode, double arg);
+        public abstract void Emit(OpCode opcode, double arg);
-        public virtual void Emit(OpCode opcode, short arg);
+        public abstract void Emit(OpCode opcode, short arg);
-        public virtual void Emit(OpCode opcode, int arg);
+        public abstract void Emit(OpCode opcode, int arg);
-        public virtual void Emit(OpCode opcode, long arg);
+        public abstract void Emit(OpCode opcode, long arg);
-        public virtual void Emit(OpCode opcode, ConstructorInfo con);
+        public abstract void Emit(OpCode opcode, ConstructorInfo con);
-        public virtual void Emit(OpCode opcode, Label label);
+        public abstract void Emit(OpCode opcode, Label label);
-        public virtual void Emit(OpCode opcode, Label[] labels);
+        public abstract void Emit(OpCode opcode, Label[] labels);
-        public virtual void Emit(OpCode opcode, LocalBuilder local);
+        public abstract void Emit(OpCode opcode, LocalBuilder local);
-        public virtual void Emit(OpCode opcode, SignatureHelper signature);
+        public abstract void Emit(OpCode opcode, SignatureHelper signature);
-        public virtual void Emit(OpCode opcode, FieldInfo field);
+        public abstract void Emit(OpCode opcode, FieldInfo field);
-        public virtual void Emit(OpCode opcode, MethodInfo meth);
+        public abstract void Emit(OpCode opcode, MethodInfo meth);
-        public virtual void Emit(OpCode opcode, float arg);
+        public abstract void Emit(OpCode opcode, float arg);
-        public virtual void Emit(OpCode opcode, string str);
+        public abstract void Emit(OpCode opcode, string str);
-        public virtual void Emit(OpCode opcode, Type cls);
+        public abstract void Emit(OpCode opcode, Type cls);
-        public virtual void EmitCall(OpCode opcode, MethodInfo methodInfo, Type[]? optionalParameterTypes);
+        public abstract void EmitCall(OpCode opcode, MethodInfo methodInfo, Type[]? optionalParameterTypes);
-        public virtual void EmitCalli(OpCode opcode, CallingConventions callingConvention, Type? returnType, Type[]? parameterTypes, Type[]? optionalParameterTypes);
+        public abstract void EmitCalli(OpCode opcode, CallingConventions callingConvention, Type? returnType, Type[]? parameterTypes, Type[]? optionalParameterTypes);
-        public virtual void EmitCalli(OpCode opcode, CallingConvention unmanagedCallConv, Type? returnType, Type[]? parameterTypes);
+        public abstract void EmitCalli(OpCode opcode, CallingConvention unmanagedCallConv, Type? returnType, Type[]? parameterTypes);
-        public virtual void EndExceptionBlock();
+        public abstract void EndExceptionBlock();
-        public virtual void EndScope();
+        public abstract void EndScope();
-        public virtual void MarkLabel(Label loc);
+        public abstract void MarkLabel(Label loc);
-        public virtual void UsingNamespace(string usingNamespace);
+        public abstract void UsingNamespace(string usingNamespace);
     }
-    public sealed class MethodBuilder : MethodInfo {
+    public abstract class MethodBuilder : MethodInfo {
+        protected MethodBuilder();
+        protected abstract bool InitLocalsCore { get; set; }
+        protected abstract GenericTypeParameterBuilder[] DefineGenericParametersCore(params string[] names);
+        protected abstract ParameterBuilder DefineParameterCore(int position, ParameterAttributes attributes, string? strParamName);
+        protected abstract ILGenerator GetILGeneratorCore(int size);
+        protected abstract void SetCustomAttributeCore(ConstructorInfo con, ReadOnlySpan<byte> binaryAttribute);
+        protected abstract void SetImplementationFlagsCore(MethodImplAttributes attributes);
+        protected abstract void SetSignatureCore(Type? returnType, Type[]? returnTypeRequiredCustomModifiers, Type[]? returnTypeOptionalCustomModifiers, Type[]? parameterTypes, Type[][]? parameterTypeRequiredCustomModifiers, Type[][]? parameterTypeOptionalCustomModifiers);
     }
-    public class ModuleBuilder : Module {
+    public abstract class ModuleBuilder : Module {
+        protected ModuleBuilder();
+        protected abstract void CreateGlobalFunctionsCore();
+        protected abstract EnumBuilder DefineEnumCore(string name, TypeAttributes visibility, Type underlyingType);
+        protected abstract MethodBuilder DefineGlobalMethodCore(string name, MethodAttributes attributes, CallingConventions callingConvention, Type? returnType, Type[]? requiredReturnTypeCustomModifiers, Type[]? optionalReturnTypeCustomModifiers, Type[]? parameterTypes, Type[][]? requiredParameterTypeCustomModifiers, Type[][]? optionalParameterTypeCustomModifiers);
+        protected abstract FieldBuilder DefineInitializedDataCore(string name, byte[] data, FieldAttributes attributes);
+        [RequiresUnreferencedCodeAttribute("P/Invoke marshalling may dynamically access members that could be trimmed.")]
+        protected abstract MethodBuilder DefinePInvokeMethodCore(string name, string dllName, string entryName, MethodAttributes attributes, CallingConventions callingConvention, Type? returnType, Type[]? parameterTypes, CallingConvention nativeCallConv, CharSet nativeCharSet);
+        protected abstract TypeBuilder DefineTypeCore(string name, TypeAttributes attr, Type? parent, Type[]? interfaces, PackingSize packingSize, int typesize);
+        protected abstract FieldBuilder DefineUninitializedDataCore(string name, int size, FieldAttributes attributes);
+        protected abstract MethodInfo GetArrayMethodCore(Type arrayClass, string methodName, CallingConventions callingConvention, Type? returnType, Type[]? parameterTypes);
+        public abstract int GetFieldMetadataToken(FieldInfo field);
+        public abstract int GetMethodMetadataToken(ConstructorInfo constructor);
+        public abstract int GetMethodMetadataToken(MethodInfo method);
+        public abstract int GetSignatureMetadataToken(SignatureHelper signature);
+        public abstract int GetStringMetadataToken(string stringConstant);
+        public abstract int GetTypeMetadataToken(Type type);
+        protected abstract void SetCustomAttributeCore(ConstructorInfo con, ReadOnlySpan<byte> binaryAttribute);
     }
-    public class ParameterBuilder {
+    public abstract class ParameterBuilder {
+        protected ParameterBuilder();
+        protected abstract void SetCustomAttributeCore(ConstructorInfo con, ReadOnlySpan<byte> binaryAttribute);
     }
-    public sealed class PropertyBuilder : PropertyInfo {
+    public abstract class PropertyBuilder : PropertyInfo {
+        protected PropertyBuilder();
+        protected abstract void AddOtherMethodCore(MethodBuilder mdBuilder);
+        protected abstract void SetConstantCore(object? defaultValue);
+        protected abstract void SetCustomAttributeCore(ConstructorInfo con, ReadOnlySpan<byte> binaryAttribute);
+        protected abstract void SetGetMethodCore(MethodBuilder mdBuilder);
+        protected abstract void SetSetMethodCore(MethodBuilder mdBuilder);
     }
-    public sealed class TypeBuilder : TypeInfo {
+    public abstract class TypeBuilder : TypeInfo {
+        protected TypeBuilder();
+        protected abstract PackingSize PackingSizeCore { get; }
+        protected abstract int SizeCore { get; }
+        protected abstract void AddInterfaceImplementationCore(Type interfaceType);
+        protected abstract TypeInfo CreateTypeInfoCore();
+        protected abstract ConstructorBuilder DefineConstructorCore(MethodAttributes attributes, CallingConventions callingConvention, Type[]? parameterTypes, Type[][]? requiredCustomModifiers, Type[][]? optionalCustomModifiers);
+        protected abstract ConstructorBuilder DefineDefaultConstructorCore(MethodAttributes attributes);
+        protected abstract EventBuilder DefineEventCore(string name, EventAttributes attributes, Type eventtype);
+        protected abstract FieldBuilder DefineFieldCore(string fieldName, Type type, Type[]? requiredCustomModifiers, Type[]? optionalCustomModifiers, FieldAttributes attributes);
+        protected abstract GenericTypeParameterBuilder[] DefineGenericParametersCore(params string[] names);
+        protected abstract FieldBuilder DefineInitializedDataCore(string name, byte[] data, FieldAttributes attributes);
+        protected abstract MethodBuilder DefineMethodCore(string name, MethodAttributes attributes, CallingConventions callingConvention, Type? returnType, Type[]? returnTypeRequiredCustomModifiers, Type[]? returnTypeOptionalCustomModifiers, Type[]? parameterTypes, Type[][]? parameterTypeRequiredCustomModifiers, Type[][]? parameterTypeOptionalCustomModifiers);
+        protected abstract void DefineMethodOverrideCore(MethodInfo methodInfoBody, MethodInfo methodInfoDeclaration);
+        protected abstract TypeBuilder DefineNestedTypeCore(string name, TypeAttributes attr, Type? parent, Type[]? interfaces, PackingSize packSize, int typeSize);
+        [RequiresUnreferencedCodeAttribute("P/Invoke marshalling may dynamically access members that could be trimmed.")]
+        protected abstract MethodBuilder DefinePInvokeMethodCore(string name, string dllName, string entryName, MethodAttributes attributes, CallingConventions callingConvention, Type? returnType, Type[]? returnTypeRequiredCustomModifiers, Type[]? returnTypeOptionalCustomModifiers, Type[]? parameterTypes, Type[][]? parameterTypeRequiredCustomModifiers, Type[][]? parameterTypeOptionalCustomModifiers, CallingConvention nativeCallConv, CharSet nativeCharSet);
+        protected abstract PropertyBuilder DefinePropertyCore(string name, PropertyAttributes attributes, CallingConventions callingConvention, Type returnType, Type[]? returnTypeRequiredCustomModifiers, Type[]? returnTypeOptionalCustomModifiers, Type[]? parameterTypes, Type[][]? parameterTypeRequiredCustomModifiers, Type[][]? parameterTypeOptionalCustomModifiers);
+        protected abstract ConstructorBuilder DefineTypeInitializerCore();
+        protected abstract FieldBuilder DefineUninitializedDataCore(string name, int size, FieldAttributes attributes);
+        protected abstract bool IsCreatedCore();
+        protected abstract void SetCustomAttributeCore(ConstructorInfo con, ReadOnlySpan<byte> binaryAttribute);
+        protected abstract void SetParentCore(Type? parent);
     }
 }
```

