# System.Reflection

``` diff
 namespace System.Reflection {
     public abstract class Assembly : ICustomAttributeProvider, ISerializable {
-        public virtual void GetObjectData(SerializationInfo info, StreamingContext context);
+        [EditorBrowsableAttribute(EditorBrowsableState.Never)]
+        [ObsoleteAttribute("This API supports obsolete formatter-based serialization. It should not be called or extended by application code.", DiagnosticId="SYSLIB0051", UrlFormat="https://aka.ms/dotnet-warnings/{0}")]
+        public virtual void GetObjectData(SerializationInfo info, StreamingContext context);
     }
     public sealed class AssemblyName : ICloneable, IDeserializationCallback, ISerializable {
-        public void GetObjectData(SerializationInfo info, StreamingContext context);
+        [EditorBrowsableAttribute(EditorBrowsableState.Never)]
+        [ObsoleteAttribute("This API supports obsolete formatter-based serialization. It should not be called or extended by application code.", DiagnosticId="SYSLIB0051", UrlFormat="https://aka.ms/dotnet-warnings/{0}")]
+        public void GetObjectData(SerializationInfo info, StreamingContext context);
     }
+    public sealed class ConstructorInvoker {
+        public static ConstructorInvoker Create(ConstructorInfo constructor);
+        public object Invoke();
+        public object Invoke(object? arg1);
+        public object Invoke(object? arg1, object? arg2);
+        public object Invoke(object? arg1, object? arg2, object? arg3);
+        public object Invoke(object? arg1, object? arg2, object? arg3, object? arg4);
+        public object Invoke(Span<object?> arguments);
+    }
     public class CustomAttributeFormatException : FormatException {
-        protected CustomAttributeFormatException(SerializationInfo info, StreamingContext context);
+        [EditorBrowsableAttribute(EditorBrowsableState.Never)]
+        [ObsoleteAttribute("This API supports obsolete formatter-based serialization. It should not be called or extended by application code.", DiagnosticId="SYSLIB0051", UrlFormat="https://aka.ms/dotnet-warnings/{0}")]
+        protected CustomAttributeFormatException(SerializationInfo info, StreamingContext context);
     }
     public abstract class DispatchProxy {
+        public static object Create(Type interfaceType, Type proxyType);
     }
     [FlagsAttribute]
     public enum FieldAttributes {
-        NotSerialized = 128,
+        [ObsoleteAttribute("Formatter-based serialization is obsolete and should not be used.", DiagnosticId="SYSLIB0050", UrlFormat="https://aka.ms/dotnet-warnings/{0}")]
+        NotSerialized = 128,
     }
     public abstract class FieldInfo : MemberInfo {
-        public bool IsNotSerialized { get; }
+        [ObsoleteAttribute("Formatter-based serialization is obsolete and should not be used.", DiagnosticId="SYSLIB0050", UrlFormat="https://aka.ms/dotnet-warnings/{0}")]
+        public bool IsNotSerialized { get; }
-        public override bool Equals(object obj);
+        public override bool Equals(object? obj);
+        public virtual Type GetModifiedFieldType();
-        public virtual object GetRawConstantValue();
+        public virtual object? GetRawConstantValue();
-        public abstract object GetValue(object obj);
+        public abstract object? GetValue(object? obj);
-        [CLSCompliantAttribute(false)]
-        public virtual object GetValueDirect(TypedReference obj);
+        [CLSCompliantAttribute(false)]
+        public virtual object? GetValueDirect(TypedReference obj);
-        public static bool operator ==(FieldInfo left, FieldInfo right);
+        public static bool operator ==(FieldInfo? left, FieldInfo? right);
-        public static bool operator !=(FieldInfo left, FieldInfo right);
+        public static bool operator !=(FieldInfo? left, FieldInfo? right);
-        public void SetValue(object obj, object value);
+        public void SetValue(object? obj, object? value);
-        public abstract void SetValue(object obj, object value, BindingFlags invokeAttr, Binder binder, CultureInfo culture);
+        public abstract void SetValue(object? obj, object? value, BindingFlags invokeAttr, Binder? binder, CultureInfo? culture);
     }
-    public static class IntrospectionExtensions {
+    [EditorBrowsableAttribute(EditorBrowsableState.Never)]
+    public static class IntrospectionExtensions {
-        public static TypeInfo GetTypeInfo(this Type type);
+        [EditorBrowsableAttribute(EditorBrowsableState.Never)]
+        public static TypeInfo GetTypeInfo(this Type type);
     }
     public class InvalidFilterCriteriaException : ApplicationException {
-        protected InvalidFilterCriteriaException(SerializationInfo info, StreamingContext context);
+        [EditorBrowsableAttribute(EditorBrowsableState.Never)]
+        [ObsoleteAttribute("This API supports obsolete formatter-based serialization. It should not be called or extended by application code.", DiagnosticId="SYSLIB0051", UrlFormat="https://aka.ms/dotnet-warnings/{0}")]
+        protected InvalidFilterCriteriaException(SerializationInfo info, StreamingContext context);
     }
+    public sealed class MethodInvoker {
+        public static MethodInvoker Create(MethodBase method);
+        public object Invoke(object obj);
+        public object Invoke(object obj, object arg1);
+        public object Invoke(object obj, object arg1, object arg2);
+        public object Invoke(object obj, object arg1, object arg2, object arg3);
+        public object Invoke(object obj, object arg1, object arg2, object arg3, object arg4);
+        public object Invoke(object obj, Span<object?> arguments);
+    }
     public abstract class Module : ICustomAttributeProvider, ISerializable {
-        public virtual void GetObjectData(SerializationInfo info, StreamingContext context);
+        [EditorBrowsableAttribute(EditorBrowsableState.Never)]
+        [ObsoleteAttribute("This API supports obsolete formatter-based serialization. It should not be called or extended by application code.", DiagnosticId="SYSLIB0051", UrlFormat="https://aka.ms/dotnet-warnings/{0}")]
+        public virtual void GetObjectData(SerializationInfo info, StreamingContext context);
     }
     public class ParameterInfo : ICustomAttributeProvider, IObjectReference {
+        public virtual Type GetModifiedParameterType();
-        public object GetRealObject(StreamingContext context);
+        [EditorBrowsableAttribute(EditorBrowsableState.Never)]
+        [ObsoleteAttribute("This API supports obsolete formatter-based serialization. It should not be called or extended by application code.", DiagnosticId="SYSLIB0051", UrlFormat="https://aka.ms/dotnet-warnings/{0}")]
+        public object GetRealObject(StreamingContext context);
     }
     public abstract class PropertyInfo : MemberInfo {
+        public virtual Type GetModifiedPropertyType();
     }
-    public sealed class ReflectionTypeLoadException : SystemException, ISerializable {
+    public sealed class ReflectionTypeLoadException : SystemException {
-        public override void GetObjectData(SerializationInfo info, StreamingContext context);
+        [EditorBrowsableAttribute(EditorBrowsableState.Never)]
+        [ObsoleteAttribute("This API supports obsolete formatter-based serialization. It should not be called or extended by application code.", DiagnosticId="SYSLIB0051", UrlFormat="https://aka.ms/dotnet-warnings/{0}")]
+        public override void GetObjectData(SerializationInfo info, StreamingContext context);
     }
     [ObsoleteAttribute("Strong name signing is not supported and throws PlatformNotSupportedException.", DiagnosticId="SYSLIB0017", UrlFormat="https://aka.ms/dotnet-warnings/{0}")]
     public class StrongNameKeyPair : IDeserializationCallback, ISerializable {
-        protected StrongNameKeyPair(SerializationInfo info, StreamingContext context);
+        [EditorBrowsableAttribute(EditorBrowsableState.Never)]
+        [ObsoleteAttribute("This API supports obsolete formatter-based serialization. It should not be called or extended by application code.", DiagnosticId="SYSLIB0051", UrlFormat="https://aka.ms/dotnet-warnings/{0}")]
+        protected StrongNameKeyPair(SerializationInfo info, StreamingContext context);
     }
     public class TargetException : ApplicationException {
-        protected TargetException(SerializationInfo info, StreamingContext context);
+        [EditorBrowsableAttribute(EditorBrowsableState.Never)]
+        [ObsoleteAttribute("This API supports obsolete formatter-based serialization. It should not be called or extended by application code.", DiagnosticId="SYSLIB0051", UrlFormat="https://aka.ms/dotnet-warnings/{0}")]
+        protected TargetException(SerializationInfo info, StreamingContext context);
     }
     [FlagsAttribute]
     public enum TypeAttributes {
-        Serializable = 8192,
+        [ObsoleteAttribute("Formatter-based serialization is obsolete and should not be used.", DiagnosticId="SYSLIB0050", UrlFormat="https://aka.ms/dotnet-warnings/{0}")]
+        Serializable = 8192,
     }
     public class TypeDelegator : TypeInfo {
+        public override bool IsFunctionPointer { get; }
+        public override bool IsUnmanagedFunctionPointer { get; }
+        public override Type[] GetFunctionPointerCallingConventions();
+        public override Type[] GetFunctionPointerParameterTypes();
+        public override Type GetFunctionPointerReturnType();
     }
 }
```

