# System.Runtime.CompilerServices

``` diff
 namespace System.Runtime.CompilerServices {
+    [AttributeUsageAttribute(AttributeTargets.Class | AttributeTargets.Interface | AttributeTargets.Struct, Inherited=false)]
+    public sealed class CollectionBuilderAttribute : Attribute {
+        public CollectionBuilderAttribute(Type builderType, string methodName);
+        public Type BuilderType { get; }
+        public string MethodName { get; }
+    }
     [InterpolatedStringHandlerAttribute]
     public ref struct DefaultInterpolatedStringHandler {
         public void AppendFormatted([ScopedRefAttribute] ReadOnlySpan<char> value);
         public void AppendFormatted([ScopedRefAttribute] ReadOnlySpan<char> value, int alignment = 0, string? format = null);
     }
+    [AttributeUsageAttribute(AttributeTargets.Struct, AllowMultiple=false)]
+    [EditorBrowsableAttribute(EditorBrowsableState.Never)]
+    public sealed class InlineArrayAttribute : Attribute {
+        public InlineArrayAttribute(int length);
+        public int Length { get; }
+    }
+    [AttributeUsageAttribute(AttributeTargets.All)]
+    [EditorBrowsableAttribute(EditorBrowsableState.Never)]
+    public sealed class IsUnmanagedAttribute : Attribute {
+        public IsUnmanagedAttribute();
+    }
+    [AttributeUsageAttribute(AttributeTargets.Class | AttributeTargets.Event | AttributeTargets.Field | AttributeTargets.GenericParameter | AttributeTargets.Parameter | AttributeTargets.Property | AttributeTargets.ReturnValue, Inherited=false)]
+    [EditorBrowsableAttribute(EditorBrowsableState.Never)]
+    public sealed class NullableAttribute : Attribute {
+        public readonly byte[] NullableFlags;
+        public NullableAttribute(byte value);
+        public NullableAttribute(byte[] value);
+    }
+    [AttributeUsageAttribute(AttributeTargets.Class | AttributeTargets.Delegate | AttributeTargets.Interface | AttributeTargets.Method | AttributeTargets.Struct, Inherited=false)]
+    [EditorBrowsableAttribute(EditorBrowsableState.Never)]
+    public sealed class NullableContextAttribute : Attribute {
+        public readonly byte Flag;
+        public NullableContextAttribute(byte value);
+    }
+    [AttributeUsageAttribute(AttributeTargets.Module, Inherited=false)]
+    [EditorBrowsableAttribute(EditorBrowsableState.Never)]
+    public sealed class NullablePublicOnlyAttribute : Attribute {
+        public readonly bool IncludesInternals;
+        public NullablePublicOnlyAttribute(bool value);
+    }
+    [AttributeUsageAttribute(AttributeTargets.Module, Inherited=false)]
+    [EditorBrowsableAttribute(EditorBrowsableState.Never)]
+    public sealed class RefSafetyRulesAttribute : Attribute {
+        public RefSafetyRulesAttribute(int version);
+        public int Version { get; }
+    }
-    [AttributeUsageAttribute(AttributeTargets.Class | AttributeTargets.Field | AttributeTargets.Property | AttributeTargets.Struct, AllowMultiple=false, Inherited=false)]
-    public sealed class RequiredMemberAttribute : Attribute
+    [AttributeUsageAttribute(AttributeTargets.Class | AttributeTargets.Field | AttributeTargets.Property | AttributeTargets.Struct, AllowMultiple=false, Inherited=false)]
+    [EditorBrowsableAttribute(EditorBrowsableState.Never)]
+    public sealed class RequiredMemberAttribute : Attribute
+    [AttributeUsageAttribute(AttributeTargets.Parameter, Inherited=false)]
+    [EditorBrowsableAttribute(EditorBrowsableState.Never)]
+    public sealed class RequiresLocationAttribute : Attribute {
+        public RequiresLocationAttribute();
+    }
     public sealed class RuntimeWrappedException : Exception {
-        public override void GetObjectData(SerializationInfo info, StreamingContext context);
+        [EditorBrowsableAttribute(EditorBrowsableState.Never)]
+        [ObsoleteAttribute("This API supports obsolete formatter-based serialization. It should not be called or extended by application code.", DiagnosticId="SYSLIB0051", UrlFormat="https://aka.ms/dotnet-warnings/{0}")]
+        public override void GetObjectData(SerializationInfo info, StreamingContext context);
     }
+    [AttributeUsageAttribute(AttributeTargets.Parameter, Inherited=false)]
+    [EditorBrowsableAttribute(EditorBrowsableState.Never)]
+    public sealed class ScopedRefAttribute : Attribute {
+        public ScopedRefAttribute();
+    }
     public sealed class SwitchExpressionException : InvalidOperationException {
-        public override void GetObjectData(SerializationInfo info, StreamingContext context);
+        [EditorBrowsableAttribute(EditorBrowsableState.Never)]
+        [ObsoleteAttribute("This API supports obsolete formatter-based serialization. It should not be called or extended by application code.", DiagnosticId="SYSLIB0051", UrlFormat="https://aka.ms/dotnet-warnings/{0}")]
+        public override void GetObjectData(SerializationInfo info, StreamingContext context);
     }
     public static class Unsafe {
-        public static bool AreSame<T>([AllowNullAttribute] ref T left, [AllowNullAttribute] ref T right);
+        public static bool AreSame<T>([AllowNullAttribute, RequiresLocationAttribute] ref T left, [AllowNullAttribute, RequiresLocationAttribute] ref T right);
-        public static ref T AsRef<T>([ScopedRefAttribute] in T source);
+        public static ref T AsRef<T>([RequiresLocationAttribute, ScopedRefAttribute] ref T source);
+        public static TTo BitCast<TFrom, TTo>(TFrom source) where TFrom : struct where TTo : struct;
-        public static IntPtr ByteOffset<T>([AllowNullAttribute] ref T origin, [AllowNullAttribute] ref T target);
+        public static IntPtr ByteOffset<T>([AllowNullAttribute, RequiresLocationAttribute] ref T origin, [AllowNullAttribute, RequiresLocationAttribute] ref T target);
-        [CLSCompliantAttribute(false)]
-        public unsafe static void Copy<T>(void* destination, ref T source);
+        [CLSCompliantAttribute(false)]
+        public unsafe static void Copy<T>(void* destination, [RequiresLocationAttribute] ref T source);
-        [CLSCompliantAttribute(false)]
-        public static void CopyBlock(ref byte destination, ref byte source, uint byteCount);
+        [CLSCompliantAttribute(false)]
+        public static void CopyBlock(ref byte destination, [RequiresLocationAttribute] ref byte source, uint byteCount);
-        [CLSCompliantAttribute(false)]
-        public static void CopyBlockUnaligned(ref byte destination, ref byte source, uint byteCount);
+        [CLSCompliantAttribute(false)]
+        public static void CopyBlockUnaligned(ref byte destination, [RequiresLocationAttribute] ref byte source, uint byteCount);
-        public static bool IsAddressGreaterThan<T>([AllowNullAttribute] ref T left, [AllowNullAttribute] ref T right);
+        public static bool IsAddressGreaterThan<T>([AllowNullAttribute, RequiresLocationAttribute] ref T left, [AllowNullAttribute, RequiresLocationAttribute] ref T right);
-        public static bool IsAddressLessThan<T>([AllowNullAttribute] ref T left, [AllowNullAttribute] ref T right);
+        public static bool IsAddressLessThan<T>([AllowNullAttribute, RequiresLocationAttribute] ref T left, [AllowNullAttribute, RequiresLocationAttribute] ref T right);
-        public static bool IsNullRef<T>(ref T source);
+        public static bool IsNullRef<T>([RequiresLocationAttribute] ref T source);
-        public static T ReadUnaligned<T>(ref byte source);
+        public static T ReadUnaligned<T>([RequiresLocationAttribute] ref byte source);
     }
+    [AttributeUsageAttribute(AttributeTargets.Method, AllowMultiple=false, Inherited=false)]
+    public sealed class UnsafeAccessorAttribute : Attribute {
+        public UnsafeAccessorAttribute(UnsafeAccessorKind kind);
+        public UnsafeAccessorKind Kind { get; }
+        public string Name { get; set; }
+    }
+    public enum UnsafeAccessorKind {
+        Constructor = 0,
+        Field = 3,
+        Method = 1,
+        StaticField = 4,
+        StaticMethod = 2,
+    }
 }
```

