# System.Runtime.InteropServices.Marshalling

``` diff
 namespace System.Runtime.InteropServices.Marshalling {
+    [AttributeUsageAttribute(AttributeTargets.Class, Inherited=false)]
+    [CLSCompliantAttribute(false)]
+    public sealed class ComExposedClassAttribute<T> : Attribute, IComExposedDetails where T : IComExposedClass {
+        public ComExposedClassAttribute();
+        public unsafe ComWrappers.ComInterfaceEntry* GetComInterfaceEntries(out int count);
+    }
+    [CLSCompliantAttribute(false)]
+    [CustomMarshallerAttribute(typeof(CustomMarshallerAttribute.GenericPlaceholder), MarshalMode.Default, typeof(ComInterfaceMarshaller<>))]
+    [UnsupportedOSPlatformAttribute("android")]
+    [UnsupportedOSPlatformAttribute("browser")]
+    [UnsupportedOSPlatformAttribute("ios")]
+    [UnsupportedOSPlatformAttribute("tvos")]
+    public static class ComInterfaceMarshaller<T> {
+        public unsafe static T? ConvertToManaged(void* unmanaged);
+        public unsafe static void* ConvertToUnmanaged(T? managed);
+        public unsafe static void Free(void* unmanaged);
+    }
+    [FlagsAttribute]
+    public enum ComInterfaceOptions {
+        ComObjectWrapper = 2,
+        ManagedObjectWrapper = 1,
+        [EditorBrowsableAttribute(EditorBrowsableState.Never)]
+        None = 0,
+    }
+    public sealed class ComObject : IDynamicInterfaceCastable, IUnmanagedVirtualMethodTableProvider {
+        ~ComObject();
+        public void FinalRelease();
+        RuntimeTypeHandle IDynamicInterfaceCastable.GetInterfaceImplementation(RuntimeTypeHandle interfaceType);
+        bool IDynamicInterfaceCastable.IsInterfaceImplemented(RuntimeTypeHandle interfaceType, bool throwIfNotImplemented);
+        VirtualMethodTableInfo IUnmanagedVirtualMethodTableProvider.GetVirtualMethodTableInfoForKey(Type type);
+    }
+    [CustomMarshallerAttribute(typeof(Exception), MarshalMode.UnmanagedToManagedOut, typeof(ExceptionAsDefaultMarshaller<>))]
+    public static class ExceptionAsDefaultMarshaller<T> where T : struct {
+        public static T ConvertToUnmanaged(Exception e);
+    }
+    [CustomMarshallerAttribute(typeof(Exception), MarshalMode.UnmanagedToManagedOut, typeof(ExceptionAsHResultMarshaller<>))]
+    public static class ExceptionAsHResultMarshaller<T> where T : struct {
+        public static T ConvertToUnmanaged(Exception e);
+    }
+    [CustomMarshallerAttribute(typeof(Exception), MarshalMode.UnmanagedToManagedOut, typeof(ExceptionAsNaNMarshaller<>))]
+    public static class ExceptionAsNaNMarshaller<T> where T : struct {
+        public static T ConvertToUnmanaged(Exception e);
+    }
+    [CustomMarshallerAttribute(typeof(Exception), MarshalMode.UnmanagedToManagedOut, typeof(ExceptionAsVoidMarshaller))]
+    public static class ExceptionAsVoidMarshaller {
+        public static void ConvertToUnmanaged(Exception e);
+    }
+    [AttributeUsageAttribute(AttributeTargets.Class)]
+    public sealed class GeneratedComClassAttribute : Attribute {
+        public GeneratedComClassAttribute();
+    }
+    [AttributeUsageAttribute(AttributeTargets.Interface)]
+    public class GeneratedComInterfaceAttribute : Attribute {
+        public GeneratedComInterfaceAttribute();
+        public ComInterfaceOptions Options { get; set; }
+        public StringMarshalling StringMarshalling { get; set; }
+        public Type StringMarshallingCustomType { get; set; }
+    }
+    [CLSCompliantAttribute(false)]
+    public interface IComExposedClass {
+        unsafe static abstract ComWrappers.ComInterfaceEntry* GetComInterfaceEntries(out int count);
+    }
+    [CLSCompliantAttribute(false)]
+    public interface IComExposedDetails {
+        unsafe ComWrappers.ComInterfaceEntry* GetComInterfaceEntries(out int count);
+    }
+    [CLSCompliantAttribute(false)]
+    public interface IIUnknownCacheStrategy {
+        void Clear(IIUnknownStrategy unknownStrategy);
+        unsafe IIUnknownCacheStrategy.TableInfo ConstructTableInfo(RuntimeTypeHandle handle, IIUnknownDerivedDetails interfaceDetails, void* ptr);
+        bool TryGetTableInfo(RuntimeTypeHandle handle, out IIUnknownCacheStrategy.TableInfo info);
+        bool TrySetTableInfo(RuntimeTypeHandle handle, IIUnknownCacheStrategy.TableInfo info);
+        public readonly struct TableInfo {
+            public RuntimeTypeHandle ManagedType { get; set; }
+            public unsafe void** Table { get; set; }
+            public unsafe void* ThisPtr { get; set; }
+        }
+    }
+    [CLSCompliantAttribute(false)]
+    public interface IIUnknownDerivedDetails {
+        Guid Iid { get; }
+        Type Implementation { get; }
+        unsafe void** ManagedVirtualMethodTable { get; }
+    }
+    [CLSCompliantAttribute(false)]
+    public interface IIUnknownInterfaceDetailsStrategy {
+        IComExposedDetails GetComExposedTypeDetails(RuntimeTypeHandle type);
+        IIUnknownDerivedDetails GetIUnknownDerivedDetails(RuntimeTypeHandle type);
+    }
+    [CLSCompliantAttribute(false)]
+    public interface IIUnknownInterfaceType {
+        static abstract Guid Iid { get; }
+        unsafe static abstract void** ManagedVirtualMethodTable { get; }
+    }
+    [CLSCompliantAttribute(false)]
+    public interface IIUnknownStrategy {
+        unsafe void* CreateInstancePointer(void* unknown);
+        unsafe int QueryInterface(void* instancePtr, in Guid iid, out void* ppObj);
+        unsafe int Release(void* instancePtr);
+    }
+    [AttributeUsageAttribute(AttributeTargets.Interface, Inherited=false)]
+    [CLSCompliantAttribute(false)]
+    public class IUnknownDerivedAttribute<T, TImpl> : Attribute, IIUnknownDerivedDetails where T : IIUnknownInterfaceType {
+        public IUnknownDerivedAttribute();
+        public Guid Iid { get; }
+        public Type Implementation { get; }
+        public unsafe void** ManagedVirtualMethodTable { get; }
+    }
+    [CLSCompliantAttribute(false)]
+    public interface IUnmanagedVirtualMethodTableProvider {
+        VirtualMethodTableInfo GetVirtualMethodTableInfoForKey(Type type);
+    }
-    [AttributeUsageAttribute(AttributeTargets.Class | AttributeTargets.Delegate | AttributeTargets.Enum | AttributeTargets.Struct)]
-    public sealed class NativeMarshallingAttribute : Attribute
+    [AttributeUsageAttribute(AttributeTargets.Class | AttributeTargets.Delegate | AttributeTargets.Enum | AttributeTargets.Interface | AttributeTargets.Struct)]
+    public sealed class NativeMarshallingAttribute : Attribute
+    [CustomMarshallerAttribute(typeof(CustomMarshallerAttribute.GenericPlaceholder), MarshalMode.ManagedToUnmanagedIn, typeof(SafeHandleMarshaller<>.ManagedToUnmanagedIn))]
+    [CustomMarshallerAttribute(typeof(CustomMarshallerAttribute.GenericPlaceholder), MarshalMode.ManagedToUnmanagedOut, typeof(SafeHandleMarshaller<>.ManagedToUnmanagedOut))]
+    [CustomMarshallerAttribute(typeof(CustomMarshallerAttribute.GenericPlaceholder), MarshalMode.ManagedToUnmanagedRef, typeof(SafeHandleMarshaller<>.ManagedToUnmanagedRef))]
+    public static class SafeHandleMarshaller<T> where T : SafeHandle {
+        public struct ManagedToUnmanagedIn {
+            public void Free();
+            public void FromManaged(T handle);
+            public IntPtr ToUnmanaged();
+        }
+        public struct ManagedToUnmanagedOut {
+            public ManagedToUnmanagedOut();
+            public void Free();
+            public void FromUnmanaged(IntPtr value);
+            public T ToManaged();
+        }
+        public struct ManagedToUnmanagedRef {
+            public ManagedToUnmanagedRef();
+            public void Free();
+            public void FromManaged(T handle);
+            public void FromUnmanaged(IntPtr value);
+            public void OnInvoked();
+            public T ToManagedFinally();
+            public IntPtr ToUnmanaged();
+        }
+    }
+    [CLSCompliantAttribute(false)]
+    public class StrategyBasedComWrappers : ComWrappers {
+        public StrategyBasedComWrappers();
+        public static IIUnknownInterfaceDetailsStrategy DefaultIUnknownInterfaceDetailsStrategy { get; }
+        public static IIUnknownStrategy DefaultIUnknownStrategy { get; }
+        protected unsafe sealed override ComWrappers.ComInterfaceEntry* ComputeVtables(object obj, CreateComInterfaceFlags flags, out int count);
+        protected virtual IIUnknownCacheStrategy CreateCacheStrategy();
+        protected static IIUnknownCacheStrategy CreateDefaultCacheStrategy();
+        protected sealed override object CreateObject(IntPtr externalComObject, CreateObjectFlags flags);
+        protected virtual IIUnknownInterfaceDetailsStrategy GetOrCreateInterfaceDetailsStrategy();
+        protected virtual IIUnknownStrategy GetOrCreateIUnknownStrategy();
+        protected sealed override void ReleaseObjects(IEnumerable objects);
+    }
+    [CLSCompliantAttribute(false)]
+    [CustomMarshallerAttribute(typeof(CustomMarshallerAttribute.GenericPlaceholder), MarshalMode.Default, typeof(UniqueComInterfaceMarshaller<>))]
+    [UnsupportedOSPlatformAttribute("android")]
+    [UnsupportedOSPlatformAttribute("browser")]
+    [UnsupportedOSPlatformAttribute("ios")]
+    [UnsupportedOSPlatformAttribute("tvos")]
+    public static class UniqueComInterfaceMarshaller<T> {
+        public unsafe static T? ConvertToManaged(void* unmanaged);
+        public unsafe static void* ConvertToUnmanaged(T? managed);
+        public unsafe static void Free(void* unmanaged);
+    }
+    [CLSCompliantAttribute(false)]
+    public readonly struct VirtualMethodTableInfo {
+        public unsafe VirtualMethodTableInfo(void* thisPointer, void** virtualMethodTable);
+        public unsafe void* ThisPointer { get; }
+        public unsafe void** VirtualMethodTable { get; }
+        public unsafe void Deconstruct(out void* thisPointer, out void** virtualMethodTable);
+    }
 }
```

