# System.Runtime.InteropServices

``` diff
 namespace System.Runtime.InteropServices {
     public static class CollectionsMarshal {
+        public static void SetCount<T>(List<T> list, int count);
     }
     public class COMException : ExternalException {
-        protected COMException(SerializationInfo info, StreamingContext context);
+        [EditorBrowsableAttribute(EditorBrowsableState.Never)]
+        [ObsoleteAttribute("This API supports obsolete formatter-based serialization. It should not be called or extended by application code.", DiagnosticId="SYSLIB0051", UrlFormat="https://aka.ms/dotnet-warnings/{0}")]
+        protected COMException(SerializationInfo info, StreamingContext context);
     }
     [CLSCompliantAttribute(false)]
     [UnsupportedOSPlatformAttribute("android")]
     [UnsupportedOSPlatformAttribute("browser")]
     [UnsupportedOSPlatformAttribute("ios")]
     [UnsupportedOSPlatformAttribute("tvos")]
     public abstract class ComWrappers {
-        protected static void GetIUnknownImpl(out IntPtr fpQueryInterface, out IntPtr fpAddRef, out IntPtr fpRelease);
+        public static void GetIUnknownImpl(out IntPtr fpQueryInterface, out IntPtr fpAddRef, out IntPtr fpRelease);
+        public static bool TryGetComInstance(object obj, out IntPtr unknown);
+        public static bool TryGetObject(IntPtr unknown, [NotNullWhenAttribute(true)] out object? obj);
     }
     public class ExternalException : SystemException {
-        protected ExternalException(SerializationInfo info, StreamingContext context);
+        [EditorBrowsableAttribute(EditorBrowsableState.Never)]
+        [ObsoleteAttribute("This API supports obsolete formatter-based serialization. It should not be called or extended by application code.", DiagnosticId="SYSLIB0051", UrlFormat="https://aka.ms/dotnet-warnings/{0}")]
+        protected ExternalException(SerializationInfo info, StreamingContext context);
     }
+    public static class ImmutableCollectionsMarshal {
+        public static T[]? AsArray<T>(ImmutableArray<T> array);
+        public static ImmutableArray<T> AsImmutableArray<T>(T[]? array);
+    }
     public class InvalidComObjectException : SystemException {
-        protected InvalidComObjectException(SerializationInfo info, StreamingContext context);
+        [EditorBrowsableAttribute(EditorBrowsableState.Never)]
+        [ObsoleteAttribute("This API supports obsolete formatter-based serialization. It should not be called or extended by application code.", DiagnosticId="SYSLIB0051", UrlFormat="https://aka.ms/dotnet-warnings/{0}")]
+        protected InvalidComObjectException(SerializationInfo info, StreamingContext context);
     }
     public class InvalidOleVariantTypeException : SystemException {
-        protected InvalidOleVariantTypeException(SerializationInfo info, StreamingContext context);
+        [EditorBrowsableAttribute(EditorBrowsableState.Never)]
+        [ObsoleteAttribute("This API supports obsolete formatter-based serialization. It should not be called or extended by application code.", DiagnosticId="SYSLIB0051", UrlFormat="https://aka.ms/dotnet-warnings/{0}")]
+        protected InvalidOleVariantTypeException(SerializationInfo info, StreamingContext context);
     }
     public static class Marshal {
-        public static int QueryInterface(IntPtr pUnk, ref Guid iid, out IntPtr ppv);
+        public static int QueryInterface(IntPtr pUnk, [RequiresLocationAttribute] ref Guid iid, out IntPtr ppv);
     }
     public class MarshalDirectiveException : SystemException {
-        protected MarshalDirectiveException(SerializationInfo info, StreamingContext context);
+        [EditorBrowsableAttribute(EditorBrowsableState.Never)]
+        [ObsoleteAttribute("This API supports obsolete formatter-based serialization. It should not be called or extended by application code.", DiagnosticId="SYSLIB0051", UrlFormat="https://aka.ms/dotnet-warnings/{0}")]
+        protected MarshalDirectiveException(SerializationInfo info, StreamingContext context);
     }
     public static class MemoryMarshal {
-        public static ReadOnlySpan<T> CreateReadOnlySpan<T>([ScopedRefAttribute] ref T reference, int length);
+        public static ReadOnlySpan<T> CreateReadOnlySpan<T>([RequiresLocationAttribute, ScopedRefAttribute] ref T reference, int length);
         public static Span<T> CreateSpan<T>([ScopedRefAttribute] ref T reference, int length);
-        public static bool TryWrite<T>(Span<byte> destination, ref T value) where T : struct;
+        public static bool TryWrite<T>(Span<byte> destination, in T value) where T : struct;
-        public static void Write<T>(Span<byte> destination, ref T value) where T : struct;
+        public static void Write<T>(Span<byte> destination, in T value) where T : struct;
     }
-    public readonly struct NFloat : IAdditionOperators<NFloat, NFloat, NFloat>, IAdditiveIdentity<NFloat, NFloat>, IBinaryFloatingPointIeee754<NFloat>, IBinaryNumber<NFloat>, IBitwiseOperators<NFloat, NFloat, NFloat>, IComparable, IComparable<NFloat>, IComparisonOperators<NFloat, NFloat, bool>, IDecrementOperators<NFloat>, IDivisionOperators<NFloat, NFloat, NFloat>, IEqualityOperators<NFloat, NFloat, bool>, IEquatable<NFloat>, IExponentialFunctions<NFloat>, IFloatingPoint<NFloat>, IFloatingPointConstants<NFloat>, IFloatingPointIeee754<NFloat>, IFormattable, IHyperbolicFunctions<NFloat>, IIncrementOperators<NFloat>, ILogarithmicFunctions<NFloat>, IMinMaxValue<NFloat>, IModulusOperators<NFloat, NFloat, NFloat>, IMultiplicativeIdentity<NFloat, NFloat>, IMultiplyOperators<NFloat, NFloat, NFloat>, INumber<NFloat>, INumberBase<NFloat>, IParsable<NFloat>, IPowerFunctions<NFloat>, IRootFunctions<NFloat>, ISignedNumber<NFloat>, ISpanFormattable, ISpanParsable<NFloat>, ISubtractionOperators<NFloat, NFloat, NFloat>, ITrigonometricFunctions<NFloat>, IUnaryNegationOperators<NFloat, NFloat>, IUnaryPlusOperators<NFloat, NFloat> {
+    public readonly struct NFloat : IAdditionOperators<NFloat, NFloat, NFloat>, IAdditiveIdentity<NFloat, NFloat>, IBinaryFloatingPointIeee754<NFloat>, IBinaryNumber<NFloat>, IBitwiseOperators<NFloat, NFloat, NFloat>, IComparable, IComparable<NFloat>, IComparisonOperators<NFloat, NFloat, bool>, IDecrementOperators<NFloat>, IDivisionOperators<NFloat, NFloat, NFloat>, IEqualityOperators<NFloat, NFloat, bool>, IEquatable<NFloat>, IExponentialFunctions<NFloat>, IFloatingPoint<NFloat>, IFloatingPointConstants<NFloat>, IFloatingPointIeee754<NFloat>, IFormattable, IHyperbolicFunctions<NFloat>, IIncrementOperators<NFloat>, ILogarithmicFunctions<NFloat>, IMinMaxValue<NFloat>, IModulusOperators<NFloat, NFloat, NFloat>, IMultiplicativeIdentity<NFloat, NFloat>, IMultiplyOperators<NFloat, NFloat, NFloat>, INumber<NFloat>, INumberBase<NFloat>, IParsable<NFloat>, IPowerFunctions<NFloat>, IRootFunctions<NFloat>, ISignedNumber<NFloat>, ISpanFormattable, ISpanParsable<NFloat>, ISubtractionOperators<NFloat, NFloat, NFloat>, ITrigonometricFunctions<NFloat>, IUnaryNegationOperators<NFloat, NFloat>, IUnaryPlusOperators<NFloat, NFloat>, IUtf8SpanFormattable, IUtf8SpanParsable<NFloat> {
+        public static NFloat DegreesToRadians(NFloat degrees);
+        public static NFloat Lerp(NFloat value1, NFloat value2, NFloat amount);
+        public static NFloat Parse(ReadOnlySpan<byte> utf8Text, NumberStyles style = NumberStyles.AllowDecimalPoint | NumberStyles.AllowExponent | NumberStyles.AllowLeadingSign | NumberStyles.AllowLeadingWhite | NumberStyles.AllowThousands | NumberStyles.AllowTrailingWhite, IFormatProvider? provider = null);
+        public static NFloat Parse(ReadOnlySpan<byte> utf8Text, IFormatProvider? provider);
+        public static NFloat RadiansToDegrees(NFloat radians);
+        public bool TryFormat(Span<byte> utf8Destination, out int bytesWritten, [StringSyntaxAttribute("NumericFormat")] ReadOnlySpan<char> format = default(ReadOnlySpan<char>), IFormatProvider? provider = null);
+        public static bool TryParse(ReadOnlySpan<byte> utf8Text, NumberStyles style, IFormatProvider? provider, out NFloat result);
+        public static bool TryParse(ReadOnlySpan<byte> utf8Text, IFormatProvider? provider, out NFloat result);
+        public static bool TryParse(ReadOnlySpan<byte> utf8Text, out NFloat result);
     }
     public class SafeArrayRankMismatchException : SystemException {
-        protected SafeArrayRankMismatchException(SerializationInfo info, StreamingContext context);
+        [EditorBrowsableAttribute(EditorBrowsableState.Never)]
+        [ObsoleteAttribute("This API supports obsolete formatter-based serialization. It should not be called or extended by application code.", DiagnosticId="SYSLIB0051", UrlFormat="https://aka.ms/dotnet-warnings/{0}")]
+        protected SafeArrayRankMismatchException(SerializationInfo info, StreamingContext context);
     }
     public class SafeArrayTypeMismatchException : SystemException {
-        protected SafeArrayTypeMismatchException(SerializationInfo info, StreamingContext context);
+        [EditorBrowsableAttribute(EditorBrowsableState.Never)]
+        [ObsoleteAttribute("This API supports obsolete formatter-based serialization. It should not be called or extended by application code.", DiagnosticId="SYSLIB0051", UrlFormat="https://aka.ms/dotnet-warnings/{0}")]
+        protected SafeArrayTypeMismatchException(SerializationInfo info, StreamingContext context);
     }
     public class SEHException : ExternalException {
-        protected SEHException(SerializationInfo info, StreamingContext context);
+        [EditorBrowsableAttribute(EditorBrowsableState.Never)]
+        [ObsoleteAttribute("This API supports obsolete formatter-based serialization. It should not be called or extended by application code.", DiagnosticId="SYSLIB0051", UrlFormat="https://aka.ms/dotnet-warnings/{0}")]
+        protected SEHException(SerializationInfo info, StreamingContext context);
     }
 }
```

