# System.Runtime.Intrinsics.X86

``` diff
 namespace System.Runtime.Intrinsics.X86 {
     [CLSCompliantAttribute(false)]
     public abstract class Aes : Sse2 {
-        public static Vector128<byte> KeygenAssist(Vector128<byte> value, byte control);
+        public static Vector128<byte> KeygenAssist(Vector128<byte> value, [ConstantExpectedAttribute] byte control);
     }
     [CLSCompliantAttribute(false)]
     public abstract class Avx : Sse42 {
-        public static Vector256<double> Blend(Vector256<double> left, Vector256<double> right, byte control);
+        public static Vector256<double> Blend(Vector256<double> left, Vector256<double> right, [ConstantExpectedAttribute] byte control);
-        public static Vector256<float> Blend(Vector256<float> left, Vector256<float> right, byte control);
+        public static Vector256<float> Blend(Vector256<float> left, Vector256<float> right, [ConstantExpectedAttribute] byte control);
-        public static Vector128<double> Compare(Vector128<double> left, Vector128<double> right, FloatComparisonMode mode);
+        public static Vector128<double> Compare(Vector128<double> left, Vector128<double> right, [ConstantExpectedAttribute(Max=FloatComparisonMode.UnorderedTrueSignaling)] FloatComparisonMode mode);
-        public static Vector128<float> Compare(Vector128<float> left, Vector128<float> right, FloatComparisonMode mode);
+        public static Vector128<float> Compare(Vector128<float> left, Vector128<float> right, [ConstantExpectedAttribute(Max=FloatComparisonMode.UnorderedTrueSignaling)] FloatComparisonMode mode);
-        public static Vector256<double> Compare(Vector256<double> left, Vector256<double> right, FloatComparisonMode mode);
+        public static Vector256<double> Compare(Vector256<double> left, Vector256<double> right, [ConstantExpectedAttribute(Max=FloatComparisonMode.UnorderedTrueSignaling)] FloatComparisonMode mode);
-        public static Vector256<float> Compare(Vector256<float> left, Vector256<float> right, FloatComparisonMode mode);
+        public static Vector256<float> Compare(Vector256<float> left, Vector256<float> right, [ConstantExpectedAttribute(Max=FloatComparisonMode.UnorderedTrueSignaling)] FloatComparisonMode mode);
-        public static Vector128<double> CompareScalar(Vector128<double> left, Vector128<double> right, FloatComparisonMode mode);
+        public static Vector128<double> CompareScalar(Vector128<double> left, Vector128<double> right, [ConstantExpectedAttribute(Max=FloatComparisonMode.UnorderedTrueSignaling)] FloatComparisonMode mode);
-        public static Vector128<float> CompareScalar(Vector128<float> left, Vector128<float> right, FloatComparisonMode mode);
+        public static Vector128<float> CompareScalar(Vector128<float> left, Vector128<float> right, [ConstantExpectedAttribute(Max=FloatComparisonMode.UnorderedTrueSignaling)] FloatComparisonMode mode);
-        public static Vector256<float> DotProduct(Vector256<float> left, Vector256<float> right, byte control);
+        public static Vector256<float> DotProduct(Vector256<float> left, Vector256<float> right, [ConstantExpectedAttribute] byte control);
-        public static Vector128<byte> ExtractVector128(Vector256<byte> value, byte index);
+        public static Vector128<byte> ExtractVector128(Vector256<byte> value, [ConstantExpectedAttribute] byte index);
-        public static Vector128<double> ExtractVector128(Vector256<double> value, byte index);
+        public static Vector128<double> ExtractVector128(Vector256<double> value, [ConstantExpectedAttribute] byte index);
-        public static Vector128<short> ExtractVector128(Vector256<short> value, byte index);
+        public static Vector128<short> ExtractVector128(Vector256<short> value, [ConstantExpectedAttribute] byte index);
-        public static Vector128<int> ExtractVector128(Vector256<int> value, byte index);
+        public static Vector128<int> ExtractVector128(Vector256<int> value, [ConstantExpectedAttribute] byte index);
-        public static Vector128<long> ExtractVector128(Vector256<long> value, byte index);
+        public static Vector128<long> ExtractVector128(Vector256<long> value, [ConstantExpectedAttribute] byte index);
-        public static Vector128<sbyte> ExtractVector128(Vector256<sbyte> value, byte index);
+        public static Vector128<sbyte> ExtractVector128(Vector256<sbyte> value, [ConstantExpectedAttribute] byte index);
-        public static Vector128<float> ExtractVector128(Vector256<float> value, byte index);
+        public static Vector128<float> ExtractVector128(Vector256<float> value, [ConstantExpectedAttribute] byte index);
-        public static Vector128<ushort> ExtractVector128(Vector256<ushort> value, byte index);
+        public static Vector128<ushort> ExtractVector128(Vector256<ushort> value, [ConstantExpectedAttribute] byte index);
-        public static Vector128<uint> ExtractVector128(Vector256<uint> value, byte index);
+        public static Vector128<uint> ExtractVector128(Vector256<uint> value, [ConstantExpectedAttribute] byte index);
-        public static Vector128<ulong> ExtractVector128(Vector256<ulong> value, byte index);
+        public static Vector128<ulong> ExtractVector128(Vector256<ulong> value, [ConstantExpectedAttribute] byte index);
-        public static Vector256<byte> InsertVector128(Vector256<byte> value, Vector128<byte> data, byte index);
+        public static Vector256<byte> InsertVector128(Vector256<byte> value, Vector128<byte> data, [ConstantExpectedAttribute] byte index);
-        public static Vector256<double> InsertVector128(Vector256<double> value, Vector128<double> data, byte index);
+        public static Vector256<double> InsertVector128(Vector256<double> value, Vector128<double> data, [ConstantExpectedAttribute] byte index);
-        public static Vector256<short> InsertVector128(Vector256<short> value, Vector128<short> data, byte index);
+        public static Vector256<short> InsertVector128(Vector256<short> value, Vector128<short> data, [ConstantExpectedAttribute] byte index);
-        public static Vector256<int> InsertVector128(Vector256<int> value, Vector128<int> data, byte index);
+        public static Vector256<int> InsertVector128(Vector256<int> value, Vector128<int> data, [ConstantExpectedAttribute] byte index);
-        public static Vector256<long> InsertVector128(Vector256<long> value, Vector128<long> data, byte index);
+        public static Vector256<long> InsertVector128(Vector256<long> value, Vector128<long> data, [ConstantExpectedAttribute] byte index);
-        public static Vector256<sbyte> InsertVector128(Vector256<sbyte> value, Vector128<sbyte> data, byte index);
+        public static Vector256<sbyte> InsertVector128(Vector256<sbyte> value, Vector128<sbyte> data, [ConstantExpectedAttribute] byte index);
-        public static Vector256<float> InsertVector128(Vector256<float> value, Vector128<float> data, byte index);
+        public static Vector256<float> InsertVector128(Vector256<float> value, Vector128<float> data, [ConstantExpectedAttribute] byte index);
-        public static Vector256<ushort> InsertVector128(Vector256<ushort> value, Vector128<ushort> data, byte index);
+        public static Vector256<ushort> InsertVector128(Vector256<ushort> value, Vector128<ushort> data, [ConstantExpectedAttribute] byte index);
-        public static Vector256<uint> InsertVector128(Vector256<uint> value, Vector128<uint> data, byte index);
+        public static Vector256<uint> InsertVector128(Vector256<uint> value, Vector128<uint> data, [ConstantExpectedAttribute] byte index);
-        public static Vector256<ulong> InsertVector128(Vector256<ulong> value, Vector128<ulong> data, byte index);
+        public static Vector256<ulong> InsertVector128(Vector256<ulong> value, Vector128<ulong> data, [ConstantExpectedAttribute] byte index);
-        public static Vector128<double> Permute(Vector128<double> value, byte control);
+        public static Vector128<double> Permute(Vector128<double> value, [ConstantExpectedAttribute] byte control);
-        public static Vector128<float> Permute(Vector128<float> value, byte control);
+        public static Vector128<float> Permute(Vector128<float> value, [ConstantExpectedAttribute] byte control);
-        public static Vector256<double> Permute(Vector256<double> value, byte control);
+        public static Vector256<double> Permute(Vector256<double> value, [ConstantExpectedAttribute] byte control);
-        public static Vector256<float> Permute(Vector256<float> value, byte control);
+        public static Vector256<float> Permute(Vector256<float> value, [ConstantExpectedAttribute] byte control);
-        public static Vector256<byte> Permute2x128(Vector256<byte> left, Vector256<byte> right, byte control);
+        public static Vector256<byte> Permute2x128(Vector256<byte> left, Vector256<byte> right, [ConstantExpectedAttribute] byte control);
-        public static Vector256<double> Permute2x128(Vector256<double> left, Vector256<double> right, byte control);
+        public static Vector256<double> Permute2x128(Vector256<double> left, Vector256<double> right, [ConstantExpectedAttribute] byte control);
-        public static Vector256<short> Permute2x128(Vector256<short> left, Vector256<short> right, byte control);
+        public static Vector256<short> Permute2x128(Vector256<short> left, Vector256<short> right, [ConstantExpectedAttribute] byte control);
-        public static Vector256<int> Permute2x128(Vector256<int> left, Vector256<int> right, byte control);
+        public static Vector256<int> Permute2x128(Vector256<int> left, Vector256<int> right, [ConstantExpectedAttribute] byte control);
-        public static Vector256<long> Permute2x128(Vector256<long> left, Vector256<long> right, byte control);
+        public static Vector256<long> Permute2x128(Vector256<long> left, Vector256<long> right, [ConstantExpectedAttribute] byte control);
-        public static Vector256<sbyte> Permute2x128(Vector256<sbyte> left, Vector256<sbyte> right, byte control);
+        public static Vector256<sbyte> Permute2x128(Vector256<sbyte> left, Vector256<sbyte> right, [ConstantExpectedAttribute] byte control);
-        public static Vector256<float> Permute2x128(Vector256<float> left, Vector256<float> right, byte control);
+        public static Vector256<float> Permute2x128(Vector256<float> left, Vector256<float> right, [ConstantExpectedAttribute] byte control);
-        public static Vector256<ushort> Permute2x128(Vector256<ushort> left, Vector256<ushort> right, byte control);
+        public static Vector256<ushort> Permute2x128(Vector256<ushort> left, Vector256<ushort> right, [ConstantExpectedAttribute] byte control);
-        public static Vector256<uint> Permute2x128(Vector256<uint> left, Vector256<uint> right, byte control);
+        public static Vector256<uint> Permute2x128(Vector256<uint> left, Vector256<uint> right, [ConstantExpectedAttribute] byte control);
-        public static Vector256<ulong> Permute2x128(Vector256<ulong> left, Vector256<ulong> right, byte control);
+        public static Vector256<ulong> Permute2x128(Vector256<ulong> left, Vector256<ulong> right, [ConstantExpectedAttribute] byte control);
-        public static Vector256<double> Shuffle(Vector256<double> value, Vector256<double> right, byte control);
+        public static Vector256<double> Shuffle(Vector256<double> value, Vector256<double> right, [ConstantExpectedAttribute] byte control);
-        public static Vector256<float> Shuffle(Vector256<float> value, Vector256<float> right, byte control);
+        public static Vector256<float> Shuffle(Vector256<float> value, Vector256<float> right, [ConstantExpectedAttribute] byte control);
     }
     [CLSCompliantAttribute(false)]
     public abstract class Avx2 : Avx {
-        public static Vector256<byte> AlignRight(Vector256<byte> left, Vector256<byte> right, byte mask);
+        public static Vector256<byte> AlignRight(Vector256<byte> left, Vector256<byte> right, [ConstantExpectedAttribute] byte mask);
-        public static Vector256<short> AlignRight(Vector256<short> left, Vector256<short> right, byte mask);
+        public static Vector256<short> AlignRight(Vector256<short> left, Vector256<short> right, [ConstantExpectedAttribute] byte mask);
-        public static Vector256<int> AlignRight(Vector256<int> left, Vector256<int> right, byte mask);
+        public static Vector256<int> AlignRight(Vector256<int> left, Vector256<int> right, [ConstantExpectedAttribute] byte mask);
-        public static Vector256<long> AlignRight(Vector256<long> left, Vector256<long> right, byte mask);
+        public static Vector256<long> AlignRight(Vector256<long> left, Vector256<long> right, [ConstantExpectedAttribute] byte mask);
-        public static Vector256<sbyte> AlignRight(Vector256<sbyte> left, Vector256<sbyte> right, byte mask);
+        public static Vector256<sbyte> AlignRight(Vector256<sbyte> left, Vector256<sbyte> right, [ConstantExpectedAttribute] byte mask);
-        public static Vector256<ushort> AlignRight(Vector256<ushort> left, Vector256<ushort> right, byte mask);
+        public static Vector256<ushort> AlignRight(Vector256<ushort> left, Vector256<ushort> right, [ConstantExpectedAttribute] byte mask);
-        public static Vector256<uint> AlignRight(Vector256<uint> left, Vector256<uint> right, byte mask);
+        public static Vector256<uint> AlignRight(Vector256<uint> left, Vector256<uint> right, [ConstantExpectedAttribute] byte mask);
-        public static Vector256<ulong> AlignRight(Vector256<ulong> left, Vector256<ulong> right, byte mask);
+        public static Vector256<ulong> AlignRight(Vector256<ulong> left, Vector256<ulong> right, [ConstantExpectedAttribute] byte mask);
-        public static Vector128<int> Blend(Vector128<int> left, Vector128<int> right, byte control);
+        public static Vector128<int> Blend(Vector128<int> left, Vector128<int> right, [ConstantExpectedAttribute] byte control);
-        public static Vector128<uint> Blend(Vector128<uint> left, Vector128<uint> right, byte control);
+        public static Vector128<uint> Blend(Vector128<uint> left, Vector128<uint> right, [ConstantExpectedAttribute] byte control);
-        public static Vector256<short> Blend(Vector256<short> left, Vector256<short> right, byte control);
+        public static Vector256<short> Blend(Vector256<short> left, Vector256<short> right, [ConstantExpectedAttribute] byte control);
-        public static Vector256<int> Blend(Vector256<int> left, Vector256<int> right, byte control);
+        public static Vector256<int> Blend(Vector256<int> left, Vector256<int> right, [ConstantExpectedAttribute] byte control);
-        public static Vector256<ushort> Blend(Vector256<ushort> left, Vector256<ushort> right, byte control);
+        public static Vector256<ushort> Blend(Vector256<ushort> left, Vector256<ushort> right, [ConstantExpectedAttribute] byte control);
-        public static Vector256<uint> Blend(Vector256<uint> left, Vector256<uint> right, byte control);
+        public static Vector256<uint> Blend(Vector256<uint> left, Vector256<uint> right, [ConstantExpectedAttribute] byte control);
-        public static new Vector128<byte> ExtractVector128(Vector256<byte> value, byte index);
+        public static new Vector128<byte> ExtractVector128(Vector256<byte> value, [ConstantExpectedAttribute] byte index);
-        public static new Vector128<short> ExtractVector128(Vector256<short> value, byte index);
+        public static new Vector128<short> ExtractVector128(Vector256<short> value, [ConstantExpectedAttribute] byte index);
-        public static new Vector128<int> ExtractVector128(Vector256<int> value, byte index);
+        public static new Vector128<int> ExtractVector128(Vector256<int> value, [ConstantExpectedAttribute] byte index);
-        public static new Vector128<long> ExtractVector128(Vector256<long> value, byte index);
+        public static new Vector128<long> ExtractVector128(Vector256<long> value, [ConstantExpectedAttribute] byte index);
-        public static new Vector128<sbyte> ExtractVector128(Vector256<sbyte> value, byte index);
+        public static new Vector128<sbyte> ExtractVector128(Vector256<sbyte> value, [ConstantExpectedAttribute] byte index);
-        public static new Vector128<ushort> ExtractVector128(Vector256<ushort> value, byte index);
+        public static new Vector128<ushort> ExtractVector128(Vector256<ushort> value, [ConstantExpectedAttribute] byte index);
-        public static new Vector128<uint> ExtractVector128(Vector256<uint> value, byte index);
+        public static new Vector128<uint> ExtractVector128(Vector256<uint> value, [ConstantExpectedAttribute] byte index);
-        public static new Vector128<ulong> ExtractVector128(Vector256<ulong> value, byte index);
+        public static new Vector128<ulong> ExtractVector128(Vector256<ulong> value, [ConstantExpectedAttribute] byte index);
-        public unsafe static Vector128<double> GatherMaskVector128(Vector128<double> source, double* baseAddress, Vector128<int> index, Vector128<double> mask, byte scale);
+        public unsafe static Vector128<double> GatherMaskVector128(Vector128<double> source, double* baseAddress, Vector128<int> index, Vector128<double> mask, [ConstantExpectedAttribute(Min=(byte)1, Max=(byte)8)] byte scale);
-        public unsafe static Vector128<double> GatherMaskVector128(Vector128<double> source, double* baseAddress, Vector128<long> index, Vector128<double> mask, byte scale);
+        public unsafe static Vector128<double> GatherMaskVector128(Vector128<double> source, double* baseAddress, Vector128<long> index, Vector128<double> mask, [ConstantExpectedAttribute(Min=(byte)1, Max=(byte)8)] byte scale);
-        public unsafe static Vector128<int> GatherMaskVector128(Vector128<int> source, int* baseAddress, Vector128<int> index, Vector128<int> mask, byte scale);
+        public unsafe static Vector128<int> GatherMaskVector128(Vector128<int> source, int* baseAddress, Vector128<int> index, Vector128<int> mask, [ConstantExpectedAttribute(Min=(byte)1, Max=(byte)8)] byte scale);
-        public unsafe static Vector128<int> GatherMaskVector128(Vector128<int> source, int* baseAddress, Vector128<long> index, Vector128<int> mask, byte scale);
+        public unsafe static Vector128<int> GatherMaskVector128(Vector128<int> source, int* baseAddress, Vector128<long> index, Vector128<int> mask, [ConstantExpectedAttribute(Min=(byte)1, Max=(byte)8)] byte scale);
-        public unsafe static Vector128<int> GatherMaskVector128(Vector128<int> source, int* baseAddress, Vector256<long> index, Vector128<int> mask, byte scale);
+        public unsafe static Vector128<int> GatherMaskVector128(Vector128<int> source, int* baseAddress, Vector256<long> index, Vector128<int> mask, [ConstantExpectedAttribute(Min=(byte)1, Max=(byte)8)] byte scale);
-        public unsafe static Vector128<long> GatherMaskVector128(Vector128<long> source, long* baseAddress, Vector128<int> index, Vector128<long> mask, byte scale);
+        public unsafe static Vector128<long> GatherMaskVector128(Vector128<long> source, long* baseAddress, Vector128<int> index, Vector128<long> mask, [ConstantExpectedAttribute(Min=(byte)1, Max=(byte)8)] byte scale);
-        public unsafe static Vector128<long> GatherMaskVector128(Vector128<long> source, long* baseAddress, Vector128<long> index, Vector128<long> mask, byte scale);
+        public unsafe static Vector128<long> GatherMaskVector128(Vector128<long> source, long* baseAddress, Vector128<long> index, Vector128<long> mask, [ConstantExpectedAttribute(Min=(byte)1, Max=(byte)8)] byte scale);
-        public unsafe static Vector128<float> GatherMaskVector128(Vector128<float> source, float* baseAddress, Vector128<int> index, Vector128<float> mask, byte scale);
+        public unsafe static Vector128<float> GatherMaskVector128(Vector128<float> source, float* baseAddress, Vector128<int> index, Vector128<float> mask, [ConstantExpectedAttribute(Min=(byte)1, Max=(byte)8)] byte scale);
-        public unsafe static Vector128<float> GatherMaskVector128(Vector128<float> source, float* baseAddress, Vector128<long> index, Vector128<float> mask, byte scale);
+        public unsafe static Vector128<float> GatherMaskVector128(Vector128<float> source, float* baseAddress, Vector128<long> index, Vector128<float> mask, [ConstantExpectedAttribute(Min=(byte)1, Max=(byte)8)] byte scale);
-        public unsafe static Vector128<float> GatherMaskVector128(Vector128<float> source, float* baseAddress, Vector256<long> index, Vector128<float> mask, byte scale);
+        public unsafe static Vector128<float> GatherMaskVector128(Vector128<float> source, float* baseAddress, Vector256<long> index, Vector128<float> mask, [ConstantExpectedAttribute(Min=(byte)1, Max=(byte)8)] byte scale);
-        public unsafe static Vector128<uint> GatherMaskVector128(Vector128<uint> source, uint* baseAddress, Vector128<int> index, Vector128<uint> mask, byte scale);
+        public unsafe static Vector128<uint> GatherMaskVector128(Vector128<uint> source, uint* baseAddress, Vector128<int> index, Vector128<uint> mask, [ConstantExpectedAttribute(Min=(byte)1, Max=(byte)8)] byte scale);
-        public unsafe static Vector128<uint> GatherMaskVector128(Vector128<uint> source, uint* baseAddress, Vector128<long> index, Vector128<uint> mask, byte scale);
+        public unsafe static Vector128<uint> GatherMaskVector128(Vector128<uint> source, uint* baseAddress, Vector128<long> index, Vector128<uint> mask, [ConstantExpectedAttribute(Min=(byte)1, Max=(byte)8)] byte scale);
-        public unsafe static Vector128<uint> GatherMaskVector128(Vector128<uint> source, uint* baseAddress, Vector256<long> index, Vector128<uint> mask, byte scale);
+        public unsafe static Vector128<uint> GatherMaskVector128(Vector128<uint> source, uint* baseAddress, Vector256<long> index, Vector128<uint> mask, [ConstantExpectedAttribute(Min=(byte)1, Max=(byte)8)] byte scale);
-        public unsafe static Vector128<ulong> GatherMaskVector128(Vector128<ulong> source, ulong* baseAddress, Vector128<int> index, Vector128<ulong> mask, byte scale);
+        public unsafe static Vector128<ulong> GatherMaskVector128(Vector128<ulong> source, ulong* baseAddress, Vector128<int> index, Vector128<ulong> mask, [ConstantExpectedAttribute(Min=(byte)1, Max=(byte)8)] byte scale);
-        public unsafe static Vector128<ulong> GatherMaskVector128(Vector128<ulong> source, ulong* baseAddress, Vector128<long> index, Vector128<ulong> mask, byte scale);
+        public unsafe static Vector128<ulong> GatherMaskVector128(Vector128<ulong> source, ulong* baseAddress, Vector128<long> index, Vector128<ulong> mask, [ConstantExpectedAttribute(Min=(byte)1, Max=(byte)8)] byte scale);
-        public unsafe static Vector256<double> GatherMaskVector256(Vector256<double> source, double* baseAddress, Vector128<int> index, Vector256<double> mask, byte scale);
+        public unsafe static Vector256<double> GatherMaskVector256(Vector256<double> source, double* baseAddress, Vector128<int> index, Vector256<double> mask, [ConstantExpectedAttribute(Min=(byte)1, Max=(byte)8)] byte scale);
-        public unsafe static Vector256<double> GatherMaskVector256(Vector256<double> source, double* baseAddress, Vector256<long> index, Vector256<double> mask, byte scale);
+        public unsafe static Vector256<double> GatherMaskVector256(Vector256<double> source, double* baseAddress, Vector256<long> index, Vector256<double> mask, [ConstantExpectedAttribute(Min=(byte)1, Max=(byte)8)] byte scale);
-        public unsafe static Vector256<int> GatherMaskVector256(Vector256<int> source, int* baseAddress, Vector256<int> index, Vector256<int> mask, byte scale);
+        public unsafe static Vector256<int> GatherMaskVector256(Vector256<int> source, int* baseAddress, Vector256<int> index, Vector256<int> mask, [ConstantExpectedAttribute(Min=(byte)1, Max=(byte)8)] byte scale);
-        public unsafe static Vector256<long> GatherMaskVector256(Vector256<long> source, long* baseAddress, Vector128<int> index, Vector256<long> mask, byte scale);
+        public unsafe static Vector256<long> GatherMaskVector256(Vector256<long> source, long* baseAddress, Vector128<int> index, Vector256<long> mask, [ConstantExpectedAttribute(Min=(byte)1, Max=(byte)8)] byte scale);
-        public unsafe static Vector256<long> GatherMaskVector256(Vector256<long> source, long* baseAddress, Vector256<long> index, Vector256<long> mask, byte scale);
+        public unsafe static Vector256<long> GatherMaskVector256(Vector256<long> source, long* baseAddress, Vector256<long> index, Vector256<long> mask, [ConstantExpectedAttribute(Min=(byte)1, Max=(byte)8)] byte scale);
-        public unsafe static Vector256<float> GatherMaskVector256(Vector256<float> source, float* baseAddress, Vector256<int> index, Vector256<float> mask, byte scale);
+        public unsafe static Vector256<float> GatherMaskVector256(Vector256<float> source, float* baseAddress, Vector256<int> index, Vector256<float> mask, [ConstantExpectedAttribute(Min=(byte)1, Max=(byte)8)] byte scale);
-        public unsafe static Vector256<uint> GatherMaskVector256(Vector256<uint> source, uint* baseAddress, Vector256<int> index, Vector256<uint> mask, byte scale);
+        public unsafe static Vector256<uint> GatherMaskVector256(Vector256<uint> source, uint* baseAddress, Vector256<int> index, Vector256<uint> mask, [ConstantExpectedAttribute(Min=(byte)1, Max=(byte)8)] byte scale);
-        public unsafe static Vector256<ulong> GatherMaskVector256(Vector256<ulong> source, ulong* baseAddress, Vector128<int> index, Vector256<ulong> mask, byte scale);
+        public unsafe static Vector256<ulong> GatherMaskVector256(Vector256<ulong> source, ulong* baseAddress, Vector128<int> index, Vector256<ulong> mask, [ConstantExpectedAttribute(Min=(byte)1, Max=(byte)8)] byte scale);
-        public unsafe static Vector256<ulong> GatherMaskVector256(Vector256<ulong> source, ulong* baseAddress, Vector256<long> index, Vector256<ulong> mask, byte scale);
+        public unsafe static Vector256<ulong> GatherMaskVector256(Vector256<ulong> source, ulong* baseAddress, Vector256<long> index, Vector256<ulong> mask, [ConstantExpectedAttribute(Min=(byte)1, Max=(byte)8)] byte scale);
-        public unsafe static Vector128<double> GatherVector128(double* baseAddress, Vector128<int> index, byte scale);
+        public unsafe static Vector128<double> GatherVector128(double* baseAddress, Vector128<int> index, [ConstantExpectedAttribute(Min=(byte)1, Max=(byte)8)] byte scale);
-        public unsafe static Vector128<double> GatherVector128(double* baseAddress, Vector128<long> index, byte scale);
+        public unsafe static Vector128<double> GatherVector128(double* baseAddress, Vector128<long> index, [ConstantExpectedAttribute(Min=(byte)1, Max=(byte)8)] byte scale);
-        public unsafe static Vector128<int> GatherVector128(int* baseAddress, Vector128<int> index, byte scale);
+        public unsafe static Vector128<int> GatherVector128(int* baseAddress, Vector128<int> index, [ConstantExpectedAttribute(Min=(byte)1, Max=(byte)8)] byte scale);
-        public unsafe static Vector128<int> GatherVector128(int* baseAddress, Vector128<long> index, byte scale);
+        public unsafe static Vector128<int> GatherVector128(int* baseAddress, Vector128<long> index, [ConstantExpectedAttribute(Min=(byte)1, Max=(byte)8)] byte scale);
-        public unsafe static Vector128<int> GatherVector128(int* baseAddress, Vector256<long> index, byte scale);
+        public unsafe static Vector128<int> GatherVector128(int* baseAddress, Vector256<long> index, [ConstantExpectedAttribute(Min=(byte)1, Max=(byte)8)] byte scale);
-        public unsafe static Vector128<long> GatherVector128(long* baseAddress, Vector128<int> index, byte scale);
+        public unsafe static Vector128<long> GatherVector128(long* baseAddress, Vector128<int> index, [ConstantExpectedAttribute(Min=(byte)1, Max=(byte)8)] byte scale);
-        public unsafe static Vector128<long> GatherVector128(long* baseAddress, Vector128<long> index, byte scale);
+        public unsafe static Vector128<long> GatherVector128(long* baseAddress, Vector128<long> index, [ConstantExpectedAttribute(Min=(byte)1, Max=(byte)8)] byte scale);
-        public unsafe static Vector128<float> GatherVector128(float* baseAddress, Vector128<int> index, byte scale);
+        public unsafe static Vector128<float> GatherVector128(float* baseAddress, Vector128<int> index, [ConstantExpectedAttribute(Min=(byte)1, Max=(byte)8)] byte scale);
-        public unsafe static Vector128<float> GatherVector128(float* baseAddress, Vector128<long> index, byte scale);
+        public unsafe static Vector128<float> GatherVector128(float* baseAddress, Vector128<long> index, [ConstantExpectedAttribute(Min=(byte)1, Max=(byte)8)] byte scale);
-        public unsafe static Vector128<float> GatherVector128(float* baseAddress, Vector256<long> index, byte scale);
+        public unsafe static Vector128<float> GatherVector128(float* baseAddress, Vector256<long> index, [ConstantExpectedAttribute(Min=(byte)1, Max=(byte)8)] byte scale);
-        public unsafe static Vector128<uint> GatherVector128(uint* baseAddress, Vector128<int> index, byte scale);
+        public unsafe static Vector128<uint> GatherVector128(uint* baseAddress, Vector128<int> index, [ConstantExpectedAttribute(Min=(byte)1, Max=(byte)8)] byte scale);
-        public unsafe static Vector128<uint> GatherVector128(uint* baseAddress, Vector128<long> index, byte scale);
+        public unsafe static Vector128<uint> GatherVector128(uint* baseAddress, Vector128<long> index, [ConstantExpectedAttribute(Min=(byte)1, Max=(byte)8)] byte scale);
-        public unsafe static Vector128<uint> GatherVector128(uint* baseAddress, Vector256<long> index, byte scale);
+        public unsafe static Vector128<uint> GatherVector128(uint* baseAddress, Vector256<long> index, [ConstantExpectedAttribute(Min=(byte)1, Max=(byte)8)] byte scale);
-        public unsafe static Vector128<ulong> GatherVector128(ulong* baseAddress, Vector128<int> index, byte scale);
+        public unsafe static Vector128<ulong> GatherVector128(ulong* baseAddress, Vector128<int> index, [ConstantExpectedAttribute(Min=(byte)1, Max=(byte)8)] byte scale);
-        public unsafe static Vector128<ulong> GatherVector128(ulong* baseAddress, Vector128<long> index, byte scale);
+        public unsafe static Vector128<ulong> GatherVector128(ulong* baseAddress, Vector128<long> index, [ConstantExpectedAttribute(Min=(byte)1, Max=(byte)8)] byte scale);
-        public unsafe static Vector256<double> GatherVector256(double* baseAddress, Vector128<int> index, byte scale);
+        public unsafe static Vector256<double> GatherVector256(double* baseAddress, Vector128<int> index, [ConstantExpectedAttribute(Min=(byte)1, Max=(byte)8)] byte scale);
-        public unsafe static Vector256<double> GatherVector256(double* baseAddress, Vector256<long> index, byte scale);
+        public unsafe static Vector256<double> GatherVector256(double* baseAddress, Vector256<long> index, [ConstantExpectedAttribute(Min=(byte)1, Max=(byte)8)] byte scale);
-        public unsafe static Vector256<int> GatherVector256(int* baseAddress, Vector256<int> index, byte scale);
+        public unsafe static Vector256<int> GatherVector256(int* baseAddress, Vector256<int> index, [ConstantExpectedAttribute(Min=(byte)1, Max=(byte)8)] byte scale);
-        public unsafe static Vector256<long> GatherVector256(long* baseAddress, Vector128<int> index, byte scale);
+        public unsafe static Vector256<long> GatherVector256(long* baseAddress, Vector128<int> index, [ConstantExpectedAttribute(Min=(byte)1, Max=(byte)8)] byte scale);
-        public unsafe static Vector256<long> GatherVector256(long* baseAddress, Vector256<long> index, byte scale);
+        public unsafe static Vector256<long> GatherVector256(long* baseAddress, Vector256<long> index, [ConstantExpectedAttribute(Min=(byte)1, Max=(byte)8)] byte scale);
-        public unsafe static Vector256<float> GatherVector256(float* baseAddress, Vector256<int> index, byte scale);
+        public unsafe static Vector256<float> GatherVector256(float* baseAddress, Vector256<int> index, [ConstantExpectedAttribute(Min=(byte)1, Max=(byte)8)] byte scale);
-        public unsafe static Vector256<uint> GatherVector256(uint* baseAddress, Vector256<int> index, byte scale);
+        public unsafe static Vector256<uint> GatherVector256(uint* baseAddress, Vector256<int> index, [ConstantExpectedAttribute(Min=(byte)1, Max=(byte)8)] byte scale);
-        public unsafe static Vector256<ulong> GatherVector256(ulong* baseAddress, Vector128<int> index, byte scale);
+        public unsafe static Vector256<ulong> GatherVector256(ulong* baseAddress, Vector128<int> index, [ConstantExpectedAttribute(Min=(byte)1, Max=(byte)8)] byte scale);
-        public unsafe static Vector256<ulong> GatherVector256(ulong* baseAddress, Vector256<long> index, byte scale);
+        public unsafe static Vector256<ulong> GatherVector256(ulong* baseAddress, Vector256<long> index, [ConstantExpectedAttribute(Min=(byte)1, Max=(byte)8)] byte scale);
-        public static new Vector256<byte> InsertVector128(Vector256<byte> value, Vector128<byte> data, byte index);
+        public static new Vector256<byte> InsertVector128(Vector256<byte> value, Vector128<byte> data, [ConstantExpectedAttribute] byte index);
-        public static new Vector256<short> InsertVector128(Vector256<short> value, Vector128<short> data, byte index);
+        public static new Vector256<short> InsertVector128(Vector256<short> value, Vector128<short> data, [ConstantExpectedAttribute] byte index);
-        public static new Vector256<int> InsertVector128(Vector256<int> value, Vector128<int> data, byte index);
+        public static new Vector256<int> InsertVector128(Vector256<int> value, Vector128<int> data, [ConstantExpectedAttribute] byte index);
-        public static new Vector256<long> InsertVector128(Vector256<long> value, Vector128<long> data, byte index);
+        public static new Vector256<long> InsertVector128(Vector256<long> value, Vector128<long> data, [ConstantExpectedAttribute] byte index);
-        public static new Vector256<sbyte> InsertVector128(Vector256<sbyte> value, Vector128<sbyte> data, byte index);
+        public static new Vector256<sbyte> InsertVector128(Vector256<sbyte> value, Vector128<sbyte> data, [ConstantExpectedAttribute] byte index);
-        public static new Vector256<ushort> InsertVector128(Vector256<ushort> value, Vector128<ushort> data, byte index);
+        public static new Vector256<ushort> InsertVector128(Vector256<ushort> value, Vector128<ushort> data, [ConstantExpectedAttribute] byte index);
-        public static new Vector256<uint> InsertVector128(Vector256<uint> value, Vector128<uint> data, byte index);
+        public static new Vector256<uint> InsertVector128(Vector256<uint> value, Vector128<uint> data, [ConstantExpectedAttribute] byte index);
-        public static new Vector256<ulong> InsertVector128(Vector256<ulong> value, Vector128<ulong> data, byte index);
+        public static new Vector256<ulong> InsertVector128(Vector256<ulong> value, Vector128<ulong> data, [ConstantExpectedAttribute] byte index);
-        public static Vector256<ushort> MultipleSumAbsoluteDifferences(Vector256<byte> left, Vector256<byte> right, byte mask);
+        public static Vector256<ushort> MultipleSumAbsoluteDifferences(Vector256<byte> left, Vector256<byte> right, [ConstantExpectedAttribute] byte mask);
-        public static new Vector256<byte> Permute2x128(Vector256<byte> left, Vector256<byte> right, byte control);
+        public static new Vector256<byte> Permute2x128(Vector256<byte> left, Vector256<byte> right, [ConstantExpectedAttribute] byte control);
-        public static new Vector256<short> Permute2x128(Vector256<short> left, Vector256<short> right, byte control);
+        public static new Vector256<short> Permute2x128(Vector256<short> left, Vector256<short> right, [ConstantExpectedAttribute] byte control);
-        public static new Vector256<int> Permute2x128(Vector256<int> left, Vector256<int> right, byte control);
+        public static new Vector256<int> Permute2x128(Vector256<int> left, Vector256<int> right, [ConstantExpectedAttribute] byte control);
-        public static new Vector256<long> Permute2x128(Vector256<long> left, Vector256<long> right, byte control);
+        public static new Vector256<long> Permute2x128(Vector256<long> left, Vector256<long> right, [ConstantExpectedAttribute] byte control);
-        public static new Vector256<sbyte> Permute2x128(Vector256<sbyte> left, Vector256<sbyte> right, byte control);
+        public static new Vector256<sbyte> Permute2x128(Vector256<sbyte> left, Vector256<sbyte> right, [ConstantExpectedAttribute] byte control);
-        public static new Vector256<ushort> Permute2x128(Vector256<ushort> left, Vector256<ushort> right, byte control);
+        public static new Vector256<ushort> Permute2x128(Vector256<ushort> left, Vector256<ushort> right, [ConstantExpectedAttribute] byte control);
-        public static new Vector256<uint> Permute2x128(Vector256<uint> left, Vector256<uint> right, byte control);
+        public static new Vector256<uint> Permute2x128(Vector256<uint> left, Vector256<uint> right, [ConstantExpectedAttribute] byte control);
-        public static new Vector256<ulong> Permute2x128(Vector256<ulong> left, Vector256<ulong> right, byte control);
+        public static new Vector256<ulong> Permute2x128(Vector256<ulong> left, Vector256<ulong> right, [ConstantExpectedAttribute] byte control);
-        public static Vector256<double> Permute4x64(Vector256<double> value, byte control);
+        public static Vector256<double> Permute4x64(Vector256<double> value, [ConstantExpectedAttribute] byte control);
-        public static Vector256<long> Permute4x64(Vector256<long> value, byte control);
+        public static Vector256<long> Permute4x64(Vector256<long> value, [ConstantExpectedAttribute] byte control);
-        public static Vector256<ulong> Permute4x64(Vector256<ulong> value, byte control);
+        public static Vector256<ulong> Permute4x64(Vector256<ulong> value, [ConstantExpectedAttribute] byte control);
-        public static Vector256<short> ShiftLeftLogical(Vector256<short> value, byte count);
+        public static Vector256<short> ShiftLeftLogical(Vector256<short> value, [ConstantExpectedAttribute] byte count);
-        public static Vector256<int> ShiftLeftLogical(Vector256<int> value, byte count);
+        public static Vector256<int> ShiftLeftLogical(Vector256<int> value, [ConstantExpectedAttribute] byte count);
-        public static Vector256<long> ShiftLeftLogical(Vector256<long> value, byte count);
+        public static Vector256<long> ShiftLeftLogical(Vector256<long> value, [ConstantExpectedAttribute] byte count);
-        public static Vector256<ushort> ShiftLeftLogical(Vector256<ushort> value, byte count);
+        public static Vector256<ushort> ShiftLeftLogical(Vector256<ushort> value, [ConstantExpectedAttribute] byte count);
-        public static Vector256<uint> ShiftLeftLogical(Vector256<uint> value, byte count);
+        public static Vector256<uint> ShiftLeftLogical(Vector256<uint> value, [ConstantExpectedAttribute] byte count);
-        public static Vector256<ulong> ShiftLeftLogical(Vector256<ulong> value, byte count);
+        public static Vector256<ulong> ShiftLeftLogical(Vector256<ulong> value, [ConstantExpectedAttribute] byte count);
-        public static Vector256<byte> ShiftLeftLogical128BitLane(Vector256<byte> value, byte numBytes);
+        public static Vector256<byte> ShiftLeftLogical128BitLane(Vector256<byte> value, [ConstantExpectedAttribute] byte numBytes);
-        public static Vector256<short> ShiftLeftLogical128BitLane(Vector256<short> value, byte numBytes);
+        public static Vector256<short> ShiftLeftLogical128BitLane(Vector256<short> value, [ConstantExpectedAttribute] byte numBytes);
-        public static Vector256<int> ShiftLeftLogical128BitLane(Vector256<int> value, byte numBytes);
+        public static Vector256<int> ShiftLeftLogical128BitLane(Vector256<int> value, [ConstantExpectedAttribute] byte numBytes);
-        public static Vector256<long> ShiftLeftLogical128BitLane(Vector256<long> value, byte numBytes);
+        public static Vector256<long> ShiftLeftLogical128BitLane(Vector256<long> value, [ConstantExpectedAttribute] byte numBytes);
-        public static Vector256<sbyte> ShiftLeftLogical128BitLane(Vector256<sbyte> value, byte numBytes);
+        public static Vector256<sbyte> ShiftLeftLogical128BitLane(Vector256<sbyte> value, [ConstantExpectedAttribute] byte numBytes);
-        public static Vector256<ushort> ShiftLeftLogical128BitLane(Vector256<ushort> value, byte numBytes);
+        public static Vector256<ushort> ShiftLeftLogical128BitLane(Vector256<ushort> value, [ConstantExpectedAttribute] byte numBytes);
-        public static Vector256<uint> ShiftLeftLogical128BitLane(Vector256<uint> value, byte numBytes);
+        public static Vector256<uint> ShiftLeftLogical128BitLane(Vector256<uint> value, [ConstantExpectedAttribute] byte numBytes);
-        public static Vector256<ulong> ShiftLeftLogical128BitLane(Vector256<ulong> value, byte numBytes);
+        public static Vector256<ulong> ShiftLeftLogical128BitLane(Vector256<ulong> value, [ConstantExpectedAttribute] byte numBytes);
-        public static Vector256<short> ShiftRightArithmetic(Vector256<short> value, byte count);
+        public static Vector256<short> ShiftRightArithmetic(Vector256<short> value, [ConstantExpectedAttribute] byte count);
-        public static Vector256<int> ShiftRightArithmetic(Vector256<int> value, byte count);
+        public static Vector256<int> ShiftRightArithmetic(Vector256<int> value, [ConstantExpectedAttribute] byte count);
-        public static Vector256<short> ShiftRightLogical(Vector256<short> value, byte count);
+        public static Vector256<short> ShiftRightLogical(Vector256<short> value, [ConstantExpectedAttribute] byte count);
-        public static Vector256<int> ShiftRightLogical(Vector256<int> value, byte count);
+        public static Vector256<int> ShiftRightLogical(Vector256<int> value, [ConstantExpectedAttribute] byte count);
-        public static Vector256<long> ShiftRightLogical(Vector256<long> value, byte count);
+        public static Vector256<long> ShiftRightLogical(Vector256<long> value, [ConstantExpectedAttribute] byte count);
-        public static Vector256<ushort> ShiftRightLogical(Vector256<ushort> value, byte count);
+        public static Vector256<ushort> ShiftRightLogical(Vector256<ushort> value, [ConstantExpectedAttribute] byte count);
-        public static Vector256<uint> ShiftRightLogical(Vector256<uint> value, byte count);
+        public static Vector256<uint> ShiftRightLogical(Vector256<uint> value, [ConstantExpectedAttribute] byte count);
-        public static Vector256<ulong> ShiftRightLogical(Vector256<ulong> value, byte count);
+        public static Vector256<ulong> ShiftRightLogical(Vector256<ulong> value, [ConstantExpectedAttribute] byte count);
-        public static Vector256<byte> ShiftRightLogical128BitLane(Vector256<byte> value, byte numBytes);
+        public static Vector256<byte> ShiftRightLogical128BitLane(Vector256<byte> value, [ConstantExpectedAttribute] byte numBytes);
-        public static Vector256<short> ShiftRightLogical128BitLane(Vector256<short> value, byte numBytes);
+        public static Vector256<short> ShiftRightLogical128BitLane(Vector256<short> value, [ConstantExpectedAttribute] byte numBytes);
-        public static Vector256<int> ShiftRightLogical128BitLane(Vector256<int> value, byte numBytes);
+        public static Vector256<int> ShiftRightLogical128BitLane(Vector256<int> value, [ConstantExpectedAttribute] byte numBytes);
-        public static Vector256<long> ShiftRightLogical128BitLane(Vector256<long> value, byte numBytes);
+        public static Vector256<long> ShiftRightLogical128BitLane(Vector256<long> value, [ConstantExpectedAttribute] byte numBytes);
-        public static Vector256<sbyte> ShiftRightLogical128BitLane(Vector256<sbyte> value, byte numBytes);
+        public static Vector256<sbyte> ShiftRightLogical128BitLane(Vector256<sbyte> value, [ConstantExpectedAttribute] byte numBytes);
-        public static Vector256<ushort> ShiftRightLogical128BitLane(Vector256<ushort> value, byte numBytes);
+        public static Vector256<ushort> ShiftRightLogical128BitLane(Vector256<ushort> value, [ConstantExpectedAttribute] byte numBytes);
-        public static Vector256<uint> ShiftRightLogical128BitLane(Vector256<uint> value, byte numBytes);
+        public static Vector256<uint> ShiftRightLogical128BitLane(Vector256<uint> value, [ConstantExpectedAttribute] byte numBytes);
-        public static Vector256<ulong> ShiftRightLogical128BitLane(Vector256<ulong> value, byte numBytes);
+        public static Vector256<ulong> ShiftRightLogical128BitLane(Vector256<ulong> value, [ConstantExpectedAttribute] byte numBytes);
-        public static Vector256<int> Shuffle(Vector256<int> value, byte control);
+        public static Vector256<int> Shuffle(Vector256<int> value, [ConstantExpectedAttribute] byte control);
-        public static Vector256<uint> Shuffle(Vector256<uint> value, byte control);
+        public static Vector256<uint> Shuffle(Vector256<uint> value, [ConstantExpectedAttribute] byte control);
-        public static Vector256<short> ShuffleHigh(Vector256<short> value, byte control);
+        public static Vector256<short> ShuffleHigh(Vector256<short> value, [ConstantExpectedAttribute] byte control);
-        public static Vector256<ushort> ShuffleHigh(Vector256<ushort> value, byte control);
+        public static Vector256<ushort> ShuffleHigh(Vector256<ushort> value, [ConstantExpectedAttribute] byte control);
-        public static Vector256<short> ShuffleLow(Vector256<short> value, byte control);
+        public static Vector256<short> ShuffleLow(Vector256<short> value, [ConstantExpectedAttribute] byte control);
-        public static Vector256<ushort> ShuffleLow(Vector256<ushort> value, byte control);
+        public static Vector256<ushort> ShuffleLow(Vector256<ushort> value, [ConstantExpectedAttribute] byte control);
     }
+    [CLSCompliantAttribute(false)]
+    public abstract class Avx512BW : Avx512F {
+        public static new bool IsSupported { get; }
+        public static Vector512<ushort> Abs(Vector512<short> value);
+        public static Vector512<byte> Abs(Vector512<sbyte> value);
+        public static Vector512<byte> Add(Vector512<byte> left, Vector512<byte> right);
+        public static Vector512<short> Add(Vector512<short> left, Vector512<short> right);
+        public static Vector512<sbyte> Add(Vector512<sbyte> left, Vector512<sbyte> right);
+        public static Vector512<ushort> Add(Vector512<ushort> left, Vector512<ushort> right);
+        public static Vector512<byte> AddSaturate(Vector512<byte> left, Vector512<byte> right);
+        public static Vector512<short> AddSaturate(Vector512<short> left, Vector512<short> right);
+        public static Vector512<sbyte> AddSaturate(Vector512<sbyte> left, Vector512<sbyte> right);
+        public static Vector512<ushort> AddSaturate(Vector512<ushort> left, Vector512<ushort> right);
+        public static Vector512<byte> AlignRight(Vector512<byte> left, Vector512<byte> right, [ConstantExpectedAttribute] byte mask);
+        public static Vector512<sbyte> AlignRight(Vector512<sbyte> left, Vector512<sbyte> right, [ConstantExpectedAttribute] byte mask);
+        public static Vector512<byte> Average(Vector512<byte> left, Vector512<byte> right);
+        public static Vector512<ushort> Average(Vector512<ushort> left, Vector512<ushort> right);
+        public static Vector512<byte> BlendVariable(Vector512<byte> left, Vector512<byte> right, Vector512<byte> mask);
+        public static Vector512<short> BlendVariable(Vector512<short> left, Vector512<short> right, Vector512<short> mask);
+        public static Vector512<sbyte> BlendVariable(Vector512<sbyte> left, Vector512<sbyte> right, Vector512<sbyte> mask);
+        public static Vector512<ushort> BlendVariable(Vector512<ushort> left, Vector512<ushort> right, Vector512<ushort> mask);
+        public static Vector512<byte> BroadcastScalarToVector512(Vector128<byte> value);
+        public static Vector512<short> BroadcastScalarToVector512(Vector128<short> value);
+        public static Vector512<sbyte> BroadcastScalarToVector512(Vector128<sbyte> value);
+        public static Vector512<ushort> BroadcastScalarToVector512(Vector128<ushort> value);
+        public static Vector512<byte> CompareEqual(Vector512<byte> left, Vector512<byte> right);
+        public static Vector512<short> CompareEqual(Vector512<short> left, Vector512<short> right);
+        public static Vector512<sbyte> CompareEqual(Vector512<sbyte> left, Vector512<sbyte> right);
+        public static Vector512<ushort> CompareEqual(Vector512<ushort> left, Vector512<ushort> right);
+        public static Vector512<byte> CompareGreaterThan(Vector512<byte> left, Vector512<byte> right);
+        public static Vector512<short> CompareGreaterThan(Vector512<short> left, Vector512<short> right);
+        public static Vector512<sbyte> CompareGreaterThan(Vector512<sbyte> left, Vector512<sbyte> right);
+        public static Vector512<ushort> CompareGreaterThan(Vector512<ushort> left, Vector512<ushort> right);
+        public static Vector512<byte> CompareGreaterThanOrEqual(Vector512<byte> left, Vector512<byte> right);
+        public static Vector512<short> CompareGreaterThanOrEqual(Vector512<short> left, Vector512<short> right);
+        public static Vector512<sbyte> CompareGreaterThanOrEqual(Vector512<sbyte> left, Vector512<sbyte> right);
+        public static Vector512<ushort> CompareGreaterThanOrEqual(Vector512<ushort> left, Vector512<ushort> right);
+        public static Vector512<byte> CompareLessThan(Vector512<byte> left, Vector512<byte> right);
+        public static Vector512<short> CompareLessThan(Vector512<short> left, Vector512<short> right);
+        public static Vector512<sbyte> CompareLessThan(Vector512<sbyte> left, Vector512<sbyte> right);
+        public static Vector512<ushort> CompareLessThan(Vector512<ushort> left, Vector512<ushort> right);
+        public static Vector512<byte> CompareLessThanOrEqual(Vector512<byte> left, Vector512<byte> right);
+        public static Vector512<short> CompareLessThanOrEqual(Vector512<short> left, Vector512<short> right);
+        public static Vector512<sbyte> CompareLessThanOrEqual(Vector512<sbyte> left, Vector512<sbyte> right);
+        public static Vector512<ushort> CompareLessThanOrEqual(Vector512<ushort> left, Vector512<ushort> right);
+        public static Vector512<byte> CompareNotEqual(Vector512<byte> left, Vector512<byte> right);
+        public static Vector512<short> CompareNotEqual(Vector512<short> left, Vector512<short> right);
+        public static Vector512<sbyte> CompareNotEqual(Vector512<sbyte> left, Vector512<sbyte> right);
+        public static Vector512<ushort> CompareNotEqual(Vector512<ushort> left, Vector512<ushort> right);
+        public static Vector256<byte> ConvertToVector256Byte(Vector512<short> value);
+        public static Vector256<byte> ConvertToVector256Byte(Vector512<ushort> value);
+        public static Vector256<byte> ConvertToVector256ByteWithSaturation(Vector512<ushort> value);
+        public static Vector256<sbyte> ConvertToVector256SByte(Vector512<short> value);
+        public static Vector256<sbyte> ConvertToVector256SByte(Vector512<ushort> value);
+        public static Vector256<sbyte> ConvertToVector256SByteWithSaturation(Vector512<short> value);
+        public static Vector512<short> ConvertToVector512Int16(Vector256<byte> value);
+        public static Vector512<short> ConvertToVector512Int16(Vector256<sbyte> value);
+        public static Vector512<ushort> ConvertToVector512UInt16(Vector256<byte> value);
+        public static Vector512<ushort> ConvertToVector512UInt16(Vector256<sbyte> value);
+        public unsafe static new Vector512<byte> LoadVector512(byte* address);
+        public unsafe static new Vector512<short> LoadVector512(short* address);
+        public unsafe static new Vector512<sbyte> LoadVector512(sbyte* address);
+        public unsafe static new Vector512<ushort> LoadVector512(ushort* address);
+        public static Vector512<byte> Max(Vector512<byte> left, Vector512<byte> right);
+        public static Vector512<short> Max(Vector512<short> left, Vector512<short> right);
+        public static Vector512<sbyte> Max(Vector512<sbyte> left, Vector512<sbyte> right);
+        public static Vector512<ushort> Max(Vector512<ushort> left, Vector512<ushort> right);
+        public static Vector512<byte> Min(Vector512<byte> left, Vector512<byte> right);
+        public static Vector512<short> Min(Vector512<short> left, Vector512<short> right);
+        public static Vector512<sbyte> Min(Vector512<sbyte> left, Vector512<sbyte> right);
+        public static Vector512<ushort> Min(Vector512<ushort> left, Vector512<ushort> right);
+        public static Vector512<short> MultiplyAddAdjacent(Vector512<byte> left, Vector512<sbyte> right);
+        public static Vector512<int> MultiplyAddAdjacent(Vector512<short> left, Vector512<short> right);
+        public static Vector512<short> MultiplyHigh(Vector512<short> left, Vector512<short> right);
+        public static Vector512<ushort> MultiplyHigh(Vector512<ushort> left, Vector512<ushort> right);
+        public static Vector512<short> MultiplyHighRoundScale(Vector512<short> left, Vector512<short> right);
+        public static Vector512<short> MultiplyLow(Vector512<short> left, Vector512<short> right);
+        public static Vector512<ushort> MultiplyLow(Vector512<ushort> left, Vector512<ushort> right);
+        public static Vector512<sbyte> PackSignedSaturate(Vector512<short> left, Vector512<short> right);
+        public static Vector512<short> PackSignedSaturate(Vector512<int> left, Vector512<int> right);
+        public static Vector512<byte> PackUnsignedSaturate(Vector512<short> left, Vector512<short> right);
+        public static Vector512<ushort> PackUnsignedSaturate(Vector512<int> left, Vector512<int> right);
+        public static Vector512<short> PermuteVar32x16(Vector512<short> left, Vector512<short> control);
+        public static Vector512<ushort> PermuteVar32x16(Vector512<ushort> left, Vector512<ushort> control);
+        public static Vector512<short> PermuteVar32x16x2(Vector512<short> lower, Vector512<short> indices, Vector512<short> upper);
+        public static Vector512<ushort> PermuteVar32x16x2(Vector512<ushort> lower, Vector512<ushort> indices, Vector512<ushort> upper);
+        public static Vector512<short> ShiftLeftLogical(Vector512<short> value, [ConstantExpectedAttribute] byte count);
+        public static Vector512<short> ShiftLeftLogical(Vector512<short> value, Vector128<short> count);
+        public static Vector512<ushort> ShiftLeftLogical(Vector512<ushort> value, [ConstantExpectedAttribute] byte count);
+        public static Vector512<ushort> ShiftLeftLogical(Vector512<ushort> value, Vector128<ushort> count);
+        public static Vector512<byte> ShiftLeftLogical128BitLane(Vector512<byte> value, [ConstantExpectedAttribute] byte numBytes);
+        public static Vector512<sbyte> ShiftLeftLogical128BitLane(Vector512<sbyte> value, [ConstantExpectedAttribute] byte numBytes);
+        public static Vector512<short> ShiftLeftLogicalVariable(Vector512<short> value, Vector512<ushort> count);
+        public static Vector512<ushort> ShiftLeftLogicalVariable(Vector512<ushort> value, Vector512<ushort> count);
+        public static Vector512<short> ShiftRightArithmetic(Vector512<short> value, [ConstantExpectedAttribute] byte count);
+        public static Vector512<short> ShiftRightArithmetic(Vector512<short> value, Vector128<short> count);
+        public static Vector512<short> ShiftRightArithmeticVariable(Vector512<short> value, Vector512<ushort> count);
+        public static Vector512<short> ShiftRightLogical(Vector512<short> value, [ConstantExpectedAttribute] byte count);
+        public static Vector512<short> ShiftRightLogical(Vector512<short> value, Vector128<short> count);
+        public static Vector512<ushort> ShiftRightLogical(Vector512<ushort> value, [ConstantExpectedAttribute] byte count);
+        public static Vector512<ushort> ShiftRightLogical(Vector512<ushort> value, Vector128<ushort> count);
+        public static Vector512<byte> ShiftRightLogical128BitLane(Vector512<byte> value, [ConstantExpectedAttribute] byte numBytes);
+        public static Vector512<sbyte> ShiftRightLogical128BitLane(Vector512<sbyte> value, [ConstantExpectedAttribute] byte numBytes);
+        public static Vector512<short> ShiftRightLogicalVariable(Vector512<short> value, Vector512<ushort> count);
+        public static Vector512<ushort> ShiftRightLogicalVariable(Vector512<ushort> value, Vector512<ushort> count);
+        public static Vector512<byte> Shuffle(Vector512<byte> value, Vector512<byte> mask);
+        public static Vector512<sbyte> Shuffle(Vector512<sbyte> value, Vector512<sbyte> mask);
+        public static Vector512<short> ShuffleHigh(Vector512<short> value, [ConstantExpectedAttribute] byte control);
+        public static Vector512<ushort> ShuffleHigh(Vector512<ushort> value, [ConstantExpectedAttribute] byte control);
+        public static Vector512<short> ShuffleLow(Vector512<short> value, [ConstantExpectedAttribute] byte control);
+        public static Vector512<ushort> ShuffleLow(Vector512<ushort> value, [ConstantExpectedAttribute] byte control);
+        public unsafe static new void Store(byte* address, Vector512<byte> source);
+        public unsafe static new void Store(short* address, Vector512<short> source);
+        public unsafe static new void Store(sbyte* address, Vector512<sbyte> source);
+        public unsafe static new void Store(ushort* address, Vector512<ushort> source);
+        public static Vector512<byte> Subtract(Vector512<byte> left, Vector512<byte> right);
+        public static Vector512<short> Subtract(Vector512<short> left, Vector512<short> right);
+        public static Vector512<sbyte> Subtract(Vector512<sbyte> left, Vector512<sbyte> right);
+        public static Vector512<ushort> Subtract(Vector512<ushort> left, Vector512<ushort> right);
+        public static Vector512<byte> SubtractSaturate(Vector512<byte> left, Vector512<byte> right);
+        public static Vector512<short> SubtractSaturate(Vector512<short> left, Vector512<short> right);
+        public static Vector512<sbyte> SubtractSaturate(Vector512<sbyte> left, Vector512<sbyte> right);
+        public static Vector512<ushort> SubtractSaturate(Vector512<ushort> left, Vector512<ushort> right);
+        public static Vector512<ushort> SumAbsoluteDifferences(Vector512<byte> left, Vector512<byte> right);
+        public static Vector512<ushort> SumAbsoluteDifferencesInBlock32(Vector512<byte> left, Vector512<byte> right, [ConstantExpectedAttribute] byte control);
+        public static Vector512<byte> UnpackHigh(Vector512<byte> left, Vector512<byte> right);
+        public static Vector512<short> UnpackHigh(Vector512<short> left, Vector512<short> right);
+        public static Vector512<sbyte> UnpackHigh(Vector512<sbyte> left, Vector512<sbyte> right);
+        public static Vector512<ushort> UnpackHigh(Vector512<ushort> left, Vector512<ushort> right);
+        public static Vector512<byte> UnpackLow(Vector512<byte> left, Vector512<byte> right);
+        public static Vector512<short> UnpackLow(Vector512<short> left, Vector512<short> right);
+        public static Vector512<sbyte> UnpackLow(Vector512<sbyte> left, Vector512<sbyte> right);
+        public static Vector512<ushort> UnpackLow(Vector512<ushort> left, Vector512<ushort> right);
+        public new abstract class VL : Avx512F.VL {
+            public static new bool IsSupported { get; }
+            public static Vector128<byte> CompareGreaterThan(Vector128<byte> left, Vector128<byte> right);
+            public static Vector128<ushort> CompareGreaterThan(Vector128<ushort> left, Vector128<ushort> right);
+            public static Vector256<byte> CompareGreaterThan(Vector256<byte> left, Vector256<byte> right);
+            public static Vector256<ushort> CompareGreaterThan(Vector256<ushort> left, Vector256<ushort> right);
+            public static Vector128<byte> CompareGreaterThanOrEqual(Vector128<byte> left, Vector128<byte> right);
+            public static Vector128<short> CompareGreaterThanOrEqual(Vector128<short> left, Vector128<short> right);
+            public static Vector128<sbyte> CompareGreaterThanOrEqual(Vector128<sbyte> left, Vector128<sbyte> right);
+            public static Vector128<ushort> CompareGreaterThanOrEqual(Vector128<ushort> left, Vector128<ushort> right);
+            public static Vector256<byte> CompareGreaterThanOrEqual(Vector256<byte> left, Vector256<byte> right);
+            public static Vector256<short> CompareGreaterThanOrEqual(Vector256<short> left, Vector256<short> right);
+            public static Vector256<sbyte> CompareGreaterThanOrEqual(Vector256<sbyte> left, Vector256<sbyte> right);
+            public static Vector256<ushort> CompareGreaterThanOrEqual(Vector256<ushort> left, Vector256<ushort> right);
+            public static Vector128<byte> CompareLessThan(Vector128<byte> left, Vector128<byte> right);
+            public static Vector128<short> CompareLessThan(Vector128<short> left, Vector128<short> right);
+            public static Vector128<sbyte> CompareLessThan(Vector128<sbyte> left, Vector128<sbyte> right);
+            public static Vector128<ushort> CompareLessThan(Vector128<ushort> left, Vector128<ushort> right);
+            public static Vector256<byte> CompareLessThan(Vector256<byte> left, Vector256<byte> right);
+            public static Vector256<short> CompareLessThan(Vector256<short> left, Vector256<short> right);
+            public static Vector256<sbyte> CompareLessThan(Vector256<sbyte> left, Vector256<sbyte> right);
+            public static Vector256<ushort> CompareLessThan(Vector256<ushort> left, Vector256<ushort> right);
+            public static Vector128<byte> CompareLessThanOrEqual(Vector128<byte> left, Vector128<byte> right);
+            public static Vector128<short> CompareLessThanOrEqual(Vector128<short> left, Vector128<short> right);
+            public static Vector128<sbyte> CompareLessThanOrEqual(Vector128<sbyte> left, Vector128<sbyte> right);
+            public static Vector128<ushort> CompareLessThanOrEqual(Vector128<ushort> left, Vector128<ushort> right);
+            public static Vector256<byte> CompareLessThanOrEqual(Vector256<byte> left, Vector256<byte> right);
+            public static Vector256<short> CompareLessThanOrEqual(Vector256<short> left, Vector256<short> right);
+            public static Vector256<sbyte> CompareLessThanOrEqual(Vector256<sbyte> left, Vector256<sbyte> right);
+            public static Vector256<ushort> CompareLessThanOrEqual(Vector256<ushort> left, Vector256<ushort> right);
+            public static Vector128<byte> CompareNotEqual(Vector128<byte> left, Vector128<byte> right);
+            public static Vector128<short> CompareNotEqual(Vector128<short> left, Vector128<short> right);
+            public static Vector128<sbyte> CompareNotEqual(Vector128<sbyte> left, Vector128<sbyte> right);
+            public static Vector128<ushort> CompareNotEqual(Vector128<ushort> left, Vector128<ushort> right);
+            public static Vector256<byte> CompareNotEqual(Vector256<byte> left, Vector256<byte> right);
+            public static Vector256<short> CompareNotEqual(Vector256<short> left, Vector256<short> right);
+            public static Vector256<sbyte> CompareNotEqual(Vector256<sbyte> left, Vector256<sbyte> right);
+            public static Vector256<ushort> CompareNotEqual(Vector256<ushort> left, Vector256<ushort> right);
+            public static Vector128<byte> ConvertToVector128Byte(Vector128<short> value);
+            public static Vector128<byte> ConvertToVector128Byte(Vector128<ushort> value);
+            public static Vector128<byte> ConvertToVector128Byte(Vector256<short> value);
+            public static Vector128<byte> ConvertToVector128Byte(Vector256<ushort> value);
+            public static Vector128<byte> ConvertToVector128ByteWithSaturation(Vector128<ushort> value);
+            public static Vector128<byte> ConvertToVector128ByteWithSaturation(Vector256<ushort> value);
+            public static Vector128<sbyte> ConvertToVector128SByte(Vector128<short> value);
+            public static Vector128<sbyte> ConvertToVector128SByte(Vector128<ushort> value);
+            public static Vector128<sbyte> ConvertToVector128SByte(Vector256<short> value);
+            public static Vector128<sbyte> ConvertToVector128SByte(Vector256<ushort> value);
+            public static Vector128<sbyte> ConvertToVector128SByteWithSaturation(Vector128<short> value);
+            public static Vector128<sbyte> ConvertToVector128SByteWithSaturation(Vector256<short> value);
+            public static Vector256<short> PermuteVar16x16(Vector256<short> left, Vector256<short> control);
+            public static Vector256<ushort> PermuteVar16x16(Vector256<ushort> left, Vector256<ushort> control);
+            public static Vector256<short> PermuteVar16x16x2(Vector256<short> lower, Vector256<short> indices, Vector256<short> upper);
+            public static Vector256<ushort> PermuteVar16x16x2(Vector256<ushort> lower, Vector256<ushort> indices, Vector256<ushort> upper);
+            public static Vector128<short> PermuteVar8x16(Vector128<short> left, Vector128<short> control);
+            public static Vector128<ushort> PermuteVar8x16(Vector128<ushort> left, Vector128<ushort> control);
+            public static Vector128<short> PermuteVar8x16x2(Vector128<short> lower, Vector128<short> indices, Vector128<short> upper);
+            public static Vector128<ushort> PermuteVar8x16x2(Vector128<ushort> lower, Vector128<ushort> indices, Vector128<ushort> upper);
+            public static Vector128<short> ShiftLeftLogicalVariable(Vector128<short> value, Vector128<ushort> count);
+            public static Vector128<ushort> ShiftLeftLogicalVariable(Vector128<ushort> value, Vector128<ushort> count);
+            public static Vector256<short> ShiftLeftLogicalVariable(Vector256<short> value, Vector256<ushort> count);
+            public static Vector256<ushort> ShiftLeftLogicalVariable(Vector256<ushort> value, Vector256<ushort> count);
+            public static Vector128<short> ShiftRightArithmeticVariable(Vector128<short> value, Vector128<ushort> count);
+            public static Vector256<short> ShiftRightArithmeticVariable(Vector256<short> value, Vector256<ushort> count);
+            public static Vector128<short> ShiftRightLogicalVariable(Vector128<short> value, Vector128<ushort> count);
+            public static Vector128<ushort> ShiftRightLogicalVariable(Vector128<ushort> value, Vector128<ushort> count);
+            public static Vector256<short> ShiftRightLogicalVariable(Vector256<short> value, Vector256<ushort> count);
+            public static Vector256<ushort> ShiftRightLogicalVariable(Vector256<ushort> value, Vector256<ushort> count);
+            public static Vector128<ushort> SumAbsoluteDifferencesInBlock32(Vector128<byte> left, Vector128<byte> right, [ConstantExpectedAttribute] byte control);
+            public static Vector256<ushort> SumAbsoluteDifferencesInBlock32(Vector256<byte> left, Vector256<byte> right, [ConstantExpectedAttribute] byte control);
+        }
+        public new abstract class X64 : Avx512F.X64 {
+            public static new bool IsSupported { get; }
+        }
+    }
+    [CLSCompliantAttribute(false)]
+    public abstract class Avx512CD : Avx512F {
+        public static new bool IsSupported { get; }
+        public static Vector512<int> DetectConflicts(Vector512<int> value);
+        public static Vector512<long> DetectConflicts(Vector512<long> value);
+        public static Vector512<uint> DetectConflicts(Vector512<uint> value);
+        public static Vector512<ulong> DetectConflicts(Vector512<ulong> value);
+        public static Vector512<int> LeadingZeroCount(Vector512<int> value);
+        public static Vector512<long> LeadingZeroCount(Vector512<long> value);
+        public static Vector512<uint> LeadingZeroCount(Vector512<uint> value);
+        public static Vector512<ulong> LeadingZeroCount(Vector512<ulong> value);
+        public new abstract class VL : Avx512F.VL {
+            public static new bool IsSupported { get; }
+            public static Vector128<int> DetectConflicts(Vector128<int> value);
+            public static Vector128<long> DetectConflicts(Vector128<long> value);
+            public static Vector128<uint> DetectConflicts(Vector128<uint> value);
+            public static Vector128<ulong> DetectConflicts(Vector128<ulong> value);
+            public static Vector256<int> DetectConflicts(Vector256<int> value);
+            public static Vector256<long> DetectConflicts(Vector256<long> value);
+            public static Vector256<uint> DetectConflicts(Vector256<uint> value);
+            public static Vector256<ulong> DetectConflicts(Vector256<ulong> value);
+            public static Vector128<int> LeadingZeroCount(Vector128<int> value);
+            public static Vector128<long> LeadingZeroCount(Vector128<long> value);
+            public static Vector128<uint> LeadingZeroCount(Vector128<uint> value);
+            public static Vector128<ulong> LeadingZeroCount(Vector128<ulong> value);
+            public static Vector256<int> LeadingZeroCount(Vector256<int> value);
+            public static Vector256<long> LeadingZeroCount(Vector256<long> value);
+            public static Vector256<uint> LeadingZeroCount(Vector256<uint> value);
+            public static Vector256<ulong> LeadingZeroCount(Vector256<ulong> value);
+        }
+        public new abstract class X64 : Avx512F.X64 {
+            public static new bool IsSupported { get; }
+        }
+    }
+    [CLSCompliantAttribute(false)]
+    public abstract class Avx512DQ : Avx512F {
+        public static new bool IsSupported { get; }
+        public static Vector512<double> And(Vector512<double> left, Vector512<double> right);
+        public static Vector512<float> And(Vector512<float> left, Vector512<float> right);
+        public static Vector512<double> AndNot(Vector512<double> left, Vector512<double> right);
+        public static Vector512<float> AndNot(Vector512<float> left, Vector512<float> right);
+        public static Vector512<int> BroadcastPairScalarToVector512(Vector128<int> value);
+        public static Vector512<float> BroadcastPairScalarToVector512(Vector128<float> value);
+        public static Vector512<uint> BroadcastPairScalarToVector512(Vector128<uint> value);
+        public unsafe static Vector512<double> BroadcastVector128ToVector512(double* address);
+        public unsafe static Vector512<long> BroadcastVector128ToVector512(long* address);
+        public unsafe static Vector512<ulong> BroadcastVector128ToVector512(ulong* address);
+        public unsafe static Vector512<int> BroadcastVector256ToVector512(int* address);
+        public unsafe static Vector512<float> BroadcastVector256ToVector512(float* address);
+        public unsafe static Vector512<uint> BroadcastVector256ToVector512(uint* address);
+        public static Vector256<float> ConvertToVector256Single(Vector512<long> value);
+        public static Vector256<float> ConvertToVector256Single(Vector512<ulong> value);
+        public static Vector512<double> ConvertToVector512Double(Vector512<long> value);
+        public static Vector512<double> ConvertToVector512Double(Vector512<ulong> value);
+        public static Vector512<long> ConvertToVector512Int64(Vector256<float> value);
+        public static Vector512<long> ConvertToVector512Int64(Vector512<double> value);
+        public static Vector512<long> ConvertToVector512Int64WithTruncation(Vector256<float> value);
+        public static Vector512<long> ConvertToVector512Int64WithTruncation(Vector512<double> value);
+        public static Vector512<ulong> ConvertToVector512UInt64(Vector256<float> value);
+        public static Vector512<ulong> ConvertToVector512UInt64(Vector512<double> value);
+        public static Vector512<ulong> ConvertToVector512UInt64WithTruncation(Vector256<float> value);
+        public static Vector512<ulong> ConvertToVector512UInt64WithTruncation(Vector512<double> value);
+        public static new Vector128<double> ExtractVector128(Vector512<double> value, [ConstantExpectedAttribute] byte index);
+        public static new Vector128<long> ExtractVector128(Vector512<long> value, [ConstantExpectedAttribute] byte index);
+        public static new Vector128<ulong> ExtractVector128(Vector512<ulong> value, [ConstantExpectedAttribute] byte index);
+        public static new Vector256<int> ExtractVector256(Vector512<int> value, [ConstantExpectedAttribute] byte index);
+        public static new Vector256<float> ExtractVector256(Vector512<float> value, [ConstantExpectedAttribute] byte index);
+        public static new Vector256<uint> ExtractVector256(Vector512<uint> value, [ConstantExpectedAttribute] byte index);
+        public static new Vector512<double> InsertVector128(Vector512<double> value, Vector128<double> data, [ConstantExpectedAttribute] byte index);
+        public static new Vector512<long> InsertVector128(Vector512<long> value, Vector128<long> data, [ConstantExpectedAttribute] byte index);
+        public static new Vector512<ulong> InsertVector128(Vector512<ulong> value, Vector128<ulong> data, [ConstantExpectedAttribute] byte index);
+        public static new Vector512<int> InsertVector256(Vector512<int> value, Vector256<int> data, [ConstantExpectedAttribute] byte index);
+        public static new Vector512<float> InsertVector256(Vector512<float> value, Vector256<float> data, [ConstantExpectedAttribute] byte index);
+        public static new Vector512<uint> InsertVector256(Vector512<uint> value, Vector256<uint> data, [ConstantExpectedAttribute] byte index);
+        public static Vector512<long> MultiplyLow(Vector512<long> left, Vector512<long> right);
+        public static Vector512<ulong> MultiplyLow(Vector512<ulong> left, Vector512<ulong> right);
+        public static Vector512<double> Or(Vector512<double> left, Vector512<double> right);
+        public static Vector512<float> Or(Vector512<float> left, Vector512<float> right);
+        public static Vector512<double> Range(Vector512<double> left, Vector512<double> right, [ConstantExpectedAttribute(Max=(byte)15)] byte control);
+        public static Vector512<float> Range(Vector512<float> left, Vector512<float> right, [ConstantExpectedAttribute(Max=(byte)15)] byte control);
+        public static Vector128<double> RangeScalar(Vector128<double> left, Vector128<double> right, [ConstantExpectedAttribute(Max=(byte)15)] byte control);
+        public static Vector128<float> RangeScalar(Vector128<float> left, Vector128<float> right, [ConstantExpectedAttribute(Max=(byte)15)] byte control);
+        public static Vector512<double> Reduce(Vector512<double> value, [ConstantExpectedAttribute] byte control);
+        public static Vector512<float> Reduce(Vector512<float> value, [ConstantExpectedAttribute] byte control);
+        public static Vector128<double> ReduceScalar(Vector128<double> value, [ConstantExpectedAttribute] byte control);
+        public static Vector128<double> ReduceScalar(Vector128<double> upper, Vector128<double> value, [ConstantExpectedAttribute] byte control);
+        public static Vector128<float> ReduceScalar(Vector128<float> value, [ConstantExpectedAttribute] byte control);
+        public static Vector128<float> ReduceScalar(Vector128<float> upper, Vector128<float> value, [ConstantExpectedAttribute] byte control);
+        public static Vector512<double> Xor(Vector512<double> left, Vector512<double> right);
+        public static Vector512<float> Xor(Vector512<float> left, Vector512<float> right);
+        public new abstract class VL : Avx512F.VL {
+            public static new bool IsSupported { get; }
+            public static Vector128<int> BroadcastPairScalarToVector128(Vector128<int> value);
+            public static Vector128<uint> BroadcastPairScalarToVector128(Vector128<uint> value);
+            public static Vector256<int> BroadcastPairScalarToVector256(Vector128<int> value);
+            public static Vector256<float> BroadcastPairScalarToVector256(Vector128<float> value);
+            public static Vector256<uint> BroadcastPairScalarToVector256(Vector128<uint> value);
+            public static Vector128<double> ConvertToVector128Double(Vector128<long> value);
+            public static Vector128<double> ConvertToVector128Double(Vector128<ulong> value);
+            public static Vector128<long> ConvertToVector128Int64(Vector128<double> value);
+            public static Vector128<long> ConvertToVector128Int64(Vector128<float> value);
+            public static Vector128<long> ConvertToVector128Int64WithTruncation(Vector128<double> value);
+            public static Vector128<long> ConvertToVector128Int64WithTruncation(Vector128<float> value);
+            public static Vector128<float> ConvertToVector128Single(Vector128<long> value);
+            public static Vector128<float> ConvertToVector128Single(Vector128<ulong> value);
+            public static Vector128<float> ConvertToVector128Single(Vector256<long> value);
+            public static Vector128<float> ConvertToVector128Single(Vector256<ulong> value);
+            public static Vector128<ulong> ConvertToVector128UInt64(Vector128<double> value);
+            public static Vector128<ulong> ConvertToVector128UInt64(Vector128<float> value);
+            public static Vector128<ulong> ConvertToVector128UInt64WithTruncation(Vector128<double> value);
+            public static Vector128<ulong> ConvertToVector128UInt64WithTruncation(Vector128<float> value);
+            public static Vector256<double> ConvertToVector256Double(Vector256<long> value);
+            public static Vector256<double> ConvertToVector256Double(Vector256<ulong> value);
+            public static Vector256<long> ConvertToVector256Int64(Vector128<float> value);
+            public static Vector256<long> ConvertToVector256Int64(Vector256<double> value);
+            public static Vector256<long> ConvertToVector256Int64WithTruncation(Vector128<float> value);
+            public static Vector256<long> ConvertToVector256Int64WithTruncation(Vector256<double> value);
+            public static Vector256<ulong> ConvertToVector256UInt64(Vector128<float> value);
+            public static Vector256<ulong> ConvertToVector256UInt64(Vector256<double> value);
+            public static Vector256<ulong> ConvertToVector256UInt64WithTruncation(Vector128<float> value);
+            public static Vector256<ulong> ConvertToVector256UInt64WithTruncation(Vector256<double> value);
+            public static Vector128<long> MultiplyLow(Vector128<long> left, Vector128<long> right);
+            public static Vector128<ulong> MultiplyLow(Vector128<ulong> left, Vector128<ulong> right);
+            public static Vector256<long> MultiplyLow(Vector256<long> left, Vector256<long> right);
+            public static Vector256<ulong> MultiplyLow(Vector256<ulong> left, Vector256<ulong> right);
+            public static Vector128<double> Range(Vector128<double> left, Vector128<double> right, [ConstantExpectedAttribute(Max=(byte)15)] byte control);
+            public static Vector128<float> Range(Vector128<float> left, Vector128<float> right, [ConstantExpectedAttribute(Max=(byte)15)] byte control);
+            public static Vector256<double> Range(Vector256<double> left, Vector256<double> right, [ConstantExpectedAttribute(Max=(byte)15)] byte control);
+            public static Vector256<float> Range(Vector256<float> left, Vector256<float> right, [ConstantExpectedAttribute(Max=(byte)15)] byte control);
+            public static Vector128<double> Reduce(Vector128<double> value, [ConstantExpectedAttribute] byte control);
+            public static Vector128<float> Reduce(Vector128<float> value, [ConstantExpectedAttribute] byte control);
+            public static Vector256<double> Reduce(Vector256<double> value, [ConstantExpectedAttribute] byte control);
+            public static Vector256<float> Reduce(Vector256<float> value, [ConstantExpectedAttribute] byte control);
+        }
+        public new abstract class X64 : Avx512F.X64 {
+            public static new bool IsSupported { get; }
+        }
+    }
+    [CLSCompliantAttribute(false)]
+    public abstract class Avx512F : Avx2 {
+        public static new bool IsSupported { get; }
+        public static Vector512<uint> Abs(Vector512<int> value);
+        public static Vector512<ulong> Abs(Vector512<long> value);
+        public static Vector512<double> Add(Vector512<double> left, Vector512<double> right);
+        public static Vector512<int> Add(Vector512<int> left, Vector512<int> right);
+        public static Vector512<long> Add(Vector512<long> left, Vector512<long> right);
+        public static Vector512<float> Add(Vector512<float> left, Vector512<float> right);
+        public static Vector512<uint> Add(Vector512<uint> left, Vector512<uint> right);
+        public static Vector512<ulong> Add(Vector512<ulong> left, Vector512<ulong> right);
+        public static Vector512<int> AlignRight32(Vector512<int> left, Vector512<int> right, [ConstantExpectedAttribute] byte mask);
+        public static Vector512<uint> AlignRight32(Vector512<uint> left, Vector512<uint> right, [ConstantExpectedAttribute] byte mask);
+        public static Vector512<long> AlignRight64(Vector512<long> left, Vector512<long> right, [ConstantExpectedAttribute] byte mask);
+        public static Vector512<ulong> AlignRight64(Vector512<ulong> left, Vector512<ulong> right, [ConstantExpectedAttribute] byte mask);
+        public static Vector512<byte> And(Vector512<byte> left, Vector512<byte> right);
+        public static Vector512<short> And(Vector512<short> left, Vector512<short> right);
+        public static Vector512<int> And(Vector512<int> left, Vector512<int> right);
+        public static Vector512<long> And(Vector512<long> left, Vector512<long> right);
+        public static Vector512<sbyte> And(Vector512<sbyte> left, Vector512<sbyte> right);
+        public static Vector512<ushort> And(Vector512<ushort> left, Vector512<ushort> right);
+        public static Vector512<uint> And(Vector512<uint> left, Vector512<uint> right);
+        public static Vector512<ulong> And(Vector512<ulong> left, Vector512<ulong> right);
+        public static Vector512<byte> AndNot(Vector512<byte> left, Vector512<byte> right);
+        public static Vector512<short> AndNot(Vector512<short> left, Vector512<short> right);
+        public static Vector512<int> AndNot(Vector512<int> left, Vector512<int> right);
+        public static Vector512<long> AndNot(Vector512<long> left, Vector512<long> right);
+        public static Vector512<sbyte> AndNot(Vector512<sbyte> left, Vector512<sbyte> right);
+        public static Vector512<ushort> AndNot(Vector512<ushort> left, Vector512<ushort> right);
+        public static Vector512<uint> AndNot(Vector512<uint> left, Vector512<uint> right);
+        public static Vector512<ulong> AndNot(Vector512<ulong> left, Vector512<ulong> right);
+        public static Vector512<double> BlendVariable(Vector512<double> left, Vector512<double> right, Vector512<double> mask);
+        public static Vector512<int> BlendVariable(Vector512<int> left, Vector512<int> right, Vector512<int> mask);
+        public static Vector512<long> BlendVariable(Vector512<long> left, Vector512<long> right, Vector512<long> mask);
+        public static Vector512<float> BlendVariable(Vector512<float> left, Vector512<float> right, Vector512<float> mask);
+        public static Vector512<uint> BlendVariable(Vector512<uint> left, Vector512<uint> right, Vector512<uint> mask);
+        public static Vector512<ulong> BlendVariable(Vector512<ulong> left, Vector512<ulong> right, Vector512<ulong> mask);
+        public static Vector512<double> BroadcastScalarToVector512(Vector128<double> value);
+        public static Vector512<int> BroadcastScalarToVector512(Vector128<int> value);
+        public static Vector512<long> BroadcastScalarToVector512(Vector128<long> value);
+        public static Vector512<float> BroadcastScalarToVector512(Vector128<float> value);
+        public static Vector512<uint> BroadcastScalarToVector512(Vector128<uint> value);
+        public static Vector512<ulong> BroadcastScalarToVector512(Vector128<ulong> value);
+        public unsafe static Vector512<int> BroadcastVector128ToVector512(int* address);
+        public unsafe static Vector512<float> BroadcastVector128ToVector512(float* address);
+        public unsafe static Vector512<uint> BroadcastVector128ToVector512(uint* address);
+        public unsafe static Vector512<double> BroadcastVector256ToVector512(double* address);
+        public unsafe static Vector512<long> BroadcastVector256ToVector512(long* address);
+        public unsafe static Vector512<ulong> BroadcastVector256ToVector512(ulong* address);
+        public static Vector512<double> Compare(Vector512<double> left, Vector512<double> right, [ConstantExpectedAttribute(Max=FloatComparisonMode.UnorderedTrueSignaling)] FloatComparisonMode mode);
+        public static Vector512<float> Compare(Vector512<float> left, Vector512<float> right, [ConstantExpectedAttribute(Max=FloatComparisonMode.UnorderedTrueSignaling)] FloatComparisonMode mode);
+        public static Vector512<double> CompareEqual(Vector512<double> left, Vector512<double> right);
+        public static Vector512<int> CompareEqual(Vector512<int> left, Vector512<int> right);
+        public static Vector512<long> CompareEqual(Vector512<long> left, Vector512<long> right);
+        public static Vector512<float> CompareEqual(Vector512<float> left, Vector512<float> right);
+        public static Vector512<uint> CompareEqual(Vector512<uint> left, Vector512<uint> right);
+        public static Vector512<ulong> CompareEqual(Vector512<ulong> left, Vector512<ulong> right);
+        public static Vector512<double> CompareGreaterThan(Vector512<double> left, Vector512<double> right);
+        public static Vector512<int> CompareGreaterThan(Vector512<int> left, Vector512<int> right);
+        public static Vector512<long> CompareGreaterThan(Vector512<long> left, Vector512<long> right);
+        public static Vector512<float> CompareGreaterThan(Vector512<float> left, Vector512<float> right);
+        public static Vector512<uint> CompareGreaterThan(Vector512<uint> left, Vector512<uint> right);
+        public static Vector512<ulong> CompareGreaterThan(Vector512<ulong> left, Vector512<ulong> right);
+        public static Vector512<double> CompareGreaterThanOrEqual(Vector512<double> left, Vector512<double> right);
+        public static Vector512<int> CompareGreaterThanOrEqual(Vector512<int> left, Vector512<int> right);
+        public static Vector512<long> CompareGreaterThanOrEqual(Vector512<long> left, Vector512<long> right);
+        public static Vector512<float> CompareGreaterThanOrEqual(Vector512<float> left, Vector512<float> right);
+        public static Vector512<uint> CompareGreaterThanOrEqual(Vector512<uint> left, Vector512<uint> right);
+        public static Vector512<ulong> CompareGreaterThanOrEqual(Vector512<ulong> left, Vector512<ulong> right);
+        public static Vector512<double> CompareLessThan(Vector512<double> left, Vector512<double> right);
+        public static Vector512<int> CompareLessThan(Vector512<int> left, Vector512<int> right);
+        public static Vector512<long> CompareLessThan(Vector512<long> left, Vector512<long> right);
+        public static Vector512<float> CompareLessThan(Vector512<float> left, Vector512<float> right);
+        public static Vector512<uint> CompareLessThan(Vector512<uint> left, Vector512<uint> right);
+        public static Vector512<ulong> CompareLessThan(Vector512<ulong> left, Vector512<ulong> right);
+        public static Vector512<double> CompareLessThanOrEqual(Vector512<double> left, Vector512<double> right);
+        public static Vector512<int> CompareLessThanOrEqual(Vector512<int> left, Vector512<int> right);
+        public static Vector512<long> CompareLessThanOrEqual(Vector512<long> left, Vector512<long> right);
+        public static Vector512<float> CompareLessThanOrEqual(Vector512<float> left, Vector512<float> right);
+        public static Vector512<uint> CompareLessThanOrEqual(Vector512<uint> left, Vector512<uint> right);
+        public static Vector512<ulong> CompareLessThanOrEqual(Vector512<ulong> left, Vector512<ulong> right);
+        public static Vector512<double> CompareNotEqual(Vector512<double> left, Vector512<double> right);
+        public static Vector512<int> CompareNotEqual(Vector512<int> left, Vector512<int> right);
+        public static Vector512<long> CompareNotEqual(Vector512<long> left, Vector512<long> right);
+        public static Vector512<float> CompareNotEqual(Vector512<float> left, Vector512<float> right);
+        public static Vector512<uint> CompareNotEqual(Vector512<uint> left, Vector512<uint> right);
+        public static Vector512<ulong> CompareNotEqual(Vector512<ulong> left, Vector512<ulong> right);
+        public static Vector512<double> CompareNotGreaterThan(Vector512<double> left, Vector512<double> right);
+        public static Vector512<float> CompareNotGreaterThan(Vector512<float> left, Vector512<float> right);
+        public static Vector512<double> CompareNotGreaterThanOrEqual(Vector512<double> left, Vector512<double> right);
+        public static Vector512<float> CompareNotGreaterThanOrEqual(Vector512<float> left, Vector512<float> right);
+        public static Vector512<double> CompareNotLessThan(Vector512<double> left, Vector512<double> right);
+        public static Vector512<float> CompareNotLessThan(Vector512<float> left, Vector512<float> right);
+        public static Vector512<double> CompareNotLessThanOrEqual(Vector512<double> left, Vector512<double> right);
+        public static Vector512<float> CompareNotLessThanOrEqual(Vector512<float> left, Vector512<float> right);
+        public static Vector512<double> CompareOrdered(Vector512<double> left, Vector512<double> right);
+        public static Vector512<float> CompareOrdered(Vector512<float> left, Vector512<float> right);
+        public static Vector512<double> CompareUnordered(Vector512<double> left, Vector512<double> right);
+        public static Vector512<float> CompareUnordered(Vector512<float> left, Vector512<float> right);
+        public static Vector128<double> ConvertScalarToVector128Double(Vector128<double> upper, uint value);
+        public static Vector128<float> ConvertScalarToVector128Single(Vector128<float> upper, uint value);
+        public static uint ConvertToUInt32(Vector128<double> value);
+        public static uint ConvertToUInt32(Vector128<float> value);
+        public static uint ConvertToUInt32WithTruncation(Vector128<double> value);
+        public static uint ConvertToUInt32WithTruncation(Vector128<float> value);
+        public static Vector128<byte> ConvertToVector128Byte(Vector512<int> value);
+        public static Vector128<byte> ConvertToVector128Byte(Vector512<long> value);
+        public static Vector128<byte> ConvertToVector128Byte(Vector512<uint> value);
+        public static Vector128<byte> ConvertToVector128Byte(Vector512<ulong> value);
+        public static Vector128<byte> ConvertToVector128ByteWithSaturation(Vector512<uint> value);
+        public static Vector128<byte> ConvertToVector128ByteWithSaturation(Vector512<ulong> value);
+        public static Vector128<short> ConvertToVector128Int16(Vector512<long> value);
+        public static Vector128<short> ConvertToVector128Int16(Vector512<ulong> value);
+        public static Vector128<short> ConvertToVector128Int16WithSaturation(Vector512<long> value);
+        public static Vector128<sbyte> ConvertToVector128SByte(Vector512<int> value);
+        public static Vector128<sbyte> ConvertToVector128SByte(Vector512<long> value);
+        public static Vector128<sbyte> ConvertToVector128SByte(Vector512<uint> value);
+        public static Vector128<sbyte> ConvertToVector128SByte(Vector512<ulong> value);
+        public static Vector128<sbyte> ConvertToVector128SByteWithSaturation(Vector512<int> value);
+        public static Vector128<sbyte> ConvertToVector128SByteWithSaturation(Vector512<long> value);
+        public static Vector128<ushort> ConvertToVector128UInt16(Vector512<long> value);
+        public static Vector128<ushort> ConvertToVector128UInt16(Vector512<ulong> value);
+        public static Vector128<ushort> ConvertToVector128UInt16WithSaturation(Vector512<ulong> value);
+        public static Vector256<short> ConvertToVector256Int16(Vector512<int> value);
+        public static Vector256<short> ConvertToVector256Int16(Vector512<uint> value);
+        public static Vector256<short> ConvertToVector256Int16WithSaturation(Vector512<int> value);
+        public static Vector256<int> ConvertToVector256Int32(Vector512<double> value);
+        public static Vector256<int> ConvertToVector256Int32(Vector512<long> value);
+        public static Vector256<int> ConvertToVector256Int32(Vector512<ulong> value);
+        public static Vector256<int> ConvertToVector256Int32WithSaturation(Vector512<long> value);
+        public static Vector256<int> ConvertToVector256Int32WithTruncation(Vector512<double> value);
+        public static Vector256<float> ConvertToVector256Single(Vector512<double> value);
+        public static Vector256<ushort> ConvertToVector256UInt16(Vector512<int> value);
+        public static Vector256<ushort> ConvertToVector256UInt16(Vector512<uint> value);
+        public static Vector256<ushort> ConvertToVector256UInt16WithSaturation(Vector512<uint> value);
+        public static Vector256<uint> ConvertToVector256UInt32(Vector512<double> value);
+        public static Vector256<uint> ConvertToVector256UInt32(Vector512<long> value);
+        public static Vector256<uint> ConvertToVector256UInt32(Vector512<ulong> value);
+        public static Vector256<uint> ConvertToVector256UInt32WithSaturation(Vector512<ulong> value);
+        public static Vector256<uint> ConvertToVector256UInt32WithTruncation(Vector512<double> value);
+        public static Vector512<double> ConvertToVector512Double(Vector256<int> value);
+        public static Vector512<double> ConvertToVector512Double(Vector256<float> value);
+        public static Vector512<double> ConvertToVector512Double(Vector256<uint> value);
+        public static Vector512<int> ConvertToVector512Int32(Vector128<byte> value);
+        public static Vector512<int> ConvertToVector512Int32(Vector128<sbyte> value);
+        public static Vector512<int> ConvertToVector512Int32(Vector256<short> value);
+        public static Vector512<int> ConvertToVector512Int32(Vector256<ushort> value);
+        public static Vector512<int> ConvertToVector512Int32(Vector512<float> value);
+        public static Vector512<int> ConvertToVector512Int32WithTruncation(Vector512<float> value);
+        public static Vector512<long> ConvertToVector512Int64(Vector128<byte> value);
+        public static Vector512<long> ConvertToVector512Int64(Vector128<short> value);
+        public static Vector512<long> ConvertToVector512Int64(Vector128<sbyte> value);
+        public static Vector512<long> ConvertToVector512Int64(Vector128<ushort> value);
+        public static Vector512<long> ConvertToVector512Int64(Vector256<int> value);
+        public static Vector512<long> ConvertToVector512Int64(Vector256<uint> value);
+        public static Vector512<float> ConvertToVector512Single(Vector512<int> value);
+        public static Vector512<float> ConvertToVector512Single(Vector512<uint> value);
+        public static Vector512<uint> ConvertToVector512UInt32(Vector128<byte> value);
+        public static Vector512<uint> ConvertToVector512UInt32(Vector128<sbyte> value);
+        public static Vector512<uint> ConvertToVector512UInt32(Vector256<short> value);
+        public static Vector512<uint> ConvertToVector512UInt32(Vector256<ushort> value);
+        public static Vector512<uint> ConvertToVector512UInt32(Vector512<float> value);
+        public static Vector512<uint> ConvertToVector512UInt32WithTruncation(Vector512<float> value);
+        public static Vector512<ulong> ConvertToVector512UInt64(Vector128<byte> value);
+        public static Vector512<ulong> ConvertToVector512UInt64(Vector128<short> value);
+        public static Vector512<ulong> ConvertToVector512UInt64(Vector128<sbyte> value);
+        public static Vector512<ulong> ConvertToVector512UInt64(Vector128<ushort> value);
+        public static Vector512<ulong> ConvertToVector512UInt64(Vector256<int> value);
+        public static Vector512<ulong> ConvertToVector512UInt64(Vector256<uint> value);
+        public static Vector512<double> Divide(Vector512<double> left, Vector512<double> right);
+        public static Vector512<float> Divide(Vector512<float> left, Vector512<float> right);
+        public static Vector512<double> DuplicateEvenIndexed(Vector512<double> value);
+        public static Vector512<float> DuplicateEvenIndexed(Vector512<float> value);
+        public static Vector512<float> DuplicateOddIndexed(Vector512<float> value);
+        public static Vector128<byte> ExtractVector128(Vector512<byte> value, [ConstantExpectedAttribute] byte index);
+        public static Vector128<double> ExtractVector128(Vector512<double> value, [ConstantExpectedAttribute] byte index);
+        public static Vector128<short> ExtractVector128(Vector512<short> value, [ConstantExpectedAttribute] byte index);
+        public static Vector128<int> ExtractVector128(Vector512<int> value, [ConstantExpectedAttribute] byte index);
+        public static Vector128<long> ExtractVector128(Vector512<long> value, [ConstantExpectedAttribute] byte index);
+        public static Vector128<sbyte> ExtractVector128(Vector512<sbyte> value, [ConstantExpectedAttribute] byte index);
+        public static Vector128<float> ExtractVector128(Vector512<float> value, [ConstantExpectedAttribute] byte index);
+        public static Vector128<ushort> ExtractVector128(Vector512<ushort> value, [ConstantExpectedAttribute] byte index);
+        public static Vector128<uint> ExtractVector128(Vector512<uint> value, [ConstantExpectedAttribute] byte index);
+        public static Vector128<ulong> ExtractVector128(Vector512<ulong> value, [ConstantExpectedAttribute] byte index);
+        public static Vector256<byte> ExtractVector256(Vector512<byte> value, [ConstantExpectedAttribute] byte index);
+        public static Vector256<double> ExtractVector256(Vector512<double> value, [ConstantExpectedAttribute] byte index);
+        public static Vector256<short> ExtractVector256(Vector512<short> value, [ConstantExpectedAttribute] byte index);
+        public static Vector256<int> ExtractVector256(Vector512<int> value, [ConstantExpectedAttribute] byte index);
+        public static Vector256<long> ExtractVector256(Vector512<long> value, [ConstantExpectedAttribute] byte index);
+        public static Vector256<sbyte> ExtractVector256(Vector512<sbyte> value, [ConstantExpectedAttribute] byte index);
+        public static Vector256<float> ExtractVector256(Vector512<float> value, [ConstantExpectedAttribute] byte index);
+        public static Vector256<ushort> ExtractVector256(Vector512<ushort> value, [ConstantExpectedAttribute] byte index);
+        public static Vector256<uint> ExtractVector256(Vector512<uint> value, [ConstantExpectedAttribute] byte index);
+        public static Vector256<ulong> ExtractVector256(Vector512<ulong> value, [ConstantExpectedAttribute] byte index);
+        public static Vector512<double> Fixup(Vector512<double> left, Vector512<double> right, Vector512<long> table, [ConstantExpectedAttribute] byte control);
+        public static Vector512<float> Fixup(Vector512<float> left, Vector512<float> right, Vector512<int> table, [ConstantExpectedAttribute] byte control);
+        public static Vector128<double> FixupScalar(Vector128<double> left, Vector128<double> right, Vector128<long> table, [ConstantExpectedAttribute] byte control);
+        public static Vector128<float> FixupScalar(Vector128<float> left, Vector128<float> right, Vector128<int> table, [ConstantExpectedAttribute] byte control);
+        public static Vector512<double> FusedMultiplyAdd(Vector512<double> a, Vector512<double> b, Vector512<double> c);
+        public static Vector512<float> FusedMultiplyAdd(Vector512<float> a, Vector512<float> b, Vector512<float> c);
+        public static Vector512<double> FusedMultiplyAddNegated(Vector512<double> a, Vector512<double> b, Vector512<double> c);
+        public static Vector512<float> FusedMultiplyAddNegated(Vector512<float> a, Vector512<float> b, Vector512<float> c);
+        public static Vector512<double> FusedMultiplyAddSubtract(Vector512<double> a, Vector512<double> b, Vector512<double> c);
+        public static Vector512<float> FusedMultiplyAddSubtract(Vector512<float> a, Vector512<float> b, Vector512<float> c);
+        public static Vector512<double> FusedMultiplySubtract(Vector512<double> a, Vector512<double> b, Vector512<double> c);
+        public static Vector512<float> FusedMultiplySubtract(Vector512<float> a, Vector512<float> b, Vector512<float> c);
+        public static Vector512<double> FusedMultiplySubtractAdd(Vector512<double> a, Vector512<double> b, Vector512<double> c);
+        public static Vector512<float> FusedMultiplySubtractAdd(Vector512<float> a, Vector512<float> b, Vector512<float> c);
+        public static Vector512<double> FusedMultiplySubtractNegated(Vector512<double> a, Vector512<double> b, Vector512<double> c);
+        public static Vector512<float> FusedMultiplySubtractNegated(Vector512<float> a, Vector512<float> b, Vector512<float> c);
+        public static Vector512<double> GetExponent(Vector512<double> value);
+        public static Vector512<float> GetExponent(Vector512<float> value);
+        public static Vector128<double> GetExponentScalar(Vector128<double> value);
+        public static Vector128<double> GetExponentScalar(Vector128<double> upper, Vector128<double> value);
+        public static Vector128<float> GetExponentScalar(Vector128<float> value);
+        public static Vector128<float> GetExponentScalar(Vector128<float> upper, Vector128<float> value);
+        public static Vector512<double> GetMantissa(Vector512<double> value, [ConstantExpectedAttribute(Max=(byte)15)] byte control);
+        public static Vector512<float> GetMantissa(Vector512<float> value, [ConstantExpectedAttribute(Max=(byte)15)] byte control);
+        public static Vector128<double> GetMantissaScalar(Vector128<double> value, [ConstantExpectedAttribute(Max=(byte)15)] byte control);
+        public static Vector128<double> GetMantissaScalar(Vector128<double> upper, Vector128<double> value, [ConstantExpectedAttribute(Max=(byte)15)] byte control);
+        public static Vector128<float> GetMantissaScalar(Vector128<float> value, [ConstantExpectedAttribute(Max=(byte)15)] byte control);
+        public static Vector128<float> GetMantissaScalar(Vector128<float> upper, Vector128<float> value, [ConstantExpectedAttribute(Max=(byte)15)] byte control);
+        public static Vector512<byte> InsertVector128(Vector512<byte> value, Vector128<byte> data, [ConstantExpectedAttribute] byte index);
+        public static Vector512<double> InsertVector128(Vector512<double> value, Vector128<double> data, [ConstantExpectedAttribute] byte index);
+        public static Vector512<short> InsertVector128(Vector512<short> value, Vector128<short> data, [ConstantExpectedAttribute] byte index);
+        public static Vector512<int> InsertVector128(Vector512<int> value, Vector128<int> data, [ConstantExpectedAttribute] byte index);
+        public static Vector512<long> InsertVector128(Vector512<long> value, Vector128<long> data, [ConstantExpectedAttribute] byte index);
+        public static Vector512<sbyte> InsertVector128(Vector512<sbyte> value, Vector128<sbyte> data, [ConstantExpectedAttribute] byte index);
+        public static Vector512<float> InsertVector128(Vector512<float> value, Vector128<float> data, [ConstantExpectedAttribute] byte index);
+        public static Vector512<ushort> InsertVector128(Vector512<ushort> value, Vector128<ushort> data, [ConstantExpectedAttribute] byte index);
+        public static Vector512<uint> InsertVector128(Vector512<uint> value, Vector128<uint> data, [ConstantExpectedAttribute] byte index);
+        public static Vector512<ulong> InsertVector128(Vector512<ulong> value, Vector128<ulong> data, [ConstantExpectedAttribute] byte index);
+        public static Vector512<byte> InsertVector256(Vector512<byte> value, Vector256<byte> data, [ConstantExpectedAttribute] byte index);
+        public static Vector512<double> InsertVector256(Vector512<double> value, Vector256<double> data, [ConstantExpectedAttribute] byte index);
+        public static Vector512<short> InsertVector256(Vector512<short> value, Vector256<short> data, [ConstantExpectedAttribute] byte index);
+        public static Vector512<int> InsertVector256(Vector512<int> value, Vector256<int> data, [ConstantExpectedAttribute] byte index);
+        public static Vector512<long> InsertVector256(Vector512<long> value, Vector256<long> data, [ConstantExpectedAttribute] byte index);
+        public static Vector512<sbyte> InsertVector256(Vector512<sbyte> value, Vector256<sbyte> data, [ConstantExpectedAttribute] byte index);
+        public static Vector512<float> InsertVector256(Vector512<float> value, Vector256<float> data, [ConstantExpectedAttribute] byte index);
+        public static Vector512<ushort> InsertVector256(Vector512<ushort> value, Vector256<ushort> data, [ConstantExpectedAttribute] byte index);
+        public static Vector512<uint> InsertVector256(Vector512<uint> value, Vector256<uint> data, [ConstantExpectedAttribute] byte index);
+        public static Vector512<ulong> InsertVector256(Vector512<ulong> value, Vector256<ulong> data, [ConstantExpectedAttribute] byte index);
+        public unsafe static Vector512<byte> LoadAlignedVector512(byte* address);
+        public unsafe static Vector512<double> LoadAlignedVector512(double* address);
+        public unsafe static Vector512<short> LoadAlignedVector512(short* address);
+        public unsafe static Vector512<int> LoadAlignedVector512(int* address);
+        public unsafe static Vector512<long> LoadAlignedVector512(long* address);
+        public unsafe static Vector512<sbyte> LoadAlignedVector512(sbyte* address);
+        public unsafe static Vector512<float> LoadAlignedVector512(float* address);
+        public unsafe static Vector512<ushort> LoadAlignedVector512(ushort* address);
+        public unsafe static Vector512<uint> LoadAlignedVector512(uint* address);
+        public unsafe static Vector512<ulong> LoadAlignedVector512(ulong* address);
+        public unsafe static Vector512<byte> LoadAlignedVector512NonTemporal(byte* address);
+        public unsafe static Vector512<short> LoadAlignedVector512NonTemporal(short* address);
+        public unsafe static Vector512<int> LoadAlignedVector512NonTemporal(int* address);
+        public unsafe static Vector512<long> LoadAlignedVector512NonTemporal(long* address);
+        public unsafe static Vector512<sbyte> LoadAlignedVector512NonTemporal(sbyte* address);
+        public unsafe static Vector512<ushort> LoadAlignedVector512NonTemporal(ushort* address);
+        public unsafe static Vector512<uint> LoadAlignedVector512NonTemporal(uint* address);
+        public unsafe static Vector512<ulong> LoadAlignedVector512NonTemporal(ulong* address);
+        public unsafe static Vector512<byte> LoadVector512(byte* address);
+        public unsafe static Vector512<double> LoadVector512(double* address);
+        public unsafe static Vector512<short> LoadVector512(short* address);
+        public unsafe static Vector512<int> LoadVector512(int* address);
+        public unsafe static Vector512<long> LoadVector512(long* address);
+        public unsafe static Vector512<sbyte> LoadVector512(sbyte* address);
+        public unsafe static Vector512<float> LoadVector512(float* address);
+        public unsafe static Vector512<ushort> LoadVector512(ushort* address);
+        public unsafe static Vector512<uint> LoadVector512(uint* address);
+        public unsafe static Vector512<ulong> LoadVector512(ulong* address);
+        public static Vector512<double> Max(Vector512<double> left, Vector512<double> right);
+        public static Vector512<int> Max(Vector512<int> left, Vector512<int> right);
+        public static Vector512<long> Max(Vector512<long> left, Vector512<long> right);
+        public static Vector512<float> Max(Vector512<float> left, Vector512<float> right);
+        public static Vector512<uint> Max(Vector512<uint> left, Vector512<uint> right);
+        public static Vector512<ulong> Max(Vector512<ulong> left, Vector512<ulong> right);
+        public static Vector512<double> Min(Vector512<double> left, Vector512<double> right);
+        public static Vector512<int> Min(Vector512<int> left, Vector512<int> right);
+        public static Vector512<long> Min(Vector512<long> left, Vector512<long> right);
+        public static Vector512<float> Min(Vector512<float> left, Vector512<float> right);
+        public static Vector512<uint> Min(Vector512<uint> left, Vector512<uint> right);
+        public static Vector512<ulong> Min(Vector512<ulong> left, Vector512<ulong> right);
+        public static Vector512<double> Multiply(Vector512<double> left, Vector512<double> right);
+        public static Vector512<long> Multiply(Vector512<int> left, Vector512<int> right);
+        public static Vector512<float> Multiply(Vector512<float> left, Vector512<float> right);
+        public static Vector512<ulong> Multiply(Vector512<uint> left, Vector512<uint> right);
+        public static Vector512<int> MultiplyLow(Vector512<int> left, Vector512<int> right);
+        public static Vector512<uint> MultiplyLow(Vector512<uint> left, Vector512<uint> right);
+        public static Vector512<byte> Or(Vector512<byte> left, Vector512<byte> right);
+        public static Vector512<short> Or(Vector512<short> left, Vector512<short> right);
+        public static Vector512<int> Or(Vector512<int> left, Vector512<int> right);
+        public static Vector512<long> Or(Vector512<long> left, Vector512<long> right);
+        public static Vector512<sbyte> Or(Vector512<sbyte> left, Vector512<sbyte> right);
+        public static Vector512<ushort> Or(Vector512<ushort> left, Vector512<ushort> right);
+        public static Vector512<uint> Or(Vector512<uint> left, Vector512<uint> right);
+        public static Vector512<ulong> Or(Vector512<ulong> left, Vector512<ulong> right);
+        public static Vector512<double> Permute2x64(Vector512<double> value, [ConstantExpectedAttribute] byte control);
+        public static Vector512<float> Permute4x32(Vector512<float> value, [ConstantExpectedAttribute] byte control);
+        public static Vector512<double> Permute4x64(Vector512<double> value, [ConstantExpectedAttribute] byte control);
+        public static Vector512<long> Permute4x64(Vector512<long> value, [ConstantExpectedAttribute] byte control);
+        public static Vector512<ulong> Permute4x64(Vector512<ulong> value, [ConstantExpectedAttribute] byte control);
+        public static Vector512<int> PermuteVar16x32(Vector512<int> left, Vector512<int> control);
+        public static Vector512<float> PermuteVar16x32(Vector512<float> left, Vector512<int> control);
+        public static Vector512<uint> PermuteVar16x32(Vector512<uint> left, Vector512<uint> control);
+        public static Vector512<int> PermuteVar16x32x2(Vector512<int> lower, Vector512<int> indices, Vector512<int> upper);
+        public static Vector512<float> PermuteVar16x32x2(Vector512<float> lower, Vector512<int> indices, Vector512<float> upper);
+        public static Vector512<uint> PermuteVar16x32x2(Vector512<uint> lower, Vector512<uint> indices, Vector512<uint> upper);
+        public static Vector512<double> PermuteVar2x64(Vector512<double> left, Vector512<long> control);
+        public static Vector512<float> PermuteVar4x32(Vector512<float> left, Vector512<int> control);
+        public static Vector512<double> PermuteVar8x64(Vector512<double> value, Vector512<long> control);
+        public static Vector512<long> PermuteVar8x64(Vector512<long> value, Vector512<long> control);
+        public static Vector512<ulong> PermuteVar8x64(Vector512<ulong> value, Vector512<ulong> control);
+        public static Vector512<double> PermuteVar8x64x2(Vector512<double> lower, Vector512<long> indices, Vector512<double> upper);
+        public static Vector512<long> PermuteVar8x64x2(Vector512<long> lower, Vector512<long> indices, Vector512<long> upper);
+        public static Vector512<ulong> PermuteVar8x64x2(Vector512<ulong> lower, Vector512<ulong> indices, Vector512<ulong> upper);
+        public static Vector512<double> Reciprocal14(Vector512<double> value);
+        public static Vector512<float> Reciprocal14(Vector512<float> value);
+        public static Vector128<double> Reciprocal14Scalar(Vector128<double> value);
+        public static Vector128<double> Reciprocal14Scalar(Vector128<double> upper, Vector128<double> value);
+        public static Vector128<float> Reciprocal14Scalar(Vector128<float> value);
+        public static Vector128<float> Reciprocal14Scalar(Vector128<float> upper, Vector128<float> value);
+        public static Vector512<double> ReciprocalSqrt14(Vector512<double> value);
+        public static Vector512<float> ReciprocalSqrt14(Vector512<float> value);
+        public static Vector128<double> ReciprocalSqrt14Scalar(Vector128<double> value);
+        public static Vector128<double> ReciprocalSqrt14Scalar(Vector128<double> upper, Vector128<double> value);
+        public static Vector128<float> ReciprocalSqrt14Scalar(Vector128<float> value);
+        public static Vector128<float> ReciprocalSqrt14Scalar(Vector128<float> upper, Vector128<float> value);
+        public static Vector512<int> RotateLeft(Vector512<int> value, [ConstantExpectedAttribute] byte count);
+        public static Vector512<long> RotateLeft(Vector512<long> value, [ConstantExpectedAttribute] byte count);
+        public static Vector512<uint> RotateLeft(Vector512<uint> value, [ConstantExpectedAttribute] byte count);
+        public static Vector512<ulong> RotateLeft(Vector512<ulong> value, [ConstantExpectedAttribute] byte count);
+        public static Vector512<int> RotateLeftVariable(Vector512<int> value, Vector512<uint> count);
+        public static Vector512<long> RotateLeftVariable(Vector512<long> value, Vector512<ulong> count);
+        public static Vector512<uint> RotateLeftVariable(Vector512<uint> value, Vector512<uint> count);
+        public static Vector512<ulong> RotateLeftVariable(Vector512<ulong> value, Vector512<ulong> count);
+        public static Vector512<int> RotateRight(Vector512<int> value, [ConstantExpectedAttribute] byte count);
+        public static Vector512<long> RotateRight(Vector512<long> value, [ConstantExpectedAttribute] byte count);
+        public static Vector512<uint> RotateRight(Vector512<uint> value, [ConstantExpectedAttribute] byte count);
+        public static Vector512<ulong> RotateRight(Vector512<ulong> value, [ConstantExpectedAttribute] byte count);
+        public static Vector512<int> RotateRightVariable(Vector512<int> value, Vector512<uint> count);
+        public static Vector512<long> RotateRightVariable(Vector512<long> value, Vector512<ulong> count);
+        public static Vector512<uint> RotateRightVariable(Vector512<uint> value, Vector512<uint> count);
+        public static Vector512<ulong> RotateRightVariable(Vector512<ulong> value, Vector512<ulong> count);
+        public static Vector512<double> RoundScale(Vector512<double> value, [ConstantExpectedAttribute] byte control);
+        public static Vector512<float> RoundScale(Vector512<float> value, [ConstantExpectedAttribute] byte control);
+        public static Vector128<double> RoundScaleScalar(Vector128<double> value, [ConstantExpectedAttribute] byte control);
+        public static Vector128<double> RoundScaleScalar(Vector128<double> upper, Vector128<double> value, [ConstantExpectedAttribute] byte control);
+        public static Vector128<float> RoundScaleScalar(Vector128<float> value, [ConstantExpectedAttribute] byte control);
+        public static Vector128<float> RoundScaleScalar(Vector128<float> upper, Vector128<float> value, [ConstantExpectedAttribute] byte control);
+        public static Vector512<double> Scale(Vector512<double> left, Vector512<double> right);
+        public static Vector512<float> Scale(Vector512<float> left, Vector512<float> right);
+        public static Vector128<double> ScaleScalar(Vector128<double> left, Vector128<double> right);
+        public static Vector128<float> ScaleScalar(Vector128<float> left, Vector128<float> right);
+        public static Vector512<int> ShiftLeftLogical(Vector512<int> value, [ConstantExpectedAttribute] byte count);
+        public static Vector512<int> ShiftLeftLogical(Vector512<int> value, Vector128<int> count);
+        public static Vector512<long> ShiftLeftLogical(Vector512<long> value, [ConstantExpectedAttribute] byte count);
+        public static Vector512<long> ShiftLeftLogical(Vector512<long> value, Vector128<long> count);
+        public static Vector512<uint> ShiftLeftLogical(Vector512<uint> value, [ConstantExpectedAttribute] byte count);
+        public static Vector512<uint> ShiftLeftLogical(Vector512<uint> value, Vector128<uint> count);
+        public static Vector512<ulong> ShiftLeftLogical(Vector512<ulong> value, [ConstantExpectedAttribute] byte count);
+        public static Vector512<ulong> ShiftLeftLogical(Vector512<ulong> value, Vector128<ulong> count);
+        public static Vector512<int> ShiftLeftLogicalVariable(Vector512<int> value, Vector512<uint> count);
+        public static Vector512<long> ShiftLeftLogicalVariable(Vector512<long> value, Vector512<ulong> count);
+        public static Vector512<uint> ShiftLeftLogicalVariable(Vector512<uint> value, Vector512<uint> count);
+        public static Vector512<ulong> ShiftLeftLogicalVariable(Vector512<ulong> value, Vector512<ulong> count);
+        public static Vector512<int> ShiftRightArithmetic(Vector512<int> value, [ConstantExpectedAttribute] byte count);
+        public static Vector512<int> ShiftRightArithmetic(Vector512<int> value, Vector128<int> count);
+        public static Vector512<long> ShiftRightArithmetic(Vector512<long> value, [ConstantExpectedAttribute] byte count);
+        public static Vector512<long> ShiftRightArithmetic(Vector512<long> value, Vector128<long> count);
+        public static Vector512<int> ShiftRightArithmeticVariable(Vector512<int> value, Vector512<uint> count);
+        public static Vector512<long> ShiftRightArithmeticVariable(Vector512<long> value, Vector512<ulong> count);
+        public static Vector512<int> ShiftRightLogical(Vector512<int> value, [ConstantExpectedAttribute] byte count);
+        public static Vector512<int> ShiftRightLogical(Vector512<int> value, Vector128<int> count);
+        public static Vector512<long> ShiftRightLogical(Vector512<long> value, [ConstantExpectedAttribute] byte count);
+        public static Vector512<long> ShiftRightLogical(Vector512<long> value, Vector128<long> count);
+        public static Vector512<uint> ShiftRightLogical(Vector512<uint> value, [ConstantExpectedAttribute] byte count);
+        public static Vector512<uint> ShiftRightLogical(Vector512<uint> value, Vector128<uint> count);
+        public static Vector512<ulong> ShiftRightLogical(Vector512<ulong> value, [ConstantExpectedAttribute] byte count);
+        public static Vector512<ulong> ShiftRightLogical(Vector512<ulong> value, Vector128<ulong> count);
+        public static Vector512<int> ShiftRightLogicalVariable(Vector512<int> value, Vector512<uint> count);
+        public static Vector512<long> ShiftRightLogicalVariable(Vector512<long> value, Vector512<ulong> count);
+        public static Vector512<uint> ShiftRightLogicalVariable(Vector512<uint> value, Vector512<uint> count);
+        public static Vector512<ulong> ShiftRightLogicalVariable(Vector512<ulong> value, Vector512<ulong> count);
+        public static Vector512<double> Shuffle(Vector512<double> value, Vector512<double> right, [ConstantExpectedAttribute] byte control);
+        public static Vector512<int> Shuffle(Vector512<int> value, [ConstantExpectedAttribute] byte control);
+        public static Vector512<float> Shuffle(Vector512<float> value, Vector512<float> right, [ConstantExpectedAttribute] byte control);
+        public static Vector512<uint> Shuffle(Vector512<uint> value, [ConstantExpectedAttribute] byte control);
+        public static Vector512<double> Shuffle4x128(Vector512<double> left, Vector512<double> right, [ConstantExpectedAttribute] byte control);
+        public static Vector512<int> Shuffle4x128(Vector512<int> left, Vector512<int> right, [ConstantExpectedAttribute] byte control);
+        public static Vector512<long> Shuffle4x128(Vector512<long> left, Vector512<long> right, [ConstantExpectedAttribute] byte control);
+        public static Vector512<float> Shuffle4x128(Vector512<float> left, Vector512<float> right, [ConstantExpectedAttribute] byte control);
+        public static Vector512<uint> Shuffle4x128(Vector512<uint> left, Vector512<uint> right, [ConstantExpectedAttribute] byte control);
+        public static Vector512<ulong> Shuffle4x128(Vector512<ulong> left, Vector512<ulong> right, [ConstantExpectedAttribute] byte control);
+        public static Vector512<double> Sqrt(Vector512<double> value);
+        public static Vector512<float> Sqrt(Vector512<float> value);
+        public unsafe static void Store(byte* address, Vector512<byte> source);
+        public unsafe static void Store(double* address, Vector512<double> source);
+        public unsafe static void Store(short* address, Vector512<short> source);
+        public unsafe static void Store(int* address, Vector512<int> source);
+        public unsafe static void Store(long* address, Vector512<long> source);
+        public unsafe static void Store(sbyte* address, Vector512<sbyte> source);
+        public unsafe static void Store(float* address, Vector512<float> source);
+        public unsafe static void Store(ushort* address, Vector512<ushort> source);
+        public unsafe static void Store(uint* address, Vector512<uint> source);
+        public unsafe static void Store(ulong* address, Vector512<ulong> source);
+        public unsafe static void StoreAligned(byte* address, Vector512<byte> source);
+        public unsafe static void StoreAligned(double* address, Vector512<double> source);
+        public unsafe static void StoreAligned(short* address, Vector512<short> source);
+        public unsafe static void StoreAligned(int* address, Vector512<int> source);
+        public unsafe static void StoreAligned(long* address, Vector512<long> source);
+        public unsafe static void StoreAligned(sbyte* address, Vector512<sbyte> source);
+        public unsafe static void StoreAligned(float* address, Vector512<float> source);
+        public unsafe static void StoreAligned(ushort* address, Vector512<ushort> source);
+        public unsafe static void StoreAligned(uint* address, Vector512<uint> source);
+        public unsafe static void StoreAligned(ulong* address, Vector512<ulong> source);
+        public unsafe static void StoreAlignedNonTemporal(byte* address, Vector512<byte> source);
+        public unsafe static void StoreAlignedNonTemporal(double* address, Vector512<double> source);
+        public unsafe static void StoreAlignedNonTemporal(short* address, Vector512<short> source);
+        public unsafe static void StoreAlignedNonTemporal(int* address, Vector512<int> source);
+        public unsafe static void StoreAlignedNonTemporal(long* address, Vector512<long> source);
+        public unsafe static void StoreAlignedNonTemporal(sbyte* address, Vector512<sbyte> source);
+        public unsafe static void StoreAlignedNonTemporal(float* address, Vector512<float> source);
+        public unsafe static void StoreAlignedNonTemporal(ushort* address, Vector512<ushort> source);
+        public unsafe static void StoreAlignedNonTemporal(uint* address, Vector512<uint> source);
+        public unsafe static void StoreAlignedNonTemporal(ulong* address, Vector512<ulong> source);
+        public static Vector512<double> Subtract(Vector512<double> left, Vector512<double> right);
+        public static Vector512<int> Subtract(Vector512<int> left, Vector512<int> right);
+        public static Vector512<long> Subtract(Vector512<long> left, Vector512<long> right);
+        public static Vector512<float> Subtract(Vector512<float> left, Vector512<float> right);
+        public static Vector512<uint> Subtract(Vector512<uint> left, Vector512<uint> right);
+        public static Vector512<ulong> Subtract(Vector512<ulong> left, Vector512<ulong> right);
+        public static Vector512<byte> TernaryLogic(Vector512<byte> a, Vector512<byte> b, Vector512<byte> c, [ConstantExpectedAttribute] byte control);
+        public static Vector512<double> TernaryLogic(Vector512<double> a, Vector512<double> b, Vector512<double> c, [ConstantExpectedAttribute] byte control);
+        public static Vector512<short> TernaryLogic(Vector512<short> a, Vector512<short> b, Vector512<short> c, [ConstantExpectedAttribute] byte control);
+        public static Vector512<int> TernaryLogic(Vector512<int> a, Vector512<int> b, Vector512<int> c, [ConstantExpectedAttribute] byte control);
+        public static Vector512<long> TernaryLogic(Vector512<long> a, Vector512<long> b, Vector512<long> c, [ConstantExpectedAttribute] byte control);
+        public static Vector512<sbyte> TernaryLogic(Vector512<sbyte> a, Vector512<sbyte> b, Vector512<sbyte> c, [ConstantExpectedAttribute] byte control);
+        public static Vector512<float> TernaryLogic(Vector512<float> a, Vector512<float> b, Vector512<float> c, [ConstantExpectedAttribute] byte control);
+        public static Vector512<ushort> TernaryLogic(Vector512<ushort> a, Vector512<ushort> b, Vector512<ushort> c, [ConstantExpectedAttribute] byte control);
+        public static Vector512<uint> TernaryLogic(Vector512<uint> a, Vector512<uint> b, Vector512<uint> c, [ConstantExpectedAttribute] byte control);
+        public static Vector512<ulong> TernaryLogic(Vector512<ulong> a, Vector512<ulong> b, Vector512<ulong> c, [ConstantExpectedAttribute] byte control);
+        public static Vector512<double> UnpackHigh(Vector512<double> left, Vector512<double> right);
+        public static Vector512<int> UnpackHigh(Vector512<int> left, Vector512<int> right);
+        public static Vector512<long> UnpackHigh(Vector512<long> left, Vector512<long> right);
+        public static Vector512<float> UnpackHigh(Vector512<float> left, Vector512<float> right);
+        public static Vector512<uint> UnpackHigh(Vector512<uint> left, Vector512<uint> right);
+        public static Vector512<ulong> UnpackHigh(Vector512<ulong> left, Vector512<ulong> right);
+        public static Vector512<double> UnpackLow(Vector512<double> left, Vector512<double> right);
+        public static Vector512<int> UnpackLow(Vector512<int> left, Vector512<int> right);
+        public static Vector512<long> UnpackLow(Vector512<long> left, Vector512<long> right);
+        public static Vector512<float> UnpackLow(Vector512<float> left, Vector512<float> right);
+        public static Vector512<uint> UnpackLow(Vector512<uint> left, Vector512<uint> right);
+        public static Vector512<ulong> UnpackLow(Vector512<ulong> left, Vector512<ulong> right);
+        public static Vector512<byte> Xor(Vector512<byte> left, Vector512<byte> right);
+        public static Vector512<short> Xor(Vector512<short> left, Vector512<short> right);
+        public static Vector512<int> Xor(Vector512<int> left, Vector512<int> right);
+        public static Vector512<long> Xor(Vector512<long> left, Vector512<long> right);
+        public static Vector512<sbyte> Xor(Vector512<sbyte> left, Vector512<sbyte> right);
+        public static Vector512<ushort> Xor(Vector512<ushort> left, Vector512<ushort> right);
+        public static Vector512<uint> Xor(Vector512<uint> left, Vector512<uint> right);
+        public static Vector512<ulong> Xor(Vector512<ulong> left, Vector512<ulong> right);
+        public abstract class VL {
+            public static bool IsSupported { get; }
+            public static Vector128<ulong> Abs(Vector128<long> value);
+            public static Vector256<ulong> Abs(Vector256<long> value);
+            public static Vector128<int> AlignRight32(Vector128<int> left, Vector128<int> right, [ConstantExpectedAttribute] byte mask);
+            public static Vector128<uint> AlignRight32(Vector128<uint> left, Vector128<uint> right, [ConstantExpectedAttribute] byte mask);
+            public static Vector256<int> AlignRight32(Vector256<int> left, Vector256<int> right, [ConstantExpectedAttribute] byte mask);
+            public static Vector256<uint> AlignRight32(Vector256<uint> left, Vector256<uint> right, [ConstantExpectedAttribute] byte mask);
+            public static Vector128<long> AlignRight64(Vector128<long> left, Vector128<long> right, [ConstantExpectedAttribute] byte mask);
+            public static Vector128<ulong> AlignRight64(Vector128<ulong> left, Vector128<ulong> right, [ConstantExpectedAttribute] byte mask);
+            public static Vector256<long> AlignRight64(Vector256<long> left, Vector256<long> right, [ConstantExpectedAttribute] byte mask);
+            public static Vector256<ulong> AlignRight64(Vector256<ulong> left, Vector256<ulong> right, [ConstantExpectedAttribute] byte mask);
+            public static Vector128<uint> CompareGreaterThan(Vector128<uint> left, Vector128<uint> right);
+            public static Vector128<ulong> CompareGreaterThan(Vector128<ulong> left, Vector128<ulong> right);
+            public static Vector256<uint> CompareGreaterThan(Vector256<uint> left, Vector256<uint> right);
+            public static Vector256<ulong> CompareGreaterThan(Vector256<ulong> left, Vector256<ulong> right);
+            public static Vector128<int> CompareGreaterThanOrEqual(Vector128<int> left, Vector128<int> right);
+            public static Vector128<long> CompareGreaterThanOrEqual(Vector128<long> left, Vector128<long> right);
+            public static Vector128<uint> CompareGreaterThanOrEqual(Vector128<uint> left, Vector128<uint> right);
+            public static Vector128<ulong> CompareGreaterThanOrEqual(Vector128<ulong> left, Vector128<ulong> right);
+            public static Vector256<int> CompareGreaterThanOrEqual(Vector256<int> left, Vector256<int> right);
+            public static Vector256<long> CompareGreaterThanOrEqual(Vector256<long> left, Vector256<long> right);
+            public static Vector256<uint> CompareGreaterThanOrEqual(Vector256<uint> left, Vector256<uint> right);
+            public static Vector256<ulong> CompareGreaterThanOrEqual(Vector256<ulong> left, Vector256<ulong> right);
+            public static Vector128<int> CompareLessThan(Vector128<int> left, Vector128<int> right);
+            public static Vector128<long> CompareLessThan(Vector128<long> left, Vector128<long> right);
+            public static Vector128<uint> CompareLessThan(Vector128<uint> left, Vector128<uint> right);
+            public static Vector128<ulong> CompareLessThan(Vector128<ulong> left, Vector128<ulong> right);
+            public static Vector256<int> CompareLessThan(Vector256<int> left, Vector256<int> right);
+            public static Vector256<long> CompareLessThan(Vector256<long> left, Vector256<long> right);
+            public static Vector256<uint> CompareLessThan(Vector256<uint> left, Vector256<uint> right);
+            public static Vector256<ulong> CompareLessThan(Vector256<ulong> left, Vector256<ulong> right);
+            public static Vector128<int> CompareLessThanOrEqual(Vector128<int> left, Vector128<int> right);
+            public static Vector128<long> CompareLessThanOrEqual(Vector128<long> left, Vector128<long> right);
+            public static Vector128<uint> CompareLessThanOrEqual(Vector128<uint> left, Vector128<uint> right);
+            public static Vector128<ulong> CompareLessThanOrEqual(Vector128<ulong> left, Vector128<ulong> right);
+            public static Vector256<int> CompareLessThanOrEqual(Vector256<int> left, Vector256<int> right);
+            public static Vector256<long> CompareLessThanOrEqual(Vector256<long> left, Vector256<long> right);
+            public static Vector256<uint> CompareLessThanOrEqual(Vector256<uint> left, Vector256<uint> right);
+            public static Vector256<ulong> CompareLessThanOrEqual(Vector256<ulong> left, Vector256<ulong> right);
+            public static Vector128<int> CompareNotEqual(Vector128<int> left, Vector128<int> right);
+            public static Vector128<long> CompareNotEqual(Vector128<long> left, Vector128<long> right);
+            public static Vector128<uint> CompareNotEqual(Vector128<uint> left, Vector128<uint> right);
+            public static Vector128<ulong> CompareNotEqual(Vector128<ulong> left, Vector128<ulong> right);
+            public static Vector256<int> CompareNotEqual(Vector256<int> left, Vector256<int> right);
+            public static Vector256<long> CompareNotEqual(Vector256<long> left, Vector256<long> right);
+            public static Vector256<uint> CompareNotEqual(Vector256<uint> left, Vector256<uint> right);
+            public static Vector256<ulong> CompareNotEqual(Vector256<ulong> left, Vector256<ulong> right);
+            public static Vector128<byte> ConvertToVector128Byte(Vector128<int> value);
+            public static Vector128<byte> ConvertToVector128Byte(Vector128<long> value);
+            public static Vector128<byte> ConvertToVector128Byte(Vector128<uint> value);
+            public static Vector128<byte> ConvertToVector128Byte(Vector128<ulong> value);
+            public static Vector128<byte> ConvertToVector128Byte(Vector256<int> value);
+            public static Vector128<byte> ConvertToVector128Byte(Vector256<long> value);
+            public static Vector128<byte> ConvertToVector128Byte(Vector256<uint> value);
+            public static Vector128<byte> ConvertToVector128Byte(Vector256<ulong> value);
+            public static Vector128<byte> ConvertToVector128ByteWithSaturation(Vector128<uint> value);
+            public static Vector128<byte> ConvertToVector128ByteWithSaturation(Vector128<ulong> value);
+            public static Vector128<byte> ConvertToVector128ByteWithSaturation(Vector256<uint> value);
+            public static Vector128<byte> ConvertToVector128ByteWithSaturation(Vector256<ulong> value);
+            public static Vector128<double> ConvertToVector128Double(Vector128<uint> value);
+            public static Vector128<short> ConvertToVector128Int16(Vector128<int> value);
+            public static Vector128<short> ConvertToVector128Int16(Vector128<long> value);
+            public static Vector128<short> ConvertToVector128Int16(Vector128<uint> value);
+            public static Vector128<short> ConvertToVector128Int16(Vector128<ulong> value);
+            public static Vector128<short> ConvertToVector128Int16(Vector256<int> value);
+            public static Vector128<short> ConvertToVector128Int16(Vector256<long> value);
+            public static Vector128<short> ConvertToVector128Int16(Vector256<uint> value);
+            public static Vector128<short> ConvertToVector128Int16(Vector256<ulong> value);
+            public static Vector128<short> ConvertToVector128Int16WithSaturation(Vector128<int> value);
+            public static Vector128<short> ConvertToVector128Int16WithSaturation(Vector128<long> value);
+            public static Vector128<short> ConvertToVector128Int16WithSaturation(Vector256<int> value);
+            public static Vector128<short> ConvertToVector128Int16WithSaturation(Vector256<long> value);
+            public static Vector128<int> ConvertToVector128Int32(Vector128<long> value);
+            public static Vector128<int> ConvertToVector128Int32(Vector128<ulong> value);
+            public static Vector128<int> ConvertToVector128Int32(Vector256<long> value);
+            public static Vector128<int> ConvertToVector128Int32(Vector256<ulong> value);
+            public static Vector128<int> ConvertToVector128Int32WithSaturation(Vector128<long> value);
+            public static Vector128<int> ConvertToVector128Int32WithSaturation(Vector256<long> value);
+            public static Vector128<sbyte> ConvertToVector128SByte(Vector128<int> value);
+            public static Vector128<sbyte> ConvertToVector128SByte(Vector128<long> value);
+            public static Vector128<sbyte> ConvertToVector128SByte(Vector128<uint> value);
+            public static Vector128<sbyte> ConvertToVector128SByte(Vector128<ulong> value);
+            public static Vector128<sbyte> ConvertToVector128SByte(Vector256<int> value);
+            public static Vector128<sbyte> ConvertToVector128SByte(Vector256<long> value);
+            public static Vector128<sbyte> ConvertToVector128SByte(Vector256<uint> value);
+            public static Vector128<sbyte> ConvertToVector128SByte(Vector256<ulong> value);
+            public static Vector128<sbyte> ConvertToVector128SByteWithSaturation(Vector128<int> value);
+            public static Vector128<sbyte> ConvertToVector128SByteWithSaturation(Vector128<long> value);
+            public static Vector128<sbyte> ConvertToVector128SByteWithSaturation(Vector256<int> value);
+            public static Vector128<sbyte> ConvertToVector128SByteWithSaturation(Vector256<long> value);
+            public static Vector128<float> ConvertToVector128Single(Vector128<uint> value);
+            public static Vector128<ushort> ConvertToVector128UInt16(Vector128<int> value);
+            public static Vector128<ushort> ConvertToVector128UInt16(Vector128<long> value);
+            public static Vector128<ushort> ConvertToVector128UInt16(Vector128<uint> value);
+            public static Vector128<ushort> ConvertToVector128UInt16(Vector128<ulong> value);
+            public static Vector128<ushort> ConvertToVector128UInt16(Vector256<int> value);
+            public static Vector128<ushort> ConvertToVector128UInt16(Vector256<long> value);
+            public static Vector128<ushort> ConvertToVector128UInt16(Vector256<uint> value);
+            public static Vector128<ushort> ConvertToVector128UInt16(Vector256<ulong> value);
+            public static Vector128<ushort> ConvertToVector128UInt16WithSaturation(Vector128<uint> value);
+            public static Vector128<ushort> ConvertToVector128UInt16WithSaturation(Vector128<ulong> value);
+            public static Vector128<ushort> ConvertToVector128UInt16WithSaturation(Vector256<uint> value);
+            public static Vector128<ushort> ConvertToVector128UInt16WithSaturation(Vector256<ulong> value);
+            public static Vector128<uint> ConvertToVector128UInt32(Vector128<double> value);
+            public static Vector128<uint> ConvertToVector128UInt32(Vector128<long> value);
+            public static Vector128<uint> ConvertToVector128UInt32(Vector128<float> value);
+            public static Vector128<uint> ConvertToVector128UInt32(Vector128<ulong> value);
+            public static Vector128<uint> ConvertToVector128UInt32(Vector256<double> value);
+            public static Vector128<uint> ConvertToVector128UInt32(Vector256<long> value);
+            public static Vector128<uint> ConvertToVector128UInt32(Vector256<ulong> value);
+            public static Vector128<uint> ConvertToVector128UInt32WithSaturation(Vector128<ulong> value);
+            public static Vector128<uint> ConvertToVector128UInt32WithSaturation(Vector256<ulong> value);
+            public static Vector128<uint> ConvertToVector128UInt32WithTruncation(Vector128<double> value);
+            public static Vector128<uint> ConvertToVector128UInt32WithTruncation(Vector128<float> value);
+            public static Vector128<uint> ConvertToVector128UInt32WithTruncation(Vector256<double> value);
+            public static Vector256<double> ConvertToVector256Double(Vector128<uint> value);
+            public static Vector256<float> ConvertToVector256Single(Vector256<uint> value);
+            public static Vector256<uint> ConvertToVector256UInt32(Vector256<float> value);
+            public static Vector256<uint> ConvertToVector256UInt32WithTruncation(Vector256<float> value);
+            public static Vector128<double> Fixup(Vector128<double> left, Vector128<double> right, Vector128<long> table, [ConstantExpectedAttribute] byte control);
+            public static Vector128<float> Fixup(Vector128<float> left, Vector128<float> right, Vector128<int> table, [ConstantExpectedAttribute] byte control);
+            public static Vector256<double> Fixup(Vector256<double> left, Vector256<double> right, Vector256<long> table, [ConstantExpectedAttribute] byte control);
+            public static Vector256<float> Fixup(Vector256<float> left, Vector256<float> right, Vector256<int> table, [ConstantExpectedAttribute] byte control);
+            public static Vector128<double> GetExponent(Vector128<double> value);
+            public static Vector128<float> GetExponent(Vector128<float> value);
+            public static Vector256<double> GetExponent(Vector256<double> value);
+            public static Vector256<float> GetExponent(Vector256<float> value);
+            public static Vector128<double> GetMantissa(Vector128<double> value, [ConstantExpectedAttribute(Max=(byte)15)] byte control);
+            public static Vector128<float> GetMantissa(Vector128<float> value, [ConstantExpectedAttribute(Max=(byte)15)] byte control);
+            public static Vector256<double> GetMantissa(Vector256<double> value, [ConstantExpectedAttribute(Max=(byte)15)] byte control);
+            public static Vector256<float> GetMantissa(Vector256<float> value, [ConstantExpectedAttribute(Max=(byte)15)] byte control);
+            public static Vector128<long> Max(Vector128<long> left, Vector128<long> right);
+            public static Vector128<ulong> Max(Vector128<ulong> left, Vector128<ulong> right);
+            public static Vector256<long> Max(Vector256<long> left, Vector256<long> right);
+            public static Vector256<ulong> Max(Vector256<ulong> left, Vector256<ulong> right);
+            public static Vector128<long> Min(Vector128<long> left, Vector128<long> right);
+            public static Vector128<ulong> Min(Vector128<ulong> left, Vector128<ulong> right);
+            public static Vector256<long> Min(Vector256<long> left, Vector256<long> right);
+            public static Vector256<ulong> Min(Vector256<ulong> left, Vector256<ulong> right);
+            public static Vector128<double> PermuteVar2x64x2(Vector128<double> lower, Vector128<long> indices, Vector128<double> upper);
+            public static Vector128<long> PermuteVar2x64x2(Vector128<long> lower, Vector128<long> indices, Vector128<long> upper);
+            public static Vector128<ulong> PermuteVar2x64x2(Vector128<ulong> lower, Vector128<ulong> indices, Vector128<ulong> upper);
+            public static Vector128<int> PermuteVar4x32x2(Vector128<int> lower, Vector128<int> indices, Vector128<int> upper);
+            public static Vector128<float> PermuteVar4x32x2(Vector128<float> lower, Vector128<int> indices, Vector128<float> upper);
+            public static Vector128<uint> PermuteVar4x32x2(Vector128<uint> lower, Vector128<uint> indices, Vector128<uint> upper);
+            public static Vector256<double> PermuteVar4x64(Vector256<double> value, Vector256<long> control);
+            public static Vector256<long> PermuteVar4x64(Vector256<long> value, Vector256<long> control);
+            public static Vector256<ulong> PermuteVar4x64(Vector256<ulong> value, Vector256<ulong> control);
+            public static Vector256<double> PermuteVar4x64x2(Vector256<double> lower, Vector256<long> indices, Vector256<double> upper);
+            public static Vector256<long> PermuteVar4x64x2(Vector256<long> lower, Vector256<long> indices, Vector256<long> upper);
+            public static Vector256<ulong> PermuteVar4x64x2(Vector256<ulong> lower, Vector256<ulong> indices, Vector256<ulong> upper);
+            public static Vector256<int> PermuteVar8x32x2(Vector256<int> lower, Vector256<int> indices, Vector256<int> upper);
+            public static Vector256<float> PermuteVar8x32x2(Vector256<float> lower, Vector256<int> indices, Vector256<float> upper);
+            public static Vector256<uint> PermuteVar8x32x2(Vector256<uint> lower, Vector256<uint> indices, Vector256<uint> upper);
+            public static Vector128<double> Reciprocal14(Vector128<double> value);
+            public static Vector128<float> Reciprocal14(Vector128<float> value);
+            public static Vector256<double> Reciprocal14(Vector256<double> value);
+            public static Vector256<float> Reciprocal14(Vector256<float> value);
+            public static Vector128<double> ReciprocalSqrt14(Vector128<double> value);
+            public static Vector128<float> ReciprocalSqrt14(Vector128<float> value);
+            public static Vector256<double> ReciprocalSqrt14(Vector256<double> value);
+            public static Vector256<float> ReciprocalSqrt14(Vector256<float> value);
+            public static Vector128<int> RotateLeft(Vector128<int> value, [ConstantExpectedAttribute] byte count);
+            public static Vector128<long> RotateLeft(Vector128<long> value, [ConstantExpectedAttribute] byte count);
+            public static Vector128<uint> RotateLeft(Vector128<uint> value, [ConstantExpectedAttribute] byte count);
+            public static Vector128<ulong> RotateLeft(Vector128<ulong> value, [ConstantExpectedAttribute] byte count);
+            public static Vector256<int> RotateLeft(Vector256<int> value, [ConstantExpectedAttribute] byte count);
+            public static Vector256<long> RotateLeft(Vector256<long> value, [ConstantExpectedAttribute] byte count);
+            public static Vector256<uint> RotateLeft(Vector256<uint> value, [ConstantExpectedAttribute] byte count);
+            public static Vector256<ulong> RotateLeft(Vector256<ulong> value, [ConstantExpectedAttribute] byte count);
+            public static Vector128<int> RotateLeftVariable(Vector128<int> value, Vector128<uint> count);
+            public static Vector128<long> RotateLeftVariable(Vector128<long> value, Vector128<ulong> count);
+            public static Vector128<uint> RotateLeftVariable(Vector128<uint> value, Vector128<uint> count);
+            public static Vector128<ulong> RotateLeftVariable(Vector128<ulong> value, Vector128<ulong> count);
+            public static Vector256<int> RotateLeftVariable(Vector256<int> value, Vector256<uint> count);
+            public static Vector256<long> RotateLeftVariable(Vector256<long> value, Vector256<ulong> count);
+            public static Vector256<uint> RotateLeftVariable(Vector256<uint> value, Vector256<uint> count);
+            public static Vector256<ulong> RotateLeftVariable(Vector256<ulong> value, Vector256<ulong> count);
+            public static Vector128<int> RotateRight(Vector128<int> value, [ConstantExpectedAttribute] byte count);
+            public static Vector128<long> RotateRight(Vector128<long> value, [ConstantExpectedAttribute] byte count);
+            public static Vector128<uint> RotateRight(Vector128<uint> value, [ConstantExpectedAttribute] byte count);
+            public static Vector128<ulong> RotateRight(Vector128<ulong> value, [ConstantExpectedAttribute] byte count);
+            public static Vector256<int> RotateRight(Vector256<int> value, [ConstantExpectedAttribute] byte count);
+            public static Vector256<long> RotateRight(Vector256<long> value, [ConstantExpectedAttribute] byte count);
+            public static Vector256<uint> RotateRight(Vector256<uint> value, [ConstantExpectedAttribute] byte count);
+            public static Vector256<ulong> RotateRight(Vector256<ulong> value, [ConstantExpectedAttribute] byte count);
+            public static Vector128<int> RotateRightVariable(Vector128<int> value, Vector128<uint> count);
+            public static Vector128<long> RotateRightVariable(Vector128<long> value, Vector128<ulong> count);
+            public static Vector128<uint> RotateRightVariable(Vector128<uint> value, Vector128<uint> count);
+            public static Vector128<ulong> RotateRightVariable(Vector128<ulong> value, Vector128<ulong> count);
+            public static Vector256<int> RotateRightVariable(Vector256<int> value, Vector256<uint> count);
+            public static Vector256<long> RotateRightVariable(Vector256<long> value, Vector256<ulong> count);
+            public static Vector256<uint> RotateRightVariable(Vector256<uint> value, Vector256<uint> count);
+            public static Vector256<ulong> RotateRightVariable(Vector256<ulong> value, Vector256<ulong> count);
+            public static Vector128<double> RoundScale(Vector128<double> value, [ConstantExpectedAttribute] byte control);
+            public static Vector128<float> RoundScale(Vector128<float> value, [ConstantExpectedAttribute] byte control);
+            public static Vector256<double> RoundScale(Vector256<double> value, [ConstantExpectedAttribute] byte control);
+            public static Vector256<float> RoundScale(Vector256<float> value, [ConstantExpectedAttribute] byte control);
+            public static Vector128<double> Scale(Vector128<double> left, Vector128<double> right);
+            public static Vector128<float> Scale(Vector128<float> left, Vector128<float> right);
+            public static Vector256<double> Scale(Vector256<double> left, Vector256<double> right);
+            public static Vector256<float> Scale(Vector256<float> left, Vector256<float> right);
+            public static Vector128<long> ShiftRightArithmetic(Vector128<long> value, [ConstantExpectedAttribute] byte count);
+            public static Vector128<long> ShiftRightArithmetic(Vector128<long> value, Vector128<long> count);
+            public static Vector256<long> ShiftRightArithmetic(Vector256<long> value, [ConstantExpectedAttribute] byte count);
+            public static Vector256<long> ShiftRightArithmetic(Vector256<long> value, Vector128<long> count);
+            public static Vector128<long> ShiftRightArithmeticVariable(Vector128<long> value, Vector128<ulong> count);
+            public static Vector256<long> ShiftRightArithmeticVariable(Vector256<long> value, Vector256<ulong> count);
+            public static Vector256<double> Shuffle2x128(Vector256<double> left, Vector256<double> right, [ConstantExpectedAttribute] byte control);
+            public static Vector256<int> Shuffle2x128(Vector256<int> left, Vector256<int> right, [ConstantExpectedAttribute] byte control);
+            public static Vector256<long> Shuffle2x128(Vector256<long> left, Vector256<long> right, [ConstantExpectedAttribute] byte control);
+            public static Vector256<float> Shuffle2x128(Vector256<float> left, Vector256<float> right, [ConstantExpectedAttribute] byte control);
+            public static Vector256<uint> Shuffle2x128(Vector256<uint> left, Vector256<uint> right, [ConstantExpectedAttribute] byte control);
+            public static Vector256<ulong> Shuffle2x128(Vector256<ulong> left, Vector256<ulong> right, [ConstantExpectedAttribute] byte control);
+            public static Vector128<byte> TernaryLogic(Vector128<byte> a, Vector128<byte> b, Vector128<byte> c, [ConstantExpectedAttribute] byte control);
+            public static Vector128<double> TernaryLogic(Vector128<double> a, Vector128<double> b, Vector128<double> c, [ConstantExpectedAttribute] byte control);
+            public static Vector128<short> TernaryLogic(Vector128<short> a, Vector128<short> b, Vector128<short> c, [ConstantExpectedAttribute] byte control);
+            public static Vector128<int> TernaryLogic(Vector128<int> a, Vector128<int> b, Vector128<int> c, [ConstantExpectedAttribute] byte control);
+            public static Vector128<long> TernaryLogic(Vector128<long> a, Vector128<long> b, Vector128<long> c, [ConstantExpectedAttribute] byte control);
+            public static Vector128<sbyte> TernaryLogic(Vector128<sbyte> a, Vector128<sbyte> b, Vector128<sbyte> c, [ConstantExpectedAttribute] byte control);
+            public static Vector128<float> TernaryLogic(Vector128<float> a, Vector128<float> b, Vector128<float> c, [ConstantExpectedAttribute] byte control);
+            public static Vector128<ushort> TernaryLogic(Vector128<ushort> a, Vector128<ushort> b, Vector128<ushort> c, [ConstantExpectedAttribute] byte control);
+            public static Vector128<uint> TernaryLogic(Vector128<uint> a, Vector128<uint> b, Vector128<uint> c, [ConstantExpectedAttribute] byte control);
+            public static Vector128<ulong> TernaryLogic(Vector128<ulong> a, Vector128<ulong> b, Vector128<ulong> c, [ConstantExpectedAttribute] byte control);
+            public static Vector256<byte> TernaryLogic(Vector256<byte> a, Vector256<byte> b, Vector256<byte> c, [ConstantExpectedAttribute] byte control);
+            public static Vector256<double> TernaryLogic(Vector256<double> a, Vector256<double> b, Vector256<double> c, [ConstantExpectedAttribute] byte control);
+            public static Vector256<short> TernaryLogic(Vector256<short> a, Vector256<short> b, Vector256<short> c, [ConstantExpectedAttribute] byte control);
+            public static Vector256<int> TernaryLogic(Vector256<int> a, Vector256<int> b, Vector256<int> c, [ConstantExpectedAttribute] byte control);
+            public static Vector256<long> TernaryLogic(Vector256<long> a, Vector256<long> b, Vector256<long> c, [ConstantExpectedAttribute] byte control);
+            public static Vector256<sbyte> TernaryLogic(Vector256<sbyte> a, Vector256<sbyte> b, Vector256<sbyte> c, [ConstantExpectedAttribute] byte control);
+            public static Vector256<float> TernaryLogic(Vector256<float> a, Vector256<float> b, Vector256<float> c, [ConstantExpectedAttribute] byte control);
+            public static Vector256<ushort> TernaryLogic(Vector256<ushort> a, Vector256<ushort> b, Vector256<ushort> c, [ConstantExpectedAttribute] byte control);
+            public static Vector256<uint> TernaryLogic(Vector256<uint> a, Vector256<uint> b, Vector256<uint> c, [ConstantExpectedAttribute] byte control);
+            public static Vector256<ulong> TernaryLogic(Vector256<ulong> a, Vector256<ulong> b, Vector256<ulong> c, [ConstantExpectedAttribute] byte control);
+        }
+        public new abstract class X64 : Avx2.X64 {
+            public static new bool IsSupported { get; }
+            public static Vector128<double> ConvertScalarToVector128Double(Vector128<double> upper, ulong value);
+            public static Vector128<float> ConvertScalarToVector128Single(Vector128<float> upper, ulong value);
+            public static ulong ConvertToUInt64(Vector128<double> value);
+            public static ulong ConvertToUInt64(Vector128<float> value);
+            public static ulong ConvertToUInt64WithTruncation(Vector128<double> value);
+            public static ulong ConvertToUInt64WithTruncation(Vector128<float> value);
+        }
+    }
+    [CLSCompliantAttribute(false)]
+    public abstract class Avx512Vbmi : Avx512BW {
+        public static new bool IsSupported { get; }
+        public static Vector512<byte> PermuteVar64x8(Vector512<byte> left, Vector512<byte> control);
+        public static Vector512<sbyte> PermuteVar64x8(Vector512<sbyte> left, Vector512<sbyte> control);
+        public static Vector512<byte> PermuteVar64x8x2(Vector512<byte> lower, Vector512<byte> indices, Vector512<byte> upper);
+        public static Vector512<sbyte> PermuteVar64x8x2(Vector512<sbyte> lower, Vector512<sbyte> indices, Vector512<sbyte> upper);
+        public new abstract class VL : Avx512BW.VL {
+            public static new bool IsSupported { get; }
+            public static Vector128<byte> PermuteVar16x8(Vector128<byte> left, Vector128<byte> control);
+            public static Vector128<sbyte> PermuteVar16x8(Vector128<sbyte> left, Vector128<sbyte> control);
+            public static Vector128<byte> PermuteVar16x8x2(Vector128<byte> lower, Vector128<byte> indices, Vector128<byte> upper);
+            public static Vector128<sbyte> PermuteVar16x8x2(Vector128<sbyte> lower, Vector128<sbyte> indices, Vector128<sbyte> upper);
+            public static Vector256<byte> PermuteVar32x8(Vector256<byte> left, Vector256<byte> control);
+            public static Vector256<sbyte> PermuteVar32x8(Vector256<sbyte> left, Vector256<sbyte> control);
+            public static Vector256<byte> PermuteVar32x8x2(Vector256<byte> lower, Vector256<byte> indices, Vector256<byte> upper);
+            public static Vector256<sbyte> PermuteVar32x8x2(Vector256<sbyte> lower, Vector256<sbyte> indices, Vector256<sbyte> upper);
+        }
+        public new abstract class X64 : Avx512BW.X64 {
+            public static new bool IsSupported { get; }
+        }
+    }
     [CLSCompliantAttribute(false)]
     public abstract class Pclmulqdq : Sse2 {
-        public static Vector128<long> CarrylessMultiply(Vector128<long> left, Vector128<long> right, byte control);
+        public static Vector128<long> CarrylessMultiply(Vector128<long> left, Vector128<long> right, [ConstantExpectedAttribute] byte control);
-        public static Vector128<ulong> CarrylessMultiply(Vector128<ulong> left, Vector128<ulong> right, byte control);
+        public static Vector128<ulong> CarrylessMultiply(Vector128<ulong> left, Vector128<ulong> right, [ConstantExpectedAttribute] byte control);
     }
     [CLSCompliantAttribute(false)]
     public abstract class Sse : X86Base {
-        public static Vector128<float> Shuffle(Vector128<float> left, Vector128<float> right, byte control);
+        public static Vector128<float> Shuffle(Vector128<float> left, Vector128<float> right, [ConstantExpectedAttribute] byte control);
     }
     [CLSCompliantAttribute(false)]
     public abstract class Sse2 : Sse {
-        public static ushort Extract(Vector128<ushort> value, byte index);
+        public static ushort Extract(Vector128<ushort> value, [ConstantExpectedAttribute] byte index);
-        public static Vector128<short> Insert(Vector128<short> value, short data, byte index);
+        public static Vector128<short> Insert(Vector128<short> value, short data, [ConstantExpectedAttribute] byte index);
-        public static Vector128<ushort> Insert(Vector128<ushort> value, ushort data, byte index);
+        public static Vector128<ushort> Insert(Vector128<ushort> value, ushort data, [ConstantExpectedAttribute] byte index);
-        public static Vector128<short> ShiftLeftLogical(Vector128<short> value, byte count);
+        public static Vector128<short> ShiftLeftLogical(Vector128<short> value, [ConstantExpectedAttribute] byte count);
-        public static Vector128<int> ShiftLeftLogical(Vector128<int> value, byte count);
+        public static Vector128<int> ShiftLeftLogical(Vector128<int> value, [ConstantExpectedAttribute] byte count);
-        public static Vector128<long> ShiftLeftLogical(Vector128<long> value, byte count);
+        public static Vector128<long> ShiftLeftLogical(Vector128<long> value, [ConstantExpectedAttribute] byte count);
-        public static Vector128<ushort> ShiftLeftLogical(Vector128<ushort> value, byte count);
+        public static Vector128<ushort> ShiftLeftLogical(Vector128<ushort> value, [ConstantExpectedAttribute] byte count);
-        public static Vector128<uint> ShiftLeftLogical(Vector128<uint> value, byte count);
+        public static Vector128<uint> ShiftLeftLogical(Vector128<uint> value, [ConstantExpectedAttribute] byte count);
-        public static Vector128<ulong> ShiftLeftLogical(Vector128<ulong> value, byte count);
+        public static Vector128<ulong> ShiftLeftLogical(Vector128<ulong> value, [ConstantExpectedAttribute] byte count);
-        public static Vector128<byte> ShiftLeftLogical128BitLane(Vector128<byte> value, byte numBytes);
+        public static Vector128<byte> ShiftLeftLogical128BitLane(Vector128<byte> value, [ConstantExpectedAttribute] byte numBytes);
-        public static Vector128<short> ShiftLeftLogical128BitLane(Vector128<short> value, byte numBytes);
+        public static Vector128<short> ShiftLeftLogical128BitLane(Vector128<short> value, [ConstantExpectedAttribute] byte numBytes);
-        public static Vector128<int> ShiftLeftLogical128BitLane(Vector128<int> value, byte numBytes);
+        public static Vector128<int> ShiftLeftLogical128BitLane(Vector128<int> value, [ConstantExpectedAttribute] byte numBytes);
-        public static Vector128<long> ShiftLeftLogical128BitLane(Vector128<long> value, byte numBytes);
+        public static Vector128<long> ShiftLeftLogical128BitLane(Vector128<long> value, [ConstantExpectedAttribute] byte numBytes);
-        public static Vector128<sbyte> ShiftLeftLogical128BitLane(Vector128<sbyte> value, byte numBytes);
+        public static Vector128<sbyte> ShiftLeftLogical128BitLane(Vector128<sbyte> value, [ConstantExpectedAttribute] byte numBytes);
-        public static Vector128<ushort> ShiftLeftLogical128BitLane(Vector128<ushort> value, byte numBytes);
+        public static Vector128<ushort> ShiftLeftLogical128BitLane(Vector128<ushort> value, [ConstantExpectedAttribute] byte numBytes);
-        public static Vector128<uint> ShiftLeftLogical128BitLane(Vector128<uint> value, byte numBytes);
+        public static Vector128<uint> ShiftLeftLogical128BitLane(Vector128<uint> value, [ConstantExpectedAttribute] byte numBytes);
-        public static Vector128<ulong> ShiftLeftLogical128BitLane(Vector128<ulong> value, byte numBytes);
+        public static Vector128<ulong> ShiftLeftLogical128BitLane(Vector128<ulong> value, [ConstantExpectedAttribute] byte numBytes);
-        public static Vector128<short> ShiftRightArithmetic(Vector128<short> value, byte count);
+        public static Vector128<short> ShiftRightArithmetic(Vector128<short> value, [ConstantExpectedAttribute] byte count);
-        public static Vector128<int> ShiftRightArithmetic(Vector128<int> value, byte count);
+        public static Vector128<int> ShiftRightArithmetic(Vector128<int> value, [ConstantExpectedAttribute] byte count);
-        public static Vector128<short> ShiftRightLogical(Vector128<short> value, byte count);
+        public static Vector128<short> ShiftRightLogical(Vector128<short> value, [ConstantExpectedAttribute] byte count);
-        public static Vector128<int> ShiftRightLogical(Vector128<int> value, byte count);
+        public static Vector128<int> ShiftRightLogical(Vector128<int> value, [ConstantExpectedAttribute] byte count);
-        public static Vector128<long> ShiftRightLogical(Vector128<long> value, byte count);
+        public static Vector128<long> ShiftRightLogical(Vector128<long> value, [ConstantExpectedAttribute] byte count);
-        public static Vector128<ushort> ShiftRightLogical(Vector128<ushort> value, byte count);
+        public static Vector128<ushort> ShiftRightLogical(Vector128<ushort> value, [ConstantExpectedAttribute] byte count);
-        public static Vector128<uint> ShiftRightLogical(Vector128<uint> value, byte count);
+        public static Vector128<uint> ShiftRightLogical(Vector128<uint> value, [ConstantExpectedAttribute] byte count);
-        public static Vector128<ulong> ShiftRightLogical(Vector128<ulong> value, byte count);
+        public static Vector128<ulong> ShiftRightLogical(Vector128<ulong> value, [ConstantExpectedAttribute] byte count);
-        public static Vector128<byte> ShiftRightLogical128BitLane(Vector128<byte> value, byte numBytes);
+        public static Vector128<byte> ShiftRightLogical128BitLane(Vector128<byte> value, [ConstantExpectedAttribute] byte numBytes);
-        public static Vector128<short> ShiftRightLogical128BitLane(Vector128<short> value, byte numBytes);
+        public static Vector128<short> ShiftRightLogical128BitLane(Vector128<short> value, [ConstantExpectedAttribute] byte numBytes);
-        public static Vector128<int> ShiftRightLogical128BitLane(Vector128<int> value, byte numBytes);
+        public static Vector128<int> ShiftRightLogical128BitLane(Vector128<int> value, [ConstantExpectedAttribute] byte numBytes);
-        public static Vector128<long> ShiftRightLogical128BitLane(Vector128<long> value, byte numBytes);
+        public static Vector128<long> ShiftRightLogical128BitLane(Vector128<long> value, [ConstantExpectedAttribute] byte numBytes);
-        public static Vector128<sbyte> ShiftRightLogical128BitLane(Vector128<sbyte> value, byte numBytes);
+        public static Vector128<sbyte> ShiftRightLogical128BitLane(Vector128<sbyte> value, [ConstantExpectedAttribute] byte numBytes);
-        public static Vector128<ushort> ShiftRightLogical128BitLane(Vector128<ushort> value, byte numBytes);
+        public static Vector128<ushort> ShiftRightLogical128BitLane(Vector128<ushort> value, [ConstantExpectedAttribute] byte numBytes);
-        public static Vector128<uint> ShiftRightLogical128BitLane(Vector128<uint> value, byte numBytes);
+        public static Vector128<uint> ShiftRightLogical128BitLane(Vector128<uint> value, [ConstantExpectedAttribute] byte numBytes);
-        public static Vector128<ulong> ShiftRightLogical128BitLane(Vector128<ulong> value, byte numBytes);
+        public static Vector128<ulong> ShiftRightLogical128BitLane(Vector128<ulong> value, [ConstantExpectedAttribute] byte numBytes);
-        public static Vector128<double> Shuffle(Vector128<double> left, Vector128<double> right, byte control);
+        public static Vector128<double> Shuffle(Vector128<double> left, Vector128<double> right, [ConstantExpectedAttribute] byte control);
-        public static Vector128<int> Shuffle(Vector128<int> value, byte control);
+        public static Vector128<int> Shuffle(Vector128<int> value, [ConstantExpectedAttribute] byte control);
-        public static Vector128<uint> Shuffle(Vector128<uint> value, byte control);
+        public static Vector128<uint> Shuffle(Vector128<uint> value, [ConstantExpectedAttribute] byte control);
-        public static Vector128<short> ShuffleHigh(Vector128<short> value, byte control);
+        public static Vector128<short> ShuffleHigh(Vector128<short> value, [ConstantExpectedAttribute] byte control);
-        public static Vector128<ushort> ShuffleHigh(Vector128<ushort> value, byte control);
+        public static Vector128<ushort> ShuffleHigh(Vector128<ushort> value, [ConstantExpectedAttribute] byte control);
-        public static Vector128<short> ShuffleLow(Vector128<short> value, byte control);
+        public static Vector128<short> ShuffleLow(Vector128<short> value, [ConstantExpectedAttribute] byte control);
-        public static Vector128<ushort> ShuffleLow(Vector128<ushort> value, byte control);
+        public static Vector128<ushort> ShuffleLow(Vector128<ushort> value, [ConstantExpectedAttribute] byte control);
     }
     [CLSCompliantAttribute(false)]
     public abstract class Sse41 : Ssse3 {
-        public static Vector128<double> Blend(Vector128<double> left, Vector128<double> right, byte control);
+        public static Vector128<double> Blend(Vector128<double> left, Vector128<double> right, [ConstantExpectedAttribute] byte control);
-        public static Vector128<short> Blend(Vector128<short> left, Vector128<short> right, byte control);
+        public static Vector128<short> Blend(Vector128<short> left, Vector128<short> right, [ConstantExpectedAttribute] byte control);
-        public static Vector128<float> Blend(Vector128<float> left, Vector128<float> right, byte control);
+        public static Vector128<float> Blend(Vector128<float> left, Vector128<float> right, [ConstantExpectedAttribute] byte control);
-        public static Vector128<ushort> Blend(Vector128<ushort> left, Vector128<ushort> right, byte control);
+        public static Vector128<ushort> Blend(Vector128<ushort> left, Vector128<ushort> right, [ConstantExpectedAttribute] byte control);
-        public static Vector128<double> DotProduct(Vector128<double> left, Vector128<double> right, byte control);
+        public static Vector128<double> DotProduct(Vector128<double> left, Vector128<double> right, [ConstantExpectedAttribute] byte control);
-        public static Vector128<float> DotProduct(Vector128<float> left, Vector128<float> right, byte control);
+        public static Vector128<float> DotProduct(Vector128<float> left, Vector128<float> right, [ConstantExpectedAttribute] byte control);
-        public static byte Extract(Vector128<byte> value, byte index);
+        public static byte Extract(Vector128<byte> value, [ConstantExpectedAttribute] byte index);
-        public static int Extract(Vector128<int> value, byte index);
+        public static int Extract(Vector128<int> value, [ConstantExpectedAttribute] byte index);
-        public static float Extract(Vector128<float> value, byte index);
+        public static float Extract(Vector128<float> value, [ConstantExpectedAttribute] byte index);
-        public static uint Extract(Vector128<uint> value, byte index);
+        public static uint Extract(Vector128<uint> value, [ConstantExpectedAttribute] byte index);
-        public static Vector128<byte> Insert(Vector128<byte> value, byte data, byte index);
+        public static Vector128<byte> Insert(Vector128<byte> value, byte data, [ConstantExpectedAttribute] byte index);
-        public static Vector128<int> Insert(Vector128<int> value, int data, byte index);
+        public static Vector128<int> Insert(Vector128<int> value, int data, [ConstantExpectedAttribute] byte index);
-        public static Vector128<sbyte> Insert(Vector128<sbyte> value, sbyte data, byte index);
+        public static Vector128<sbyte> Insert(Vector128<sbyte> value, sbyte data, [ConstantExpectedAttribute] byte index);
-        public static Vector128<float> Insert(Vector128<float> value, Vector128<float> data, byte index);
+        public static Vector128<float> Insert(Vector128<float> value, Vector128<float> data, [ConstantExpectedAttribute] byte index);
-        public static Vector128<uint> Insert(Vector128<uint> value, uint data, byte index);
+        public static Vector128<uint> Insert(Vector128<uint> value, uint data, [ConstantExpectedAttribute] byte index);
-        public static Vector128<ushort> MultipleSumAbsoluteDifferences(Vector128<byte> left, Vector128<byte> right, byte mask);
+        public static Vector128<ushort> MultipleSumAbsoluteDifferences(Vector128<byte> left, Vector128<byte> right, [ConstantExpectedAttribute] byte mask);
         public new abstract class X64 : Ssse3.X64 {
-            public static long Extract(Vector128<long> value, byte index);
+            public static long Extract(Vector128<long> value, [ConstantExpectedAttribute] byte index);
-            public static ulong Extract(Vector128<ulong> value, byte index);
+            public static ulong Extract(Vector128<ulong> value, [ConstantExpectedAttribute] byte index);
-            public static Vector128<long> Insert(Vector128<long> value, long data, byte index);
+            public static Vector128<long> Insert(Vector128<long> value, long data, [ConstantExpectedAttribute] byte index);
-            public static Vector128<ulong> Insert(Vector128<ulong> value, ulong data, byte index);
+            public static Vector128<ulong> Insert(Vector128<ulong> value, ulong data, [ConstantExpectedAttribute] byte index);
         }
     }
     [CLSCompliantAttribute(false)]
     public abstract class Ssse3 : Sse3 {
-        public static Vector128<byte> AlignRight(Vector128<byte> left, Vector128<byte> right, byte mask);
+        public static Vector128<byte> AlignRight(Vector128<byte> left, Vector128<byte> right, [ConstantExpectedAttribute] byte mask);
-        public static Vector128<short> AlignRight(Vector128<short> left, Vector128<short> right, byte mask);
+        public static Vector128<short> AlignRight(Vector128<short> left, Vector128<short> right, [ConstantExpectedAttribute] byte mask);
-        public static Vector128<int> AlignRight(Vector128<int> left, Vector128<int> right, byte mask);
+        public static Vector128<int> AlignRight(Vector128<int> left, Vector128<int> right, [ConstantExpectedAttribute] byte mask);
-        public static Vector128<long> AlignRight(Vector128<long> left, Vector128<long> right, byte mask);
+        public static Vector128<long> AlignRight(Vector128<long> left, Vector128<long> right, [ConstantExpectedAttribute] byte mask);
-        public static Vector128<sbyte> AlignRight(Vector128<sbyte> left, Vector128<sbyte> right, byte mask);
+        public static Vector128<sbyte> AlignRight(Vector128<sbyte> left, Vector128<sbyte> right, [ConstantExpectedAttribute] byte mask);
-        public static Vector128<ushort> AlignRight(Vector128<ushort> left, Vector128<ushort> right, byte mask);
+        public static Vector128<ushort> AlignRight(Vector128<ushort> left, Vector128<ushort> right, [ConstantExpectedAttribute] byte mask);
-        public static Vector128<uint> AlignRight(Vector128<uint> left, Vector128<uint> right, byte mask);
+        public static Vector128<uint> AlignRight(Vector128<uint> left, Vector128<uint> right, [ConstantExpectedAttribute] byte mask);
-        public static Vector128<ulong> AlignRight(Vector128<ulong> left, Vector128<ulong> right, byte mask);
+        public static Vector128<ulong> AlignRight(Vector128<ulong> left, Vector128<ulong> right, [ConstantExpectedAttribute] byte mask);
     }
-    public abstract class X86Base {
+    [CLSCompliantAttribute(false)]
+    public abstract class X86Base {
+        [RequiresPreviewFeaturesAttribute("DivRem is in preview.")]
+        public static (int Quotient, int Remainder) DivRem(uint lower, int upper, int divisor);
+        [RequiresPreviewFeaturesAttribute("DivRem is in preview.")]
+        public static (uint Quotient, uint Remainder) DivRem(uint lower, uint upper, uint divisor);
+        [RequiresPreviewFeaturesAttribute("DivRem is in preview.")]
+        public static (IntPtr Quotient, IntPtr Remainder) DivRem(UIntPtr lower, IntPtr upper, IntPtr divisor);
+        [RequiresPreviewFeaturesAttribute("DivRem is in preview.")]
+        public static (UIntPtr Quotient, UIntPtr Remainder) DivRem(UIntPtr lower, UIntPtr upper, UIntPtr divisor);
         public abstract class X64 {
+            [RequiresPreviewFeaturesAttribute("DivRem is in preview.")]
+            public static (long Quotient, long Remainder) DivRem(ulong lower, long upper, long divisor);
+            [RequiresPreviewFeaturesAttribute("DivRem is in preview.")]
+            public static (ulong Quotient, ulong Remainder) DivRem(ulong lower, ulong upper, ulong divisor);
         }
     }
 }
```

