# System.Runtime.Serialization

``` diff
 namespace System.Runtime.Serialization {
-    [CLSCompliantAttribute(false)]
-    public abstract class Formatter : IFormatter {
+    [CLSCompliantAttribute(false)]
+    [ObsoleteAttribute("BinaryFormatter serialization is obsolete and should not be used. See https://aka.ms/binaryformatter for more information.", DiagnosticId="SYSLIB0011", UrlFormat="https://aka.ms/dotnet-warnings/{0}")]
+    public abstract class Formatter : IFormatter {
-        [ObsoleteAttribute("BinaryFormatter serialization is obsolete and should not be used. See https://aka.ms/binaryformatter for more information.", DiagnosticId="SYSLIB0011", UrlFormat="https://aka.ms/dotnet-warnings/{0}")]
-        [RequiresUnreferencedCodeAttribute("BinaryFormatter serialization is not trim compatible because the Type of objects being processed cannot be statically discovered.")]
-        public abstract object Deserialize(Stream serializationStream);
+        [RequiresUnreferencedCodeAttribute("BinaryFormatter serialization is not trim compatible because the type of objects being processed cannot be statically discovered.")]
+        public abstract object Deserialize(Stream serializationStream);
-        [ObsoleteAttribute("BinaryFormatter serialization is obsolete and should not be used. See https://aka.ms/binaryformatter for more information.", DiagnosticId="SYSLIB0011", UrlFormat="https://aka.ms/dotnet-warnings/{0}")]
-        [RequiresUnreferencedCodeAttribute("BinaryFormatter serialization is not trim compatible because the Type of objects being processed cannot be statically discovered.")]
-        public abstract void Serialize(Stream serializationStream, object graph);
+        [RequiresUnreferencedCodeAttribute("BinaryFormatter serialization is not trim compatible because the type of objects being processed cannot be statically discovered.")]
+        public abstract void Serialize(Stream serializationStream, object graph);
     }
-    public class FormatterConverter : IFormatterConverter
+    [ObsoleteAttribute("Formatter-based serialization is obsolete and should not be used.", DiagnosticId="SYSLIB0050", UrlFormat="https://aka.ms/dotnet-warnings/{0}")]
+    public class FormatterConverter : IFormatterConverter
-    public static class FormatterServices
+    [ObsoleteAttribute("Formatter-based serialization is obsolete and should not be used.", DiagnosticId="SYSLIB0050", UrlFormat="https://aka.ms/dotnet-warnings/{0}")]
+    public static class FormatterServices
-    public interface IFormatter {
+    [ObsoleteAttribute("BinaryFormatter serialization is obsolete and should not be used. See https://aka.ms/binaryformatter for more information.", DiagnosticId="SYSLIB0011", UrlFormat="https://aka.ms/dotnet-warnings/{0}")]
+    public interface IFormatter {
-        [ObsoleteAttribute("BinaryFormatter serialization is obsolete and should not be used. See https://aka.ms/binaryformatter for more information.", DiagnosticId="SYSLIB0011", UrlFormat="https://aka.ms/dotnet-warnings/{0}")]
-        [RequiresUnreferencedCodeAttribute("BinaryFormatter serialization is not trim compatible because the Type of objects being processed cannot be statically discovered.")]
-        object Deserialize(Stream serializationStream);
+        [RequiresUnreferencedCodeAttribute("BinaryFormatter serialization is not trim compatible because the type of objects being processed cannot be statically discovered.")]
+        object Deserialize(Stream serializationStream);
-        [ObsoleteAttribute("BinaryFormatter serialization is obsolete and should not be used. See https://aka.ms/binaryformatter for more information.", DiagnosticId="SYSLIB0011", UrlFormat="https://aka.ms/dotnet-warnings/{0}")]
-        [RequiresUnreferencedCodeAttribute("BinaryFormatter serialization is not trim compatible because the Type of objects being processed cannot be statically discovered.")]
-        void Serialize(Stream serializationStream, object graph);
+        [RequiresUnreferencedCodeAttribute("BinaryFormatter serialization is not trim compatible because the type of objects being processed cannot be statically discovered.")]
+        void Serialize(Stream serializationStream, object graph);
     }
-    [CLSCompliantAttribute(false)]
-    public interface IFormatterConverter
+    [CLSCompliantAttribute(false)]
+    [ObsoleteAttribute("Formatter-based serialization is obsolete and should not be used.", DiagnosticId="SYSLIB0050", UrlFormat="https://aka.ms/dotnet-warnings/{0}")]
+    public interface IFormatterConverter
     public class InvalidDataContractException : Exception {
-        protected InvalidDataContractException(SerializationInfo info, StreamingContext context);
+        [EditorBrowsableAttribute(EditorBrowsableState.Never)]
+        [ObsoleteAttribute("This API supports obsolete formatter-based serialization. It should not be called or extended by application code.", DiagnosticId="SYSLIB0051", UrlFormat="https://aka.ms/dotnet-warnings/{0}")]
+        protected InvalidDataContractException(SerializationInfo info, StreamingContext context);
     }
-    public interface IObjectReference
+    [ObsoleteAttribute("Formatter-based serialization is obsolete and should not be used.", DiagnosticId="SYSLIB0050", UrlFormat="https://aka.ms/dotnet-warnings/{0}")]
+    public interface IObjectReference
-    public interface ISafeSerializationData
+    [ObsoleteAttribute("Formatter-based serialization is obsolete and should not be used.", DiagnosticId="SYSLIB0050", UrlFormat="https://aka.ms/dotnet-warnings/{0}")]
+    public interface ISafeSerializationData
     public interface ISerializable {
-        void GetObjectData(SerializationInfo info, StreamingContext context);
+        [ObsoleteAttribute("Formatter-based serialization is obsolete and should not be used.", DiagnosticId="SYSLIB0050", UrlFormat="https://aka.ms/dotnet-warnings/{0}")]
+        void GetObjectData(SerializationInfo info, StreamingContext context);
     }
-    public interface ISerializationSurrogate
+    [ObsoleteAttribute("Formatter-based serialization is obsolete and should not be used.", DiagnosticId="SYSLIB0050", UrlFormat="https://aka.ms/dotnet-warnings/{0}")]
+    public interface ISerializationSurrogate
-    public interface ISurrogateSelector
+    [ObsoleteAttribute("Formatter-based serialization is obsolete and should not be used.", DiagnosticId="SYSLIB0050", UrlFormat="https://aka.ms/dotnet-warnings/{0}")]
+    public interface ISurrogateSelector
-    public class ObjectIDGenerator
+    [ObsoleteAttribute("Formatter-based serialization is obsolete and should not be used.", DiagnosticId="SYSLIB0050", UrlFormat="https://aka.ms/dotnet-warnings/{0}")]
+    public class ObjectIDGenerator
-    public class ObjectManager {
+    [ObsoleteAttribute("Formatter-based serialization is obsolete and should not be used.", DiagnosticId="SYSLIB0050", UrlFormat="https://aka.ms/dotnet-warnings/{0}")]
+    public class ObjectManager {
         [RequiresUnreferencedCodeAttribute("ObjectManager is not trim compatible because the Type of objects being managed cannot be statically discovered.")]
         public virtual void DoFixups();
         [RequiresUnreferencedCodeAttribute("ObjectManager is not trim compatible because the Type of objects being managed cannot be statically discovered.")]
         public void RaiseOnDeserializingEvent(object obj);
         [RequiresUnreferencedCodeAttribute("ObjectManager is not trim compatible because the Type of objects being managed cannot be statically discovered.")]
         public virtual void RegisterObject(object obj, long objectID);
         [RequiresUnreferencedCodeAttribute("ObjectManager is not trim compatible because the Type of objects being managed cannot be statically discovered.")]
         public void RegisterObject(object obj, long objectID, SerializationInfo info);
         [RequiresUnreferencedCodeAttribute("ObjectManager is not trim compatible because the Type of objects being managed cannot be statically discovered.")]
         public void RegisterObject(object obj, long objectID, SerializationInfo? info, long idOfContainingObj, MemberInfo? member);
         [RequiresUnreferencedCodeAttribute("ObjectManager is not trim compatible because the Type of objects being managed cannot be statically discovered.")]
         public void RegisterObject(object obj, long objectID, SerializationInfo? info, long idOfContainingObj, MemberInfo? member, int[]? arrayIndex);
     }
-    public sealed class SafeSerializationEventArgs : EventArgs
+    [ObsoleteAttribute("Formatter-based serialization is obsolete and should not be used.", DiagnosticId="SYSLIB0050", UrlFormat="https://aka.ms/dotnet-warnings/{0}")]
+    public sealed class SafeSerializationEventArgs : EventArgs
     public class SerializationException : SystemException {
-        protected SerializationException(SerializationInfo info, StreamingContext context);
+        [EditorBrowsableAttribute(EditorBrowsableState.Never)]
+        [ObsoleteAttribute("This API supports obsolete formatter-based serialization. It should not be called or extended by application code.", DiagnosticId="SYSLIB0051", UrlFormat="https://aka.ms/dotnet-warnings/{0}")]
+        protected SerializationException(SerializationInfo info, StreamingContext context);
     }
     public sealed class SerializationInfo {
-        [CLSCompliantAttribute(false)]
-        public SerializationInfo(Type type, IFormatterConverter converter);
+        [CLSCompliantAttribute(false)]
+        [ObsoleteAttribute("Formatter-based serialization is obsolete and should not be used.", DiagnosticId="SYSLIB0050", UrlFormat="https://aka.ms/dotnet-warnings/{0}")]
+        public SerializationInfo(Type type, IFormatterConverter converter);
-        [CLSCompliantAttribute(false)]
-        public SerializationInfo(Type type, IFormatterConverter converter, bool requireSameTokenInPartialTrust);
+        [CLSCompliantAttribute(false)]
+        [ObsoleteAttribute("Formatter-based serialization is obsolete and should not be used.", DiagnosticId="SYSLIB0050", UrlFormat="https://aka.ms/dotnet-warnings/{0}")]
+        public SerializationInfo(Type type, IFormatterConverter converter, bool requireSameTokenInPartialTrust);
     }
-    public sealed class SerializationObjectManager {
+    [ObsoleteAttribute("Formatter-based serialization is obsolete and should not be used.", DiagnosticId="SYSLIB0050", UrlFormat="https://aka.ms/dotnet-warnings/{0}")]
+    public sealed class SerializationObjectManager {
         [RequiresUnreferencedCodeAttribute("SerializationObjectManager is not trim compatible because the Type of objects being managed cannot be statically discovered.")]
         public void RegisterObject(object obj);
     }
     public readonly struct StreamingContext {
-        public StreamingContext(StreamingContextStates state);
+        [ObsoleteAttribute("Formatter-based serialization is obsolete and should not be used.", DiagnosticId="SYSLIB0050", UrlFormat="https://aka.ms/dotnet-warnings/{0}")]
+        public StreamingContext(StreamingContextStates state);
-        public StreamingContext(StreamingContextStates state, object additional);
+        [ObsoleteAttribute("Formatter-based serialization is obsolete and should not be used.", DiagnosticId="SYSLIB0050", UrlFormat="https://aka.ms/dotnet-warnings/{0}")]
+        public StreamingContext(StreamingContextStates state, object additional);
-        public StreamingContextStates State { get; }
+        [ObsoleteAttribute("Formatter-based serialization is obsolete and should not be used.", DiagnosticId="SYSLIB0050", UrlFormat="https://aka.ms/dotnet-warnings/{0}")]
+        public StreamingContextStates State { get; }
     }
-    [FlagsAttribute]
-    public enum StreamingContextStates
+    [FlagsAttribute]
+    [ObsoleteAttribute("Formatter-based serialization is obsolete and should not be used.", DiagnosticId="SYSLIB0050", UrlFormat="https://aka.ms/dotnet-warnings/{0}")]
+    public enum StreamingContextStates
-    public class SurrogateSelector : ISurrogateSelector
+    [ObsoleteAttribute("Formatter-based serialization is obsolete and should not be used.", DiagnosticId="SYSLIB0050", UrlFormat="https://aka.ms/dotnet-warnings/{0}")]
+    public class SurrogateSelector : ISurrogateSelector
 }
```

