# System.Security.Cryptography

``` diff
 namespace System.Security.Cryptography {
     [UnsupportedOSPlatformAttribute("browser")]
     [UnsupportedOSPlatformAttribute("ios")]
     [UnsupportedOSPlatformAttribute("tvos")]
     public sealed class AesGcm : IDisposable {
-        public AesGcm(byte[] key);
+        [ObsoleteAttribute("AesGcm should indicate the required tag size for encryption and decryption. Use a constructor that accepts the tag size.", DiagnosticId="SYSLIB0053", UrlFormat="https://aka.ms/dotnet-warnings/{0}")]
+        public AesGcm(byte[] key);
+        public AesGcm(byte[] key, int tagSizeInBytes);
-        public AesGcm(ReadOnlySpan<byte> key);
+        [ObsoleteAttribute("AesGcm should indicate the required tag size for encryption and decryption. Use a constructor that accepts the tag size.", DiagnosticId="SYSLIB0053", UrlFormat="https://aka.ms/dotnet-warnings/{0}")]
+        public AesGcm(ReadOnlySpan<byte> key);
+        public AesGcm(ReadOnlySpan<byte> key, int tagSizeInBytes);
+        public int? TagSizeInBytes { get; }
     }
     public abstract class AsymmetricAlgorithm : IDisposable {
+        public string ExportEncryptedPkcs8PrivateKeyPem(ReadOnlySpan<byte> passwordBytes, PbeParameters pbeParameters);
+        public bool TryExportEncryptedPkcs8PrivateKeyPem(ReadOnlySpan<byte> passwordBytes, PbeParameters pbeParameters, Span<char> destination, out int charsWritten);
     }
+    public sealed class AuthenticationTagMismatchException : CryptographicException {
+        public AuthenticationTagMismatchException();
+        public AuthenticationTagMismatchException(string message);
+        public AuthenticationTagMismatchException(string message, Exception inner);
+    }
     public class CryptographicException : SystemException {
-        protected CryptographicException(SerializationInfo info, StreamingContext context);
+        [EditorBrowsableAttribute(EditorBrowsableState.Never)]
+        [ObsoleteAttribute("This API supports obsolete formatter-based serialization. It should not be called or extended by application code.", DiagnosticId="SYSLIB0051", UrlFormat="https://aka.ms/dotnet-warnings/{0}")]
+        protected CryptographicException(SerializationInfo info, StreamingContext context);
     }
     public class CryptographicUnexpectedOperationException : CryptographicException {
-        protected CryptographicUnexpectedOperationException(SerializationInfo info, StreamingContext context);
+        [EditorBrowsableAttribute(EditorBrowsableState.Never)]
+        [ObsoleteAttribute("This API supports obsolete formatter-based serialization. It should not be called or extended by application code.", DiagnosticId="SYSLIB0051", UrlFormat="https://aka.ms/dotnet-warnings/{0}")]
+        protected CryptographicUnexpectedOperationException(SerializationInfo info, StreamingContext context);
     }
     public abstract class ECDiffieHellman : ECAlgorithm {
+        public virtual byte[] DeriveRawSecretAgreement(ECDiffieHellmanPublicKey otherPartyPublicKey);
     }
     public readonly struct HashAlgorithmName : IEquatable<HashAlgorithmName> {
+        public static HashAlgorithmName SHA3_256 { get; }
+        public static HashAlgorithmName SHA3_384 { get; }
+        public static HashAlgorithmName SHA3_512 { get; }
     }
+    public class HMACSHA3_256 : HMAC {
+        public const int HashSizeInBits = 256;
+        public const int HashSizeInBytes = 32;
+        public HMACSHA3_256();
+        public HMACSHA3_256(byte[] key);
+        public static bool IsSupported { get; }
+        public override byte[] Key { get; set; }
+        protected override void Dispose(bool disposing);
+        protected override void HashCore(byte[] rgb, int ib, int cb);
+        protected override void HashCore(ReadOnlySpan<byte> source);
+        public static byte[] HashData(byte[] key, byte[] source);
+        public static byte[] HashData(byte[] key, Stream source);
+        public static byte[] HashData(ReadOnlySpan<byte> key, Stream source);
+        public static int HashData(ReadOnlySpan<byte> key, Stream source, Span<byte> destination);
+        public static byte[] HashData(ReadOnlySpan<byte> key, ReadOnlySpan<byte> source);
+        public static int HashData(ReadOnlySpan<byte> key, ReadOnlySpan<byte> source, Span<byte> destination);
+        public static ValueTask<byte[]> HashDataAsync(byte[] key, Stream source, CancellationToken cancellationToken = default(CancellationToken));
+        public static ValueTask<int> HashDataAsync(ReadOnlyMemory<byte> key, Stream source, Memory<byte> destination, CancellationToken cancellationToken = default(CancellationToken));
+        public static ValueTask<byte[]> HashDataAsync(ReadOnlyMemory<byte> key, Stream source, CancellationToken cancellationToken = default(CancellationToken));
+        protected override byte[] HashFinal();
+        public override void Initialize();
+        public static bool TryHashData(ReadOnlySpan<byte> key, ReadOnlySpan<byte> source, Span<byte> destination, out int bytesWritten);
+        protected override bool TryHashFinal(Span<byte> destination, out int bytesWritten);
+    }
+    public class HMACSHA3_384 : HMAC {
+        public const int HashSizeInBits = 384;
+        public const int HashSizeInBytes = 48;
+        public HMACSHA3_384();
+        public HMACSHA3_384(byte[] key);
+        public static bool IsSupported { get; }
+        public override byte[] Key { get; set; }
+        protected override void Dispose(bool disposing);
+        protected override void HashCore(byte[] rgb, int ib, int cb);
+        protected override void HashCore(ReadOnlySpan<byte> source);
+        public static byte[] HashData(byte[] key, byte[] source);
+        public static byte[] HashData(byte[] key, Stream source);
+        public static byte[] HashData(ReadOnlySpan<byte> key, Stream source);
+        public static int HashData(ReadOnlySpan<byte> key, Stream source, Span<byte> destination);
+        public static byte[] HashData(ReadOnlySpan<byte> key, ReadOnlySpan<byte> source);
+        public static int HashData(ReadOnlySpan<byte> key, ReadOnlySpan<byte> source, Span<byte> destination);
+        public static ValueTask<byte[]> HashDataAsync(byte[] key, Stream source, CancellationToken cancellationToken = default(CancellationToken));
+        public static ValueTask<int> HashDataAsync(ReadOnlyMemory<byte> key, Stream source, Memory<byte> destination, CancellationToken cancellationToken = default(CancellationToken));
+        public static ValueTask<byte[]> HashDataAsync(ReadOnlyMemory<byte> key, Stream source, CancellationToken cancellationToken = default(CancellationToken));
+        protected override byte[] HashFinal();
+        public override void Initialize();
+        public static bool TryHashData(ReadOnlySpan<byte> key, ReadOnlySpan<byte> source, Span<byte> destination, out int bytesWritten);
+        protected override bool TryHashFinal(Span<byte> destination, out int bytesWritten);
+    }
+    public class HMACSHA3_512 : HMAC {
+        public const int HashSizeInBits = 512;
+        public const int HashSizeInBytes = 64;
+        public HMACSHA3_512();
+        public HMACSHA3_512(byte[] key);
+        public static bool IsSupported { get; }
+        public override byte[] Key { get; set; }
+        protected override void Dispose(bool disposing);
+        protected override void HashCore(byte[] rgb, int ib, int cb);
+        protected override void HashCore(ReadOnlySpan<byte> source);
+        public static byte[] HashData(byte[] key, byte[] source);
+        public static byte[] HashData(byte[] key, Stream source);
+        public static byte[] HashData(ReadOnlySpan<byte> key, Stream source);
+        public static int HashData(ReadOnlySpan<byte> key, Stream source, Span<byte> destination);
+        public static byte[] HashData(ReadOnlySpan<byte> key, ReadOnlySpan<byte> source);
+        public static int HashData(ReadOnlySpan<byte> key, ReadOnlySpan<byte> source, Span<byte> destination);
+        public static ValueTask<byte[]> HashDataAsync(byte[] key, Stream source, CancellationToken cancellationToken = default(CancellationToken));
+        public static ValueTask<int> HashDataAsync(ReadOnlyMemory<byte> key, Stream source, Memory<byte> destination, CancellationToken cancellationToken = default(CancellationToken));
+        public static ValueTask<byte[]> HashDataAsync(ReadOnlyMemory<byte> key, Stream source, CancellationToken cancellationToken = default(CancellationToken));
+        protected override byte[] HashFinal();
+        public override void Initialize();
+        public static bool TryHashData(ReadOnlySpan<byte> key, ReadOnlySpan<byte> source, Span<byte> destination, out int bytesWritten);
+        protected override bool TryHashFinal(Span<byte> destination, out int bytesWritten);
+    }
     public abstract class RandomNumberGenerator : IDisposable {
+        public static string GetHexString(int stringLength, bool lowercase = false);
+        public static void GetHexString(Span<char> destination, bool lowercase = false);
+        public static T[] GetItems<T>(ReadOnlySpan<T> choices, int length);
+        public static void GetItems<T>(ReadOnlySpan<T> choices, Span<T> destination);
+        public static string GetString(ReadOnlySpan<char> choices, int length);
+        public static void Shuffle<T>(Span<T> values);
     }
     public abstract class RSA : AsymmetricAlgorithm {
-        public virtual byte[] DecryptValue(byte[] rgb);
+        [EditorBrowsableAttribute(EditorBrowsableState.Never)]
+        [ObsoleteAttribute("RSA.EncryptValue and DecryptValue are not supported and throw NotSupportedException. Use RSA.Encrypt and RSA.Decrypt instead.", DiagnosticId="SYSLIB0048", UrlFormat="https://aka.ms/dotnet-warnings/{0}")]
+        public virtual byte[] DecryptValue(byte[] rgb);
-        public virtual byte[] EncryptValue(byte[] rgb);
+        [EditorBrowsableAttribute(EditorBrowsableState.Never)]
+        [ObsoleteAttribute("RSA.EncryptValue and DecryptValue are not supported and throw NotSupportedException. Use RSA.Encrypt and RSA.Decrypt instead.", DiagnosticId="SYSLIB0048", UrlFormat="https://aka.ms/dotnet-warnings/{0}")]
+        public virtual byte[] EncryptValue(byte[] rgb);
+        public int GetMaxOutputSize();
     }
     public sealed class RSACryptoServiceProvider : RSA, ICspAsymmetricAlgorithm {
-        public override byte[] DecryptValue(byte[] rgb);
+        [EditorBrowsableAttribute(EditorBrowsableState.Never)]
+        [ObsoleteAttribute("RSA.EncryptValue and DecryptValue are not supported and throw NotSupportedException. Use RSA.Encrypt and RSA.Decrypt instead.", DiagnosticId="SYSLIB0048", UrlFormat="https://aka.ms/dotnet-warnings/{0}")]
+        public override byte[] DecryptValue(byte[] rgb);
-        public override byte[] EncryptValue(byte[] rgb);
+        [EditorBrowsableAttribute(EditorBrowsableState.Never)]
+        [ObsoleteAttribute("RSA.EncryptValue and DecryptValue are not supported and throw NotSupportedException. Use RSA.Encrypt and RSA.Decrypt instead.", DiagnosticId="SYSLIB0048", UrlFormat="https://aka.ms/dotnet-warnings/{0}")]
+        public override byte[] EncryptValue(byte[] rgb);
     }
     public sealed class RSAEncryptionPadding : IEquatable<RSAEncryptionPadding> {
+        public static RSAEncryptionPadding OaepSHA3_256 { get; }
+        public static RSAEncryptionPadding OaepSHA3_384 { get; }
+        public static RSAEncryptionPadding OaepSHA3_512 { get; }
     }
     public sealed class SafeEvpPKeyHandle : SafeHandle {
+        [UnsupportedOSPlatformAttribute("android")]
+        [UnsupportedOSPlatformAttribute("browser")]
+        [UnsupportedOSPlatformAttribute("ios")]
+        [UnsupportedOSPlatformAttribute("tvos")]
+        [UnsupportedOSPlatformAttribute("windows")]
+        public static SafeEvpPKeyHandle OpenPrivateKeyFromEngine(string engineName, string keyId);
+        [UnsupportedOSPlatformAttribute("android")]
+        [UnsupportedOSPlatformAttribute("browser")]
+        [UnsupportedOSPlatformAttribute("ios")]
+        [UnsupportedOSPlatformAttribute("tvos")]
+        [UnsupportedOSPlatformAttribute("windows")]
+        public static SafeEvpPKeyHandle OpenPublicKeyFromEngine(string engineName, string keyId);
     }
+    public abstract class SHA3_256 : HashAlgorithm {
+        public const int HashSizeInBits = 256;
+        public const int HashSizeInBytes = 32;
+        protected SHA3_256();
+        public static bool IsSupported { get; }
+        public static new SHA3_256 Create();
+        public static byte[] HashData(byte[] source);
+        public static byte[] HashData(Stream source);
+        public static int HashData(Stream source, Span<byte> destination);
+        public static byte[] HashData(ReadOnlySpan<byte> source);
+        public static int HashData(ReadOnlySpan<byte> source, Span<byte> destination);
+        public static ValueTask<int> HashDataAsync(Stream source, Memory<byte> destination, CancellationToken cancellationToken = default(CancellationToken));
+        public static ValueTask<byte[]> HashDataAsync(Stream source, CancellationToken cancellationToken = default(CancellationToken));
+        public static bool TryHashData(ReadOnlySpan<byte> source, Span<byte> destination, out int bytesWritten);
+    }
+    public abstract class SHA3_384 : HashAlgorithm {
+        public const int HashSizeInBits = 384;
+        public const int HashSizeInBytes = 48;
+        protected SHA3_384();
+        public static bool IsSupported { get; }
+        public static new SHA3_384 Create();
+        public static byte[] HashData(byte[] source);
+        public static byte[] HashData(Stream source);
+        public static int HashData(Stream source, Span<byte> destination);
+        public static byte[] HashData(ReadOnlySpan<byte> source);
+        public static int HashData(ReadOnlySpan<byte> source, Span<byte> destination);
+        public static ValueTask<int> HashDataAsync(Stream source, Memory<byte> destination, CancellationToken cancellationToken = default(CancellationToken));
+        public static ValueTask<byte[]> HashDataAsync(Stream source, CancellationToken cancellationToken = default(CancellationToken));
+        public static bool TryHashData(ReadOnlySpan<byte> source, Span<byte> destination, out int bytesWritten);
+    }
+    public abstract class SHA3_512 : HashAlgorithm {
+        public const int HashSizeInBits = 512;
+        public const int HashSizeInBytes = 64;
+        protected SHA3_512();
+        public static bool IsSupported { get; }
+        public static new SHA3_512 Create();
+        public static byte[] HashData(byte[] source);
+        public static byte[] HashData(Stream source);
+        public static int HashData(Stream source, Span<byte> destination);
+        public static byte[] HashData(ReadOnlySpan<byte> source);
+        public static int HashData(ReadOnlySpan<byte> source, Span<byte> destination);
+        public static ValueTask<int> HashDataAsync(Stream source, Memory<byte> destination, CancellationToken cancellationToken = default(CancellationToken));
+        public static ValueTask<byte[]> HashDataAsync(Stream source, CancellationToken cancellationToken = default(CancellationToken));
+        public static bool TryHashData(ReadOnlySpan<byte> source, Span<byte> destination, out int bytesWritten);
+    }
+    public sealed class Shake128 : IDisposable {
+        public Shake128();
+        public static bool IsSupported { get; }
+        public void AppendData(byte[] data);
+        public void AppendData(ReadOnlySpan<byte> data);
+        public void Dispose();
+        public byte[] GetCurrentHash(int outputLength);
+        public void GetCurrentHash(Span<byte> destination);
+        public byte[] GetHashAndReset(int outputLength);
+        public void GetHashAndReset(Span<byte> destination);
+        public static byte[] HashData(byte[] source, int outputLength);
+        public static byte[] HashData(Stream source, int outputLength);
+        public static void HashData(Stream source, Span<byte> destination);
+        public static byte[] HashData(ReadOnlySpan<byte> source, int outputLength);
+        public static void HashData(ReadOnlySpan<byte> source, Span<byte> destination);
+        public static ValueTask<byte[]> HashDataAsync(Stream source, int outputLength, CancellationToken cancellationToken = default(CancellationToken));
+        public static ValueTask HashDataAsync(Stream source, Memory<byte> destination, CancellationToken cancellationToken = default(CancellationToken));
+    }
+    public sealed class Shake256 : IDisposable {
+        public Shake256();
+        public static bool IsSupported { get; }
+        public void AppendData(byte[] data);
+        public void AppendData(ReadOnlySpan<byte> data);
+        public void Dispose();
+        public byte[] GetCurrentHash(int outputLength);
+        public void GetCurrentHash(Span<byte> destination);
+        public byte[] GetHashAndReset(int outputLength);
+        public void GetHashAndReset(Span<byte> destination);
+        public static byte[] HashData(byte[] source, int outputLength);
+        public static byte[] HashData(Stream source, int outputLength);
+        public static void HashData(Stream source, Span<byte> destination);
+        public static byte[] HashData(ReadOnlySpan<byte> source, int outputLength);
+        public static void HashData(ReadOnlySpan<byte> source, Span<byte> destination);
+        public static ValueTask<byte[]> HashDataAsync(Stream source, int outputLength, CancellationToken cancellationToken = default(CancellationToken));
+        public static ValueTask HashDataAsync(Stream source, Memory<byte> destination, CancellationToken cancellationToken = default(CancellationToken));
+    }
+    public sealed class SP800108HmacCounterKdf : IDisposable {
+        public SP800108HmacCounterKdf(byte[] key, HashAlgorithmName hashAlgorithm);
+        public SP800108HmacCounterKdf(ReadOnlySpan<byte> key, HashAlgorithmName hashAlgorithm);
+        public static byte[] DeriveBytes(byte[] key, HashAlgorithmName hashAlgorithm, byte[] label, byte[] context, int derivedKeyLengthInBytes);
+        public static byte[] DeriveBytes(byte[] key, HashAlgorithmName hashAlgorithm, string label, string context, int derivedKeyLengthInBytes);
+        public static byte[] DeriveBytes(ReadOnlySpan<byte> key, HashAlgorithmName hashAlgorithm, ReadOnlySpan<byte> label, ReadOnlySpan<byte> context, int derivedKeyLengthInBytes);
+        public static void DeriveBytes(ReadOnlySpan<byte> key, HashAlgorithmName hashAlgorithm, ReadOnlySpan<byte> label, ReadOnlySpan<byte> context, Span<byte> destination);
+        public static byte[] DeriveBytes(ReadOnlySpan<byte> key, HashAlgorithmName hashAlgorithm, ReadOnlySpan<char> label, ReadOnlySpan<char> context, int derivedKeyLengthInBytes);
+        public static void DeriveBytes(ReadOnlySpan<byte> key, HashAlgorithmName hashAlgorithm, ReadOnlySpan<char> label, ReadOnlySpan<char> context, Span<byte> destination);
+        public byte[] DeriveKey(byte[] label, byte[] context, int derivedKeyLengthInBytes);
+        public byte[] DeriveKey(ReadOnlySpan<byte> label, ReadOnlySpan<byte> context, int derivedKeyLengthInBytes);
+        public void DeriveKey(ReadOnlySpan<byte> label, ReadOnlySpan<byte> context, Span<byte> destination);
+        public byte[] DeriveKey(ReadOnlySpan<char> label, ReadOnlySpan<char> context, int derivedKeyLengthInBytes);
+        public void DeriveKey(ReadOnlySpan<char> label, ReadOnlySpan<char> context, Span<byte> destination);
+        public byte[] DeriveKey(string label, string context, int derivedKeyLengthInBytes);
+        public void Dispose();
+    }
 }
```

