# System.Text.Json.Nodes

``` diff
 namespace System.Text.Json.Nodes {
     public sealed class JsonArray : JsonNode, ICollection<JsonNode?>, IEnumerable, IEnumerable<JsonNode?>, IList<JsonNode?> {
+        public IEnumerable<T> GetValues<T>();
     }
     public abstract class JsonNode {
+        public JsonNode DeepClone();
+        public static bool DeepEquals(JsonNode? node1, JsonNode? node2);
+        public int GetElementIndex();
+        public string GetPropertyName();
+        public JsonValueKind GetValueKind();
-        public static implicit operator JsonNode? (string? value);
+        [return: NotNullIfNotNullAttribute("value")]
+        public static implicit operator JsonNode? (string? value);
+        public static Task<JsonNode?> ParseAsync(Stream utf8Json, JsonNodeOptions? nodeOptions = default(JsonNodeOptions?), JsonDocumentOptions documentOptions = default(JsonDocumentOptions), CancellationToken cancellationToken = default(CancellationToken));
+        [RequiresUnreferencedCodeAttribute("Creating JsonValue instances with non-primitive types is not compatible with trimming. It can result in non-primitive types being serialized, which may have their members trimmed.")]
+        public void ReplaceWith<T>(T value);
     }
     public abstract class JsonValue : JsonNode {
-        public static JsonValue Create(string value, JsonNodeOptions? options = default(JsonNodeOptions?));
+        [return: NotNullIfNotNullAttribute("value")]
+        public static JsonValue Create(string value, JsonNodeOptions? options = default(JsonNodeOptions?));
     }
 }
```

