# System.Text.Json.Serialization.Metadata

``` diff
 namespace System.Text.Json.Serialization.Metadata {
     [EditorBrowsableAttribute(EditorBrowsableState.Never)]
     public static class JsonMetadataServices {
-        public static JsonConverter<byte[]> ByteArrayConverter { get; }
+        public static JsonConverter<byte[]?> ByteArrayConverter { get; }
+        public static JsonConverter<Half> HalfConverter { get; }
+        public static JsonConverter<Int128> Int128Converter { get; }
-        public static JsonConverter<JsonArray> JsonArrayConverter { get; }
+        public static JsonConverter<JsonArray?> JsonArrayConverter { get; }
-        public static JsonConverter<JsonDocument> JsonDocumentConverter { get; }
+        public static JsonConverter<JsonDocument?> JsonDocumentConverter { get; }
-        public static JsonConverter<JsonNode> JsonNodeConverter { get; }
+        public static JsonConverter<JsonNode?> JsonNodeConverter { get; }
-        public static JsonConverter<JsonObject> JsonObjectConverter { get; }
+        public static JsonConverter<JsonObject?> JsonObjectConverter { get; }
-        public static JsonConverter<JsonValue> JsonValueConverter { get; }
+        public static JsonConverter<JsonValue?> JsonValueConverter { get; }
+        public static JsonConverter<Memory<byte>> MemoryByteConverter { get; }
+        public static JsonConverter<ReadOnlyMemory<byte>> ReadOnlyMemoryByteConverter { get; }
-        public static JsonConverter<string> StringConverter { get; }
+        public static JsonConverter<string?> StringConverter { get; }
+        [CLSCompliantAttribute(false)]
+        public static JsonConverter<UInt128> UInt128Converter { get; }
-        public static JsonConverter<Uri> UriConverter { get; }
+        public static JsonConverter<Uri?> UriConverter { get; }
-        public static JsonConverter<Version> VersionConverter { get; }
+        public static JsonConverter<Version?> VersionConverter { get; }
+        public static JsonTypeInfo<Memory<TElement>> CreateMemoryInfo<TElement>(JsonSerializerOptions options, JsonCollectionInfoValues<Memory<TElement>> collectionInfo);
+        public static JsonTypeInfo<ReadOnlyMemory<TElement>> CreateReadOnlyMemoryInfo<TElement>(JsonSerializerOptions options, JsonCollectionInfoValues<ReadOnlyMemory<TElement>> collectionInfo);
     }
     public abstract class JsonPropertyInfo {
+        public JsonObjectCreationHandling? ObjectCreationHandling { get; set; }
     }
     public abstract class JsonTypeInfo {
+        [EditorBrowsableAttribute(EditorBrowsableState.Never)]
+        public IJsonTypeInfoResolver? OriginatingResolver { get; set; }
+        public JsonObjectCreationHandling? PreferredPropertyObjectCreationHandling { get; set; }
+        public JsonUnmappedMemberHandling? UnmappedMemberHandling { get; set; }
     }
-    public abstract class JsonTypeInfo<T> : JsonTypeInfo
+    public sealed class JsonTypeInfo<T> : JsonTypeInfo
     public static class JsonTypeInfoResolver {
-        public static IJsonTypeInfoResolver Combine(params IJsonTypeInfoResolver[] resolvers);
+        public static IJsonTypeInfoResolver Combine(params IJsonTypeInfoResolver?[] resolvers);
+        public static IJsonTypeInfoResolver WithAddedModifier(this IJsonTypeInfoResolver resolver, Action<JsonTypeInfo> modifier);
     }
 }
```

