# System.Text.Json.Serialization

``` diff
 namespace System.Text.Json.Serialization {
     public abstract class JsonConverter {
+        public abstract Type Type { get; }
     }
     public abstract class JsonConverter<T> : JsonConverter {
+        public sealed override Type Type { get; }
-        public virtual void WriteAsPropertyName(Utf8JsonWriter writer, T value, JsonSerializerOptions options);
+        public virtual void WriteAsPropertyName(Utf8JsonWriter writer, [DisallowNullAttribute] T value, JsonSerializerOptions options);
     }
     public abstract class JsonConverterFactory : JsonConverter {
+        public sealed override Type Type { get; }
     }
     public enum JsonKnownNamingPolicy {
+        KebabCaseLower = 4,
+        KebabCaseUpper = 5,
+        SnakeCaseLower = 2,
+        SnakeCaseUpper = 3,
     }
+    public sealed class JsonNumberEnumConverter<TEnum> : JsonConverterFactory where TEnum : struct {
+        public JsonNumberEnumConverter();
+        public override bool CanConvert(Type typeToConvert);
+        public override JsonConverter? CreateConverter(Type typeToConvert, JsonSerializerOptions options);
+    }
+    public enum JsonObjectCreationHandling {
+        Populate = 1,
+        Replace = 0,
+    }
+    [AttributeUsageAttribute(AttributeTargets.Class | AttributeTargets.Field | AttributeTargets.Interface | AttributeTargets.Property | AttributeTargets.Struct, AllowMultiple=false)]
+    public sealed class JsonObjectCreationHandlingAttribute : JsonAttribute {
+        public JsonObjectCreationHandlingAttribute(JsonObjectCreationHandling handling);
+        public JsonObjectCreationHandling Handling { get; }
+    }
     [AttributeUsageAttribute(AttributeTargets.Class, AllowMultiple=false)]
     public sealed class JsonSourceGenerationOptionsAttribute : JsonAttribute {
+        public JsonSourceGenerationOptionsAttribute(JsonSerializerDefaults defaults);
+        public bool AllowTrailingCommas { get; set; }
+        public Type[]? Converters { get; set; }
+        public int DefaultBufferSize { get; set; }
+        public JsonKnownNamingPolicy DictionaryKeyPolicy { get; set; }
+        public int MaxDepth { get; set; }
+        public JsonNumberHandling NumberHandling { get; set; }
+        public JsonObjectCreationHandling PreferredObjectCreationHandling { get; set; }
+        public bool PropertyNameCaseInsensitive { get; set; }
+        public JsonCommentHandling ReadCommentHandling { get; set; }
+        public JsonUnknownTypeHandling UnknownTypeHandling { get; set; }
+        public JsonUnmappedMemberHandling UnmappedMemberHandling { get; set; }
+        public bool UseStringEnumConverter { get; set; }
     }
+    public class JsonStringEnumConverter<TEnum> : JsonConverterFactory where TEnum : struct {
+        public JsonStringEnumConverter();
+        public JsonStringEnumConverter(JsonNamingPolicy? namingPolicy = null, bool allowIntegerValues = true);
+        public sealed override bool CanConvert(Type typeToConvert);
+        public sealed override JsonConverter CreateConverter(Type typeToConvert, JsonSerializerOptions options);
+    }
+    public enum JsonUnmappedMemberHandling {
+        Disallow = 1,
+        Skip = 0,
+    }
+    [AttributeUsageAttribute(AttributeTargets.Class | AttributeTargets.Interface | AttributeTargets.Struct, AllowMultiple=false, Inherited=false)]
+    public class JsonUnmappedMemberHandlingAttribute : JsonAttribute {
+        public JsonUnmappedMemberHandlingAttribute(JsonUnmappedMemberHandling unmappedMemberHandling);
+        public JsonUnmappedMemberHandling UnmappedMemberHandling { get; }
+    }
 }
```

