# System.Text.Json

``` diff
 namespace System.Text.Json {
     public readonly struct JsonEncodedText : IEquatable<JsonEncodedText> {
+        public string Value { get; }
     }
     public class JsonException : Exception {
-        protected JsonException(SerializationInfo info, StreamingContext context);
+        [EditorBrowsableAttribute(EditorBrowsableState.Never)]
+        [ObsoleteAttribute("This API supports obsolete formatter-based serialization. It should not be called or extended by application code.", DiagnosticId="SYSLIB0051", UrlFormat="https://aka.ms/dotnet-warnings/{0}")]
+        protected JsonException(SerializationInfo info, StreamingContext context);
-        public override void GetObjectData(SerializationInfo info, StreamingContext context);
+        [EditorBrowsableAttribute(EditorBrowsableState.Never)]
+        [ObsoleteAttribute("This API supports obsolete formatter-based serialization. It should not be called or extended by application code.", DiagnosticId="SYSLIB0051", UrlFormat="https://aka.ms/dotnet-warnings/{0}")]
+        public override void GetObjectData(SerializationInfo info, StreamingContext context);
     }
     public abstract class JsonNamingPolicy {
+        public static JsonNamingPolicy KebabCaseLower { get; }
+        public static JsonNamingPolicy KebabCaseUpper { get; }
+        public static JsonNamingPolicy SnakeCaseLower { get; }
+        public static JsonNamingPolicy SnakeCaseUpper { get; }
     }
     public static class JsonSerializer {
+        public static bool IsReflectionEnabledByDefault { get; }
+        public static object? Deserialize(Stream utf8Json, JsonTypeInfo jsonTypeInfo);
+        public static object? Deserialize(ReadOnlySpan<byte> utf8Json, JsonTypeInfo jsonTypeInfo);
+        public static object? Deserialize([StringSyntaxAttribute("Json")] ReadOnlySpan<char> json, JsonTypeInfo jsonTypeInfo);
+        public static object? Deserialize([StringSyntaxAttribute("Json")] string json, JsonTypeInfo jsonTypeInfo);
+        public static object? Deserialize(this JsonDocument document, JsonTypeInfo jsonTypeInfo);
+        public static object? Deserialize(this JsonElement element, JsonTypeInfo jsonTypeInfo);
+        public static object? Deserialize(this JsonNode? node, JsonTypeInfo jsonTypeInfo);
+        public static object? Deserialize(ref Utf8JsonReader reader, JsonTypeInfo jsonTypeInfo);
+        public static ValueTask<object?> DeserializeAsync(Stream utf8Json, JsonTypeInfo jsonTypeInfo, CancellationToken cancellationToken = default(CancellationToken));
+        public static void Serialize(Stream utf8Json, object? value, JsonTypeInfo jsonTypeInfo);
+        public static string Serialize(object? value, JsonTypeInfo jsonTypeInfo);
+        public static void Serialize(Utf8JsonWriter writer, object? value, JsonTypeInfo jsonTypeInfo);
+        public static Task SerializeAsync(Stream utf8Json, object? value, JsonTypeInfo jsonTypeInfo, CancellationToken cancellationToken = default(CancellationToken));
+        public static JsonDocument SerializeToDocument(object? value, JsonTypeInfo jsonTypeInfo);
+        public static JsonElement SerializeToElement(object? value, JsonTypeInfo jsonTypeInfo);
+        public static JsonNode? SerializeToNode(object? value, JsonTypeInfo jsonTypeInfo);
+        public static byte[] SerializeToUtf8Bytes(object? value, JsonTypeInfo jsonTypeInfo);
     }
     public sealed class JsonSerializerOptions {
+        public bool IsReadOnly { get; }
+        public JsonObjectCreationHandling PreferredObjectCreationHandling { get; set; }
+        public IList<IJsonTypeInfoResolver> TypeInfoResolverChain { get; }
+        public JsonUnmappedMemberHandling UnmappedMemberHandling { get; set; }
-        public void AddContext<TContext>() where TContext : JsonSerializerContext, new();
+        [EditorBrowsableAttribute(EditorBrowsableState.Never)]
+        [ObsoleteAttribute("JsonSerializerOptions.AddContext is obsolete. To register a JsonSerializerContext, use either the TypeInfoResolver or TypeInfoResolverChain properties.", DiagnosticId="SYSLIB0049", UrlFormat="https://aka.ms/dotnet-warnings/{0}")]
+        public void AddContext<TContext>() where TContext : JsonSerializerContext, new();
+        public void MakeReadOnly();
+        [RequiresUnreferencedCodeAttribute("Populating unconfigured TypeInfoResolver properties with the reflection resolver requires unreferenced code.")]
+        public void MakeReadOnly(bool populateMissingResolver);
+        public bool TryGetTypeInfo(Type type, [NotNullWhenAttribute(true)] out JsonTypeInfo? typeInfo);
     }
     public sealed class Utf8JsonWriter : IAsyncDisposable, IDisposable {
+        public void WriteRawValue(ReadOnlySequence<byte> utf8Json, bool skipInputValidation = false);
     }
 }
```

